#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from py.common.util import common
from py.common.entity.check_result import CheckResult
from py.common.entity.check_item import CheckItem
from py.common.util.connection_util import SshService


def execute(env, method):
    return ExpansionDlmVm(env).execute(method)


class ExpansionDlmVm(CheckItem):
    def __init__(self, env):
        super(ExpansionDlmVm, self).__init__(env)
        self.fsm_dev_node = self.task_env.get_master_fsm_dev_node()
        self.path = self.task_env.get_task_cache().get("unzip_folder_path")
        self.expand_result_file = "dlm_vm_expand_result.txt"
        self.rollback_result_file = "dlm_vm_rollback_result.txt"

    def do_check(self):
        """
        扩容dlm_vm节点
        """
        ssh_service = SshService(self.fsm_dev_node)
        last_line = common.command_result_redirect_to_file_strip_cc(
            ssh_service, self.task_env, "ExpandEdsDlmVmCluster", self.expand_result_file)
        if "result(0)" not in last_line:
            return CheckResult(CheckResult.NOT_PASS, last_line,
                               self.get_msg("eds.cluster.expand.fail", "dlm_vm"))
        return CheckResult(CheckResult.PASS, last_line, "")

    def rollback(self):
        """
        回退逻辑
        """
        ssh_service = SshService(self.fsm_dev_node)
        last_line = common.command_result_redirect_to_file_strip_cc(
            ssh_service, self.task_env, "RollbackEdsDlmVmCluster", self.rollback_result_file)
        if "result(0)" not in last_line:
            return CheckResult(CheckResult.NOT_PASS, last_line,
                               self.get_msg("eds.cluster.expand.fail", "dlm_vm"))
        return CheckResult(CheckResult.PASS, last_line, "")
