#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

from py.common.util import common
from py.common.entity.check_result import CheckResult
from py.common.entity.check_item import CheckItem
from py.common.util.connection_util import SshService


def execute(env, method):
    return ExpansionFdsaCore(env).execute(method)


class ExpansionFdsaCore(CheckItem):
    def __init__(self, env):
        super(ExpansionFdsaCore, self).__init__(env)
        self.fsm_dev_node = self.task_env.get_master_fsm_dev_node()
        self.old_zk_node_list = self.task_env.get_task_cache().get("oldZkNodes")
        self.path = self.task_env.get_task_cache().get("unzip_folder_path")
        self.expand_result_file = "fdsaCore_expand_result.txt"
        self.rollback_result_file = "fdsaCore_rollback_result.txt"

    def do_check(self):
        """
        扩容fdsaCore节点
        """
        if not self.has_fdsacore_cfg():
            return CheckResult(CheckResult.NOT_INVOLVED, "", "")
        ssh_service = SshService(self.fsm_dev_node)
        last_line = common.command_result_redirect_to_file_strip_cc(
            ssh_service, self.task_env, "ExpandEdsFdsaCoreCluster", self.expand_result_file)
        if "result(0)" not in last_line:
            return CheckResult(CheckResult.NOT_PASS, last_line,
                               self.get_msg("eds.cluster.expand.fail", "fdsaCore"))
        return CheckResult(CheckResult.PASS, last_line, "")

    def rollback(self):
        """
        回退逻辑
        """
        if not self.has_fdsacore_cfg():
            return CheckResult(CheckResult.NOT_INVOLVED, "", "")
        ssh_service = SshService(self.fsm_dev_node)
        last_line = common.command_result_redirect_to_file_strip_cc(
            ssh_service, self.task_env, "RollbackEdsFdsaCoreCluster", self.rollback_result_file)
        if "result(0)" not in last_line:
            return CheckResult(CheckResult.NOT_PASS, last_line,
                               self.get_msg("eds.cluster.expand.fail", "fdsaCore"))
        return CheckResult(CheckResult.PASS, last_line, "")

    def has_fdsacore_cfg(self):
        ssh_service = SshService(self.old_zk_node_list[0])
        cli_ret = ssh_service.execute_cmd("ls /opt/fusionstorage/fdsa/conf/fdsa_cluster_srv.conf")
        ssh_service.release_ssh()
        return "No such file or directory" not in cli_ret
