# coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from py.common.util import common
from py.common.entity.check_item import CheckItem
from py.common.util.connection_util import SshService
from py.common.entity.check_result import CheckResult


def execute(env, method):
    """
    清理环境上扩容文件信息
    :param method:
    :return: 执行结果
    """
    return CleanFile(env).execute(method)


class CleanFile(CheckItem):
    """
    清理环境
    """

    def do_check(self):
        cluster_tool_path = self.task_env.get_task_cache().get("cluster_tool_path")
        ssh_service = SshService(self.task_env.get_master_fsm_dev_node())
        ssh_service.execute_cmd("rm -rf {}".format(cluster_tool_path))
        cmd = '[ -d  "{}" ] && echo yes || echo no'.format(cluster_tool_path)
        rm_result = ssh_service.execute_cmd(cmd).replace(cmd, "")
        if "no" in rm_result:
            return CheckResult(CheckResult.PASS, "", "")
        return CheckResult(CheckResult.NOT_PASS, "", common.get_msg("failed.delete.file"))
