#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import json
import time

from py.common.entity.check_result import CheckResult
from py.common.entity.check_item import CheckItem
from py.common.java_adapter import java_adapter
from py.common.util.connection_util import SshService, RestService

QUERY_PRODUCT_MODEL_URL = "/dsware/service/noAuth/managerStatus"


def execute(env, method):
    return RebootFsmTomcat(env).execute(method)


class RebootFsmTomcat(CheckItem):
    def __init__(self, env):
        super(RebootFsmTomcat, self).__init__(env)
        self.fsm_dev_node = self.task_env.get_master_fsm_dev_node()
        self.path = self.task_env.get_task_cache().get("unzip_folder_path")
        self.cluster = self.task_env.get_dev_node()

    def do_check(self):
        """
        重启FSM的Tomcat
        """
        self.clean_fix_log()
        RestService(self.cluster).release_rest()
        cli_ret = SshService(self.fsm_dev_node).execute_cmd("su - omm -c restart_tomcat -s /bin/bash")
        if "restarted successfully" not in cli_ret:
            return CheckResult(CheckResult.NOT_PASS, cli_ret,
                               self.get_msg("reboot.fsm.tomcat.fail"))
        # 重启tomcat后需要等待fsm启动，通过轮询接口进行判断
        time.sleep(10)
        wait_sec = 0
        while wait_sec < 60:
            try:
                res_dict = json.loads(RestService(self.cluster).execute_get(QUERY_PRODUCT_MODEL_URL))
                if res_dict and res_dict.get("result") == 0:
                    return CheckResult(CheckResult.PASS, cli_ret, "")
            # 轮询接口时，如果fsm后台服务没有启动，会在Java侧抛出异常，需要捕获
            except (Exception, java_adapter.get_java_exception_class()):
                self.logger.error("The fsm server process is not reboot")
            # 出现过的场景：不加finally会出现异常错误信息，异常信息在return getattr(self, str(method))().to_dict()被捕获
            finally:
                wait_sec += 10
                time.sleep(10)
        return CheckResult(CheckResult.NOT_PASS, cli_ret, self.get_msg("reboot.fsm.tomcat.fail"))

    def clean_fix_log(self):
        # 清理记录文件防止对第二次扩容产生影响，临时实现，以后改为产品脚本侧修改
        ssh_service = SshService(self.fsm_dev_node)
        ssh_service.execute_cmd("cd {}".format(self.path))
        ssh_service.execute_cmd("rm -f fix_*")
