# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import re

CLI = None
LANGUAGE = None
IP_ADDR = None


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    CLI.execCmd("PS1='\\u:\\h:~$'")
    global LANGUAGE

    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    name = check_and_get_result(get_device_name())
    if name=="AIX":
        dev_type = "AIX"
        sn = check_and_get_result(get_serial_number())
        version = check_and_get_result(get_product_version())
    else:
        dev_type=""
        sn=""
        version=""

    return {"name": name, "type":dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmdNoLog("oslevel")
    dev_type = "AIX " + op_sys_info.splitlines()[1].strip()
    if "AIX " != dev_type:
        fun_flag = CHECK_PASS
    return fun_flag, dev_type, fun_err_msg



# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLog("uname -a")
    device_name = cli_ret.splitlines()[1].split()[0]

    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    cli_flag = CHECK_FAIL
    fun_err_msg = ''
    op_sys_ver = CLI.execCmdNoLog("oslevel")
    product_version = op_sys_ver.splitlines()[1].strip()
    if '' != product_version:
        fun_flag = CHECK_PASS
    return cli_flag, product_version, fun_err_msg


#need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    en_num = CLI.execCmdNoLog("netstat -in|grep "+IP_ADDR+" |awk '{print $1}'")
    mac_address = CLI.execCmdNoLog("netstat -in|grep "+en_num.splitlines()[1].strip()+"|grep link|awk '{print $4}'")
    mac_arr = mac_address.splitlines()[1].strip().split('.')
    for mac in mac_arr:
        if(len(mac)==1):
            serial_number += "0"
        serial_number +=mac
    if '' != serial_number:
        fun_flag = CHECK_PASS
    return fun_flag, serial_number, fun_err_msg
