﻿# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import re
import time
CLI = None
LANGUAGE = None
IP_ADDR = None
END_LIST = None

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()
    END_LIST = ['#',']']

    name = check_and_get_result(get_device_name())
    if name=="VMware":
        dev_type = check_and_get_result(get_dev_type())
        sn = check_and_get_result(get_serial_number())
        version = check_and_get_result(get_product_version())
    else:
        dev_type=""
        sn=""
        version=""

    return {"name": name, "type":dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmd("vmware -v",END_LIST)
    dev_type = op_sys_info.splitlines()[1].split()[1].strip()+" "+op_sys_info.splitlines()[1].split()[2].strip()
    if '' != dev_type:
        fun_flag = CHECK_PASS
    return fun_flag, dev_type, fun_err_msg

# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmd("uname -a",END_LIST)

    device_name = cli_ret.splitlines()[1].split()[0]
    if "VMkernel" == device_name:
        device_name = "VMware"

    # here
    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmd("vmware -v",END_LIST)
    product_version = op_sys_info.splitlines()[1].split()[2].strip()
    if '' != product_version:
        fun_flag = CHECK_PASS
    return fun_flag, product_version, fun_err_msg


#need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str = "0"
    mac_address = CLI.execCmd("esxcfg-vmknic -l|grep "+IP_ADDR,END_LIST)
    macPattern = re.compile(r" (([0-9a-fA-F]{1,2}:){4,}[0-9a-fA-F:]*) ")
    for line in mac_address.splitlines():
        macAddress = macPattern.search(line)
        if macAddress:
            mac_str = macAddress.group(1).replace(":", "")
            break

    if "0"==mac_str:
        serial_number = get_time_str()+IP_ADDR
    else:
        serial_number = mac_str + IP_ADDR
        
    if '' != serial_number:
        fun_flag = CHECK_PASS
    else:
        serial_number = "SN" + get_time_str()+IP_ADDR
    serial_number = serial_number.replace('.', '')
        
    return fun_flag, serial_number, fun_err_msg

def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S',time.localtime(time.time()))
    t = t.replace('-', '')
    return t
 