# -*- coding: UTF-8 -*-
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time

CLI = None
LANGUAGE = None
IP_ADDR = None

#交换机命令
display_cmd_command = "show system"


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    name = "McDATA"
    dev_type = check_and_get_result(getSwitchType())
    sn = check_and_get_result(getSwitchWWN())
    version = check_and_get_result(getSwitchVersion())

    return {"name": name, "type":dev_type, "sn": sn, "version": version}

# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)
    
def getSwitchType():
    '''
    @summary: 获取交换机类型
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机类型
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLog("show system")
    cli_ret_list = cli_ret.splitlines()
    
    switchType = ""
    for line in cli_ret_list:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "Type Number":
            try:
            
                switchType = str(int(fieldValue))
            except:
                switchType = fieldValue
            
    # here
    if len(switchType) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = "获取交换机类型失败。"
        else:
            fun_err_msg = "Get switch type failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchType, fun_err_msg

def getSwitchVersion():
    '''
    @summary: 获取交换机版本号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机版本号
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
  
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    
    switchVersion = ""
    for line in cli_ret_list:
        fields = line.split(":")
        if len(fields) < 2:
            continue
        
        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()
        
        if fieldName == "Firmware Version":
            switchVersion = fieldValue
            
    # here
    if len(switchVersion) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机版本号失败。"
        else:
            fun_err_msg = "Get switch version failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchVersion, fun_err_msg

def getSwitchWWN():
    '''
    @summary: 获取交换机WWN号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机WWN号
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
  
    
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    
    switchWwn = "" 
    for line in cli_ret_list:
            
        fields = line.split(":")
        if len(fields) < 2 :
            continue
        
        fieldName = fields[0].strip()      
        if fieldName == "Serial Number":
            switchWwn = line[line.index(":") + 1:].strip()
    # here
    if len(switchWwn) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机WWN号失败。"
        else:
            fun_err_msg = "Get switch WWN failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchWwn, fun_err_msg
