#!/bin/bash

shopt -s expand_aliases

HOSTNAME=$(hostname)

# FILE|LOG|PROFILE|MAP
SNAS_MSG_LOG="/var/log/snasmessages"
NAS_KLOG="/var/log/platform/nas_klog"
SNAS_DLM_LOG="/var/log/snas_dlm.log"
DLM_INFO="/proc/dlm_info"
CA_MAP="/proc/monc_camap"
MDS_MAP="/proc/monc_mdsmap"
DS_MAP="/proc/monc_dsmap"
SNAS_INI="/opt/huawei/snas/etc/snas.ini"
NODE_MAP="/proc/monc_nodemap"
CCDB_MAP="/proc/ccdb_statemap"
DEPLOY_XML="/opt/huawei/deploy/etc/deployconfig.xml"
SOFT_VER="/opt/huawei/deploy/package/version"

# ALIAS Commands
alias ALI_GetProTmoutReq='nas_proto_pum -m nas_vfs -c get_timeout_stat'
alias ALI_GetCAMemInfo='MmlBatch 988 "mem show stat 3" '
alias ALI_GetMDSMemInfo='MmlBatch 988 "mem show stat 1" '
alias ALI_GetMDSFcInfo='MmlBatch 988 "mds statis fc" '

alias ALI_GetProLeakMem='nas_proto_pum -m nas_mem -c get_all_leak'
alias ALI_GetMDSMemLruInfo='MmlBatch 988 "mds show lru"'
alias ALI_GetMDSMemFragInfo='MmlBatch 988 "mem show stat 1"'
alias ALI_GetOBSMemInfo='MmlBatch 988 "mem show stat 9 "'
alias ALI_GetDSMemInfo='MmlBatch 988 "mem show stat 2 "'
alias ALI_GetNOFSMemInfo='MmlBatch 988 "mem show stat 15" '
alias ALI_GetSYSMemInfo="free -m | sed -n '2p' | awk '{print   $3/$2*100}'"
alias ALI_GetDLMMemInfo="echo -n 'showmp'> $DLM_INFO; cat $DLM_INFO"
alias ALI_GetNOFSMemInfo='MmlBatch 988 "mem show stat 15"'

alias ALI_GetProOmniLockInfo='nas_proto_pum -m omni_lock -c get_lockc_stat '
alias ALI_GetMDSLockInfo='MmlBatch 988 "mds show trk" '
alias ALI_GetDLMZoneInfo="echo -n 'showzone' >$DLM_INFO;cat $DLM_INFO"
alias ALI_GetDLMLockInfo="echo -n 'dir showall' >$DLM_INFO;cat $DLM_INFO"

alias ALI_GetAbnorCAMap='grep Abnormal $CA_MAP'
alias ALI_GetAbnorMDSMap='grep Abnormal $MDS_MAP'
alias ALI_GetAbnorDSMap='grep Abnormal $DS_MAP'

alias ALI_GetProVfsHangInfo='nas_proto_pum -m nas_vfs -c get_timeout_stat'
alias ALI_GetNOFSDiskInfo='/opt/huawei/snas/sbin/nofs-snas getpoolinfo'
alias ALI_GetNOFSStackInfo='checkStackStatus.sh snas_nofs'

# VARIABLE Commands
ETHTOOL_CMD="/sbin/ethtool"

RED="\033[0;31m"
YELLOW="\033[0;33m"
GREEN="\033[0;32m"
NONE="\033[0;0m"

# RET Codes
E_BADFC=1
E_BADMEM=2
E_BADNET=3
E_DEADLOCK=4
E_BADMAP=5
E_BADPFC=6
E_HANG=7
E_EIO=8
E_PASS=0
E_FAIL=1

# SLEEP Time(s)
INTERVAL=1


# LOG
MAX_LOGFILE_SIZE=2097152
DIAG_LOGFILE="/var/log/onlineDiag.log"


# FUNCTION
function COMM_Usage()
{
	local info="$1"
	 
	[ -n "$info" ] && echo "$info" >&$output_fd

	echo "Usage: OPTION..."  >&$output_fd
	printf "      %-60s %-20s\n" "./diagnose -h" ":Display brief usage message and help message" >&$output_fd
    printf "      %-60s %-20s\n" "./diagnose -m [fc|mem|net|lock|map|pfc|hang|eio|sys]" ":Diagnose module" >&$output_fd
	echo ""  >&$output_fd
}

function COMM_LogRotate()
{
	local logFile="$1"
    local logSize="$2"

    # If the given file already exists and its size is
    # more than the maximum allowed, take a backup of that
    # file and create a new empty one with given name.
    if ! [ -f $logFile ]; then
        cat /dev/null > $logFile
    else
        local t_filesize=`/bin/ls -l $1 2> /dev/null | awk '{print $5}'`
        if [ -n "$logSize" ]; then
            size=$logSize
        else
            size=$MAX_LOGFILE_SIZE
        fi

        if [ $t_filesize -gt $size ]; then
            mv $logFile ${logFile}_old
            cat /dev/null > $logFile
        fi
    fi
}

function COMM_PrintLogHeader()
{
    # Print the current date information to file as a header
    echo
    echo "##########################################"
    echo "#"
    t_date=$( date )
    t_node=$( hostname )
    echo "# ${t_node} $t_date"
    echo "#"
    echo "##########################################"
    echo
}

function COMM_SetupLogFile()
{
    local logFile="$1"
    local logSize="$2"

    # Setup the output logfile where logs should be written
    if  [ -n "$logFile" ]
    then
        COMM_LogRotate $logFile $logSize

        # Change file descriptors so that all output goes to logfile
        # for output that should be shown to the user, use this fd
        output_fd=3
        output_fd_error=4
        exec 3>&1
        exec 4>&2
        exec 2>>$logFile
        exec 1>>$logFile
        COMM_PrintLogHeader
    else
        output_fd=3
        output_fd_error=4
        exec 3>&1
        exec 4>&2
    fi
}

function COMM_UnsetupLogfile
{
    # Setup the output logfile where logs should be written.
    if ! [ -z "$output_fd" ] && ! [ -z "$output_fd_error" ]
    then
        set +x
        exec 2>&$output_fd_error
        exec 1>&$output_fd
        output_fd=0
        output_fd_error=0
    fi
}

function COMM_GetSrvType()
{
	awk -F'=' '{if($1 == "serviceType") {print $2}}' $SNAS_INI | sed -r 's/\s+//g'
}

function COMM_GetCAFcPct()
{
	local srv=$(COMM_GetSrvType)

	case "$srv" in 
	default)
		echo $FC_CA_MEM_THRESHOLD4DEF
	;;
    *)
		echo $FC_CA_MEM_THRESHOLD4OTH
	;;
	esac
}

function COMM_GetMDSKeyMem()
{
	ALI_GetMDSMemLruInfo | egrep -i 'llLeftMemSize|uiYellowMemLine|uiRedMemLine' | \
	awk -F'=' '{print $2}'| xargs 
}

function COMM_GetMDSFcInfo()
{
	ALI_GetMDSFcInfo | egrep 'SrvDiscardReq4Cnt|SrvDiscardReq4Mem|SrvDiscardReq4Cnt|SrvDiscardReq4Mem' | \
	awk -F'=' '{print $2}'| sed -r 's/\s+//g' | xargs 
}

function COMM_NumComp()
{
	local compared="$1"
	local compar="$2"
	local flag="$3"

	compared=$(echo "$compared" | sed -r 's/\s+//g')
	compar=$(echo "$compar" | sed -r 's/\s+//g')
	case "$flag" in
	ge)
		[ ${compar:-0} -ge ${compared:-0} ] && return 0 || return 1
	;;
	gt)
		[ ${compar:-0} -gt ${compared:-0} ] && return 0 || return 1
	;;
	esac
}

function COMM_GetLocalTime()
{
	date "+%y%m%d%H"
}

function COMM_GetLocalTime4Pro()
{
	local Zone=$(date +"%z")
	local Time=$(date "+%Y-%m-%d %H")
	local Version=$(COMM_GetSoftVersion)

	local ZHour="${Zone:1:2}"
	local DHour=0

	# 8 is the Zone of BeiJing.
	
	let DHour=8-${ZHour/#0/}		
	CHour=${Time##* }
	let CHour=CHour+DHour

	if ! [[ "$Version" =~ "V500R007C10" ]]; then
		Time=$(echo "$Time" | awk '{$2='${CHour}';print $0}')
	fi

	echo $Time
	
}

function COMM_GetBackendPort()
{
	grep 'subnetwork_id.*=1$' $SNAS_INI | while read subnetwork_id ;do 
		ids=$(echo $subnetwork_id |cut -d"=" -f1 |awk -F'_' '{print $NF}')
		grep -P "subnetwork_port_${ids}"'\s*=' $SNAS_INI | awk -F'=' '{print $2}'
	done
}

function COMM_GetPortDriver()
{
	local port="$1"
	
	$ETHTOOL_CMD -i  $port | sed -r 's/\s+//g' |awk -F':' '{if($1=="driver"){print $2}}'
}

function COMM_SearchLog4Module()
{
	local logFile="$1"
	local logInfo="$2"
	local Module="$3"
	local tm=""
	
	if [ "X${Module##*#}" != "XPRO" ];then
		tm=$(COMM_GetLocalTime)
	else
		tm=$(COMM_GetLocalTime4Pro)
	fi	
	
	if [[ "$logFile" =~ "snas_dlm.log" ]];then
		Ver=$(COMM_GetSoftVersion)
		if [[ "$Ver" =~ "V300R006C00" ]]; then
			logFile=${SNAS_MSG_LOG}
		fi
	fi	


	tms=$(egrep -i  "\[${tm}${logInfo}" $logFile | wc -l)
	(( tms == 0 )) && ret="I" || ret="E"

	COMM_CPrint "${Module}#LOG(${logFile##*/}|${logInfo}|${tms})"  "$ret"	
}

function COMM_GetSoftVersion()
{
	awk -F'=' '{if($1=="ProductVersion"){print $2}}' $SOFT_VER | sed -r 's/\s+//g'
}

function COMM_CheckFSMap()
{
	local map="$1"
	local mapFile=""
	
	case "$map" in
	CA)
		mapFile="$CA_MAP"
		;;
	MDS)
		mapFile="$MDS_MAP"
		;;
	DS)
		mapFile="$DS_MAP"
		;;
	esac
		
	abnormalInfo=$(grep -i abnormal $mapFile)
	[ -z "$abnormalInfo" ] && ret="I" || ret="E"
	COMM_CPrint "MAP#${map}#INF|AbnormalMAP(${mapFile##*/}|$abnormalInfo)"  "$ret"	
}

function COMM_GetNodeList()
{
	NodeList=$(sed -r -n '/DEVICELIST/,$p' $DEPLOY_XML | grep -oP 'PARAM name="name[^>]*' | awk -F'"' '{print $4}')
}

function COMM_GetBackendIPList()
{
	BackEndIPlist=($(sed -r -n '/DEVICELIST/,$p' $DEPLOY_XML | grep -oP 'PARAM name="backIp[^>]*' | awk -F'"' '{print $4}'))
}

function COMM_BuildSNASFile()
{
	local file="$1"

	echo '#!/bin/bash' > $file
	echo '$*' >>$file
	chmod 750 $file
}

function COMM_CPrint()
{
    local info="$1"
    local tp="$2"

	local color=""
	local state=""
	
    case $tp in
    E)
		color="$RED"
		state=FAIL
    ;;
    I)
		color="$GREEN"
		state=PASS
    ;;
    W)
		color="$YELLOW"
		state=CHECK
	;;
	*)
		color="$GREEN"
		state=""
    ;;
    esac
	
	printf "${color}%-25s:%-70s [%s]${NONE}\n" "${HOSTNAME}:${info%#*}"  "${info##*\#}" "$state" >&$output_fd
}

