#!/bin/bash

. ./diag_lib.sh

MAP_CCDB_STATUS="result:0,status:2"

function MAP_Diagnosis4CA()
{
	COMM_CheckFSMap "CA"
}

function MAP_Diagnosis4MDS()
{
	COMM_CheckFSMap "MDS"
}

function MAP_Diagnosis4DS()
{
	COMM_CheckFSMap "DS"
}

function MAP_Diagnosis4CCDB()
{
	grep -q '^'"${MAP_CCDB_STATUS}"'$' $CCDB_MAP && ret="I" || ret="E"
	
	COMM_CPrint "MAP#CCDB#INF|MAP(${CCDB_MAP##*/}|${MAP_CCDB_STATUS})" "${ret}"
}

function MAP_Diagnosis()
{	
	(MAP_Diagnosis4CA) &
	(MAP_Diagnosis4MDS) &
	(MAP_Diagnosis4DS) &
	(MAP_Diagnosis4CCDB)&
	wait
}


