#!/bin/bash

. ./diag_lib.sh

MNT_FSSHARE_PATH='/mnt/fs/share'
TIMER=10

function SYS_Diagnosis4Ping()
{
	local index=0
	
	COMM_GetNodeList
	COMM_GetBackendIPList
	for NodeName in $NodeList;do
		if ! ping -W 5 -c 4  ${BackEndIPlist[$index]}  && ! ping -W 5 -c 4  ${BackEndIPlist[$index + 1]}   ;then
			COMM_CPrint "SYS#PING#INF|PING(${NodeName}:${BackEndIPlist[$index]}|${BackEndIPlist[$index + 1]} can not PING)" "E"
		else
			COMM_CPrint "SYS#PING#INF|PING(${NodeName}:${BackEndIPlist[$index]}|${BackEndIPlist[$index + 1]} can successfully PING)" "I"
		fi
		let 'index+=2'
	done
}

function SYS_Diagnosis4AccessFS()
{
	local dirs=""
	local tmpfile="./tmpfile.$$"

	COMM_BuildSNASFile "snas.sh"
		
	timeout -s SIGKILL $TIMER ./snas.sh ls ${MNT_FSSHARE_PATH} >$tmpfile 2>&1
	ret=$?
	info=$(cat $tmpfile  |tr '\n' ' ')
	if [ $ret -eq 124 -o $ret -eq 137 ]; then
		COMM_CPrint "SYS#FS#INF|Filesystem/TMOUT(${MNT_FSSHARE_PATH}|${TIMER}s)" "E"
	elif [ $ret -ne 0 ];then
		COMM_CPrint "SYS#FS#INF|Filesystem/CMDERR(${MNT_FSSHARE_PATH}|${info})" "E"
	else
		COMM_CPrint "SYS#FS#INF|Filesystem/DIRINFO(${MNT_FSSHARE_PATH}|${info})"  "I"
	fi
	[ -f "$tmpfile" ] && rm "$tmpfile"
}

function SYS_Diagnosis()
{
	(SYS_Diagnosis4AccessFS ) &
	(SYS_Diagnosis4Ping) &
	wait
}

