#!/bin/bash
set +x

# ********************************************** ***************************** #
# File Name: inspect_software.sh
# Description: ѲĿе״̬.
# Input:
# Output:
# Author:
# Created: 2013-01-16
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #
G_SCRIPT_PATH="/opt/inspect"
dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1
. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

. /opt/node_devicename.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile$$"
G_REMOTE_TMP_FILE="/tmp/tmpfile$$"
G_TMP_FILE2="$G_SCRIPT_PATH/tmpfilex$$"
G_REMOTE_TMP_FILE2="/tmp/tmpfilex$$"

IP_ROLE_FILE="/tmp/tmp_ip_role"
G_LINE_FILE="/tmp/lines.txt"
G_TOTALCAP_FILE="/tmp/totalcap.txt"
G_FREECAP_FILE="/tmp/freecap.txt"
G_INFO_FILE="/tmp/dsinfo.txt"

G_UNKNOWN_PROTO="Unknown protocol type"
G_CMD_FAILED="Execute command failed!"
LOG_FILE="/var/log/inspect.log"
LOG_FILE_BAK="/var/log/inspect_1.log"
REPLACE_HWDIR_SEDSTR="s/\/opt\/huawei\//\/opt\/product\//g"
STANDBY_IP_FILE="/tmp/standbyiplistrole.tmp"

VALID_IP_FILE="/tmp/tmp_valid_ip$$"
VALID_IP_FILE2="/tmp/tmp_valid_ip2"
VALID_IP_FILE3="/tmp/tmp_valid_ip3"

export G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
. $G_MML_FILE_PATH/CommonFunc.sh
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=759
FIFO_THREAD_NUM_MAX=60
RPC_REFER_CNT_MAX=20

G_SEPARATOR="-----------------------------------------------------------------------------"

RPC_REFER_PROC_FILE="/proc/sys/internalrpc/rpc_req_leak"
RPC_REFER_CNT_KEY="The leaked requests are found"

G_GET_REPLICATION_INFO="/opt/huawei/snas/script/inspect_mml/GetReplicationInfo"

G_REMOTE_EXEX_RESULT="/tmp/tmpfileRemoteResult$$"
G_DOWNLOAD_FILE="/tmp/inspect_downloadfile$$"


function LOG
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}
function check_pass()
{
    local list=(["2"]=0 ["1"]=1 ["4"]=2 ["0"]=3 ["3"]=4) #δ(2)>ͨ(1)>Ż(4)>ͨ(0)>漰(3)
    local isPass=$1   #Ⱥ
    local tmpIsPass=$2 #ǰ

    if [ ${list[$tmpIsPass]} -lt ${list[$isPass]} ];then
        isPass=$tmpIsPass
    fi
    echo $isPass
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"
}

function get_nlunmap()
{
    local result_log=/var/log/nluninfo.log
    #ȡIP
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        WRITE_XML_ERROR 0 "INFO:Failed to get local ip."
        return 1
    fi

    nlunready=0
    #ڵǷ񶼼뵽nlunmapУ15sһΣ4ΣҲ1ӡѲ칤ÿȴ5
    waitcount=0
    while [ $waitcount -lt 4 ]
    do
        #Ƚ/var/log/nluninfo.log
        >${result_log}

         $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "monc nluninfo 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
         iRet=$?
         if [ $iRet -ne 0 ]; then
             Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
             LOG "[$FUNCNAME]mml_result:$Info"
             WRITE_XML_COMMON 0 "INFO:Failed to execute command(monc nluninfo 0)."
             nlunready=0
             break
         fi

        #ȡеnodepoolǷÿnodepoolеĽڵ㶼nlun(ֻҪһnodepoolеĽڵnlunУnodepoolеĽڵ㶼nlun)
        allNodePool=`cat /proc/monc_tiermap | grep "nodepool id" | awk -F: '{print $2}'`
        for tmpNodePool in $allNodePool
        do
            nlunready=0
            frontIpInPool=`cat /proc/monc_tiermap | grep -A16 "nodepool id :$tmpNodePool" | grep "node :" | sed 's/node : *//'`
        if [ "$frontIpInPool" = "" ];then
            LOG "[$FUNCNAME]:nodepool:$tmpNodePool no node."
        nlunready=1
        fi
            allBackIp=""
            allDsId=""
            #nodepoolǰipdsmapǺipҪǰipҶӦĺipٸݺipdsid
            for tmpfront in $frontIpInPool
            do
                tmpBackIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=(select NID from CM_NODE_IP_T where IP_ADDR=\"$tmpfront\") and SUBNET_ID=1"`
                allBackIp=${allBackIp}" "${tmpBackIp}
                for tmpip in $tmpBackIp
                do
                    dsIdQuery=`cat /proc/monc_dsmap | grep "$tmpip" | awk '{print $2}'`
                    allDsId=${allDsId}" $dsIdQuery"
                done
            done

            for dsid in $allDsId
            do
                grep "($dsid" ${result_log} > /dev/null
                if [ $? -eq 0 ];then
                    LOG "[$FUNCNAME]:ds $allDsId is in nlunmap"
                    nlunready=1
                    break
                fi
            done
            #ǰnodepoolеĽڵ㶼mapУΪmapҪ
            if [ $nlunready -ne 1 ];then
                LOG "[$FUNCNAME]:ds $allDsId is not in nlunmap"
                break
            fi
        done

        #nodepoolдpoolнڵ㶼ûnlunУ˵nlunûãȴһʱ
        if [ $nlunready -ne 1 ];then
            sleep 15
            let "waitcount=$waitcount+1"
        else
            break;
        fi
    done

    #nlun״̬ǲǳɹ˵βѯʧˣ󷵻ʧܼ
    if [ $nlunready -ne 1 ];then
        WRITE_XML_ERROR 0 "nodes $allBackIp have no nlunmap."
        return 0
    else
        return 1
    fi
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$$$2"
    local exe_cmd=$3

    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ] || [ $iRet -eq 107 ] || [ "X${proresult}" == "X" ]; then
            LOG "[$FUNCNAME]:IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,TryTimes:$time"
            sleep 10
        else
            break
        fi
    done
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query.if command(${exe_cmd}) was finished or not. Error(${iRet})."
        if [ $iRet -eq 106 ];then
            return 125 # timeout=125
        fi
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query.if command(${exe_cmd}) was finished or not. Errno(${errno})."
        if [ "$errno" = "106" ]; then
            return 125 # timeout=125
        fi
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query.if command(${exe_cmd}) was finished or not. Progress(${process})."
        return 4    #δ
    fi
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$$$2"
    local time_out=$3
    local cmd=$4
    local iRet=0
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        iRet=$?
        LOG "[$FUNCNAME][$LINENO]:IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,tTryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
    fi
    done
    return $iRet
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item,item:${G_CHECK_IDLIST}||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command($3).Error(${iRet})."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}
#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item,item:${G_CHECK_IDLIST}||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command($3 $Item).Error(${iRet})."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    # ȡڵĸ
    nodeNum=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select HOSTNAME from CM_NODE_T" | wc -l)
    if [ "$nodeNum" -gt 1 ];then
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download "$remote_ip" "$local_file" "$remote_file"
            iRet=$?
            LOG "[$FUNCNAME] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:$iRet TryTimes:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                break
            fi
        done
    else
        if [ "$remote_file" != "$local_file" ];then
            mv "$remote_file" "$local_file"
            iRet=$?
            LOG "[$FUNCNAME][$LINENO] mv $remote_file $local_file, iRet:($iRet)."
        else
            if [ -f "${local_file}" ];then
                LOG "[$FUNCNAME][$LINENO] $local_file already exists."
            else
                iRet=1
                LOG "[$FUNCNAME][$LINENO] $local_file does not exist."
            fi
        fi
    fi

    if [ "$nodeNum" -gt 1 ];then
        remote_exec "$remote_ip" 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
        iRmRet=$?
        if [ $iRmRet -ne 0 ]; then
            LOG "[$FUNCNAME][$LINENO] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
        fi
    fi

    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' "$local_file" 2>&1

    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:$iRet TryTimes:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

#ȡڵһõĺIP
function get_backnet_ip
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "${IpNum:-0}" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            break
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#ȡȺDFSڵһIP
function get_dfs_backnet_ip
{
    local dfs_nid=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID from CM_NODE_T where (Reserved2 = 0 OR Reserved2 = 1)")
    local dfs_ip=$(get_node_backnet_ip "${dfs_nid}")

    echo $dfs_ip
    return 0
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    local IpNum=0
    local BackendIp=""
    IpNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select COUNT(*) from (select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID);"`
    if [ "${IpNum:-0}" -eq 0 ]; then
        LOG "[$FUNCNAME]There is no back subnet IP of $nid in db"
        return 1
    fi

    while [ "$temp" -le "${IpNum:-0}" ];
    do
        BackendIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit $((temp - 1)), $temp;"`
        if [ "$BackendIp" = "" ]; then
            LOG "[$FUNCNAME] Get back ip of $nid failed"
            temp=$((temp + 1))
            continue
        else
            #try ping
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                temp=$((temp + 1))
                continue
            else
                LOG "[$FUNCNAME] Get back ip of $nid: $BackendIp"
                break
            fi
        fi
    done
    echo ${BackendIp}
}

function get_valid_back_ip_by_dsid()
{
    local ds_id=$1
    local back_ip=""
    local back_ips=""
    local i=1
    local cnt=0

    back_ip=`grep "DS $ds_id " /proc/monc_dsmap|awk '{print $14}'`
    back_ips=`sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 and NID=(select NID from CM_NODE_IP_T where SUBNET_ID=1 and IP_ADDR=\"$back_ip\" limit 1)"`
    cnt=`echo "$back_ips" | wc -l`
    while [ "$i" -le "$cnt" ]
    do
        back_ip=`echo "$back_ips" | awk NR==$i'{print $1}'`
        #try ping
        for time in ${RepeatTimes[*]};do
            ping_result=`ping -q -c 1 $back_ip  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ];then
                sleep 10
            else
                break
            fi
        done

        if [ "$ping_result" != "0" ];then
            echo "$back_ip"
            return
        fi

        i=$((i + 1))
    done
}

checkIOPerform()
{
    rcount=`cat $G_TMP_FILE$Item |grep '<read count>' |sed "s/[^0-9]//g"`
    wcount=`cat $G_TMP_FILE$Item |grep '<write count>' |sed "s/[^0-9]//g"`
    ccount=`cat $G_TMP_FILE$Item |grep '<cmd count>' |sed "s/[^0-9]//g"`
    rbytes=`cat $G_TMP_FILE$Item |grep '<read bytes>' |sed "s/[^0-9]//g"`
    wbytes=`cat $G_TMP_FILE$Item |grep '<write bytes>' |sed "s/[^0-9]//g"`
    maxcalldelay=`cat $G_TMP_FILE$Item |grep '<max call delay(ms)>' |sed "s/[^0-9]//g"`
    maxreaddelay=`cat $G_TMP_FILE$Item |grep '<max read delay(ms)>' |sed "s/[^0-9]//g"`
    maxwritedelay=`cat $G_TMP_FILE$Item |grep '<max write delay(ms)>' |sed "s/[^0-9]//g"`
    totalcmddelay=`cat $G_TMP_FILE$Item |grep '<total cmd delay(ms)>' |sed "s/[^0-9]//g"`
    totalreaddelay=`cat $G_TMP_FILE$Item |grep '<total read delay(ms)>' |sed "s/[^0-9]//g"`
    totalwritedelay=`cat $G_TMP_FILE$Item |grep '<total write delay(ms)>' |sed "s/[^0-9]//g"`

    result="IP:$2||Protocol:$1||CheckType:IO perform||Read count:${rcount}||Write count:${wcount}||Cmd count:${ccount}"
    result=${result}"||Read bytes:${rbytes}||Write bytes:${wbytes}"
    result=${result}"||max call delay(ms):${maxcalldelay}||max read delay(ms):${maxreaddelay}||max write delay(ms):${maxwritedelay}"
    result=${result}"||total cmd delay(ms):${totalcmddelay}||total read delay(ms):${totalreaddelay}||total write delay(ms):${totalwritedelay}"
    echo $result

    if [[ ${maxreaddelay} -gt 50000 ||  ${maxwritedelay} -gt 50000 || ${maxcalldelay} -gt 50000 ]];then
        LOG "[$FUNCNAME]$1 $2 maxreaddelay($maxreaddelay) or maxwritedelay($maxwritedelay) or maxcalldelay(${maxcalldelay}) over 50 !"
        return 1
    fi

    return 0
}


#һΧڵ
function ProduceRandom()
{
    min=$1
    max=$2-$1
    num=$(date +%s+%N)
    ((retnum=num%max+min))
    echo $retnum
}

checkNASClient()
{
    local Item=$1
    local res=$(cat $G_TMP_FILE$Item)
    if [ "${res}" == "Does not involve" ];then
        LOG "res:${res}"
        result="$res"
        return 0
    fi

    client_ip=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
    client_num=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'|wc -l`
    client_protocal=`cat $G_TMP_FILE$Item |grep "proto_type"| sed 's/[^A-Z]//g'`
    result="LocalIp:$1||client_num:${client_num}||client_type:$2"

    info=`cat $G_TMP_FILE$Item`
    LOG "[$FUNCNAME] $1 ,info:$info"
    LOG "client_num:$client_num"

    if [ ${client_num} -gt 400 ];then
        LOG "[$FUNCNAME]$1 ${client_protocal} client num(${client_num}) over 400!"
        echo $result
        return 1
    else
        echo "LocalIp:$1||client_num:$client_num||client_type:$2"
    fi
}

#===================================================
# ƣȡcm_conf.dbнڵӦķ
# ܣ
# 
#===================================================
function get_service_type_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do

        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${service_type}" == "" ]]
    do

        LOG "[$FUNCNAME]Failed to get service_type from db ,temp=$temp"
        service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${service_type}
}
#===================================================
# ƣȡcm_conf.dbнڵӦIP
# ܣͨڵĺIPݿжϵǰڵIPV4 or IPV6
# 
#===================================================
function get_frontip_type()
{
    local temp=1
    local ip=$1
    local FrontIP=""
    local iret=0
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    #ȡڵһǰIP
    local FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
    while [[ "${FrontIP}" == "" ]]
    do

        LOG "[$FUNCNAME]Failed to get FrontIP from db ,temp=$temp"
        FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    #IPûðűʾIPV4
    echo $FrontIP|grep -q "\:" > /dev/null
    iret=$?
    echo ${iret}
}

#===================================================
# ƣȡcm_conf.dbнڵӦĽڵ
# ܣͨڵĺIPݿȡڵ
# 
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do

        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}

hextoip() {
    hex=$1
    local length=`echo $hex |wc -c`
    if [ $length -lt 8 ] || [ $length -gt 9 ]; then
        printf "0"
        return
    fi
    if [ $length -eq 9 ]; then
        printf "%d." 0x${hex:0:2}
        printf "%d." 0x${hex:2:2}
        printf "%d." 0x${hex:4:2}
        printf "%d"  0x${hex:6:2}
    else
        printf "%d." 0x${hex:0:1}
        printf "%d." 0x${hex:1:2}
        printf "%d." 0x${hex:3:2}
        printf "%d"  0x${hex:5:2}
    fi
}

mdsMasterIP1=""
mdsMasterIP2=""
#ȡLeaderкIP
function getMdsMasterIps()
{

    mdsMasterIP1=""
    mdsMasterIP2=""
    local isPass=0
    local TASK_ID=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local service_type=0
    for Item in ${REMOTE_IP_S}; do
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi
        if [ "${ValidIP}" = "" ]; then
            ValidIP="${Item}"
        else
            ValidIP="${ValidIP} ${Item}"
        fi
    done

    #˵漰ĽڵԶʱļ
    REMOTE_IP_S=${ValidIP}
    remote_exec_async_batch_mml $TASK_ID 30 GetMdsSubtreeInfo $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            isDfs=1
            remote_exec_checkfini $Item $TASK_ID "GetMdsSubtreeInfo ${Item}"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(GetMdsSubtreeInfo ${Item}), Error(${iRet})."
                isPass=1
                continue
            fi

            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $G_TMP_FILE$Item >/dev/null 2>&1

            MDSMaster1=`cat $G_TMP_FILE$Item | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster1" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                Result="INFO:Failed to get MDS master1."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp1=$MDSMaster1
            mdsMasterIP1=`hextoip "${mdsMastertmp1}"`
            LOG "[$FUNCNAME]mdsMasterIP1:$mdsMasterIP1"
            if [ "$mdsMasterIP1" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp1) err."
                Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp1}) err."
                isPass=1
                break
            fi

            MDSMaster2=`cat $G_TMP_FILE$Item | grep "root mds 2nd ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster2" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                Result="INFO:Failed to get MDS master2."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp2=$MDSMaster2
            mdsMasterIP2=`hextoip "${mdsMastertmp2}"`
            LOG "[$FUNCNAME]mdsMasterIP2:$mdsMasterIP2"
            if [ "mdsMasterIP2" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp2) err."
                Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp2}) err."
                isPass=1
                break
            fi
            >${VALID_IP_FILE}
            break
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
}

checkOMIPandIPMIinOneNet()
{
    local omip_v4_gw=""
    local ipmi_v4_gw=""
    local omip_mask_v4=""
    local ipmi_mask_v4=""
    local omip_v6_gw=""
    local ipmi_v6_gw=""
    local omip_mask_v6=""
    local ipmi_mask_v6=""
    local ipmi_ip_v6_prefix_tmp=""
    local ret=0

    $G_MML_FILE_PATH/checkIPMI >/dev/null 2>&1

    omip_v4_gw=`cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway|awk -F= '{print $2}' |tr -d ' '`
    ipmi_v4_gw=`cat /tmp/tmpfilecheckIPMI|grep -w "Default Gateway IP"|awk -F: '{print $2}' | tr -d ' '`
    omip_mask_v4=`cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask|awk -F= '{print $2}' | tr -d ' '`
    ipmi_mask_v4=`cat /tmp/tmpfilecheckIPMI|grep -w "Subnet Mask"|awk -F: '{print $2}' |tr -d ' '`
    LOG "[$FUNCNAME]omip_v4_gw: $omip_v4_gw,ipmi_v4_gw: $ipmi_v4_gw,omip_mask_v4: $omip_mask_v4,ipmi_mask_v4: $ipmi_mask_v4"
    omip_v6_gw=`cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway_v6|awk -F= '{print $2}' |tr -d ' '`
    ipmi_v6_gw=`cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_gateway" | awk -F: '{print $2}'| tr -d ' '`
    omip_mask_v6=`cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask_v6|awk -F= '{print $2}' | tr -d ' '`
    ipmi_ip_v6_prefix_tmp=`cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_prefix" | awk -F: '{print $2} ' `
    ipmi_mask_v6="`printf %d 0x0$ipmi_ip_v6_prefix_tmp`"
    LOG "[$FUNCNAME]omip_v6_gw: $omip_v6_gw,ipmi_v6_gw: $ipmi_v6_gw,omip_mask_v6: $omip_mask_v6,ipmi_mask_v6: $ipmi_mask_v6"
    if [ "$omip_v4_gw" == "$ipmi_v4_gw" -a "$omip_mask_v4" == "$ipmi_mask_v4" ];then
        ret=1;
    fi
    if [ "$omip_v6_gw" == "$ipmi_v6_gw" -a "$omip_mask_v6" == "$ipmi_mask_v6" -a "$ipmi_mask_v6" != "0" ];then
        ret=1;
    fi
    [ -f "/tmp/tmpfilecheckIPMI" ] && rm -f "/tmp/tmpfilecheckIPMI"
    #űcheckIPMI
    [ -f "/tmp/tmpResultcheckIPMI" ] && rm -f "/tmp/tmpResultcheckIPMI"
    return $ret
}

#DiskPoolֵ
Checkdiskpoolcap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local PoolType=""
    local PoolTypeindex=0
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=`cat $G_TMP_FILE$Item | grep "DiskPool"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep DiskPool | sed -n "$index"p`
        PoolTypeindex=`cat $G_TMP_FILE$Item | grep -A12 "$HeadInfo" | grep PoolType | awk -F: '{print $2}'`
        PoolType="SSD"
        if [ "$PoolTypeindex" == "1" ]; then
            PoolType="HDD"
        fi

        TotalCap=`cat $G_TMP_FILE$Item | grep -A12 "$HeadInfo" | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A12 "$HeadInfo" | grep LeftCap | awk -F: '{print $2}'`

        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        Percentage=$(echo "scale=4; $UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.4f", $0}')

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:"$PoolType" "$HeadInfo"||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ]; then
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#NodePoolֵ
CheckNodePoolCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=`cat $G_TMP_FILE$Item | grep "NodePool"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep NodePool | awk NR==$index`

        TotalCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep LeftCap | awk -F: '{print $2}'`

        UsedCap=`echo $TotalCap-$LeftCap|bc -l`
        Percentage=$(echo "scale=4; $UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.4f", $0}')

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ];then
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#Tiercapֵ
CheckTierCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=`cat $G_TMP_FILE$Item | grep "Tier"|wc -l`
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=`cat $G_TMP_FILE$Item | grep Tier | awk NR==$index`

        TotalCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep TotalCap | awk -F: '{print $2}'`
        LeftCap=`cat $G_TMP_FILE$Item | grep -A4 "$HeadInfo" | grep LeftCap | awk -F: '{print $2}'`

        UsedCap=`echo $TotalCap-$LeftCap|bc -l`

        Percentage=$(echo "scale=4; $UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.4f", $0}')

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "$Result"
        Percentage=`echo $UsedCap/$TotalCap*100|bc -l`
        if [ `echo "$Percentage > 75.0" | bc` -eq 1 ];then
            LOG "[$FUNCNAME]:$isok"
            isok=1
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#λȡpoolname
NvdimmPool_GetPollName()
{
    case $1 in
        5)
            echo "Pool[nvcache.0]"
            ;;
        6)
            echo "Pool[trns.0]"
            ;;
        7)
            echo "Pool[ds.0]"
            ;;
        8)
            echo "Pool[quota.0]"
            ;;
        *)
            echo "Pool[UNKNOWN]"
            ;;
    esac
}

#ds mapȡ״̬쳣pool
getAbnormalPool()
{
    dsid=0
    poolid=0
    cat /proc/monc_dsmap > /var/dsmap
    > /var/abnormalpool;
    while read line
    do
        echo "$line" |grep "^Pools" &> /dev/null
        if [ $? -eq 0 ]; then
            dsid=`echo $line |awk -F" " '{print $4}' |awk -F":" '{print $1}'`
            continue;
        fi
        echo "$line" |grep "^Id" &> /dev/null
        if [ $? -eq 0 ]; then
            echo "$line" |grep "Abnormal" &> /dev/null
            if [ $? -ne 0 ]; then
                continue;
            fi
            #abnormal pool
            poolid=`echo $line |awk -F" " '{print $2}'`
            echo "($dsid $poolid)" >> /var/abnormalpool
        fi
    done < /var/dsmap
}

getDiskStatInNlun()
{
    bitmap=`printf %d 0x$1`
    cnt=$2
    index=$3
    cnt=$(($cnt-$index))
    cnt=$(($cnt-1))
    cnt=$((3*$cnt))
    bitmap=$(($bitmap>>$cnt))
    bitmap=$(($bitmap&7))
    return $bitmap;
}

addPoolInBadList()
{
    echo "$1" >> /var/nlun_pool_result
}

#nlun mapds mapеpool statǷһ
checkDiskStat()
{
    nlundiskstat=$1
    poolcnt=$2
    idx=$3
    pname=$4
    #ȡnlun disk statӦbitλ
    getDiskStatInNlun $nlundiskstat $poolcnt $idx
    if [ $? -eq 0 ]; then
        return
    fi
    #쳣poolǷѾ¼/var/nlun_pool_result
    grep "$pname" /var/nlun_pool_result &> /dev/null
    if [ $? -eq 0 ]; then
        return
    fi
    #ӹpool
    addPoolInBadList "($pname)"
}

#nlunгԱpool״̬״̬쳣DS map״̬һ¶ӡ$G_TMP_FILE2$Item
checkNlunPoolStatus()
{
    local result_log=/var/log/nluninfo.log

    > /var/nlun_pool_result
    #$result_logÿһ
    neednext=0
    while read line
    do
        if [[ "$line" == NLUN*NewPt* ]]; then
            diskstat=`echo $line |awk -F" " '{print $23}'`
            neednext=1
            continue;
        fi
        if [ $neednext -eq 1 ]; then
            neednext=0
            #ȡnlunԱ
            if [ $diskstat -ne 0 ]; then
                pools=`echo $line |awk 'BEGIN{FS="[()]"}{for(i=2;i<NF;i++) if($i!=" ")print $i}'`
                poolcnt=0
                for pool in $pools
                do
                    poolcnt=$(($poolcnt+1))
                done
                index=0
                for pool in $pools
                do
                    checkDiskStat $diskstat $poolcnt $index $pool
                    index=$(($index+1))
                done
            fi
        fi
    done < $result_log
    #/var/abnormalpoolе쳣̼/var/nlun_pool_result
    while read line
    do
        #쳣poolǷѾ¼/var/nlun_pool_result
        grep "$line" /var/nlun_pool_result &> /dev/null
        if [ $? -eq 0 ]; then
            continue;
        fi
        addPoolInBadList "$line"
    done < /var/abnormalpool
}

CheckReplicationMasterNodeChannel()
{
    local item="$1"
    local nodeip="$2"

    NodeNum=`echo "${item}" | awk '{print $5}'`
    ChannelNum=`echo "${item}" | awk '{print $6}'`
    WRITE_XML_COMMON 0 "Node:${nodeip}||NodeNum:$NodeNum||ChannelNum:$ChannelNum"
    if [ "X$NodeNum" == "X0" ] && [ "X$ChannelNum" == "X0" ]; then
        return 0
    elif [ "X$NodeNum" == "X0" ] && [ "X$ChannelNum" != "X0" ]; then
        WRITE_XML_ERROR 0 "Node:${nodeip}||INFO:Replication channels exit,but the number of replication nodes is zero in the replication area."
        return 1
    else
        WRITE_XML_ERROR 0 "Node:${nodeip}||INFO:Inter error."
        return 2
    fi
}

CheckReplicationMasterNodePair()
{
    local item="$1"
    local nodeip="$2"

    NodeNum=`echo "${item}" | awk '{print $5}'`
    PairCount=`echo "${item}" | awk '{print $6}'`
    WRITE_XML_COMMON 0 "Node: ${nodeip}|| NodeNum:$NodeNum||PairCount:$PairCount"
    if [ "X$NodeNum" == "X0" ] && [ "X$PairCount" == "X0" ]; then
        return 0
    elif [ "X$NodeNum" == "X0" ] && [ "X$PairCount" != "X0" ]; then
        WRITE_XML_ERROR 0 "Node:${nodeip}||INFO:Replication channels exit,but the number of replication nodes is zero in the replication area."
        return 1
    else
        WRITE_XML_ERROR 0 "Node:${nodeip}||INFO:Inter error"
        return 2
    fi
}

function JudgeLicense()
{
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
        WRITE_XML_ERROR 0 "Node:--||INFO:Can't get local IP."
        return 2
    fi

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $G_REMOTE_TMP_FILE2$FUNCNAME`
        LOG "[$FUNCNAME]mml_result:$Info"
        WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Failed to execute command(MmlBatch 4016 'cm licensecfg')."
        return 2
    fi

    dos2unix $G_REMOTE_TMP_FILE2$FUNCNAME > /dev/null 2>&1
    cat $G_REMOTE_TMP_FILE2$FUNCNAME >> $LOG_FILE 2>&1

    javaId=$(cat $G_REMOTE_TMP_FILE2$FUNCNAME|grep InfoReplicator)
    if [ "$javaId" = "" ]; then
        LOG "[$FUNCNAME]:javaId is null"
        WRITE_XML_COMMON 0 "No license resource exists. Do not involved to inspect."
        return 0
    fi

    acRunTime=`echo $javaId |awk '{print $7}'`
    LOG "acRunTime:$acRunTime"
    if [ "${acRunTime}" == "9999-12-31" ];then
        date1=$(date --date "${acRunTime}" +%s)
        return 1
    else
        date1=`expr $acRunTime \/ 1000`
    fi
    LOG "date1:$date1"
    date2=`date`

    t1=$date1
    t2=`date --date "$date2" +%s`
    LOG "acRunTime:$t1,CurrentTime:$t2"
    if [ $t1 -lt $t2 ]; then
        LOG "$acRunTime < $date2"
        WRITE_XML_COMMON 0 "License resource is disabled. Do not involved to inspect."
        return 0
    elif [ $t1 -eq $t2 ]; then
        LOG "$acRunTime = $date2"
        return 1
    else
        LOG "$acRunTime > $date2"
        return 1
    fi
}


#return:0 pass, 1 fail, 2 error

interCheckReplicationLink()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #add filed:NodeStatus NodeResult isMasterNode isCtrlNode
    #original filed:LogicId     ArrayID     LinkCnt     LiveLink     Status    Ref    Compatible
    #original filed:$NodeNum $ChannelNum
    while read item
    do
        nodeStatus=`echo "${item}" | awk '{print $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME][$LINENO] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=`echo "${item}" | awk '{print $2}'`
        isMasterNode=`echo "${item}" | awk '{print $3}'`
        isCtrlNode=`echo "${item}" | awk '{print $4}'`

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Excute diagnose command(GetReplicationInfo Link) failed."
            ret=2
            break
        fi

        #MasterNode and isCtrlNode=-, display
        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                CheckReplicationMasterNodeChannel "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:replication link not configure"
            ret=0
            break
        fi

        LogicId=`echo "${item}" | awk '{print $5}'`
        ArrayID=`echo "${item}" | awk '{print $6}'`
        LinkCnt=`echo "${item}" | awk '{print $7}'`
        LiveLink=`echo "${item}" | awk '{print $8}'`
        Status=`echo "${item}" | awk '{print $9}'`
        Ref=`echo "${item}" | awk '{print $10}'`
        Compatible=`echo "${item}" | awk '{print $11}'`
        if [ "X$LiveLink" = "X0" ]; then
                LOG "[$FUNCNAME][$LINENO] Node: $NodeIP item: $item."
                WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:The LiveLink of replication is 0."
                ret=1
        else
                WRITE_XML_COMMON 0 "LogicId:$LogicId||ArrayID:$ArrayID||LinkCnt:$LinkCnt||LiveLink:$LiveLink||Status:$Status||Ref:$Ref||Compatible:$Compatible"
        fi

    done <$tmpFile

    return $ret
}

#ûдѲΪ
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
    LOG "[$FUNCNAME][$LINENO]The current system does not support the appointed inspect item!"
}

###add Ѳ¿ܣѲ270-275#################

#ִ
exec_cmd()
{
    remoteIp=$1
    taskids=$2
    params=$3
    exec_taskid="CheckItems"
    command="${G_MML_FILE_PATH}/CheckItems '$taskids'> $G_REMOTE_EXEX_RESULT${params} 2>&1"
    remote_exec_async $remoteIp $exec_taskid 600 "$command"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME][$LINENO]Node:$remoteIp||INFO:Failed to exec_cmd command.item ${taskids}"
    fi
}

# **************************************************************************** #
# Function Name: download_standby_result
# Description: Զļ.
# Parameter: $1(remoteIp) $2(taskid) $3(localfileȫ·ļ) $4(remotefile)
# Return:
# **************************************************************************** #
function download_standby_result()
{
    local remoteIp=$1
    local taskid="$2"
    local localfile="$3"
    local remotefile="$4"
    local iRet=0
    #ѭֱسɹʧܺ˳ѭ
    while [[ ${remoteIp} != "" ]]
    do
    {
        remote_exec_checkfini $remoteIp $taskid "download ($remoteIp) exec result failed"
        iFunRet=$?
        if [ $iFunRet -eq 0 ];then
            continue
        elif [ $iFunRet -eq 2 || $iFunRet -eq 5 ];then
            iRet=0
        else
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_standby_result checkfini failed."
            iRet=1
        fi

        #Ϊ100%֮ļأн
        remote_download_sync $remoteIp ${localfile} ${remotefile}
        iFunRet=$?
        if [ $iFunRet -ne 0 ];then
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO:remote_download_sync return ($iFunRet) download_standby_result download file failed."
            iRet=1
        fi
        break
    }
    done
    return $iRet
}

function download_result()
{
    remoteIp=$1
    params=$2
    TASK_ID="CheckItems"
    local iRet=0
    #ѭֱسɹʧܺ˳ѭ
    while [[ ${remoteIp} != "" ]]
    do
    {
        remote_exec_checkfini $remoteIp $TASK_ID "checkwareStatusExBatch"
        iFunRet=$?
        if [ $iFunRet -eq 0 ];then
            continue
        elif [ $iFunRet -eq 2 -o $iFunRet -eq 5 ];then
            iRet=0
        elif [ $iFunRet -eq 125 ];then # timeout=125
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=125
        else
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=1
        fi

        #Ϊ100%֮ļؽнcheckfiniɹִزԶʱļ
        remote_download_sync $remoteIp $G_DOWNLOAD_FILE$remoteIp $G_REMOTE_EXEX_RESULT${params}
        iFunRet=$?
        if [ $iFunRet -ne 0 ];then
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO:remote_download_sync return ($iFunRet) download_result download file failed."
            [ ${iRet} -eq 0 ] && iRet=126 # checkfini succuss, download fail=126
        fi
        break
    }
    done
    return $iRet
}

#100. 
analyse_result_checkDiskUsage()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"


    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=$(cat ${CheckMsgFile}${Item})
        if [ "$fifoContext" = "" ];then
            isPass=1
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get disk infomation from output(${fun}) failed!"
            continue
        fi

        javaId=`grep -v Filesystem $CheckMsgFile$Item | sed 's/^ *//g'|sed "/^$/d"`

        set_ifs
        for line in $javaId; do
            if [ "$line" = "" ];then
                continue
            fi

            FileSystem=`echo $line |awk '{print $1}'`
            Size=`echo $line |awk '{print $2}'`
            Used=`echo $line |awk '{print $3}'`
            Avail=`echo $line |awk '{print $4}'`
            Percentage=`echo $line |awk '{print $5}'|sed 's/.$//'`
            Mounted=`echo $line |awk '{print $6}' | sed ${REPLACE_HWDIR_SEDSTR}`

            if [ X"/var/log/btmp" == X"${FileSystem}" ]; then
                local byte_of_10M=10485760
                if [ ${Size} -ge ${byte_of_10M} ]; then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:The size of /var/log/btmp is too big(${Size})."
                fi
                    
                continue
            fi

            Result="Node:$Item||FileSystem:$FileSystem||Size:$Size||Used:$Used||Avail:$Avail||Percentage(%):$Percentage||Mounted:$Mounted"
            WRITE_XML_COMMON 0 "$Result"

            if [ $Percentage -ge 78 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:The used percentage of partition ${Mounted} on ${Item} is greater than 78%."
                LOG "[$FUNCNAME][$LINENO]isPass:$isPass||item:$Item||Percentage:$Percentage"
            fi

        done
        restore_ifs
    }
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

#101. CPU
analyse_result_checkCPUUsage()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=$(cat ${CheckMsgFile}${Item})
        if [ "$fifoContext" = "" ];then
            isPass=1
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get CPU infomation from output(${fun}) failed!"
            continue
        fi

        userUsage=`grep "CPU_Usage:" $CheckMsgFile$Item |awk '{print $2}'`
        sysUsage=`grep "CPU_Usage:" $CheckMsgFile$Item |awk '{print $3}'`
        Percentage=`grep "CPU_Usage:" $CheckMsgFile$Item |awk '{print $4}'`
        crazyTask=`grep "CPU_CrazyTask:" $CheckMsgFile$Item |awk -F: '{print $2}'`
        #ռcpu5̵Ϣ
        info=`cat $CheckMsgFile$Item |head -3|tail -1`
        i=0
        Result=""
        while read line; do
            i=$[ $i + 1 ]
            #ǰ
            if [ $i -le 3 ]; then
                continue
            fi
            if [ "" != "${Result}" ]; then
                Result="$Result||CPU Usage:$line"
            else
                Result="CPU Usage:$line"
            fi
        done < $CheckMsgFile$Item

        #ıʶͬӰ칤߽ʾ
        Result="CPU Usage:${G_SEPARATOR}||CPU Usage:$Item||CPU Usage:user(%):$userUsage
                ||CPU Usage:system(%):$sysUsage||CPU Usage:Percentage(%):$Percentage
                ||CPU Usage:--------------detail--------------||CPU Usage:$info||${Result}"
        #ڵǷ߳ռCPU 100% 1
        if [ "${crazyTask}""X" != "0X" ];then
            isPass=4
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Task (PID:$crazyTask) fully occupies CPU resources for one minute!"
        fi
        WRITE_XML_COMMON 0 "<![CDATA[$Result]]>"

        if [ $(echo "$Percentage < 80"|bc) -ne 1 ];then
            isPass=4
            WRITE_XML_ERROR 0 "Node:$Item||INFO:The used percentage of CPU on ${Item} is greater than 80%!"
        fi
    }
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}



#133 ڴ
function analyse_result_checkPhyMem()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local nodepool=""
    local tMemSize=0
    local nodepoolinfo="/tmp/tmpfilenodepoolinfo"

    > $nodepoolinfo
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:($InspectFun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:($InspectFun) get PassStatus failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' >${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Can not get physical memory information from command ($InspectFun)."
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )

        nodePool=$(cat ${CheckMsgFile} | grep "^nodepool" | awk -F"=" '{print $2}' | tr -d ' ')
        tMemSize=$(cat ${CheckMsgFile} | grep "^totalmemsize" | awk -F"=" '{print $2}' | tr -d ' ')
        sed -i '/nodepool/d' ${CheckMsgFile}
        sed -i '/totalmemsize/d' ${CheckMsgFile}
        CheckMsgParse "$Item" "$CheckMsgFile" 0
        rm -rf $CheckMsgFile
        if [ "${nodePool}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Can not get nodepool name from command ($InspectFun)."
            continue
        fi
        if [ "${tMemSize}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Can not get total physical memory size from command ($InspectFun)."
            continue
        fi
        echo "${Item},${nodePool},${tMemSize}" >> ${nodepoolinfo}
    done

    arAllPool=$(cat $nodepoolinfo | tr -d ' ' | awk -F',' '{print $2}' | sort | uniq)
    for pool in $arAllPool; do
        memnum=$(cat $nodepoolinfo | tr -d ' '| grep "${pool}," | awk -F',' '{print $3}' | sort | uniq | wc -l)
        if [ $memnum -ne 1 ];then
            isPass=$(check_pass $isPass 1)
            memSize=$(cat $nodepoolinfo | tr -d ' '| grep "${pool}," | awk -F',' '{print $3}' | sort | uniq)
            for size in $memSize; do
                iplist=$(cat $nodepoolinfo | tr -d ' ' | grep "${pool},${size}" | awk -F',' '{print $1}' |sed ':jix;N;s/\n/,/g;b jix')
                if [ ${#iplist} -gt 50 ];then
                    iplist="${iplist:0:50}......"
                fi
                WRITE_XML_ERROR 0  "Node:--||INFO:There are $memnum memory sizes in nodepool($pool), and the $size (MB) IP address is ($iplist)."
            done
        fi
    done
    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}

#140 ״̬
function analyse_result_checkVmstatus()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local javaId=""
    local Result=""
    local errResult=""

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    #ںϳû
    local productVersion=$(grep ProductVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    if [[ "$productVersion" =~ "V100R006C30SPC" ]] || [[ "$productVersion" =~ "V100R006C10SPC" ]];then
        WRITE_XML_COMMON 0 "VM not Exist "
        WRITE_XML_JUDGE $isPass
        return
    fi
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get Vmms information from output(${InspectFun}) failed."
            continue
        fi

        #
        javaId=$( cat ${CheckMsgFile} )
        if [ "$javaId" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get VmId information from output(${InspectFun}) failed."
            #
            LOG "[$FUNCNAME][$LINENO]$(cat ${CheckMsgFile})"
            break
        fi

        set_ifs
        for line in $javaId; do

            if [ $line = "" ];then
                    LOG "[$FUNCNAME][$LINENO]this line is empty"
                continue
            fi

            VmBond=`echo $line |awk '{print $2}'`
            VmId=`echo $line |awk '{print $5}'`
            VmName=`echo $line |awk '{print $8}'`
            Health_Status=`echo $line |awk '{print $11}'`
            Running_Status=`echo $line |awk '{print $14}'`
            Bus_Mode=`echo $line |awk '{print $17}'`
            Start_Mode=`echo $line |awk '{print $20}'`
            Exsit_Status=`echo $line |awk '{print $NF}'`
            if [ "$Exsit_Status" != "1" ]; then
                LOG "[$FUNCNAME][$LINENO]:vm not Exsit"
                break
            else
                #ͨĵж״̬״̬
                HealthStatus=`MapHealthStatus $Health_Status`
                RunningStatus=`MapRunningStatus $Running_Status`
                BusMode=`BusModeStatus $Bus_Mode`
                StartMode=`StatModeStatus $Start_Mode`
                Result="IP:$Item||VmID:$VmId||VmName:$VmName||HealthStatus:$HealthStatus||RunningStatus:$RunningStatus||BusMode:$BusMode||StartMode:$StartMode||VmBond:$VmBond"
                WRITE_XML_COMMON 0 "$Result"

                errResult=""
                if [ "$RunningStatus" != "RUNNING" ] || [ "$HealthStatus" != "NORMAL" ] || [ "$BusMode" != "VIRTIO" ] || [ "$StartMode" != "HD" ];then
                    if [ "$RunningStatus" != "RUNNING" ]; then
                        LOG "[$FUNCNAME][$LINENO] ${VmId} RunningStatus(${RunningStatus}) not RUNNING!"
                        errResult="${errResult} Running status is not RUNNING."
                    fi

                    if [ "$HealthStatus" != "NORMAL" ];then
                        LOG "[$FUNCNAME][$LINENO] ${VmId} HealthStatus{$HealthStatus} not NORMAL!"
                        errResult="${errResult} Health status is not NORMAL."
                    fi

                    if [ "$BusMode" != "VIRTIO" ];then
                        LOG "[$FUNCNAME][$LINENO] ${VmId} BusMode(${BusMode}) not Virtio!"
                        errResult="${errResult} Bus mode is not VIRTIO."
                    fi

                    if [ "$StartMode" != "HD" ];then
                        LOG "[$FUNCNAME][$LINENO] ${VmId}StartMode(${StartMode}) not HD!"
                        errResult="${errResult} Bootup mode is not HD."
                    fi
                    isPass=$(check_pass $isPass 1)
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:About VM(VmID ${VmId}).${errResult}"
                fi
            fi
        done
        restore_ifs
    done

    if [ -z "$Result" ];then
        WRITE_XML_COMMON 0 "VM not Exist "
    fi

    WRITE_XML_JUDGE $isPass
}

function version_lt()
{
    test "$( echo "$@" | tr " " "\n" | sort -rV | head -n 1 )" != "$1";
}

#147 SAS̼汾
analyse_result_checkSASVersion()
{
    local fun=$1
    local fun_end=${fun}_End
    local CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local errResult=""
    local SASTypeList="/tmp/tmpfileSASVersionList"
    # T3000(2008,2308)  C72(PM8070)
    local SASTypeArray=("SAS3008")
    local RHTypeArray=("V3 V5")

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=$(cat ${CheckMsgFile}${Item})
        if [ "$fifoContext" = "" ];then
            isPass=1
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            errResult="Node:${Item}||INFO:Get SAS version infomation from output(${fun}) failed!||${errResult}"
            continue
        fi

        isNeedcheck=$(cat $CheckMsgFile$Item | grep "Does not involve")
        LOG "[$FUNCNAME][$LINENO]isNeedcheck=$isNeedcheck"
        if [ "$isNeedcheck" != "" ];then
            WRITE_XML_COMMON 0 "Node:$Item||Node_Version:not invovle||Controller:--||NVDATA:--||Firmware:--||BIOS_Version:--||UEFI_BSD:--"
            continue
        fi

        Controller=$(cat $CheckMsgFile$Item | grep "Controller" | awk -F'=' '{print $2}')
        if [ "$Controller" = "NULL" ];then
            isPass=1
            info="Get Controller field from output(${fun}) failed."
            errResult="Node: $Item||INFO:$info||${errResult}"
            LOG "[$FUNCNAME][$LINENO]item=$Item, Get SAS Controller Fail!"
            continue
        fi
        local rhVer=$(cat $CheckMsgFile$Item | grep "^RH=" | awk -F'=' '{print $2}')
        echo "RH=${rhVer};Controller=${Controller};IP=${Item}" >> $SASTypeList
        nvdata=$(cat $CheckMsgFile$Item | grep "NVDATA" | awk -F'=' '{print $2}')
        Firmware=$(cat $CheckMsgFile$Item | grep "Firmware" | awk -F'=' '{print $2}')
        BIOS_Version=$(cat $CheckMsgFile$Item | grep "BIOS_Version" | awk -F'=' '{print $2}')
        uefi_bsd=$(cat $CheckMsgFile$Item | grep "UEFI_BSD" | awk -F'=' '{print $2}')

        # 1. 3008FW汾15.00.07.00汾в2
        if [ X"${Controller}" == X"SAS3008" ]; then
            if version_lt $Firmware "15.00.07.00"; then
                # 2. message־Ƿ fault_state(0x26b6) ӡѿͻRAIDFW߻
                fault_state_backup=$( zcat /var/log/backup/OS/message.log.*.tar.gz | grep -a "fault_state(0x26b6)" | wc -l )
                fault_state=$( cat /var/log/message/message.log | grep -a "fault_state(0x26b6)" | wc -l )
                if [ ${fault_state_backup} -ne 0 ] || [ ${fault_state} -ne 0 ]; then
                    isPass=$(check_pass $isPass 4)
                    LOG "item=${Item}, SAS3008FwVersion=${Firmware}!"
                    errResult="Node:${Item}||INFO:SAS3008FwVersion is ${Firmware}! Please upgrade RAID card's FW version to 15.00.07.00 or later, or replace the card.||${errResult}"
                fi
            fi
        fi

        WRITE_XML_COMMON 0 "Node:$Item||Node_Version:RH ${rhVer}||Controller:$Controller||NVDATA:$nvdata||Firmware:$Firmware||BIOS_Version:$BIOS_Version||UEFI_BSD:$uefi_bsd"
    }
    done

    for SAStype in ${SASTypeArray[*]};do
        for tmprh in ${RHTypeArray[*]};do
            local filter="RH=${tmprh};Controller=${SAStype}"
            local mastFlag=0
            local firstIP=""
            local firstfile=""
            if [ $isPass -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]SAStype=$SAStype,due to isPass=$isPass,so no need to compare."
                break
            fi

            for line in $(cat $SASTypeList | grep $filter);do
                LOG "[$FUNCNAME][$LINENO]isPass=$isPass,SAStype=${SAStype},compare line info[line=$line]."
                local tmpIP=`echo $line | awk -F ";" '{print $3}' | awk -F "=" '{print $2}'`
                if [ $mastFlag -eq 0 ];then
                    firstfile=$CheckMsgFile$tmpIP
                    firstIP=$tmpIP
                    mastFlag=1
                    LOG "[$FUNCNAME][$LINENO]master file=$firstfile"
                    continue
                fi
                diff $firstfile $CheckMsgFile$tmpIP > /dev/null
                if [ 0 -ne $? ];then
                    isPass=4
                    errResult="Node:${tmpIP}||INFO:SAS version is not same between $firstIP and $tmpIP||${errResult}"
                    LOG "[$FUNCNAME][$LINENO] SAS version not the same between $firstIP and $tmpIP."
                    break
                fi
            done
        done
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
    rm -rf $SASTypeList
}

# 149 ڵMTUǷһ¡֡
analyse_result_checkNetportBitErrandJumboframe()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local base_front_mtu=""
    local base_manage_mtu=""
    local is_base_ini_set=""
    local base_ini_front_mtu=""
    local base_ini_manage_mtu=""
    local original_ip=""
    get_cluster_lite_deploy
    if [ $? -eq 0 ];then
        isPass=3
        LOG "[$FUNCNAME][$LINENO]lite node , does not involve"
        WRITE_XML_COMMON 0 "This node is a lite node and does not involve"
        WRITE_XML_JUDGE $isPass > /dev/null
        return
    fi

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        local fifoContext=$(cat ${CheckMsgFile}${Item})
        if [ "$fifoContext" = "" ];then
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi
        #cm.iniõmtuֵͻ׼ֵǷһ
        local cmini_front_mtu=$(echo "${fifoContext}" |grep "front_mtu_value" |awk -F':' '{print $2}'|tr -d ' ')
        local cmini_manage_mtu=$(echo "${fifoContext}" |grep "manage_mtu_value" |awk -F':' '{print $2}'|tr -d ' ')

        if [[ "${is_base_ini_set}" == "" ]];then
            is_base_ini_set="set"
            base_ini_front_mtu="${cmini_front_mtu}"
            base_ini_manage_mtu="${cmini_manage_mtu}"
            original_ip="${Item}"
        fi

        #жmtu
        local netCard=$(echo "${fifoContext}" |grep "type:" |awk {'print $1'})
        for eth_tmp in $(sort -u <<< "${netCard}" || echo ${netCard});do
            #ȡsysconfigõmtuֵ,            #ȡǰõmtuֵ
            local sysconfig_mtu=$(echo "${fifoContext}" |grep ${eth_tmp} |grep 'MTU=' | head -n1 |awk -F'=' '{print $2}'|sed "s/'//g")
            local port_mtu=$(echo "${fifoContext}" |grep "${eth_tmp} mtu:" | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local bussiness_type=$(echo "${fifoContext}" |grep "${eth_tmp} type:" | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local BitErr_num=$(echo "${fifoContext}" |grep "${eth_tmp} BitErr:" | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local JumboFrameErr_num=$(echo "${fifoContext}" |grep "${eth_tmp}" | grep JumboFrameErr | head -n1 |awk -F':' '{print $2}'|tr -d ' ')
            local base_mtu=""
            local base_ini_mtu=""
            if [ "${bussiness_type}" = "front" ];then
                #ǰmtu
                if [[ "${base_front_mtu}" == "" ]];then
                    base_front_mtu="${port_mtu}"
                    original_front_mtu_ip=$Item
                    LOG "[$FUNCNAME][$LINENO] base:${Item} base_front_mtu:${base_front_mtu}"
                fi
                base_mtu="${base_front_mtu}"
                base_ini_mtu="${base_ini_front_mtu}"
                #original_ip="${original_front_mtu_ip}"
            else
                #mtu
                if [[ "${base_manage_mtu}" == "" ]];then
                    base_manage_mtu="${port_mtu}"
                    original_manage_mtu_ip=$Item
                    LOG "[$FUNCNAME][$LINENO] base:${Item} base_manage_mtu:${base_manage_mtu}"
                fi
                base_mtu="${base_manage_mtu}"
                base_ini_mtu="${base_ini_manage_mtu}"
                #original_ip="${original_manage_mtu_ip}"
            fi

            if [[ "${base_mtu}" != "${port_mtu}" ]];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} configureation MTU (${port_mtu}) is different from the reference node (${original_ip}) MTU (${base_mtu})."
            fi

            if [[ "${base_ini_mtu}" != "${sysconfig_mtu}" ]];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} MTU (${sysconfig_mtu}) in sysconfig file is different from the reference node (${original_ip}) MTU (${base_ini_mtu}) in configuration file(cm.ini)."
            fi

            if [[ "${base_ini_mtu}" != "" &&  "${base_ini_mtu}" != "${port_mtu}" ]];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} MTU (${port_mtu}) in configuration file is different from the reference node (${original_ip}) MTU (${base_ini_mtu}) in configuration file(cm.ini)."
            fi

            if [ $BitErr_num -gt 100000 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} BitErr is greater than 100,000."
            fi

            if [ $JumboFrameErr_num -gt 100000 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${eth_tmp} JumboFrameErr is greater than 100,000."
            fi
        done

        result=$(cat $CheckMsgFile$Item)
        WRITE_XML_COMMON 0 "MTU Info:---------------$Item---------------||MTU Info:$result"
    }
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

#205 NTP 
function analyse_result_checkNTPService()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local PassStatus=""
    local tmpinfo=""
    local lineinfo=""
    local state=""
    local Status=""
    local tmpStatusFile="/tmp/tmpfileNtpStatusFile$$"
    local tmpNtpCfgFile="/tmp/tmpfileNtpCfgFile$$"
    local server=""
    local tempStr_ping=""
    local isConnected=0

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Remote_ip in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile} | grep "^\[ERR\]")
        lineinfo=`handle_remote_result "${tmpinfo}"`
        if [ $? -ne 0 ]; then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Remote_ip||${lineinfo}"
            continue
        fi
        #׼NtpCfgFile  NTP Status File ,Աʹ
        cat ${CheckMsgFile} |eval sed '/${G_SEPARATOR}/,\$\d' >${tmpStatusFile}
        cat ${CheckMsgFile} |eval sed '0,/${G_SEPARATOR}/d' >${tmpNtpCfgFile}

        state=`cat ${tmpStatusFile} | grep 'Active: ' | awk '{ print $3}' | sed "s/[^a-z]//g"`
        if [ $? -ne 0 ]; then
            isPass=1
            Status="Can not get NTP status."
            WRITE_XML_ERROR 0 "Node:${Remote_ip}||INFO:Failed to get NTP status."
            LOG "[$FUNCNAME][$LINENO]$Remote_ip $Status"
        elif [ "${state}" != "running" ];then
            isPass=1
            Status="NTP service is NOT running."
            WRITE_XML_ERROR 0 "Node:${Remote_ip}||INFO:NTP service is NOT running."
            LOG "[$FUNCNAME][$LINENO]$Remote_ip $Status"
        else
            Status="NTP service is running."
        fi

        server=`cat ${tmpNtpCfgFile} |grep server | sed '/#/d'|awk '{print $2}'`
        if [ $? -ne 0 ] || [ "$server" == "" ]; then
            isPass=1
            ntpServer="Can not get NTP server."
            connectState="--"
            WRITE_XML_ERROR 0 "Node:${Remote_ip}||INFO:Failed to get NTP server."
            LOG "[$FUNCNAME][$LINENO]$Remote_ip $server"
        else
            LOG "[$FUNCNAME][$LINENO]$Remote_ip $server"
            isConnected=0
            for ip in ${server[*]}
            do
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping=`ping -q -c 1 $ip |grep "1 received" |wc -l`
                    if [ "1" != "$tempStr_ping" ];then
                        tempStr_ping=`ping6 -q -c 1 $ip |grep "1 received" |wc -l`
                    fi
                    local iRet=$?
                    LOG "[$FUNCNAME][$LINENO] tempStr_ping=$tempStr_ping,iRet=$iRet"
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done
                if [ "1" == "$tempStr_ping" ];then
                    connectState="OK"
                    isConnected=1
                    ntpServer="$ip"
                    break
                fi
            done
            if [ $isConnected -eq 0 ]; then
                connectState="Can not access."
                ntpServer=`echo ${server} | tr '\n' ' '`
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Remote_ip}||INFO:NTP server(${ntpServer}) can not access."
            fi
        fi

        Result="RunningStatus:$Status||Server:$ntpServer||ConnectingStatus:$connectState"
        WRITE_XML_COMMON 0 "Node:$Remote_ip||$Result"
    done

    WRITE_XML_JUDGE $isPass
}

#206 CMڵ 
function analyse_result_checkCMMaster()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local tmpIP=""
    local masterNID=""
    local NID_before=""
    local Result=""

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Remote_ip in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
        while read line; do
            tmpinfo=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                isPass=1
                LOG "[$FUNCNAME][$LINENO] Error: $tmpinfo"
                WRITE_XML_ERROR 0 "Node:${Remote_ip}||${tmpinfo}"
                continue
            fi

            #ȡ
            masterNID=`cat ${CheckMsgFile} | grep CMMasterNID | awk '{print $2}'`
            LOG "[$FUNCNAME][$LINENO]:masterNID:$masterNID,NID_before:$NID_before"

            if [ "$masterNID" == "" ]; then
                isPass=1
                LOG "[$FUNCNAME][$LINENO] Error: No CM MasterNID info"

                WRITE_XML_ERROR 0 "Node:${Remote_ip}||INFO:Get CM MasterNID from output(${InspectFun}) failed."
                continue
            fi

            #NID,ȡڵip
            tmpinfo=`get_node_backnet_ip $masterNID`
            Result="Node:$Remote_ip||CMMasterNID:$masterNID||CMMasterIP:$tmpinfo"

            if [ "$NID_before" != "" ];then
                if [ "$NID_before" != "$masterNID" ];then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:${Remote_ip}||INFO:The master NID is different from others"
                fi
            fi

            NID_before=$masterNID
            WRITE_XML_COMMON 0 "${Result}"

        done < ${CheckMsgFile}
    done

    local tmpIP=`grep "^ip=" /opt/huawei/snas/etc/cm.ini | sed 's/ip=//'`
    #Ѿ鵽ڵˣѲ½ľǸIPһжڵǲԼ
    local myNid=`grep "NID=" /opt/huawei/snas/etc/cm.ini | sed 's/NID=//'`
    if [ "$myNid" != "$NID_before" ];then
        isPass=1
        WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:The master ip is not on master node!"
    fi
    #CM/monǲ
    local cm_master_ip=$(/opt/huawei/snas/script/getCmMaster.sh)
    local mon_leader=$(cat /proc/monc_leader | grep -Po '(?<=Mon leader: )[0-9.]*')
    if [ -z "${cm_master_ip}" ] || [ -z "${mon_leader}" ];then
        LOG "[$FUNCNAME][$LINENO]ERROR:Failed to get leader IP of cm or mon!"
        WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Failed to get leader IP of cm or mon!"
        isPass=1
    else
        echo ${cm_master_ip} | grep -wFq ${mon_leader}
        if [ $? -eq 0 ];then
            WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Cm and mon's leader are on the same node!"
            LOG "[$FUNCNAME][$LINENO]ERROR:Cm and mon's leader are on the same node!"
        else
            LOG "[$FUNCNAME][$LINENO]OK:Cm and mon's leader are on the different node!"
        fi
    fi
    LOG "[$FUNCNAME][$LINENO]:myNid:$myNid,NID_before:$NID_before"
    WRITE_XML_JUDGE $isPass
}

#210 ͻ˸
function analyse_result_checkALLClient()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpCIFSfile="${G_TMP_FILE}CIFSclientinfo"
    local tmpNFSfile="${G_TMP_FILE}NFSclientinfo"
    local tmpfile="${G_TMP_FILE}ALLClientinfo"
    local service_type=0
    local tmpinfo=""
    local vers=""

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
        #ֻеdfsڵż
        service_type=$(cat ${CheckMsgFile} | grep "^node_service_type=" | awk -F'=' '{print $2}')
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            WRITE_XML_COMMON 0 "Node:${Item}||DFS:No||Client_Type:--||SMB1:--||SMB2:--||SMB3:--||NFSV3:--||NFSV4:--"
            continue
        fi
        #CIFSͻ
        cat ${CheckMsgFile} | grep -v "^node_service_type=" | eval sed '/${G_SEPARATOR}/,\$\d' >${tmpCIFSfile}
        tmpinfo=`cat ${tmpCIFSfile}`
        if [ "$tmpinfo" = "" ];then
            WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||Client_Type:CIFS||SMB1:0||SMB2:0||SMB3:0||NFSV3:--||NFSV4:--"
            continue
        fi

        >${tmpfile}
        while read line; do
            tmpinfo=$(echo $line |grep -w raddr |awk '{print $4}' |awk -F: '{print $2}')
            if [ "X${tmpinfo}" == "X" ];then
                continue
            fi
            vers=$(echo $line |grep -w vers |awk '{print $22}' |awk -F: '{print $2}')
            echo "raddr=$tmpinfo vers=$vers" >>${tmpfile}
            LOG "[$FUNCNAME][$LINENO]raddr=$tmpinfo vers=$vers"
        done < ${tmpCIFSfile}
        SMB1=$(cat ${tmpfile} |sort -u |grep "vers=1" |wc -l)
        SMB2=$(cat ${tmpfile} |sort -u |grep "vers=2" |wc -l)
        SMB3=$(cat ${tmpfile} |sort -u |grep "vers=3" |wc -l)

        WRITE_XML_COMMON 0 "Node:$Item||DFS:Yes||Client_Type:CIFS||SMB1:$SMB1||SMB2:$SMB2||SMB3:$SMB3||NFSV3:--||NFSV4:--"
    done

    for Item in $REMOTE_IP_S
    do
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
        #ֻеdfsڵż
        service_type=$(cat ${CheckMsgFile} | grep "^node_service_type=" | awk -F'=' '{print $2}')
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            continue
        fi

        #NFSͻ
        cat ${CheckMsgFile} | grep -v "^node_service_type=" | eval sed '0,/$G_SEPARATOR/d' >${tmpNFSfile}
        tmpinfo=`cat ${tmpNFSfile}`
        if [ "$tmpinfo" = "" ];then
            WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||Client_Type:NFS||SMB1:--||SMB2:--||SMB3:--||NFSV3:0||NFSV4:0"
            continue
        fi

        >${tmpfile}
        while read line; do
            tmpinfo=$(echo $line |grep -w raddr |awk '{print $4}' |awk -F: '{print $2}')
            if [ "X${tmpinfo}" == "X" ];then
                continue
            fi
            vers=$(echo $line |grep -w vers |awk '{print $22}' |awk -F: '{print $2}')
            echo "raddr=$tmpinfo vers=$vers" >>${tmpfile}
            LOG "[$FUNCNAME][$LINENO]raddr=$tmpinfo vers=$vers"
        done < ${tmpNFSfile}
        NFSV3=$(cat ${tmpfile} |sort -u |grep "vers=3" |wc -l)
        NFSV4=$(cat ${tmpfile} |sort -u |grep "vers=4" |wc -l)
        WRITE_XML_COMMON 0 "Node:$Item||DFS:Yes||Client_Type:NFS||SMB1:--||SMB2:--||SMB3:--||NFSV3:$NFSV3||NFSV4:$NFSV4"
    done

    WRITE_XML_JUDGE $isPass
    rm -f ${tmpCIFSfile}
    rm -f ${tmpNFSfile}
    rm -f ${tmpFTPfile}
    rm -f ${tmpfile}
}

# 213 ڵϵͨѶ·
function analyse_result_checkCommuLink()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local down_rpc_link="/tmp/down_rpc_link_file"

    >${CheckMsgFile}
    >${down_rpc_link}
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get /proc/sys/lnet/peers contents from output(${InspectFun}) failed!"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )
        cat ${CheckMsgFile} >>${down_rpc_link}
    done

    # IPżIP״̬Ϊdownrpc linkϢ
    grep "CROSSOVER_FLAG:YES" ${down_rpc_link} >${down_rpc_link}.tmp
    grep -v "CROSSOVER_FLAG:YES" ${down_rpc_link} >>${down_rpc_link}.tmp
    mv ${down_rpc_link}.tmp ${down_rpc_link}

    if [ -f "${down_rpc_link}" -a -s "${down_rpc_link}" ]
    then
        while read line
        do
            tmpinfo=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "${tmpinfo}"
            else
                WRITE_XML_COMMON 0 "${tmpinfo}"
            fi

        done <${down_rpc_link}
    fi
    rm -f ${CheckMsgFile}
    rm -f ${down_rpc_link}

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}

#214. ڴʹ
analyse_result_checkMemPoolUsage_Async()
{
    fun=$1
    fun_end=${fun}_End
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local Result=""
    local TASK_ID=0
    local isPass=0
    local isflag=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local yellowmemline=0
    local Info=""
    local Info_one=""
    local PoolName=""
    local MainNodeIP=$(get_backnet_ip)
    local DM_ibaseused=$(ps -e -o "pid,comm,rsz" | grep -w ibase|awk '{print $3}')
    local DM_httpdused=$(ps -e -o "pid,comm,rsz" | grep -w httpd|awk '{print $3}')
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    local capPercentage=0
    local ChainedHt_EntryNum=""
    while true; do
        #ע ȡ
        set_ifs
        #ִmml cm system
        /usr/local/bin/MmlBatch 4016 "cm system"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        ret=$?
        if [ "${ret}" -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][${LINENO}]:mml_result:${Info}"
            WRITE_XML_ERROR 0 "Node:${MainNodeIP}||INFO:Failed to execute command(MmlBatch 4016 'cm system'). Error(${ret})."
            isPass=1
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=`cat $G_REMOTE_TMP_FILE$FUNCNAME`

            if [ "$content" == "" ];then
                WRITE_XML_ERROR 0 "Node:${MainNodeIP}||INFO:Get information from output(MmlBatch 4016 'cm system') failed."
                isPass=1
            else
                totalCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}'|egrep -o "[0-9]+"`
                usedCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}'|egrep -o "[0-9]+"`
                capPercentage=`expr 100 \* $usedCap`
                capPercentage=`expr $capPercentage / $totalCap`
                LOG "[${FUNCNAME}][$LINENO]capPercentage=${capPercentage}"
            fi
        fi
        restore_ifs
        break 
        rm -f $G_REMOTE_TMP_FILE$FUNCNAME
    done
    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item

        fifoContext=$(cat ${CheckMsgFile}${Item})
        if [ "$fifoContext" = "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get Memory pool information from output(${fun}) failed"
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi
        dos2unix ${CheckMsgFile}${Item} > /dev/null 2>&1
        if [ "${Item}" == "${MainNodeIP}" ]; then
            #ȡDMģڴϢ,ֻڵִм
            sed -i '$d' ${CheckMsgFile}${Item}
            if [ "X""${DM_ibaseused}" == "X" ];then
                echo "[DM_ibase]" >>${CheckMsgFile}${Item} 2>&1
                echo "DM[ERR]Module DM ibase process not exit!" >>${CheckMsgFile}${Item} 2>&1
            else
                echo "${DM_ibaseused}" |while read line;do
                echo "[DM_ibase]" >>${CheckMsgFile}${Item} 2>&1
                echo "ibase_Used=${line}" >>${CheckMsgFile}${Item} 2>&1
                done
            fi
            if [ "X""{DM_httpdused}" == "X" ];then
                echo "[DM_ibase]" >>${CheckMsgFile}${Item} 2>&1
                echo "DM[ERR]Module DM httpd process not exit!" >>${CheckMsgFile}${Item} 2>&1
            else
                echo "${DM_httpdused}" |while read line;do
                echo "[DM_httpd]" >>${CheckMsgFile}${Item} 2>&1
                echo "httpd_Used=${line}" >>${CheckMsgFile}${Item} 2>&1
                done
            fi
            echo "[END]" >>${CheckMsgFile}${Item} 2>&1
        fi
        local count=0
        while read line;do
            echo ${line}|grep -q "^\[" >/dev/null 2>&1
            iRet=$?
            if [ 0 -eq ${iRet} ];then
                if [ 0 -eq ${count} ];then
                    let count++
                else
                    let count++
                    Result="Node:${Item}||Module:${module}||Pool:${pool}||memSuccessiveArise:${memSuccessiveArise}||totalsize(MB):${totalsize}||freesize(MB):${freesize}||Percentage(%):${percentage}||Process_Used(MB):${processused_TMP}||RPCmemused/RPCpageusd(MB):${RPCmemused_TMP}/${RPCpageused_TMP}||MDS_LeftMemSize/MDS_ResvMemSize(MB):${MDS_LeftMemSize}/${MDS_ResvMemSize}||ChainedHt_EntryNum:${ChainedHt_EntryNum}"
                    WRITE_XML_COMMON 0 "${Result}"
                fi
                module=$(echo ${line} |awk -F"[" '{print $2}'|awk -F"]" '{print $1}')
                pool="-"
                totalsize="--"
                freesize="--"
                percentage="--"
                processused_TMP="--"
                RPCmemused_TMP="--"
                RPCpageused_TMP="--"
                MDS_LeftMemSize="--"
                MDS_ResvMemSize="--"
                memSuccessiveArise="--"
                ChainedHt_EntryNum="--"
            else
                Info=$(handle_remote_result "${line}")
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:${Item}||INFO:${Info}"
                    LOG "[$FUNCNAME] Error: ${Info}"
                    WRITE_XML_ERROR 0 "${errResult}"
                else
                    echo ${Info}|grep -qE "total size|ModuleId" >/dev/null 2>&1
                    TOTAL=$?
                    if [ 0 -eq ${TOTAL} ];then
                        if [ "NAS" == "${module}" ];then
                            pool=$(echo ${Info}  | awk -F: '{print $1}')
                            poolid=$(echo "${pool}" |sed 's/ //g'|awk -F] '{print $1}'|awk -F[ '{print $2}')
                            totalsize_tmp=$(expr $(echo $Info|awk -F":|," '{print $3}') \* ${poolid})
                            totalsize=$(echo "scale=4; ${totalsize_tmp}/1048576"|bc -l)
                            freesize_tmp=$(expr $(echo $Info |awk -F":|," '{print $5}') \* ${poolid})
                            freesize=$(echo "scale=4; ${freesize_tmp}/1048576"|bc -l)
                            usedSize=$(expr $(echo ${Info} |awk -F":|," '{print $7}') \* ${poolid})
                            usedSize_temp=$(expr ${usedSize} \* 100)
                            percentage=$(expr ${usedSize_temp} \/ ${totalsize_tmp})
                        else
                            pool=$(echo ${Info} | awk -F',' '{print $3}')
                            totalsize_tmp=$(echo "$Info" | grep -Po '(?<=Total )[0-9+]+' )
                            totalsize_tmp=${totalsize_tmp:-0}
                            totalsize=$(echo ${totalsize_tmp} |awk '{printf "%d",$0/1048576}')
                            freesize_tmp=$(echo "$Info" | grep -Po '(?<=Free )[0-9+]+')
                            freesize_tmp=${freesize_tmp:-0}
                            freesize=$(echo ${freesize_tmp} |awk '{printf "%d",$0/1048576}')
                            percentage=$(echo "$Info" | grep -Po '(?<=Percent )[0-9+]+')
                            percentage=${percentage:-0}
                        fi
                        Threpercentage=""
                        #ģԼӦģڴʹֵ
                        MODULEMEM=("MON" "BJM_Server" "BJM_Worker" "CA" "DAB" "DS" "OBS" "CM_Kernel" "CM_User" "NV" "TRNS" "TRNS_LOG" "MONC" "NOFS" "DLM" "BASE" "NAS")
                        moduleper=(85 85 85 85 80 80 80 90 90 85 90 90 85 95 80 90 70)
                        for i in $(seq 0 `expr ${#MODULEMEM[@]} - 1`);do
                            if [ "$module" == "${MODULEMEM[$i]}" ];then
                               Threpercentage=${moduleper[$i]}
                               break;
                            fi
                        done
                        if [ ${percentage} -ge ${Threpercentage} ];then
                            isPass=1
                            errResult="Node:${Item}||INFO:${module} percentage ${percentage} over the threshould percentage ${Threpercentage}!"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        fi
                    fi
                    #MON,BJM_Server,BJM_Worker,BJM_ManagerģҪУ鵱ǰڴʹ
                    echo ${Info} |grep "_Used" >/dev/null 2>&1
                    TOTALUSED=$?
                    if [ 0 -eq ${TOTALUSED} ];then
                        #ģԼӦģڴʹֵ,MONģΪ1.5G,BJM_ServerģΪ2G,BJM_WorkerģΪ1.5G,BJM_ManagerģΪ1.5G
                        TOTALModule=("MON" "BJM_Server" "BJM_Worker" "BJM_Manager" "DM_ibase" "DM_httpd" "Replication")
                        TOTALTHRmem=("1610612736" "2147483648" "1610612736" "1610612736" "335544320" "83886080" "1073741824")
                        #SFSԶ̸ģ
                        if [ "91" == "${ProductType}" ];then
                            TOTALModule=("MON" "BJM_Server" "BJM_Worker" "BJM_Manager" "DM_ibase" "DM_httpd")
                            TOTALTHRmem=("1610612736" "2147483648" "1610612736" "1610612736" "335544320" "83886080")
                        fi
                        processused=$(echo ${Info}|awk -F= '{print $2}')
                        processused_TMP=$(echo ${processused} |awk '{printf "%0.4f",$0/1048576}')
                        if [ "X""${processused}" == "X" ];then
                            isPass=1
                            errResult="Node:${Item}||INFO:Get information of $module processused used FAILED!"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        else
                            for i in $(seq 0 `expr ${#TOTALModule[@]} - 1`);do
                                if [ "${module}" == "${TOTALModule[$i]}" ];then
                                    ThreshouldMem=${TOTALTHRmem[$i]}
                                    break;
                                fi
                            done
                            if [ ${processused} -ge ${ThreshouldMem} ];then
                                isPass=1
                                LOG "[${FUNCNAME}][$LINENO]Node: ${Item}||INFO:${module} processused $processused (B) over the ThreshouldMem  $ThreshouldMem (B)!"
                                errResult="Node:${Item}||INFO:${module} processused $processused (B) over the ThreshouldMem  $ThreshouldMem (B)!"
                                WRITE_XML_ERROR 0 "${errResult}"
                                continue
                            fi
                        fi
                    fi
                    #鶯̬ڴ־
                    echo "${Info}" |grep "memSuccessiveArise" >/dev/null 2>1
                    if [ $? -eq 0 ];then
                        memSuccessiveArise=$(echo ${Info}|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        if [ 1 -eq ${memSuccessiveArise} ];then
                            isPass=1
                            details=$(echo ${Info}|awk -F"," '{print $2}')
                            LOG "[${FUNCNAME}][$LINENO]Node: ${Item}||INFO:the details of ten days memory (${details})"
                            errResult="Node:${Item}||INFO:The module ${module} memory of ten days (${details})!"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        fi
                    fi
                    #RPCģֻRPCmemusedRPCpageused
                    echo ${Info} |grep "RPC_" >/dev/null 2>&1
                    RPC=$?
                    if [ 0 -eq ${RPC} ];then
                        RPCmemused=$(echo ${Info}|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        RPCpageused=$(echo ${Info}|awk -F"," '{print $2}'|awk -F= '{print $2}')
                        RPCmemused_TMP=$(echo "scale=4; ${RPCmemused}/1048576"|bc -l)
                        RPCpageused_TMP=$(echo "scale=4; ${RPCpageused}/1048576"|bc -l)
                        #RPCģֵΪ1G
                        ThreshouldRPCMem="1073741824"
                        if [ ${RPCmemused} -gt ${ThreshouldRPCMem} -a ${RPCpageused} -gt ${ThreshouldRPCMem} ];then
                            isPass=1
                            LOG "[${FUNCNAME}]RPCmemused:${RPCmemused}, RPCpageused:${RPCpageused}"
                            errResult="Node:${Item}||INFO:${module} ${RPCpageused} (B) AND ${RPCmemused} (B) ALL OVER THE ${ThreshouldRPCMem} (B)!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        fi
                    fi
                    #SSDCģڴϢ
                    echo ${Info} |grep "SSDC_" >/dev/null 2>&1
                    SSDC=$?
                    if [ 0 -eq ${SSDC} ];then
                        local ThreshouldSSDCMemFree_1="51200"   #50M 
                        local ThreshouldSSDCMemFree_2="102400"   #100M
                        local ThreshouldSSDCMemFree_3="153600"   #150M
                        local ThreshouldSSDCMemFree_4="204800"   #200M
                        local ThreshouldHtEntryNum="3072000"
                        local ssdc_memfree=$(echo ${Info} | grep -Po '(?<=SSDC_memfree=)[0-9]+')
                        local ssdc_result=$(echo ${Info} | grep -Po '(?<=SSDC_result=)[0-9]+')
                        ChainedHt_EntryNum=$(echo ${Info} | grep -Po '(?<=ChainedHt_EntryNum=)[0-9]+')
                        if [ "X${ssdc_memfree}" != "X" ];then
                            #ʾͳһתλK/1024---M
                            freesize=$(echo ""|awk -v x=${ssdc_memfree} -v y=1024 '{printf("%0.02f",x/y)}')
                            if [ ${ssdc_result:-0} -ne 0 ];then
                                isPass=$(check_pass $isPass 1)
                                LOG "[${FUNCNAME}]ThreshouldSSDCMemFree:${ThreshouldSSDCMemFree}, SSDC_memfree:${freesize} ssdc_result=${ssdc_result}"
                                errResult="Node:${Item}||INFO:${module} free memory ${freesize}(M) is less than 50(M)! The 64-byte or 128-byte memory usage exceeds 90%."
                                WRITE_XML_ERROR 0 "${errResult}"
                            fi
                            if [ ${ssdc_memfree} -lt ${ThreshouldSSDCMemFree_1} ];then
                                if [ ${ChainedHt_EntryNum} -lt ${ThreshouldHtEntryNum} ];then
                                    isPass=$(check_pass $isPass 4)
                                    errResult="Node:${Item}||INFO:${module} free memory ${freesize}(M) is less than 50(M)! ChainedHt_EntryNum=${ChainedHt_EntryNum}. Please upgrade the product version to 7.1.1.SPC600 or later."
                                    WRITE_XML_ERROR 0 "${errResult}"
                                fi
                            elif [ ${ssdc_memfree} -lt ${ThreshouldSSDCMemFree_2} ];then
                                isPass=$(check_pass $isPass 4)
                                errResult="Node:${Item}||INFO:${module} free memory ${freesize}(M) is less than 100(M)! Please upgrade the product version to 7.1.1.SPC600 or later."
                                WRITE_XML_ERROR 0 "${errResult}"
                            elif [ ${ssdc_memfree} -lt ${ThreshouldSSDCMemFree_3} ];then
                                if [ ${capPercentage:-0} -lt 70 ];then
                                    isPass=$(check_pass $isPass 4)
                                    errResult="Node:${Item}||INFO:${module} free memory ${freesize}(M) is less than 150(M)! percentage ${capPercentage} is less than 70%! Please upgrade the product version to 7.1.1.SPC600 or later."
                                    WRITE_XML_ERROR 0 "${errResult}"
                                fi
                            elif [ ${ssdc_memfree} -lt ${ThreshouldSSDCMemFree_4} ];then
                                if [ ${capPercentage:-0} -lt 50 ];then
                                    isPass=$(check_pass $isPass 4)
                                    errResult="Node:${Item}||INFO:${module} free memory ${freesize}(M) is less than 200(M)! percentage ${capPercentage} is less than 50%! Please upgrade the product version to 7.1.1.SPC600 or later."
                                    WRITE_XML_ERROR 0 "${errResult}"
                                fi
                            fi
                        fi
                    fi
                    #MDSģLeftMemSizeǷСڵResvMemSize
                    echo $Info |grep "MDS_" >/dev/null 2>&1
                    MDS=$?
                    if [ 0 -eq ${MDS} ];then
                        MDS_LeftMemSize=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        MDS_ResvMemSize=$(echo $Info|awk -F"," '{print $2}'|awk -F= '{print $2}')
                        if [ "X" == "X${MDS_LeftMemSize}" -o "X" == "X${MDS_ResvMemSize}" ];then
                            isPass=1
                            LOG "[${FUNCNAME}]MDS_LeftMemSize:${MDS_LeftMemSize}, MDS_ResvMemSize:${MDS_ResvMemSize}"
                            errResult="Node: ${Item}||INFO:Get $module MDS_LeftMemSize ${MDS_LeftMemSize} (MB)  or MDS_ResvMemSize ${MDS_ResvMemSize} (MB) failed!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        elif [ ${MDS_LeftMemSize} -le ${MDS_ResvMemSize} ];then
                            isPass=1
                            LOG "[${FUNCNAME}]MDS_LeftMemSize:${MDS_LeftMemSize}, MDS_ResvMemSize:${MDS_ResvMemSize}"
                            errResult="Node:${Item}||INFO:$module MDS_LeftMemSize ${MDS_LeftMemSize} (MB)  is less than or equal to  MDS_ResvMemSize ${MDS_ResvMemSize} (MB)!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        fi

                    fi
                fi
            fi
        done <${CheckMsgFile}${Item}

    }
    done
    WRITE_XML_JUDGE $isPass >/dev/null
}

#215. ؼһУ
analyse_result_checkDataConsistent_Async()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local info=""
    local isPass=0
    local result_log=/var/log/nluninfo.log
    local errResult=""
    local rootdir_result=""
    local fssblock_result=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        info=$(cat $CheckMsgFile$Item)
        if [ "$info" != "" ]; then
            errResult=`handle_remote_result "$info"`
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node:${Item}||${errResult}" >/dev/null
                LOG "[$FUNCNAME]:Node:$Item||${errResult}"
                isPass=1
                break
            fi
        fi
        errResult=""
        info=$(cat $CheckMsgFile$Item | grep "Does not involve")
        if [ $? -eq 0 ];then
            continue
        fi

        local root_dir1=$(cat $CheckMsgFile$Item | grep root_dir1 | awk -F ":" '{print $2}')
        local root_dir2=$(cat $CheckMsgFile$Item | grep root_dir2 | awk -F ":" '{print $2}')
        local fs_sblock1=$(cat $CheckMsgFile$Item | grep fs_sblock1 | awk -F ":" '{print $2}')
        local fs_sblock2=$(cat $CheckMsgFile$Item | grep fs_sblock2 | awk -F ":" '{print $2}')
        local Primary_id=$(cat $CheckMsgFile$Item | grep Primary_id | awk -F ":" '{print $2}')
        #ȡDS_IDӦIPַ
        DS_ID_Address=`get_valid_back_ip_by_dsid "$Primary_id"`
        LOG "[$FUNCNAME]DS_ID_Address:${DS_ID_Address}"
        if [ "${DS_ID_Address}" == "" ]; then
            LOG "DS_ID_Address is Null"
            errResult="Node:${Item}||INFO:Get DS address from output(${fun}) failed."

            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
            break
        fi

        #Ƚroot_dirһ
        rootdir_result=`remote_exec ${DS_ID_Address} 30 "$G_MML_FILE_PATH/ShowDataConsistent $DS_ID_Address 'check consfile $root_dir1 $root_dir2' ROOT_DIR 2>&1"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:${Item}||INFO:Failed to execute(${DS_ID_Address},check consfile $root_dir1 $root_dir2),iRet($iRet),errinfo($rootdir_result)."
            LOG "[$FUNCNAME]Failed to execute(${DS_ID_Address},check consfile $root_dir1 $root_dir2),iRet($iRet),errinfo($rootdir_result)"

            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
        else
            WRITE_XML_COMMON 0 "$rootdir_result"
        fi

        #ȽFS_SBLOCKһ
        fssblock_result=`remote_exec ${DS_ID_Address} 30 "$G_MML_FILE_PATH/ShowDataConsistent ${DS_ID_Address} 'check consfile $fs_sblock1 $fs_sblock2' FS_SBLOCK 2>&1"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:${Item}||INFO:Failed to execute(${DS_ID_Address},check consfile $fs_sblock1 $fs_sblock2),iRet($iRet),errinfo($fssblock_result)."
            LOG "[$FUNCNAME] Failed to execute(${DS_ID_Address},check consfile $fs_sblock1 $fs_sblock2),iRet($iRet),errinfo($fssblock_result)"

            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
        else
            WRITE_XML_COMMON 0 "$fssblock_result"
        fi

        break
    }
    done
    chmod 640 ${result_log}
    if [[ ${errResult} == "" && ${rootdir_result} == "" && ${fssblock_result} == "" ]];then
        WRITE_XML_COMMON 0 "Do not involve to inspect."
        isPass=3
    fi
    WRITE_XML_JUDGE $isPass >/dev/null
}

#221. LDAP
analyse_result_checkLDAP()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local info=""
    local isPass=0
    local ldapIp=""
    local pingResult=""
    local errResult=""
    local pingCompare=0
    local basedn=""  #Ըڵ㣬ļһʱֵ
    local portnum="" #Ըڵ㣬ļһʱֵ
    local masterFlag=0 #ǵһϷLDAP server ipִpingΪ1Ϊ1ʾýڵipִйping
    local frontiptype=0
    local ipflag=0
    local FLAG=1
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    local netflag=0 #ǰIPֻIPV4IPV6ַΪ0ͬʱΪ1
    local oldnodeiptype=-1
    for Item in $REMOTE_IP_S; do
        frontiptype=$(get_frontip_type "${Item}")
        if [ "$oldnodeiptype" == -1 ];then
            oldnodeiptype=$frontiptype
        fi
        if [ "$oldnodeiptype" -eq "$frontiptype" ];then
            continue
        else
            LOG "[$FUNCNAME]:the network is IPV4 and IPV6"
            netflag=1
            break
        fi
        LOG "[$FUNCNAME]:the network is only IPV4 or IPV6"
    done

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        #s3 judge
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ]; then
            LOG "service_type = ${service_type}.skip ${Item}."
            WRITE_XML_COMMON 0 "Node:${Item}||DFS:No||ldap_server_ip:--||ldap_server_basedn:--||ldap_server_portnum:--||ldap_server_status:--"
            continue
        fi

        LOG "[$FUNCNAME]:IP:$Item"

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get LDAP information from output(${fun}) failed."
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi

        #
        cat $CheckMsgFile$Item >> $LOG_FILE 2>&1
        frontiptype=$(get_frontip_type "${Item}")


        #ÿڵ㴦ļǰֵʼ
        masterFlag=-1
        basedn=""
        portnum=""
        set_ifs
        while read line; do
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
            else
                #жϵǰǷldap server
                ldap_server=$(echo $info|grep -w "no ldap_server")
                if [ "$ldap_server" != "" ];then
                    WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||ldap_server_ip:no ldap_server||ldap_server_basedn:no ldap_server||ldap_server_portnum:no ldap_server||ldap_server_status:no ldap_server"
                    FLAG=0
                    break
                fi

                #ǰضldap server
                ldap_server_ip=$(echo $info|grep -w "ldap_server_ip"|awk -F '\\|\\|' '{print $1}'|awk '{print $2}')
                ldap_server_basedn=$(echo $info|grep -w "ldap_server_basedn"|awk -F '\\|\\|' '{print $2}'|awk -F ':' '{print $3}')
                ldap_server_portnum=$(echo $info|grep -w "ldap_server_portnum"|awk -F '\\|\\|' '{print $3}'|awk -F ':' '{print $3}')

                ldap_server_status=$(echo $info|grep -w "status")
                ldapIp=`echo $info|grep -w "status"|awk -F"status" '{print $1}'`
                ldapIp_vaild=$(echo $info|grep -w "status ok")

                #жǷΪϢĵһУbasednportnumcontinueһ
                if [ "${ldap_server_ip}" != "" ];then
                    basedn=$ldap_server_basedn
                    portnum=$ldap_server_portnum
                    continue
                fi
                #ldapIpΪյУV4pingV6 ײֶ
                if [ "${ldapIp}" == "" ];then
                   continue
                fi
                #masterFlagΪ0
                masterFlag=$((masterFlag+1))
                #Ź˲ͬ͵صַ
                if [ $netflag -eq 1 ];then
                    #ǰLDAPIPͲһֱӹ
                    echo $ldapIp |grep -q "\:" >/dev/null
                    ipflag=$?
                    if [ $ipflag -ne $frontiptype ];then
                        LOG "ipflag=$ipflag;frontiptype=$frontiptype"
                        continue
                    fi
                fi
                if [ "${ldapIp}" != "" ];then
                    #ÿһldap server ip ֱӡϢ
                    WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||ldap_server_ip:${ldapIp}||ldap_server_basedn:${basedn}||ldap_server_portnum:${portnum}||ldap_server_status:$ldap_server_status"
                fi
                FLAG=0

                #ǰip״̬:status err. һip
                if [ "x$ldapIp_vaild" == "x" ];then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                        LOG "masterFlag=$masterFlag  isPass=$isPass"
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi

                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP ($ldapIp) status is abnormal."
                    continue
                fi

                remote_exec $Item 30 "$G_MML_FILE_PATH/ShowPingResult $ldapIp > $G_REMOTE_TMP_FILE$FUNCNAME$Item 2>&1"
                if [ $? -ne 0 ]; then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi

                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to execute ShowPingResult ${ldapIp}."
                    continue
                fi

                remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item$Item $G_REMOTE_TMP_FILE$FUNCNAME$Item
                if [ $? -ne 0 ]; then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(GetMdsSubtreeInfo))."
                    continue
                fi
                pingResult=$(sed -n 1p $G_REMOTE_TMP_FILE$FUNCNAME$Item$Item)
                if [ "$pingResult" == "" ];then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP (${ldapIp}) failed to execute PING command(${pingResult})."
                else
                    pingCompare=`echo "$pingResult >= 200" | bc`
                    if [ $pingCompare -eq 1 ];then
                        if [ $isPass -eq 0 ];then
                            isPass=4
                            WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP (${ldapIp}) ping too large(${pingResult})."
                        fi
                    fi
                fi

            fi
        done < $CheckMsgFile$Item
        restore_ifs
    }
    done
    WRITE_XML_JUDGE $isPass >/dev/null
}

#222. ڵIPMIַ
analyse_result_checkIPMI()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local Result=""
    local isPass=0
    local isSameNet=1
    local errResult=""

    #жOMIPIPMIǷΪһ
    checkOMIPandIPMIinOneNet
    isSameNet=$?
    if [ $isSameNet -eq 0 ];then
        Result="BMC network and Manage network is not in the same network segment!"
        WRITE_XML_COMMON 0 "$Result"
        WRITE_XML_JUDGE 0
    else
        set_ifs
        #ȡصomip
        OMIPV4Address=`cat /opt/huawei/snas/etc/cm.ini|grep -w omip|awk -F= '{print $2}'`
        OMIPV6Address=`cat /opt/huawei/snas/etc/cm.ini|grep -w omip_v6|awk -F= '{print $2}'`
        LOG "[$LINENO]OMIPV4Address: $OMIPV4Address,OMIPV6Address: $OMIPV6Address"
        restore_ifs

        REMOTE_IP_S=$(cat "${IP_ROLE_FILE}")


        for Item in $REMOTE_IP_S
        do
        {
            cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
            dos2unix $CheckMsgFile$Item > /dev/null 2>&1

            #
            cat $CheckMsgFile$Item >> $LOG_FILE 2>&1

            connectState_v4=""
            ipmi_ip_v4=`cat $CheckMsgFile$Item |grep "IP Address"|grep -v Source|awk '{print $4}'`
            connectState_v6=""
            ipmi_ip_v6=`cat $CheckMsgFile$Item | grep "ipmi_ipv6_address:" | awk -F'ipmi_ipv6_address:' '{print $2}'`
            if [ "$ipmi_ip_v4" == "" -o "$ipmi_ip_v4" == "0.0.0.0" ];then
                ipmi_ip_v4="--"
                connectState_v4="no IPMI"
            fi
            if [ "$ipmi_ip_v6" == "" -o "$ipmi_ip_v6" == "null" -o "$ipmi_ip_v6" == "::" ];then
                ipmi_ip_v6="--"
                connectState_v6="no IPMI"
            fi
            if [ "$ipmi_ip_v4" == "--" ] && [ "$ipmi_ip_v6" == "--" ];then
                errResult="Node:${Item}||INFO:Get IPMI address failed!||$errResult"
                LOG "[$LINENO]$Item:can not get IPMI address!"
                isPass=1
            fi
            if [ "$ipmi_ip_v4" != "--" ] ;then
                #ͨomip ping ipmi 
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping_v4=`ping -q -c 1 $ipmi_ip_v4 |grep "1 received" |wc -l`
                    local iRet=$?
                    if [ $iRet -ne 0 ];then
                        sleep 10
                    else
                        break
                    fi
                done
                LOG "[$LINENO]Node:$Item, ipmi:$ipmi_ip_v4,omipv4:$OMIPV4Address,tempStr_ping_v4:$tempStr_ping_v4"
                if [ "0" != "$tempStr_ping_v4" ];then
                    connectState_v4="OK"
                else
                    connectState_v4="Can not access."
                    isPass=1
                    errResult="Node:${Item}||INFO:IPMI_IPV4:$ipmi_ip_v4 can not access!||$errResult"
                fi
            fi
            if [ "$ipmi_ip_v6" != "--" ];then
                #ͨomip ping ipmi 
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping_v6=`ping6 -q -c 1 $ipmi_ip_v6 |grep "1 received" |wc -l`
                local iRet=$?
                if [ $iRet -ne 0 ]; then
                    sleep 10
                else
                    break
                fi
                done
                LOG "[$LINENO]Node:$Item, ipmi:$ipmi_ip_v6,omipv6:$OMIPV6Address,tempStr_ping_v6:$tempStr_ping_v6"
                if [ "0" != "$tempStr_ping_v6" ];then
                    connectState_v6="OK"
                else
                    connectState_v6="Can not access."
                    errResult="Node:${Item}||INFO:IPMI_IPV6:$ipmi_ip_v6 can not access!||$errResult"
                    isPass=1
                fi
            fi

            Result="Node:$Item||IPMI_IPV4:$ipmi_ip_v4||IPMI_IPV6:$ipmi_ip_v6||ConnectingStatus_IPV4:$connectState_v4||ConnectingStatus_IPV6:$connectState_v6"
            LOG "[$LINENO]Node:$Item||$Result"

            WRITE_XML_COMMON 0 "$Result"
        }
        done
        if [ "${isPass}" == "0" ];then
            WRITE_XML_JUDGE 0
        else
            WRITE_XML_ERROR 0 "$errResult"
            WRITE_XML_JUDGE 1
        fi
    fi
}

#250. ̼Ŀ
analyse_result_checkAvailabilityOfFwUpg()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local Result=""
    local isPass=0
    local BMCVersion=''
    local node_hw_catagory=''
    local omNIC=$(grep omCard /opt/huawei/snas/etc/cm.ini | cut -d '=' -f 2)
    local i=0
    local needPing='no'
    local time_start=$(date +%s)
    LOG "start epoch (since 1970-01-01 00:00:00 UTC): ${time_start} seconds"
    set_ifs
    #ȡصomip
    OMIPV4Address=`cat /opt/huawei/snas/etc/cm.ini|grep -w omip|awk -F= '{print $2}'`
    OMIPV6Address=`cat /opt/huawei/snas/etc/cm.ini|grep -w omip_v6|awk -F= '{print $2}'`
    LOG "[$LINENO]OMIPV4Address: $OMIPV4Address,OMIPV6Address: $OMIPV6Address"
    restore_ifs
    REMOTE_IP_S=$(cat "${IP_ROLE_FILE}")
    local CmMainIPMIGatewayIPv4=''
    local CmMainIPMISubnetMaskIPv4=''
    local CmMainIPMIGatewayIPv6=''
    local CmMainIPMISubnetMaskIPv6=''
    local OMIPGatewayIPv4=$(grep -w omGateway /opt/huawei/snas/etc/cm.ini | awk -F= '{print $2}' |tr -d ' ')
    local OMIPSubnetMaskIPv4=$(grep -w omNetMask /opt/huawei/snas/etc/cm.ini | awk -F= '{print $2}' |tr -d ' ')
    local OMIPGatewayIPv6=$(grep -w omGateway_v6 /opt/huawei/snas/etc/cm.ini | awk -F= '{print $2}' |tr -d ' ')
    local OMIPSubnetMaskIPv6=$(grep -w omNetMask_v6 /opt/huawei/snas/etc/cm.ini | awk -F= '{print $2}' |tr -d ' ')
    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1
         #
        cat $CheckMsgFile$Item >> $LOG_FILE 2>&1
        if $(grep -q MasterNode $CheckMsgFile$Item); then
            CmMainIPMIGatewayIPv4=$(grep 'Default Gateway IP' $CheckMsgFile$Item | cut -d ':' -f 2 | tr -d ' ')
            CmMainIPMISubnetMaskIPv4=$(grep 'Subnet Mask' $CheckMsgFile$Item | cut -d ':' -f 2 | tr -d ' ')
            CmMainIPMIGatewayIPv6=$(grep -w "ipmi_ipv6_gateway" $CheckMsgFile$Item | awk -F: '{print $2}'| tr -d ' ')
            local ipmi_ip_v6_prefix_tmp=$(grep -w "ipmi_ipv6_prefix" $CheckMsgFile$Item | awk -F: '{print $2}'| tr -d ' ')
            CmMainIPMISubnetMaskIPv6="$(printf %d 0x0$ipmi_ip_v6_prefix_tmp)"
            #  OMIP磩 IPMI ǷͬһΣڣѲ첻ͨ  -- ʼ
            if [[ "$OMIPGatewayIPv4" != "$CmMainIPMIGatewayIPv4" ]] || [[ "$OMIPSubnetMaskIPv4" != "$CmMainIPMISubnetMaskIPv4" ]]; then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because the BMC network and management network are not on the same network segment."
            fi
            if ( [[ "$OMIPGatewayIPv6" != "$CmMainIPMIGatewayIPv6" ]] || [[ "$OMIPSubnetMaskIPv6" != "$CmMainIPMISubnetMaskIPv6" ]] ) && [[ "$CmMainIPMISubnetMaskIPv6" != "0" ]]; then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because the BMC network and management network are not on the same network segment."
            fi
            #  OMIP磩 IPMI ǷͬһΣڣѲ첻ͨ  -- 
        fi
    }
    done
    i=0
    local Result='' # array
    local needPings='' # arrayҪping1Ҫ0
    for Item in $REMOTE_IP_S
    do
    {   
        needPing='yes'
        # V3 Ӳ̼
        if $(grep -q 'TaiShan Node' $CheckMsgFile$Item); then
            node_hw_catagory=TaiShan
        elif $(grep -q 'V3 Node' $CheckMsgFile$Item); then
            node_hw_catagory=V3
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Firmware upgrade is unavailable during online upgrade because the hardware type is V3. However, it is still available in offline upgrades."
        elif $(grep -q 'V5 Node' $CheckMsgFile$Item); then
            # 7.1.1.SPC1°汾V5Ӳ֧BMC/BIOS/CPLD̼
            node_hw_catagory=V5
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:V5 hardware server running 7.1.1.SPC1 and earlier versions do not support online upgrade of the BMC, BIOS, and CPLD firmware, it is still available in offline upgrades."
        elif $(grep -q 'Unrecognized Node' $CheckMsgFile$Item); then
            node_hw_catagory=$(grep 'Unrecognized Node' $CheckMsgFile$Item | cut -d ':' -f 2)
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Firmware upgrade is unavailable because the hardware type is ${node_hw_catagory}."
        else
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to fetch the node type!"
        fi
        # BMC 汾Ϊ xx.xx.xx.xx Ķ̼
        # BMC 汾Ϊ xx.xx ģ3.28 ²̼
        BMCVersion=$(grep 'BMC Version' $CheckMsgFile$Item | cut -d ':' -f 2 | tr -d ' ')
        if [[ "$BMCVersion" =~ ^[0-9]{1,2}\.[0-9]{1,2}\.[0-9]{1,2}\.[0-9]{1,2}$ ]] || [[ "$node_hw_catagory" == TaiShan ]]; then
            :   # do nothing
        else
            if [[ "$BMCVersion" =~ ^[0-9]{1,2}\.[0-9]{1,2}$ ]]; then
                if [[ $(echo $BMCVersion | cut -d '.' -f 1) -lt 3 ]]||([[ $(echo $BMCVersion | cut -d '.' -f 1) -eq 3 ]]&&[[ $(echo $BMCVersion | cut -d '.' -f 2) -le 28 ]]); then
                    isPass=$(check_pass ${isPass} 1)
                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because BMC version($BMCVersion) is not later than 3.28"
                fi
            else
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Unrecognized BMC version($BMCVersion)"
            fi
        fi
        # ȡ IP Ϊ Item Ľڵ IPMI غ
        ipmi_v4_gw=$(grep -w "Default Gateway IP" $CheckMsgFile$Item |awk -F: '{print $2}' | tr -d ' ')
        ipmi_mask_v4=$(grep -w "Subnet Mask" $CheckMsgFile$Item |awk -F: '{print $2}' |tr -d ' ')
        ipmi_v6_gw=$(grep -w "ipmi_ipv6_gateway" $CheckMsgFile$Item | awk -F: '{print $2}'| tr -d ' ')
        ipmi_ip_v6_prefix_tmp=$(grep -w "ipmi_ipv6_prefix" $CheckMsgFile$Item | awk -F: '{print $2} ' )
        ipmi_mask_v6="$(printf %d 0x0$ipmi_ip_v6_prefix_tmp)"
        #  IP Ϊ Item Ľڵ IPMI Ƿڵ IPMI ͬһΡڣѲ첻ͨ -- ʼ
        if [[ "$CmMainIPMIGatewayIPv4" != "$ipmi_v4_gw" ]]||[[ "$CmMainIPMISubnetMaskIPv4" != "$ipmi_mask_v4" ]]; then
            isPass=$(check_pass ${isPass} 1)
            needPing='no'
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because BMC network of this node and BMC network of the main node is not in the same network segment."
        fi
        if [[ -z "$ipmi_v6_gw" ]]&&[[ "$ipmi_mask_v6" == 0 ]];then
            LOG "[$LINENO]Node:$Item, ipmi gateway ipv6:$ipmi_v6_gw,ipmi mask ipv6:$ipmi_mask_v6; empty"
        elif [[ "$CmMainIPMIGatewayIPv6" != "$ipmi_v6_gw" ]]||[[ "$CmMainIPMISubnetMaskIPv6" != "$ipmi_mask_v6" ]]||[[ "$ipmi_mask_v6" == "0" ]]; then
            isPass=$(check_pass ${isPass} 1)
            needPing='no'
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because BMC network of this node and BMC network of the main node is not in the same network segment."
        fi
        #  IP Ϊ Item Ľڵ IPMI Ƿڵ IPMI ͬһΡڣѲ첻ͨ -- 
        if [[ -z "$ipmi_v6_gw" ]]; then
            ipmi_v6_gw='--'
        fi
        if [[ -z "$ipmi_mask_v6" ]] || [[ "$ipmi_mask_v6" == '0' ]]; then
            ipmi_mask_v6='--'
        fi
        if [[ -z "$OMIPGatewayIPv6" ]] || [[ "$OMIPGatewayIPv6" == '""' ]]; then
            OMIPGatewayIPv6='--'
        fi
        if [[ -z "$OMIPSubnetMaskIPv6" ]] || [[ "$OMIPSubnetMaskIPv6" == '0' ]]; then
            OMIPSubnetMaskIPv6='--'
        fi
        ipmi_ip_v4=$(grep "IP Address" $CheckMsgFile$Item | awk '{print $4}')
        ipmi_ip_v6=$(grep "ipmi_ipv6_address:" $CheckMsgFile$Item | awk -F'ipmi_ipv6_address:' '{print $2}')
        if [ "$ipmi_ip_v4" == "" -o "$ipmi_ip_v4" == "0.0.0.0" ]; then
            ipmi_ip_v4="--"
        fi
        if [ "$ipmi_ip_v6" == "" -o "$ipmi_ip_v6" == "null" -o "$ipmi_ip_v6" == "::" ]; then
            ipmi_ip_v6="--"
        fi
        if [ "$ipmi_ip_v4" == "--" ] && [ "$ipmi_ip_v6" == "--" ];then
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get IPMI address failed!"
            needPing='no'
            LOG "[$LINENO]$Item:The firmware upgrade is unavailable because failed to get IPMI address!"
            isPass=$(check_pass ${isPass} 1)
        fi
        if [[ $needPing == 'no' ]]; then
            connectState_v4='--'
            connectState_v6='--'
            needPings[$i]=0
        elif [[ $needPing == 'yes' ]]; then
            connectState_v4='Not tested'
            connectState_v6='Not tested'
            needPings[$i]=1
        fi
        Result[$i]="Node:$Item||IPMI IP (IPv4):$ipmi_ip_v4||IPMI default gateway (IPv4):$ipmi_v4_gw||IPMI subnet mask (IPv4):$ipmi_mask_v4||"
        Result[$i]="${Result[$i]}""OMIP default gateway (IPv4):$OMIPGatewayIPv4||OMIP subnet mask (IPv4):$OMIPSubnetMaskIPv4||Connectivity (IPv4):$connectState_v4||"
        Result[$i]="${Result[$i]}""IPMI IP (IPv6):$ipmi_ip_v6||IPMI default gateway (IPv6):$ipmi_v6_gw||IPMI subnet mask (IPv6):$ipmi_mask_v6||"
        Result[$i]="${Result[$i]}""OMIP default gateway (IPv6):$OMIPGatewayIPv6||OMIP subnet mask (IPv6):$OMIPSubnetMaskIPv6||Connectivity (IPv6):$connectState_v6||"
        Result[$i]="${Result[$i]}""Hardware type:$node_hw_catagory||BMC version:$BMCVersion"
        # LOG "[$LINENO]Node:$Item||$Result"
        # WRITE_XML_COMMON 0 "$Result"
        i=$[i+1]
    }
    done
    local isPass_old=${isPass}
    isPass=1
    local tmppass=0
    i=0
    for Item in $REMOTE_IP_S
    do
    {
        local time_now=$(date +%s)
        LOG "epoch now: ${time_now} seconds, passed $[time_now - time_start] seconds"
        if [[ $[time_now - time_start] -ge 400 ]]; then
            tmppass=2
            break
        fi
        if [[ ${needPings[$i]} == '0' ]]; then
            i=$[i+1]
            continue
        fi
        ipmi_ip_v4=$(grep "IP Address" $CheckMsgFile$Item | awk '{print $4}')
        ipmi_ip_v6=$(grep "ipmi_ipv6_address:" $CheckMsgFile$Item | awk -F'ipmi_ipv6_address:' '{print $2}')
        if [ "$ipmi_ip_v4" == "" -o "$ipmi_ip_v4" == "0.0.0.0" ]; then
            ipmi_ip_v4="--"
        fi
        if [ "$ipmi_ip_v6" == "" -o "$ipmi_ip_v6" == "null" -o "$ipmi_ip_v6" == "::" ]; then
            ipmi_ip_v6="--"
        fi
        # ͨ OM Card ڵ ping ڵ IPMI IP -- ʼ
        if [[ $ipmi_ip_v4 != '--' ]] ; then
            local repeat_ltines=${#RepeatTimes[*]}
            local iRet=0
            for time in ${RepeatTimes[*]}; do
                ping -q -c 1 -I $omNIC $ipmi_ip_v4 > /dev/null 2>&1
                iRet=$?
                if [[ $iRet != 0 ]] && [[ $time != $repeat_ltines ]];then
                    sleep 2
                else
                    break
                fi
            done
            if [[ $iRet == 0 ]];then
                Result[$i]=$(echo "${Result[$i]}" | sed 's/Connectivity (IPv4):[^|]*/Connectivity (IPv4):OK/g')
            else
                Result[$i]=$(echo "${Result[$i]}" | sed 's/Connectivity (IPv4):[^|]*/Connectivity (IPv4):Can not access/g')
                tmppass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because IPMI_IPV4:$ipmi_ip_v4 can not access!"
                LOG "Node:${Item}||INFO:IPMI_IPV4:$ipmi_ip_v4 can not access! CMD: ping -q -c 1 -I $omNIC $ipmi_ip_v4"
            fi
        fi
        if [[ $ipmi_ip_v6 != '--' ]] ;then
            local repeat_ltines=${#RepeatTimes[*]}
            local iRet=0
            for time in ${RepeatTimes[*]}; do
                ping -q -c 1 -I $omNIC $ipmi_ip_v6 > /dev/null 2>&1
                iRet=$?
                if [[ $iRet != 0 ]] && [[ $time != $repeat_ltines ]];then
                    sleep 2
                else
                    break
                fi
            done
            if [[ $iRet == 0 ]];then
                Result[$i]=$(echo "${Result[$i]}" | sed 's/Connectivity (IPv6):[^|]*/Connectivity (IPv6):OK/g')
            else
                Result[$i]=$(echo "${Result[$i]}" | sed 's/Connectivity (IPv6):[^|]*/Connectivity (IPv6):Can not access/g')
                tmppass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The firmware upgrade is unavailable because IPMI_IPV6:$ipmi_ip_v6 can not access!"
                LOG "Node:${Item}||INFO:IPMI_IPV4:$ipmi_ip_v4 can not access! CMD: ping -q -c 1 -I $omNIC $ipmi_ip_v4"
            fi
        fi
        # ͨ OM Card ڵ ping ڵ IPMI IP --  
        i=$[i+1]
    }
    done
    if [[ $tmppass == 0 ]]; then
        isPass=$isPass_old
    elif [[ $tmppass == 2 ]]; then
        WRITE_XML_ERROR 0 "Node:--||INFO:There are nodes that have not completed the ping test due to timeout(400 seconds)."
    fi
    i=0
    for Item in $REMOTE_IP_S
    do
    {   
        WRITE_XML_COMMON 0 "${Result[$i]}"
        i=$[i+1]
    }
    done
    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_JUDGE ${isPass}
    fi
}
#225. ҵڵ
analyse_result_checkMasterStatus()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local errResult=""
    local Result=""
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    set_ifs
    #ȡcmϢΪ׼
    mon_base=`cat /proc/monc_leader | grep Mon | awk '{print $3}'`
    mds_base=`cat /proc/monc_leader | grep Mds | awk '{print $3}'`
    pip_base=`cat /proc/monc_leader | grep Pip | awk '{print $3}'`
    restore_ifs

    LOG "[$LINENO]mon_base:$mon_base||mds_base:$mds_base||pip_leader:$pip_base||ProductType:$ProductType"
    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get Master status information from output(${fun}) failed"
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi

        mon_leader=`cat $CheckMsgFile$Item | grep Mon | awk '{print $3}'`
        mds_leader=`cat $CheckMsgFile$Item | grep Mds | awk '{print $3}'`
        pip_leader=`cat $CheckMsgFile$Item | grep Pip | awk '{print $3}'`
        #checkڵ
        if [ $ProductType -eq 80 ];then
            Result="Node:$Item||mon_leader:$mon_leader"
        else
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                Result="Node:$Item||mon_leader:$mon_leader||mds_leader:$mds_leader||pip_leader:$pip_leader"
            else
                Result="Node:$Item||mon_leader:$mon_leader||mds_leader:--||pip_leader:--"
            fi
        fi

        WRITE_XML_COMMON 0 "$Result"
        errResult=""
        #ݲһ
        if [ $ProductType -eq 80 ];then
            if [ "$mon_leader" == "" ] || [ "$mon_leader" != "$mon_base" ]; then
                isPass=1
                errResult="Node:${Item}||INFO:Mon leader is NULL or different from other nodes."
            fi
        else
            if [ "${service_type}" == "1" ];then
                if [ "$mon_leader" == "" ] || [ "$mds_leader" == "" ] || [ "$pip_leader" == "" ] || [ "$mon_leader" != "$mon_base" ] || [ "$mds_leader" != "$mds_base" ] || [ "$pip_leader" != "$pip_base" ]; then
                    isPass=1
                    errResult="Node:${Item}||INFO:Leader is NULL or differen from other nodes."
                fi
            else
                if [ "$mon_leader" == "" ] || [ "$mon_leader" != "$mon_base" ]; then
                    isPass=1
                    errResult="Node:${Item}||INFO:Mon leader is NULL or differen from other nodes."
                fi
            fi
        fi
        if [ "" != "${errResult}" ];then
            WRITE_XML_ERROR 0 "$errResult"
        fi
    }
    done

    WRITE_XML_JUDGE $isPass
}

#227 Nvdimmڴصʹ
analyse_result_checkNvdimmPool()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local Result=""
    local fimename="NvdimmPool"
    local TASK_ID="getinfo"
    local isPass=0
    local isflag=""
    local Info=""
    local Info_one=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local PoolName=""
    #V3R6C108GNVռӷ5700Mmoduleid=15
    modulelist="5 6 7 15"
    moduleid=("nvcache" "trns" "basecombine")

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1
        Result=""

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get NvdimmPool from output(${fun}) failed."
            continue
        fi
        errResult=`handle_remote_result "$fifoContext"`
        if [ $? -ne 0 ]; then
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:${errResult}" >/dev/null
            LOG "[$FUNCNAME][$LINENO]:Node: $Item||${errResult}"
            isPass=1
            continue
        fi

        modulecnt=0
        totalsize=(0 0 0 0)
        freesize=(0 0 0 0)
        for i in $modulelist;
        do
            cat $CheckMsgFile$Item |eval sed '0,/$fun$i/d' |eval sed '/$fun${i}_end/,\$\d' >$CheckMsgFile$Item$i
            dos2unix $CheckMsgFile$Item$i > /dev/null 2>&1

            fifoContext=`cat $CheckMsgFile$Item$i`
            if [ "$fifoContext" = "" ];then
                LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
                continue
            fi
            errResult=`cat $CheckMsgFile$Item$i | grep "[ERR]" |awk -F] '{print $2}'`
            if [ ${errResult} != "" ];then
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:${errResult}"
                isPass=1
                totalsize[$modulecnt]=0
                freesize[$modulecnt]=0
                modulecnt=$((modulecnt+1))
                continue
            fi

            #жǷΪûnvdimmµ
            isNvdimm=`cat $CheckMsgFile$Item$i | grep "no nvdimm, no need to get"`
            if [ "$isNvdimm" != "" ] ;then
                Result="Node:$Item||INFO: no nvdimm, no need to get ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                WRITE_XML_COMMON 0 "$Result"
                continue
            fi

            #nvdimmչֶûлȡtotalsizeҪδͨ
            Info=`cat $CheckMsgFile$Item$i | grep "total size"`
            if [[ "$Info" == "" && $i != 15 ]];then
                Info=`cat $CheckMsgFile$Item$i`
                LOG "[$FUNCNAME]:Node:$Item||INFO:get pool($i) info fail,Info($Info)"

                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get total size from output(${fun}) failed."

                isPass=1
                continue
            fi

            set_ifs

            #ȡ
            Total_Count=`cat $CheckMsgFile$Item$i | grep -w "free size" | wc -l`
            numCnt=1
            while [ $numCnt -le $Total_Count ]; do
                #ȡݣ
                Info_one=`cat $CheckMsgFile$Item$i | grep -w "free size" `

                tsize=`echo $Info_one|awk '{print $4}'`
                fsize=`echo $Info_one|awk '{print $11}'`
                totalsize[$modulecnt]=`expr ${totalsize[$modulecnt]} \+ $tsize`
                freesize[$modulecnt]=`expr ${freesize[$modulecnt]} \+ $fsize`

                #¼
                numCnt=$((numCnt+1))
            done
            restore_ifs
            modulecnt=$((modulecnt+1))
        done

        #nvdimm_extendȡҪӵnvdimm
        if [ "$modulecnt" == "4" ] ;then
            totalsize[0]=`expr ${totalsize[0]} \+ ${totalsize[3]}`
            freesize[0]=`expr ${freesize[0]} \+ ${freesize[3]}`
            modulecnt=$((modulecnt-1))
        fi

        #ջȡ˳
        for ((j=0; j<$modulecnt;j ++));
        do
            Pool="Pool[${moduleid[$j]}]"
            tsize=${totalsize[$j]}
            fsize=${freesize[$j]}
            usedSize=`expr $tsize \- $fsize`
            usedSize_temp=`expr $usedSize \* 100`
            percentage=`expr $usedSize_temp \/ $tsize`

            Result="Node:$Item||INFO: get pool info ok||Pool:$Pool||TotalSize(MB):$tsize||FreeSize(MB):$fsize||UsedSize(MB):$usedSize||Percentage(%):$percentage"

            WRITE_XML_COMMON 0 "$Result"
            #ģڴռҲģڴռ85%
            if [ $percentage -ge 90 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The Percentage(%):$percentage of Pool:$Pool is greater than 90%."
            fi
        done
    }
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

#245.Check Replication Link
analyse_result_checkReplicationLink()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        return
    else
        LOG "[$FUNCNAME][$LINENO]license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        #checkڵ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            continue
        fi

        dfsFlag=1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi

        interCheckReplicationLink "$Item" "$CheckMsgFile$Item"
        ret=$?
        if [ $ret -ne 0 ]; then
            isPass=1
        fi
    }
    done

    if [ $dfsFlag = 1 ]; then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:--||INFO:Can not find replication master node."
            #cluster no rep ctrl node
            elif [ $isFindCtrlNode -eq 0 ]; then
                WRITE_XML_COMMON 0 "INFO:Replication link is not configured."
            fi
        fi
    fi

    LOG "[$FUNCNAME][$LINENO] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

interCheckReplicationProcess()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #isGetSuccess isRepZoneNode status repPid
    if [  `cat $tmpFile | wc -l` -ne 1 ]; then
        WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:The number of replication process is greater than 1."
        tmpinfo=$(cat $tmpFile)
        LOG "[$FUNCNAME][$LINENO] $tmpFile unexpect.NodeIP=$NodeIP,tmpinfo=$tmpinfo"
        return 1
    fi
        item=`cat $tmpFile`
        status=`echo "${item}" | awk '{print $1}'`
        repPid=`echo "${item}" | awk '{print $2}'`
        if [ $status -eq 0 ]; then
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Normal||RepPID:${repPid}"
            if [ "X$repPid" == "X-" ]; then
                LOG "[$FUNCNAME][$LINENO] Failed to get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Failed to get replication process PID."
                return 1
            else
                return 0
            fi
        elif [ $status -eq 1 ]; then
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Disabled||RepPID:${repPid}"
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME][$LINENO]Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Replication node is disabled."
                return 1
            else
                return 0
            fi
        elif [ $status -eq 2 ]; then
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Frozen||RepPID:${repPid}"
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME][$LINENO] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Replication node is frozen."
                return 1
            else
                return 0
            fi
        elif [ $status -eq 3 ]; then
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Shutdown||RepPID:${repPid}"
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME][$LINENO] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Replication node is shutdown."
                return 1
            else
                return 0
            fi
        elif [ $status -eq 4 ]; then
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Deleted||RepPID:${repPid}"
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME][$LINENO] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Status of replication node is deleted."
                return 1
            else
                return 0
            fi
        elif [ $status -eq 5 ]; then
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Restart||RepPID:${repPid}"
            return 0
        else
            LOG "[$FUNCNAME][$LINENO] Get Replication Process when device status is $status."
            WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Unknown||RepPID:${repPid}"
            WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Status of replication node is unknown."
            return 1
        fi

    return 0
}

#246 Check Replication Process
analyse_result_checkReplicationProcess()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        return
    else
        LOG "[$FUNCNAME][$LINENO]license resource exists."
    fi

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        #checkڵ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            continue
        fi

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get Replication Process from output(${fun}) failed."
            continue
        fi

        interCheckReplicationProcess "$Item" "$CheckMsgFile$Item"
        ret=$?
        if [ $ret -ne 0 ]; then
            isPass=1
        fi
    }
    done

    LOG "[$FUNCNAME][$LINENO] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

interCheckReplicationZoneStatus()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #add filed:NodeStatus NodeResult isMasterNode isCtrlNode
    #original filed:NodeNum ChannelNum
    while read item
    do
        nodeStatus=`echo "${item}" | awk '{print $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME][$LINENO] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=`echo "${item}" | awk '{print $2}'`
        isMasterNode=`echo "${item}" | awk '{print $3}'`
        isCtrlNode=`echo "${item}" | awk '{print $4}'`

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Excute diagnose command(GetReplicationInfo ZoneStatus) failed."
            ret=2
            break
        fi

        #MasterNode and isCtrlNode=-, display:
        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                CheckReplicationMasterNodeChannel "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:Replication zone is not configured."
            ret=0
            break
        fi

        NodeNum=`echo "${item}" | awk '{print $5}'`
        ChannelNum=`echo "${item}" | awk '{print $6}'`
        if [ "X$NodeNum" = "X0" ] && [ "X$ChannelNum" != "X0" ]; then
            LOG "[$FUNCNAME][$LINENO], NodeNum($NodeNum), ChannelNum($ChannelNum)"
            WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:Replication channels exit,but the number of replication nodes is zero in the replication area."
            ret=1
        fi
        WRITE_XML_COMMON 0 "NodeNum:$NodeNum||ChannelNum:$ChannelNum"

    done <$tmpFile

    return $ret
}

#247.Check ReplicationZone Status
analyse_result_checkReplicationZoneStatus()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        return
    else
        LOG "[$FUNCNAME][$LINENO]license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        #checkڵ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            continue
        fi

        dfsFlag=1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi

        interCheckReplicationZoneStatus "$Item" "$CheckMsgFile$Item"
        ret=$?
        if [ $ret -ne 0 ]; then
            isPass=1
        fi
    }
    done

    if [ $dfsFlag = 1 ];then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:--||INFO:Can not find replication master node."
            #cluster no rep ctrl node
            elif [ $isFindCtrlNode -eq 0 ]; then
                WRITE_XML_COMMON 0 "INFO:Replication is not configured."
            fi
        fi
    fi

    LOG "[$FUNCNAME][$LINENO] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

interCheckReplicationPairStatus()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0
    local isPass=0

    sed -i /^shell-init:*/d "${tmpFile}"
    while read item
    do
        nodeStatus=`echo "${item}" | awk '{print $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME][$LINENO] Node: $NodeIP nodeStatus: $nodeStatus."
            break
        fi

        isGetSuccess=`echo "${item}" | awk '{print $2}'`
        isMasterNode=`echo "${item}" | awk '{print $3}'`
        isCtrlNode=`echo "${item}" | awk '{print $4}'`

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Excute diagnose command(GetReplicationInfo PairStatus) failed."
            isPass=$(check_pass ${isPass} 1)
            break
        fi

        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:
                CheckReplicationMasterNodePair "${item}" "${NodeIP}"
                ret=$?
                if [ $ret -ne 0 ]; then
                    isPass=$(check_pass ${isPass} 1)
                fi
                return $isPass
            fi
        elif [ "$isMasterNode" == "-" ]; then
            #MasterNode=- and isCtrlNode=CtrlNode, display ERR $NF
            tmpInfo=`echo "${item}" | awk -F" CtrlNode " '{print $2}'`
            WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:${tmpInfo}"
            isPass=$(check_pass ${isPass} 4)
            continue
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:Replication pair is not configured."
            break
        fi

        PairId=`echo "${item}" | awk '{print $5}'`
        RunningStatus=`echo "${item}" | awk '{print $6}'`
        HealthStatus=`echo "${item}" | awk '{print $7}'`
        if [ "$RunningStatus" == "Interrupted" ] || [ "$RunningStatus" == "ToBeRecoverd" ] || [ "$RunningStatus" == "Invalid" ]; then
            LOG "[$FUNCNAME][$LINENO] NodeIP($NodeIP), PairId($PairId), RunningStatus($RunningStatus), HealthStatus($HealthStatus)."
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:PairId:${PairId} running status is ${RunningStatus}."
        fi
        WRITE_XML_COMMON 0 "PairId:$PairId||RunningStatus:$RunningStatus||HealthStatus:$HealthStatus"
    done <$tmpFile

    return $isPass
}

#248 Check Replication Pair Status
analyse_result_checkReplicationPairStatus()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        return
    else
        LOG "[$FUNCNAME][$LINENO]license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        #checkڵ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            continue
        fi

        dfsFlag=1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi

        interCheckReplicationPairStatus "$Item" "$CheckMsgFile$Item"
        ret=$?
        isPass=$(check_pass ${isPass} $ret)
    }
    done

    if [ $dfsFlag = 1 ];then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:--||INFO:Can not find replication master node."
            fi
        fi
    fi

    LOG "[$FUNCNAME][$LINENO] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

#249.Check Replication Version
analyse_result_checkReplicationVersion()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        return
    else
        LOG "[$FUNCNAME][$LINENO]license resource exists."
    fi

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        #checkڵ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME][$LINENO]service_type = ${service_type}.skip ${Item}."
            continue
        fi

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME][$LINENO]item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get replication version from output(${fun}) failed."
            continue
        fi

        sed -i /^shell-init:*/d "${CheckMsgFile}""${Item}"
        nodeStatus=`cat $CheckMsgFile$Item | awk '{printf $1}'`
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME][$LINENO] Node: $NodeIP nodeStatus: $nodeStatus."
            continue
        fi

        isGetSuccess=`cat $CheckMsgFile$Item | awk '{printf $2}'`
        if [ "X$isGetSuccess" = "XFail" ]; then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Excute diagnose command(GetReplicationInfo Version) failed."
            continue
        fi
        repVersion=`cat $CheckMsgFile$Item | awk '{printf $4}'`
        WRITE_XML_COMMON 0 "Node:$Item||RepVersion:$repVersion"
        if [ -z "$firstVersionInfo" ]; then
            firstVersionInfo="$repVersion"
        else
            if [ "X$firstVersionInfo" != "X$repVersion" ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Replication version is different from others."
            fi
        fi
    }
    done

    LOG "[$FUNCNAME][$LINENO] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

#274 ֤Ч
function analyse_result_checkCertificate()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local certificateinfo="/tmp/tmpfilecertificateinfo"

    > $certificateinfo
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get certificate information from output(${InspectFun}) failed!"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )
        while read line
        do
            local filename=$(echo "$line" | grep "CerName" | awk -F"|" '{print $1}' | awk -F':' '{print $2}')
            local cersha=$(echo "$line" | grep "CerName" | awk -F"|" '{print $7}')
            echo "${Item} ${filename} ${cersha}" >> ${certificateinfo}
        done <$CheckMsgFile

        #ļеSHAֵ˵,ղʾSHAֵ
        sed -i "s/||key:[A-Za-z0-9:]*//g" ${CheckMsgFile}

        CheckMsgParse "$Item" "$CheckMsgFile" 0
        rm -rf $CheckMsgFile
    done

    local CertificateList="/opt/huawei/snas/etc/sslcert.pem /opt/huawei/snas/etc/sslca.cer /opt/huawei/deploy/etc/Equipment_Root_CA.der /opt/huawei/deploy/etc/IT_Product_CA.cer /etc/softcert/HuaweiRootCA.der /opt/huawei/deploy/etc/cluster_ca.cer /opt/huawei/deploy/etc/cluster_cert.pem /opt/huawei/deploy/etc/toolkit_dep_ca.cer /opt/Runtime/tomcat7/conf/server.pem /opt/Runtime/tomcat7/conf/server.cer /etc/ssl/private/server_cert.pem /opt/huawei/snas/etc/cert/alarm/cacert.pem /opt/huawei/snas/etc/cert/password/cacert.pem /opt/huawei/snas/etc/cert/emui/cacert.pem /etc/rsyslog-key/client_cert.pem /etc/rsyslog-key/ca.pem /opt/deviceManager/apache/conf/ca.crt /opt/huawei/viid/config/server/server.pem /opt/huawei/viid/config/server/server.cer /opt/huawei/deploy/etc/toolkit_dep_cert.pem /opt/deviceManager/apache/conf/cert_en.pem /opt/Runtime/tomcat7/cert/ToolKitDeploy.keystore /opt/Runtime/tomcat7/cert/IT_CA.keystore /opt/Runtime/tomcat7/conf/server.keystore /opt/obs/service/osc/etc/keystore /opt/obs/service/poe/etc/keystore /opt/obs/service/dcm/etc/keystore /var/uds/user/data_upf/server.crt"
    for item in ${CertificateList}
    do
        #ȥֻSHA
        local DiffCertiList=$( grep ${item} ${certificateinfo} |grep -v "NA" | awk '{print $3}'| sort | uniq -c | sort | awk '{print $2}' )
        local ArraySHAList=(${DiffCertiList})
        #һµĻֱӳȥ
        if [ 1 -eq ${#ArraySHAList[@]} ];then
            continue
        fi
        for i in $( seq 0 $( expr ${#ArraySHAList[@]} - 2 ) )
        do
            isPass=$(check_pass $isPass 1)
            grep ${item} ${certificateinfo} | grep "${ArraySHAList[i]}" |while read line
            do
                local Nodeip=$( echo ${line} | awk '{print $1}')
                #ҵͬshaֵ,ֱӱȥ,:ļûм¼ڵϢ,֪ĸڵ,ڵϢȥ
                WRITE_XML_ERROR 0 "Node:${Nodeip}||INFO:The Certificate ${item} is different with other nodes."
            done
        done
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
    [ -f $certificateinfo ] && rm -f $certificateinfo
}

#282.Ȳ״̬
analyse_result_checkHPatchstatus()
{
    local fun=$1
    local fun_end=${fun}_End
    local CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=3
    #ѯ״̬ɵʱļ
    local tmp_file="/tmp/tmp.getCmMaster.cache"
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
 
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        local fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            isPass=$(check_pass $isPass 3)
            continue
        fi

        set_ifs
        while read line
        do
            LOG "item=$Item, $line!"
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:$Item||INFO:$line!"
        done <$CheckMsgFile$Item
        restore_ifs
    }
    done

    /opt/huawei/snas/upd/patch_script/cluster_patch.sh cluster show > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
    if [ 0 -ne $? ];then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node:--||INFO: Failed to exectue command(cluster_patch.sh cluster show)."
    fi

    while read line
    do
        local status=""
        local tmpIp=$(echo ${line} | grep -Po '(?<=IP:)[0-9]+.[0-9]+.[0-9]+.[0-9]+')
        if [ "X${tmpIp}" != "X" ]; then
            local info=$(echo ${line} | grep 'Node Status')
            if [ "X${info}" != "X" ]; then
                status=$(echo $info | awk -F, '{print $2}' | awk -F: '{print $2}' | tr -d ' ')
            else
                local tmpinfo=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh ${tmpIp} show | grep "Node Status" )
                if [ 0 -ne $? ];then
                    isPass=$(check_pass $isPass 1)
                    WRITE_XML_ERROR 0 "Node:${tmpIp}||INFO: Failed to exectue command(cluster_patch.sh ${tmpIp} show)."
                else
                    status=$(echo "$tmpinfo" | awk -F, '{print $2}' | awk -F: '{print $2}' | tr -d ' ')
                    line="$tmpinfo"
                fi
            fi
            LOG "[$FUNCNAME][$LINENO] status: ${status}"
            #ڵʱstatusΪ
            if [ "X${status}" == "X" ] || [ "${status}" == "unload" ]; then
                isPass=$(check_pass $isPass 3)
            elif [ "${status}" != "confirmok" ];then
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node:${tmpIp}||INFO:Node Status is not confirm ok."
            else
                isPass=$(check_pass $isPass 0)
            fi
        fi
        WRITE_XML_COMMON 0 "INFO:${line}"
    done < $G_REMOTE_TMP_FILE$FUNCNAME

    LOG "[$FUNCNAME] pass:$isPass."
    [ -f "${tmp_file}" ] && rm -f "${tmp_file}"
    WRITE_XML_JUDGE $isPass >/dev/null
}

#286.ؼļȨ޼
analyse_result_checkKeyFileAuthority()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            isPass=$(check_pass $isPass 1)
            errResult="Node:${Item}||INFO:Get key file information from output(${fun}) failed."
            WRITE_XML_ERROR 0 "$errResult"
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            continue
        fi

        #жǷ
        snasshinfo=$(cat $CheckMsgFile$Item |grep snassh)
        if [ "X${snasshinfo}" != "X" ];then
            for line in $snasshinfo;do
                isPass=$(check_pass $isPass 1)
                catalogue=$(echo $line |awk -F ":" '{print $2}' )
                errResult="Node:$Item||INFO:snassh soft link exists in the /var/log/ directory."
                LOG "item=$Item,snassh is at $catalogue"
                WRITE_XML_ERROR 0 "$errResult"
            done
        fi
        #S30_get_os_permission.sh
        echo $fifoContext |grep S30_get_os_permission.sh >/dev/null
        if [ $? -eq 0 ];then
            Result="Node:$Item||INFO:S30_get_os_permission.sh is not exist."
            WRITE_XML_COMMON 0 "${Result}"
            continue
        fi
        #permission.log
        echo $fifoContext |grep permission.log >/dev/null
        if [ $? -eq 0 ];then
            Result="Node:$Item||INFO:/opt/permission.log is not exist,create it successful."
            WRITE_XML_COMMON 0 "${Result}"
            continue
        fi
        #ӡȨ޲ͬ
        unequalfilename=$(cat $CheckMsgFile$Item |grep filename0)
        for line in $unequalfilename;do
            isPass=$(check_pass $isPass 4)
            filename=$(echo $line | awk -F '\\|\\|' '{print $1}' | awk -F ":" '{print $2}')
            realFileMode=$(echo $line | awk -F '\\|\\|' '{print $2}' | awk -F ":" '{print $2}')
            expectFileMode=$(echo $line | awk -F '\\|\\|' '{print $3}' | awk -F ":" '{print $2}')
            errResult="Node:$Item||INFO:The file mode of $filename is $realFileMode, but $expectFileMode is expected."
            LOG "[$FUNCNAME] :Node:$Item||catalogue:$filename||realFileMode:$realFileMode||expectFileMode:$expectFileMode"
            WRITE_XML_ERROR 0 "$errResult"
        done
    }
    done

    #ȫͬӡ
    if [ ${isPass} -eq 0 ] && [ "X${errResult}" == "X" ] && [ "X${Result}" == "X" ];then
        Result="The authority in /opt/permission.log is same with the realFileMode."
        WRITE_XML_COMMON 0 "$Result"
    fi

    if [ ${isPass} -eq 0 ];then
        WRITE_XML_COMMON 0 "The inspection is passed."
    fi

    WRITE_XML_JUDGE $isPass >/dev/null
}

#305. УsmrϢһ
analyse_result_checkNodeSMRConfig()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local errResult=""
    local isPass=0
    local isFound=false
    local first_activeness_switch="NULL"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1
        
        # ļactiveness_switch=${activeness_switch} g_uiFetchSmrActivenessTimer=${timer} SMR_THRESHOLD_=${SMR_THRESHOLD_} isSmrNode=${isSmrNode} nodepoolName=${nodepoolName}
        if [ ${first_activeness_switch} == "NULL" ]
        then
            firt_ip=${Item}
            first_activeness_switch=$( awk '{print $1}' $CheckMsgFile${firt_ip} )
            first_g_uiFetchSmrActivenessTimer=$( awk '{print $2}' $CheckMsgFile${firt_ip} )
            first_SMR_THRESHOLD_=$( awk '{print $3}' $CheckMsgFile${firt_ip} )
            first_isSmrNode=$( awk '{print $4}' $CheckMsgFile${firt_ip} )
            first_version=$( awk '{print $6}' $CheckMsgFile${firt_ip} )
            first_smrfcswitch=$( awk '{print $7}' $CheckMsgFile${firt_ip} )
            LOG "[$FUNCNAME]:Node: $Item,contents:$(cat $CheckMsgFile${firt_ip} )"
        fi

        activeness_switch=$( awk '{print $1}' $CheckMsgFile$Item )
        g_uiFetchSmrActivenessTimer=$( awk '{print $2}' $CheckMsgFile$Item )
        SMR_THRESHOLD_=$( awk '{print $3}' $CheckMsgFile$Item )
        isSmrNode=$( awk '{print $4}' $CheckMsgFile$Item )
        nodepoolName=$( awk '{print $5}' $CheckMsgFile$Item )
        version=$( awk '{print $6}' $CheckMsgFile$Item )
        smrfcswitch=$( awk '{print $7}' $CheckMsgFile$Item )
        g_ullClearZoneDst=$( awk '{print $8}' $CheckMsgFile$Item )
        DefragEnable=$( awk '{print $9}' $CheckMsgFile$Item )
        if [ X"${first_activeness_switch}" != X"${activeness_switch}" -o X"${first_g_uiFetchSmrActivenessTimer}" != X"${g_uiFetchSmrActivenessTimer}" -o X"${first_SMR_THRESHOLD_}" != X"${SMR_THRESHOLD_}" -o X"${first_version}" != X"${version}" -o X"${first_smrfcswitch}" != X"${smrfcswitch}" ]
        then
            WRITE_XML_ERROR 0 "Node:${Item}||INFO: The SMR config is different with ${firt_ip}."
            isPass=1
        fi

        if [ X"${first_isSmrNode}" != X"${isSmrNode}" -a X"${isFound}" != X"true" ]
        then
            WRITE_XML_ERROR 0 "Node:${Item}||INFO: The cluster contains smr disk nodes and common sata disk nodes."
            isPass=1
            isFound=true
        fi
        # SMRֵĹ߰汾ж
        if [ "${isSmrNode}" == "isSmrNode=Yes" ]; then
            # 4.0汾SMRڵ㣬򿪿
            if [ "${version}" == "5.0" ]; then
                if [ ${smrfcswitch} -ne 1 ]; then
                    isPass=$(check_pass $isPass 4)
                    WRITE_XML_ERROR 0 "Node:${Item}||INFO: Need Set smrfcswitch=1 to Open the smrfcswitch"
                fi
            else
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node:${Item}||INFO: Need Install nofsspace_monitor_tool_5.0"
            fi

            # SMR GCڴ鿪״̬
            if [ ${g_ullClearZoneDst} -eq 0 ]; then
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node:${Item}||INFO: The value of g_ullClearZoneDst is ${g_ullClearZoneDst}."
            elif [ ${g_ullClearZoneDst} == "--" ] && [ ${DefragEnable} -eq 1 ];then
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node:${Item}||INFO: The value of g_ullClearZoneDst is ${g_ullClearZoneDst} and the value of DefragEnable is ${DefragEnable}."
            fi 
        fi
        Result=$(cat $CheckMsgFile$Item | tr "\n" " " 2>/dev/null)
        Result="Node:$Item||Config:${activeness_switch} ${g_uiFetchSmrActivenessTimer} ${SMR_THRESHOLD_} ${isSmrNode} ${nodepoolName}||nofsspace_monitor_tool_version:${version}||SmrFcSwitch:${smrfcswitch}||g_ullClearZoneDst:${g_ullClearZoneDst}||DefragEnable:${DefragEnable}"
        WRITE_XML_COMMON 0 "${Result}"
    }
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

#234 NTP״̬
analyse_result_checkNtpConn()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local back_ip=`get_backnet_ip`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S,back_ip=$back_ip"

    for Item in $REMOTE_IP_S
    do
    {
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            LOG "item=${Item}, file(${CheckMsgFile}$Item) is empty!"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get NTP information from output(ntpq -p) failed."
            continue
        fi

        bflag1=1   #NTPǷΪ1Ϊ0
        bflag2=1   #ڵNTPserver*Ϊ0Ϊ1.
        #״̬
        serverConn=`cat $CheckMsgFile$Item|grep "^*"|wc -l`
        if [ $serverConn -eq 0 ];then
            bflag1=0
            if [ "$back_ip" == "$Item" ];then
                ntpserverIP=$(cat /etc/ntp.conf |grep "^server"|awk '{print $2}')
                for serverip in ${ntpserverIP[*]};
                do
                    ntpinfo=$(sntp -t 3 $serverip |grep "secs"|wc -l)
                    if [ $ntpinfo -eq 1 ];then
                        bflag1=1
                        bflag2=0
                        LOG "[$FUNCNAME]bflag1=$bflag1;bflag2=$bflag2"
                        break
                    fi
                done
            fi
            if [ $bflag1 == 0 ];then
                isPass=1
                errResult="Node:$Item||INFO:NTP server is unreachable."
                WRITE_XML_ERROR 0 "$errResult"
            fi
            #
            cat $CheckMsgFile$Item >> $LOG_FILE 2>&1
        fi
        if [ $bflag1 == 1 ];then
            #offsetƫ
            if [ bflag2 == 1 ];then
                offset=`tac $CheckMsgFile$Item|grep "^*"|awk '{print $9}'|sed -n '1p'`
            else
                offset=`cat $CheckMsgFile$Item|awk '{print $9}'|sed -n '3p'`
            fi

            LOG "[$FUNCNAME]:offset:$offset"
            if [ `echo "$offset < 7200000"|bc` -eq 1 ] && [ `echo "$offset > -7200000"|bc` -eq 1 ] ;then
                offset=${offset#-}
                Result="Node: $Item||INFO: ntp is normal.||Offset: ${offset}"
                WRITE_XML_COMMON 0 "${Result}"
            else
                isPass=1
                errResult="Node:$Item||INFO:The offset(${offset}) in output(ntpq -p) is more than 7,200,000."
                WRITE_XML_ERROR 0 "$errResult"

                #
                cat $CheckMsgFile$Item >> $LOG_FILE 2>&1
            fi
        fi
    }
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass >/dev/null
}

# **************************************************************************** #
# Function Name: checkViidIpcStatus
# Description: viid ͷ״̬.
# Parameter:
# Return:
# **************************************************************************** #
#307 ipc״̬Ѳ
analyse_result_checkViidIpcStatus()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    #ҵ߼
    local result=1
    local masterNode=''
    for Item in $REMOTE_IP_S; do
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        local nodeType=`grep "NodeType: *Master" $CheckMsgFile$Item |awk '{gsub(/ /,"")}1'`
        if [ "${nodeType}X" != "X" ];then
            #ڵ
            result=0
            masterNode=$Item
        else
            continue
        fi
    done
    if [ $result -ne 0 ];then
        #ѯ
        local Result="There is no VIID master node."
        WRITE_XML_ERROR 0 "$Result"
        isPass=1
    else
        set_ifs
        grep -v "NodeType: *Master" $CheckMsgFile$masterNode > /tmp/tmp.viid.log
        grep -v "Status:*" /tmp/tmp.viid.log > /tmp/tmp.viid.log1
        local flag=$(grep "\.disconnectIpc\." $CheckMsgFile$masterNode)
        local abnormal=$(grep "Status:*Error" $CheckMsgFile$masterNode)
        while read line; do
            if [ "${flag}X" != "X" -o "${abnormal}X" != "X" ];then
                WRITE_XML_ERROR 0 "The cameras in the cluster are not deployed successfully."
                isPass=1
            else
                WRITE_XML_COMMON 0 "The cameras in the cluster are deployed successfully."
            fi
        done < /tmp/tmp.viid.log1
        rm /tmp/tmp.viid.log
        rm /tmp/tmp.viid.log1
        restore_ifs
    fi

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}

#309. ڵwal״̬
analyse_result_checkNodeWALSwitch()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    fileLine_init=NULL
    for Item in $REMOTE_IP_S; do

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        if [ $fileLine_init == "NULL" ]
        then
            fileLine_init="$Item"
            LOG "[$FUNCNAME]:Node: $Item||INFO: set fileLine_init $fileLine_init OK"
        fi
        fileLine=$(diff -bB $CheckMsgFile$fileLine_init $CheckMsgFile$Item |wc -l)
        swValues=$(cat $CheckMsgFile$Item | tr '\n' ' ')
        #ӡ־
        LOG "[$FUNCNAME]:Node: $Item||INFO: file line $fileLine"

        if [ $fileLine -ne 0 ]
        then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Values of switches are different with its in ${fileLine_init}."
        fi
        Result="Node:$Item||Switches:${swValues}"
        WRITE_XML_COMMON 0 "${Result}"
    done
    
    # WALļ,ǰѲ칤ߵýڵʵʾCMڵ
    local service_type=0
    local dfsnodeCnt=0
    local nodeid=""
    local backip=""
    local walSwitch="/mnt/fs/system/wal_switch"
    local tmpdir="/tmp/tmpCheckWALIni"
    fileLine_init=NULL
    
    [ -d ${tmpdir} ] && rm -rf ${tmpdir}
    mkdir -p ${tmpdir}
    local nas="${tmpdir}/nas.sh"
    echo "#!/bin/bash" > $nas
    echo "\$*" >> $nas
    echo " " >> $nas
    chmod +x $nas
    
    cat /proc/monc_nodemap 2>/dev/null | grep NodeID >${tmpdir}/tmp_nodemap
    while read line
    do
        if [ X"${line}" == X"" ]; then
            continue
        fi
        
        nodeid=$( echo "${line}" | awk -F "[()]" '{print $2}' )
        backip=$( echo "${line}" | awk -F "[()]" '{print $8}' )
        if [ X"${nodeid}" == X"" -o X"$( echo ${nodeid} | grep -o '[0-9]*' )" != X"${nodeid}" \
            -o X"${backip}" == X"" -o X"${backip}" != X"$( echo ${backip} | grep -o '[0-9.]*' )" ]; then
            LOG "[$FUNCNAME] ERR:nodeid:${nodeid} or backip:${backip} format is error."
            continue
        fi
        
        # 1.0 ֻļڵ㣬ļڵ㲻
        service_type=$(get_service_type_from_db "${backip}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type} is not dfs,.skip ${backip}."
            continue
        fi
    
        dfsnodeCnt=$((dfsnodeCnt+1))
        
        # WALļʽ⣬ת1.iniʾ001.ini,23.iniʾ023.ini,123.iniʾ123.ini
        nodeid=$( printf "%03d" ${nodeid} )
        curWalFile="${walSwitch}/${nodeid}.ini"
        if [ $fileLine_init == "NULL" ]; then
            fileLine_init="${curWalFile}"
            diffBaseWalFile="${curWalFile}"
        fi
        
        # 2.0 dfsڵwalļڻΪգѲ첻ͨ
        fileExistAndNonEmpty=$( ${nas} [ -f "${curWalFile}" -a -s "${curWalFile}" ] && echo yes || echo no )
        if [ X"${fileExistAndNonEmpty}" != X"yes" ]; then
            Result="Node:${backip}||INFO:WAL configuration file:${curWalFile} is nonexist or empty."
            WRITE_XML_ERROR 0 "${Result}"
            isPass=1
            continue
        fi
        
        # 3.0 dfsڵWALļͬѲ첻ͨ
        ${nas} diff -bB "${curWalFile}" "${diffBaseWalFile}" >/dev/null 2>&1
        WalIniSame=$?
        if [ ${WalIniSame} -ne 0 ]; then
            Result="Node:${backip}||INFO:WAL configuration file:${curWalFile} is different from ${diffBaseWalFile}."
            WRITE_XML_ERROR 0 "${Result}"
            isPass=1
            continue
        fi
    done <${tmpdir}/tmp_nodemap

    # 4.0 WALļdfsڵһ˳Ѳ첻ͨ
    WalIniFileCnt=$( $nas ls ${walSwitch}/[0-9][0-9][0-9].ini 2>/dev/null | wc -l )
    if [ X"${WalIniFileCnt}" != X"${dfsnodeCnt}" ]; then
        Result="Node:${dfsnodeCnt}||INFO:there are ${dfsnodeCnt} dfs node,but ${WalIniFileCnt} WAL configuration files under ${walSwitch}."
        WRITE_XML_ERROR 0 "${Result}"
        isPass=1
    fi
     
    rm -rf /tmp/tmpCheckWALIni	 
    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}

#311. Կݷͨ
analyse_result_checkAKAutoback_server()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=3
    local result=""
    local fifoContext=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"

    #ҵ߼
    for Item in $REMOTE_IP_S; do
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Null output(${fun})."
            isPass=$(check_pass $isPass 1)
            continue
        fi

        result=`echo "$fifoContext" |grep "abnormal"`
        if [ "X" != "X${result}" ];then
            LOG "Node: $Item||INFO: abnormal"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:${result}"
            isPass=$(check_pass $isPass 1)
        else
            isPass=$(check_pass $isPass 0)
            LOG "Node: $Item||INFO: normal"
        fi
    done

    if [ $isPass -eq 0 ]; then
        WRITE_XML_COMMON 0 "Pass"
    fi

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}

#320. ü飨㣺snas.ini shutdownEarTemp shutdownCpuTemp shutdownNvdimmTempã ǰ汾Ϊ7.1.1ҴSPH5Լ֮Ĳ,[flow_control]GangNodeMemPercent
function analyse_result_CheckALLNodeSpecialConf()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local confinfo="/tmp/tmpfileSpecialConf"

    > $confinfo
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get snas.ini information from output(${InspectFun}) failed!"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )
        cat $CheckMsgFile >> $confinfo

        CheckMsgParse "$Item" "$CheckMsgFile" "1"
        rm -rf $CheckMsgFile
    done

    local checkList="shutdownEarTemp shutdownCpuTemp shutdownNvdimmTemp"
    local NodeNum=$(cat $confinfo | grep shutdownEarTemp: | wc -l)
    for item in ${checkList}
    do
        local nodeList=""
        local cfgNum=$(cat $confinfo | grep "${item}:yes" |wc -l)
        if [ ${cfgNum} -ne ${NodeNum} ] && [ ${cfgNum} -ne 0 ];then
            isPass=$(check_pass ${isPass} 4)
            local notCfgInfo=$(cat $confinfo | grep ${item}:no )
            for tmpInfo in ${notCfgInfo}
            do
                local node=$(echo ${tmpInfo} | grep -Po '(?<=^Node:)[0-9.]*')
                nodeList="${node} ${nodeList}"
            done
            WRITE_XML_ERROR 0 "nodeIP:master||INFO:${item} is not configued on (${nodeList})."
        fi
    done

    # flow_controlǷ
    while read content
    do
        echo "${content}" | grep "flow_control:NO PASS"
        if [ $? -eq 0 ]
        then
            nodeinfo=$( echo "${content}" | awk -F \| '{print $1}' )
            sphinfo=$( echo "${content}" | awk -F \| '{print $(NF-2)}' )
            WRITE_XML_ERROR 0 "${nodeinfo}||INFO:the flow_control configuration(${sphinfo}) needs to be updated in the /opt/huawei/snas/etc/nofs.ini file."
        fi
    done < ${confinfo}

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
    [ -f $confinfo ] && rm -f $confinfo
}

#327. CCDBڵݿ汾Ƿһ
analyse_result_CheckCCDBDBConsistency()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local result=""
    local fifoContext=""
    local dbfileList=""
    local CCDB_Num=0
    local monLeader=""
    local ccdbIP=""
    local isBackIp=""
    local isCCDBIp=""
    local nodeIdList=""
    local tmpIpRole=$(cat $IP_ROLE_FILE)
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    local tmpFileCCDB="${G_TMP_FILE}CCDB"
    local tmpFileCCDB_bak="${G_TMP_FILE}CCDB.BAK"
    local ccdbMasterVersion=1
    local ccdbMasterNodeIp=""
    local ccdbSlaveVersion=0
    local ccdbSlaveNodeIp=""
    > ${tmpFileCCDB}
    >${tmpFileCCDB_bak}
    monLeader=$(cat /proc/monc_leader | grep "Mon leader:" | awk -F":" '{print $2}')
    ccdbMasterNodeIp=$( cat /proc/monc_ccdbmap | grep "Role: 0" | awk '{print $NF}' | sed "s/^ *//g" | sed "s/ *$//g" )
    
    if [ -f "/proc/monc_ccdbmap" ];then
        nodeIdList=$(cat /proc/monc_ccdbmap | grep -Po '(?<=MinIp: )[0-9.]+' | tr "\n" " ")
        local nodeId=""
        for nodeId in $nodeIdList;do
            local bakipList=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select ip_addr from cm_node_ip_t where(nid = (select nid from cm_node_ip_t where(ip_addr = '${nodeId}')) and SUBNET_ID = 1) ")
            local ip=""
            for ip in $bakipList;do
                isBackIp=$(echo "${tmpIpRole}" | grep -wF ${ip})
                if [ $? -eq 0 ];then
                    ccdbIP="${ip} ${ccdbIP}"
                    break
                fi
            done
        done
    else
        #monڵִвѯccdb
        nodeIdList=$(/opt/huawei/deploy/script/localexec.py cmd ${monLeader} 30 false "MmlBatch 988 'monc ccdbmap 0'| grep \"Node Id :\"  " | grep -Po '(?<=Node Id : )[0-9]+')
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet) "
            errResult="Node:${monLeader}||INFO:Failed to execute command(MmlBatch 988 'monc ccdbmap 0'). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
        else
            /opt/huawei/deploy/script/localexec.py cmd ${monLeader} 30 false "cat /proc/monc_nodemap" > ${tmpFileCCDB} 2>&1
            local nodeId=""
            for nodeId in $nodeIdList;do
                local tmpNodeIdIp=$(cat ${tmpFileCCDB} | grep "NodeID($nodeId)" | grep -Po '(?<=DevName\()[0-9.]+')
                local bakipList=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select ip_addr from cm_node_ip_t where(nid = (select nid from cm_node_ip_t where(ip_addr = '${tmpNodeIdIp}')) and SUBNET_ID = 1) ")
                local ip=""
                for ip in $bakipList;do
                    isBackIp=$(echo "${tmpIpRole}" | grep -wF ${ip})
                    if [ $? -eq 0 ];then
                        ccdbIP="${ip} ${ccdbIP}"
                        break
                    fi
                done
            done
            > ${tmpFileCCDB}
        fi
    fi
    #ҵ߼
    if [ -z "$ccdbIP" ];then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node: $(hostname)(master) || INFO: Can not get ccdbIP!"
        rm -f ${tmpFileCCDB}
        LOG "[$FUNCNAME] pass:$isPass."
        WRITE_XML_JUDGE $isPass
        return
    fi
    for Item in $tmpIpRole; do
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1

        isCCDBIp=$(echo "$ccdbIP" | grep -w "$Item")
        if [ $? -ne 0 ];then
            cat $CheckMsgFile$Item >> ${tmpFileCCDB_bak}
            echo $Item >> ${tmpFileCCDB_bak}
            continue
        fi
        
        # ߼CCDBƵϢ
        grep -q "Epoch: " $CheckMsgFile$Item
        if [ $? -eq 0 ]; then
            errinfo_=$(  grep "Epoch: " $CheckMsgFile$Item | awk -F "Epoch: " '{print $2}' )
            sed -i "/Epoch: /d" $CheckMsgFile$Item
            [ X"${errinfo_}" != X"" ] && WRITE_XML_ERROR 0 "Node:$Item||INFO:${errinfo_}."
            isPass=$(check_pass $isPass 1)
        fi

        # ߼7.1.1.SPC1汾ccdbڵpaxos_versionڵڱڵpaxos_version
        grep -q "paxos_version:" $CheckMsgFile$Item
        if [ $? -eq 0 ]; then
            LOG "[$FUNCNAME] ${item}:$(grep paxos_version: $CheckMsgFile$Item)."
            nodeRole=$(  grep "paxos_version:" $CheckMsgFile$Item | awk -F: '{print $2}' | sed "s/ //g" )
            version=$(  grep "paxos_version:" $CheckMsgFile$Item | awk -F: '{print $3}' | sed "s/ //g" )
            [ X"${nodeRole}" == X"ccdbmaster" ] && ccdbMasterVersion=${version}
            [ X"${nodeRole}" == X"ccdbslave" ] && [ X"${version}" != X"" ] && [ ${ccdbSlaveVersion} -lt ${version} ] && ccdbSlaveVersion=${version} && ccdbSlaveNodeIp="${Item}"
            sed -i "/paxos_version:/d" $CheckMsgFile$Item
        fi
        
        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Null output(${fun})."
            isPass=$(check_pass $isPass 1)
            continue
        fi
        result=`echo "$fifoContext" |grep "No CCDB database file"`
        if [ "X" != "X${result}" ];then
            LOG "Node: $Item||INFO: No CCDB database file"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:${result}"
            isPass=$(check_pass $isPass 1)
        else
            CCDB_Num=$(expr $CCDB_Num + 1)
            cat $CheckMsgFile$Item >> ${tmpFileCCDB}
            echo $Item >> ${tmpFileCCDB}
        fi
    done
    dbfileList=$(/opt/huawei/deploy/script/localexec.py cmd ${monLeader} 30 false "find /opt/product/etc/ccdb/ -type f "| grep -vP '\-wal|\-shm|\.log|/ccdb_export/')
    [ $? -ne 0 ] && dbfileList=$(cat ${tmpFileCCDB} | grep "^/opt/" | awk '{print $1}' |sort -u )
    for item in $dbfileList;do
        maxVer=$(cat ${tmpFileCCDB} | grep -w "$item" | awk '{print $NF}' | sort -n | tail -1)
        tmpNum=$(cat ${tmpFileCCDB} | grep -w "$item" | grep -w "${maxVer}" | wc -l)
        if [ "$tmpNum" -gt "$(expr $CCDB_Num / 2 )" ] || [ "$item" = "/opt/product/etc/ccdb/ccdb_metadata.db_0/ccdb_metadata.db" ];then
            WRITE_XML_COMMON 0 "Node: ${monLeader}(mon) || INFO:$item max version is $maxVer ($tmpNum/$CCDB_Num)."
        else
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node: ${monLeader}(mon) || INFO: $item max version is $maxVer ($tmpNum/$CCDB_Num)!"
        fi
    done

    # ߼7.1.1.SPC1汾ccdbڵpaxos_versionڵڱڵpaxos_version
    if [ ${ccdbSlaveVersion} -gt ${ccdbMasterVersion} ]; then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node: ${ccdbMasterNodeIp}(ccdbMasterNodeIp) || INFO: ccdbMasterNode(${ccdbMasterNodeIp}) version(${ccdbMasterVersion}) is lower than ccdbSlaveNode(${ccdbSlaveNodeIp}) version(${ccdbSlaveVersion})!"
    fi

    mv -f ${tmpFileCCDB} /var/log/CCDB_DB_version.log
    echo "-------other node-------" >> /var/log/CCDB_DB_version.log
    cat ${tmpFileCCDB_bak} >> /var/log/CCDB_DB_version.log 
    [ -f "${tmpFileCCDB_bak}" ] && rm -f  ${tmpFileCCDB_bak}
    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}

#337. NOFS mosռü
analyse_result_CheckNofsMosObjectUsage()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local CheckMsgFileFail="/tmp/CheckMsgFileFail${InspectFun}$$"
    local CheckMsgFileNormal="/tmp/CheckMsgFileNormal${InspectFun}$$"
    local CheckMsgFileAbnormal="/tmp/CheckMsgFileAbnormal${InspectFun}$$"
    local CheckMsgFileErrInfo="/tmp/CheckMsgFileErrInfo${InspectFun}$$"
    local tmpinfo=""
    local TaskIps="/tmp/tmpfileTaskIps"

    > $TaskIps
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        # ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            isPass=$(check_pass $isPass 1)
            LOG "[$FUNCNAME]:Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            echo "[ERR]Node:$Item||poolName:--||(ObjType ChunkCount Sum Percent):Get PassStatus from output(${InspectFun}) failed!" >> ${CheckMsgFileFail}
            continue
        fi
        isPass=$(check_pass $isPass $PassStatus )

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            echo "[ERR]Node:${Item}||poolName:--||(ObjType ChunkCount Sum Percent):Get NofsMosObjectUsage from output(${InspectFun}) failed!" >> ${CheckMsgFileFail}
            continue
        fi
        cat $CheckMsgFile |grep -v "poolName:--" |grep -v "\[ERR\]" |awk -v Item=$Item '{print "Node:"Item"||"$0}' >> $CheckMsgFileNormal
        cat $CheckMsgFile |grep "\[ERR\]poolName:P" |sed 's/\[ERR\]//g' |awk -v Item=$Item '{print "[ERR]Node:"Item"||"$0}' >> $CheckMsgFileAbnormal
        cat $CheckMsgFile |grep "\[ERR\]" |grep -v "poolName:P" |sed 's/\[ERR\]//g' |awk -v Item=$Item '{print "[ERR]Node:"Item"||"$0}' >> $CheckMsgFileErrInfo

        val=$( cat $CheckMsgFile | tail -n1 | awk -F ':' '{print $NF}' )
        iRet=$?
        if [ $iRet -eq 0 ];then
            echo -n " $Item ($val) ," >> $TaskIps
        fi
    done

    CheckMsgParse "" "$CheckMsgFileNormal" "1"
    CheckMsgParse "" "$CheckMsgFileAbnormal" "1"
    CheckMsgParse "" "$CheckMsgFileErrInfo" "1"
    CheckMsgParse "" "$CheckMsgFileFail" "1"

    str="Node:--||poolName:--||(ObjType ChunkCount Sum Percent):--||dataCount(type1-3):--||dataLimit:--||metaCount(type4-6):--||metalimit:--||totalCount(type07):--||RandomZoneTotalAlloc:--"
    if [ -f $TaskIps ] && [ -s $TaskIps ];then
        dos2unix $TaskIps > /dev/null 2>&1
        sed -i 's/,$//' $TaskIps
        valTaskIps=$( cat $TaskIps )
        WRITE_XML_COMMON 0 "${str}||MosReserve:${valTaskIps}"
    fi

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass

    [ -f $CheckMsgFile ] && rm -f $CheckMsgFile
    [ -f $CheckMsgFileNormal ] && rm -f $CheckMsgFileNormal
    [ -f $CheckMsgFileAbnormal ] && rm -f $CheckMsgFileAbnormal
    [ -f $CheckMsgFileErrInfo ] && rm -f $CheckMsgFileErrInfo
    [ -f $CheckMsgFileFail ] && rm -f $CheckMsgFileFail
    [ -f $TaskIps ] && rm -f $TaskIps
}

# 343 ǿĿ¼ɨ迪ؼ
analyse_result_CheckNonEmptyDirQuotaSwitch()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local back_ip=""
    local usedCapRate=0

    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi
        isPass=$(check_pass $isPass $PassStatus )

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" != "" ];then
            CheckMsgParse "$Item" "$CheckMsgFile" "0"
        fi
    done
    [ -f $CheckMsgFile ] && rm -rf $CheckMsgFile

    #дnas.shļ
    local tmpdir=$(mktemp -d /tmp/XXXXXX)
    local nas="${tmpdir}/nas.sh"
    echo "#!/bin/bash" > $nas
    echo "\$*" >> $nas
    echo " " >> $nas
    chmod +x $nas

    quotaSwitch=$( $nas "cat /mnt/fs/system/quota_scan/quota_scan.ini" | grep switch | awk -F, '{print $2}' | sed "s/ *//g" | sed "s/ *$//g" )

    if [ X"${quotaSwitch}" != X"1" ]; then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node:(master)||INFO:The non-empty directory quota scan switch is disabled,advise to enable it."
        WRITE_XML_JUDGE $isPass
    else
        WRITE_XML_COMMON 0 "Node:(master)||INFO:The non-empty directory quota scan switch is enable."
        WRITE_XML_JUDGE $isPass
    fi

    rm -rf ${tmpdir}

    return
}

upd_database_check_cm()
{
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local allinfo_file=$1
    local inspction_fun=$2
    local fun_end=${inspction_fun}_End
    local ipmitool_sn
    local remote_msg
    local isPass=0 # pass
    local upd_db_sn_master=$(grep "masterSNs in cm_upd.db" ${allinfo_file}| awk -F ':' '{print $2}')
    local upd_db_sn_slave=$(grep "slaveSNs in cm_upd.db" ${allinfo_file}| awk -F ':' '{print $2}')
    cat ${allinfo_file} >> /var/log/inspect.log
    for Item in $REMOTE_IP_S
    do
        remote_msg=$(cat ${allinfo_file} | sed "0,/NODEIP_${Item}_BEGIN/d" | sed "/NODEIP_${Item}_END/,\$d")
        ipmitool_sn=$(echo "${remote_msg}" | grep -Eo 'LOCAL_SN:[^|]*' | awk -F ':' '{print $2}')
        if ! $(echo "${upd_db_sn_master}" | grep -q ${ipmitool_sn}) ; then
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:SN of local node(${ipmitool_sn}) is not in upd master's DB"
            isPass=1 # not pass
        fi    
        if ! $(echo "${upd_db_sn_slave}" | grep -q ${ipmitool_sn}) ; then
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:SN of local node(${ipmitool_sn}) is not in upd slave's DB"
            isPass=1 # not pass
        fi
    done
    return ${isPass}
}
#346. ǰü
function analyse_result_CheckALLNodeSpecialConfPreUpgrade()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local CheckMsgFile2="/tmp/CheckMsgFile2${InspectFun}$$"
    local iRet
    local tmpinfo=""
    local allinfo="/tmp/tmpfileSpecialConfPreUpgrade"

    > $allinfo
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get certificate information from output(${InspectFun}) failed!"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )
        echo "NODEIP_${Item}_BEGIN" >> $allinfo
        cat $CheckMsgFile >> $allinfo
        echo "NODEIP_${Item}_END" >> $allinfo
        grep -Ev '^\[ZJZ\]' $CheckMsgFile > $CheckMsgFile2 2>/dev/null

        CheckMsgParse "$Item" "$CheckMsgFile2" "1"
        rm -rf $CheckMsgFile
        rm -rf $CheckMsgFile2
    done

    # ÿһҪ CM Ѳ칦ܣһѲ첻ͨϢͨ WRITE_XML_ERROR ,  pass status
    # úʹ allinfo зallinfo ÿڵȡϢ NODEIP_${backend_ip}_BEGIN  NODEIP_${backend_ip}_END ֮
    upd_database_check_cm ${allinfo} ${InspectFun}
    iRet=$?
    isPass=$(check_pass $isPass $iRet )
    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
    [ -f $allinfo ] && rm -f $allinfo
}

function check_front_end_bond4()
{
    local cm_db_file="/opt/huawei/snas/etc/cm_conf.db"
    local back_ip=$( get_backnet_ip )
    local retryTime=0
    local maxTryTimes=4

    if [ ! -f "${cm_db_file}" ];then
        WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:the file ${cm_db_file} does not exist!"
        LOG "[$FUNCNAME]the file ${cm_db_file} does not exist."
        return 1
    fi

    while [ ${retryTime} -lt ${maxTryTimes} ]
    do
        retryTime=$((retryTime+1))
        front_end_info=$( /usr/bin/sqlite3 ${cm_db_file} "select * from CM_NODE_NETCARD_T where SUBNET_ID=2" )
        if [ $? -ne 0 ]
        then
            sleep 2
            continue
        fi

        echo "${front_end_info}" | grep bond0 >/dev/null 2>&1
        if [ $? -eq 0 ]
        then
            LOG "[$FUNCNAME]front end is bond,info:${front_end_info}."
            break
        else
            LOG "[$FUNCNAME]front end is not bond,info:${front_end_info}."
            return 0
        fi
    done

    # ǰbondģʽǷbond4 802.3ad
    grep "802\.3ad" /etc/sysconfig/network-scripts/ifcfg-bond0 >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        bond4_info=$( grep "802\.3ad" /etc/sysconfig/network-scripts/ifcfg-bond0 )
        WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The front-end port is bond4 mode(${bond4_info}). you need to change the expanding node's bond mode."
        return 4
    fi

    return 0
}

#347. ü
function analyse_result_CheckALLNodeSpecialConfExpand()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local iRet=0
    local allinfo="/tmp/tmpfileSpecialConfExpand"

    > $allinfo
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get certificate information from output(${InspectFun}) failed!"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )
        cat $CheckMsgFile >> $allinfo

        CheckMsgParse "$Item" "$CheckMsgFile" "1"
        rm -rf $CheckMsgFile
    done

    # 洢ݳѲ콨ŻʾڵҪSR-IOV˲
    grep streamStoreMode /opt/huawei/snas/etc/snas.ini | grep -q ds
    if [ $? -eq 0 ]
    then
        # ûʵʴֻҪݳѲŻҴӡϢ
        isPass=$(check_pass $isPass 4)
        WRITE_XML_ERROR 0 "Node:expand_node||INFO:For nodes to be expand, enable the SR-IOV function and invoke /opt/vm_cpu_bond.py to bind CPU cores to VMs. For details, see the product documentation!"
    fi

    # ԭȺǰ˿bond4ģʽǰѲҪʾΪĬǰbond6ģʽҪݱдbondIPݳɹ޸ݽڵbondģʽΪbond4bondIP.
    # ǰbond϶нڵ㶼˵ģֻڹڵͿ
    check_front_end_bond4
    iRet=$?
    isPass=$(check_pass $isPass ${iRet})

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
    [ -f $allinfo ] && rm -f $allinfo
}

#348. ü
function analyse_result_CheckALLNodeSpecialConfPatch()
{
    local isPass=0
    local InspectFun="$1"
    local fun_end=${InspectFun}_End
    local REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local CheckMsgFile="/tmp/CheckMsgFile${InspectFun}$$"
    local tmpinfo=""
    local allinfo="/tmp/tmpfileSpecialConfPatch"

    > $allinfo
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    for Item in $REMOTE_IP_S
    do
        #ȡÿڵѲϢ
        PassStatus=$(cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${InspectFun}_Pass' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get PassStatus from output(${InspectFun}) failed!"
            isPass=$(check_pass $isPass 1)
            continue
        fi

        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$InspectFun/d' |eval sed '/${InspectFun}_Pass/,\$\d' > ${CheckMsgFile}
        tmpinfo=$(cat ${CheckMsgFile})
        if [ "${tmpinfo}" == "" ];then
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get certificate information from output(${InspectFun}) failed!"
            continue
        fi

        isPass=$(check_pass $isPass $PassStatus )
        cat $CheckMsgFile >> $allinfo

        CheckMsgParse "$Item" "$CheckMsgFile" "1"
        rm -rf $CheckMsgFile
    done

    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
    [ -f $allinfo ] && rm -f $allinfo
}

analyse_result_default()
{
    local taskid=$1
    local InspectFun=`GetInspectType $taskid`
    G_CHECK_RESULT_FILE="/tmp/check_result_file"$taskid
    if [ -L $G_CHECK_RESULT_FILE ]; then
        LOG "[$FUNCNAME] There are security risks"
        rm -f $G_CHECK_RESULT_FILE
    fi
    > $G_CHECK_RESULT_FILE

    WRITE_XML_HEADER >/dev/null
    WRITE_XML_CMD_HEADER $taskid >/dev/null
    WRITE_XML_SUBCMD_HEADER "0" >/dev/null
    if [ "$InspectFun" != "" ];then
        $2 $InspectFun
    else
        LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
        WRITE_XML_COMMON 0 "INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
    fi
    WRITE_XML_SUBCMD_TAIL >/dev/null
    WRITE_XML_CMD_TAIL >/dev/null
    WRITE_XML_TAIL $taskid >/dev/null
}

#default=0:NODEУdefault=1NODE
CheckMsgParse()
{
    local Remote_ip=$1
    local CheckMsgFile=$2
    local default=$3
    local info=""
    local Result=""
    dos2unix $CheckMsgFile > /dev/null 2>&1
    local index=0
    while read var
    do
        if [ "$var" != "" ]; then
            info=`handle_remote_result "$var"`
            if [ $? -ne 0 ]; then
                if [ $default -eq 0 ];then
                    WRITE_XML_ERROR 0 "Node: $Remote_ip||${info}" >/dev/null
                elif [ $default -eq 1 ];then
                    WRITE_XML_ERROR 0 "${info}" >/dev/null
                fi
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:inspect error ${info}"
            else
                if [ $default -eq 0 ];then
                    WRITE_XML_COMMON 0 "Node: $Remote_ip||${info}" >/dev/null
                elif [ $default -eq 1 ];then
                    WRITE_XML_COMMON 0 "${info}" >/dev/null
                fi
            fi
        fi
    done < "$CheckMsgFile"
}

CheckPassStatus()
{
    isPass=3
    fun=$1
    fun_end=${fun}_End
    strGrep=${fun}_Pass
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"

    for Remote_ip in $REMOTE_IP_S
    do
    {
        PassStatus=$(cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:Get PassStatus from output(${fun}) failed!"
            isPass=$(check_pass $isPass 1)
        else
            #ӽڵѲϢ
            cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >$CheckMsgFile
            #дѲXML
            CheckMsg=$(cat $CheckMsgFile)
            if [ "$CheckMsg" = "" ];then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get CheckMsg failed"
                WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:Null output($fun)!"
                isPass=$(check_pass $isPass 1)
            else
                CheckMsgParse "$Remote_ip" "$CheckMsgFile" $2
                rm -rf $CheckMsgFile
            fi
            if [ "$PassStatus" !=  "0" ]; then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO: ${fun} check result:$PassStatus."
            fi
            isPass=$(check_pass $isPass $PassStatus)
        fi
    }
    done
    WRITE_XML_JUDGE $isPass >/dev/null
}

#207
analyse_result_checkISMStatus()
{
    isPass=0
    fun=$1
    fun_end=${fun}_End
    strGrep=${fun}_Pass
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"

    for Remote_ip in $REMOTE_IP_S
    do
    {
        PassStatus=$(cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:Get PassStatus from output(${fun}) failed!"
            isPass=1
        else
            cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >$CheckMsgFile
            CheckMsg=$(cat $CheckMsgFile)
            if [ "$CheckMsg" = "" ];then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get CheckMsg failed"
                continue
            else
                CheckMsgParse "$Remote_ip" "$CheckMsgFile" 1
                rm -rf $CheckMsgFile
            fi
            if [ "$PassStatus" !=  "0" ]; then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO: ${fun} check result:$PassStatus."
                isPass=$PassStatus
            fi
        fi
    }
    done
    WRITE_XML_JUDGE $isPass >/dev/null
}

#2=0:NODEУ2=1NODE
analyse_result_common()
{
    local taskid=$1
    local InspectFun=`GetInspectType $taskid`

    G_CHECK_RESULT_FILE="/tmp/check_result_file"$taskid
    > $G_CHECK_RESULT_FILE
    WRITE_XML_HEADER >/dev/null
    WRITE_XML_CMD_HEADER $taskid >/dev/null
    WRITE_XML_SUBCMD_HEADER "0" >/dev/null
    if [ "$InspectFun" != "" ];then
        CheckPassStatus $InspectFun $2
    else
        LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
        WRITE_XML_COMMON 0 "INFO:The current system does not support the appointed inspect item($taskid)!"
    fi
    WRITE_XML_SUBCMD_TAIL >/dev/null
    WRITE_XML_CMD_TAIL >/dev/null
    WRITE_XML_TAIL $taskid >/dev/null
}

analyse_result()
{
    #xmlдļG_CHECK_RESULT_FILE У̴ᵼд󣬹ʴС
    #ڿɸıдxmlʽŻΪС
    taskids=$1
    analyse_method=""
    for taskid in $taskids
    do
    {
        case $taskid in
            100)
                #1.Check Disk Usage
                analyse_result_default $taskid "analyse_result_checkDiskUsage"
                ;;
            101)
                #2.Check CPU Usage
                analyse_result_default $taskid "analyse_result_checkCPUUsage"
                ;;
            102)
                analyse_result_common $taskid 1
                ;;
            103)
                #4.Check Disk Status
                analyse_result_common $taskid 1
                ;;
            106)
                #7.Check Netport Status
                analyse_result_common $taskid 0
                ;;
            107)
                analyse_result_common $taskid 1
                ;;
            109)
                #10.Check disk verify error
                analyse_result_common $taskid 0
                ;;
            110)
                #ڵ()¶
                analyse_result_common $taskid 0
                ;;
            111)
                #ڴü
                analyse_result_common $taskid 0
                ;;
            113)
                #check SSD
                analyse_result_common $taskid 0
                ;;
            115)
                #nvdimm״̬
                analyse_result_common $taskid 0
                ;;
            116)
                #nvdimm״̬
                analyse_result_common $taskid 1
                ;;
            117)
                #check ARP
                analyse_result_common $taskid 0
                ;;
            122)
                #syslog״̬
                analyse_result_common $taskid 1
                ;;
            123)
                #ϵͳ̽״̬
                analyse_result_common $taskid 0
                ;;
            133)
                #ڴ
                analyse_result_default $taskid "analyse_result_checkPhyMem"
                ;;
            136)
                #豸ڵǷʱԴ쳣
                analyse_result_common $taskid 0
                ;;
            139)
                # rmbg񲢷
                analyse_result_common $taskid 0
                ;;
            140)
                #Ϣ
                analyse_result_default $taskid "analyse_result_checkVmstatus"
                ;;
            144)
                #PCIEЭ
                analyse_result_common $taskid 0
                ;;
            145)
                #SES̼汾
                analyse_result_common $taskid 0
                ;;
            146)
                #д
                analyse_result_common $taskid 0
                ;;
            147)
                #SAS̼汾
                analyse_result_default $taskid "analyse_result_checkSASVersion"
                ;;
            148)
                #SMR״̬
                analyse_result_common $taskid 0
                ;;
            149)
                #ڵMTUǷһ¡֡
                analyse_result_default $taskid "analyse_result_checkNetportBitErrandJumboframe"
                ;;
            150)
                #̿ؼ
                analyse_result_common $taskid 0
                ;;
            151)
                #̼汾
                analyse_result_common $taskid 0
                ;;
            152)
                #IOB״̬
                analyse_result_common $taskid 0
                ;;
            153)
                #BBU״̬
                analyse_result_common $taskid 0
                ;;
            154)
                #RoCE״̬
                analyse_result_common $taskid 0
                ;;
            157)
                #ڵӱǩ
                analyse_result_common $taskid 0
                ;;
            159)
                #BBUռ
                analyse_result_common $taskid 0
                ;;
            160)
                #T3000豸Ƿ
                analyse_result_common $taskid 0
                ;;
            170)
                #ES3000 V5SSD/NVME
                analyse_result_common $taskid 0
                ;;
	    171)
                #ES3000V6
                analyse_result_common $taskid 0
                ;;
            202)
                #4.Check Node IO Perform
                analyse_result_common $taskid 0
                ;;
            203)
                #4.Check Watchdog Status
                analyse_result_common $taskid 0
                ;;
            204)
                #6.MONϵͳ״̬
                analyse_result_common $taskid 1
                ;;
            205)
                #6.Check NTP Service
                analyse_result_default $taskid "analyse_result_checkNTPService"
                ;;
            206)
                #7.Check CM master
                analyse_result_default $taskid "analyse_result_checkCMMaster"
                ;;
            207)
                analyse_result_default $taskid "analyse_result_checkISMStatus"
                ;;
            209)
                #10.Check File operationļ
                analyse_result_common $taskid 0
                ;;
            210)
                #11.Check NAS client
                analyse_result_default $taskid "analyse_result_checkALLClient"
                ;;
            211)
                #12.Check NAS Cluster Status
                analyse_result_common $taskid 0
                ;;
            213)
                #14.Check Communication Link (ڵϵͨѶ·)
                analyse_result_default $taskid "analyse_result_checkCommuLink"
                ;;
            214)
                #14.Check memory pool usage
                analyse_result_default $taskid "analyse_result_checkMemPoolUsage_Async"
                ;;
            215)
                #Check data consistentһ
                analyse_result_default $taskid "analyse_result_checkDataConsistent_Async"
                ;;
            218)
                #Check system file opened (linuxϵͳ򿪵ļ)
                analyse_result_common $taskid 0
                ;;
            221)
                #Check LDAP ط״̬
                analyse_result_default $taskid "analyse_result_checkLDAP"
                ;;
            222)
                #Check IPMIַǷ
                analyse_result_default $taskid "analyse_result_checkIPMI"
                ;;
            225)
                #ҵڵ״̬  mon mds pip
                analyse_result_default $taskid "analyse_result_checkMasterStatus"
                ;;
            226)
                #MON Serverڵ
                analyse_result_common $taskid 0
                ;;
            227)
                #Nvdimmڴصʹ
                analyse_result_default $taskid "analyse_result_checkNvdimmPool"
                ;;
            231)
                #monitorƵѡ
                analyse_result_common $taskid 0
                ;;
            233)
                #30ǷcorecrashԼcorefileÿռǷ
                analyse_result_common $taskid 0
                ;;
            234)
                #NTPʱͬ״̬
                analyse_result_default $taskid "analyse_result_checkNtpConn"
                ;;
            235)
                #ڵRPCüǷй©
                analyse_result_common $taskid 1
                ;;
            236)
                #дNOFSǷгʱ
                analyse_result_common $taskid 0
                ;;
            237)
                analyse_result_common $taskid 1
                ;;
            242)
                #һɨ赼µعʧ
                analyse_result_common $taskid 0
                ;;
            244)
                #ɾrecycle_switchrmbg_data
                analyse_result_common $taskid 0
                ;;
            245)
                #1.Check Replication Link
                analyse_result_default $taskid "analyse_result_checkReplicationLink"
                ;;
            246)
                #1.Check Replication Process
                analyse_result_default $taskid "analyse_result_checkReplicationProcess"
                ;;
            247)
                #1.Check ReplicationZone Status
                analyse_result_default $taskid "analyse_result_checkReplicationZoneStatus"
                ;;
            248)
                #1.Check Replication Pair Status
                analyse_result_default $taskid "analyse_result_checkReplicationPairStatus"
                ;;
            249)
                #1.Check ReplicationZone Version
                analyse_result_default $taskid "analyse_result_checkReplicationVersion"
                ;;
            250)
                # ̼
                analyse_result_default $taskid "analyse_result_checkAvailabilityOfFwUpg"
                ;;
            251)
                analyse_result_common $taskid 1
                ;;
            253)
                #check default log print level
                analyse_result_common $taskid 0
                ;;
            258)
                #rpcǷȷ
                analyse_result_common $taskid 1
                ;;
            260)
                #check ad connection
                analyse_result_common $taskid 0
                ;;
            261)
                #ʱ
                analyse_result_common $taskid 0
                ;;
            266)
                #daemoncgroupȨ
                analyse_result_common $taskid 0
                ;;
            274)
                analyse_result_default $taskid "analyse_result_checkCertificate"
                ;;
            276)
                analyse_result_common $taskid 0
                ;;
            278)
                analyse_result_common $taskid 0
                ;;
            282)
                #Ȳ״̬
                analyse_result_default $taskid "analyse_result_checkHPatchstatus"
                ;;
            285)
                #ȡvfsͳ
                analyse_result_common $taskid 1
                ;;
            286)
                #ؼļȨ޼
                analyse_result_default $taskid "analyse_result_checkKeyFileAuthority"
                ;;
            288)
                #ȺIDһУ
                analyse_result_common $taskid 0
                ;;
            289)
                #DLMȺ״̬
                analyse_result_common $taskid 1
                ;;
            290)
                #DSǷϱ׼ϢNOFSϱ׼Ϣ
                analyse_result_common $taskid 0
                ;;
            292)
                #omuserͬ
                analyse_result_common $taskid 0
                ;;
            296)
                #Ԫݽڵü
                analyse_result_common $taskid 0
                ;;
            302)
                #ϵͳ
                analyse_result_common $taskid 0
                ;;
            303)
                analyse_result_common $taskid 0
                ;;
            304)
                analyse_result_common $taskid 0
                ;;
            305)
                #ȺSMRһԼ
                analyse_result_default $taskid "analyse_result_checkNodeSMRConfig"
                ;;
            306)
                #viid server״̬
                analyse_result_common $taskid 1
                ;;
            307)
                #viid ͷ״̬
                analyse_result_default $taskid "analyse_result_checkViidIpcStatus"
                ;;
            309)
                #viid wal״̬һԼ
                analyse_result_default $taskid "analyse_result_checkNodeWALSwitch"
                ;;
            310)
                #ǷNFSӾ̬ipĿͻ
                analyse_result_common $taskid 0
                ;;
            311)
                #Կݷͨ
                analyse_result_default $taskid "analyse_result_checkAKAutoback_server"
                ;;
            313)
                #xml
                analyse_result_common $taskid 0
                ;;
            316)
                #ЭIO״̬
                analyse_result_common $taskid 0
                ;;
            317)
                #Numa
                analyse_result_common $taskid 0
                ;;
            318)
                #ڵü
                analyse_result_common $taskid 0
                ;;
            319)
                #ֵԿؼ
                analyse_result_common $taskid 0
                ;;
            320)
                #ü
                analyse_result_default $taskid "analyse_result_CheckALLNodeSpecialConf"
                ;;
            321)
                #Ӳ̹̼Ѳ
                analyse_result_common $taskid 0
                ;;
            322)
                analyse_result_common $taskid 0
                ;;
            323)
                #ݲɼѲ
                analyse_result_common $taskid 0
                ;;
            326)
                #·ɼ
                analyse_result_common $taskid 0
                ;;
            327)
                #CCDBڵݿ汾
                analyse_result_default $taskid "analyse_result_CheckCCDBDBConsistency"
                ;;
            328)
                #Ӳmode page
                analyse_result_common $taskid 0
                ;;
            329)
                #־
                analyse_result_common $taskid 0
                ;;
            331)
                #С
                analyse_result_common $taskid 0
                ;;
            332)
                #iBMA
                analyse_result_common $taskid 0
                ;;
            334)
                #staticļ
                analyse_result_common $taskid 0
                ;;
            335)
                #updļ
                analyse_result_common $taskid 0
                ;;
            337)
                #NOFS mosռü
                analyse_result_default $taskid "analyse_result_CheckNofsMosObjectUsage"
                ;;
            338)
                #NOFSŴд
                analyse_result_common $taskid 0
                ;;
            339)
                #NOFS mosռü
                analyse_result_common $taskid 0
                ;;
            341)
                #V5ʱǷѡ ӿڿ&оƬ
                analyse_result_common $taskid 0
                ;;
            342)
                #NOFSʱӺgang
                analyse_result_common $taskid 0
                ;;
            343)
                #
                analyse_result_default $taskid "analyse_result_CheckNonEmptyDirQuotaSwitch"
                ;;
            344)
                #ռͺ̨
                analyse_result_common $taskid 0
                ;;
            346)
                #ǰü
                analyse_result_default $taskid "analyse_result_CheckALLNodeSpecialConfPreUpgrade"
                ;;
            347)
                #ü
                analyse_result_default $taskid "analyse_result_CheckALLNodeSpecialConfExpand"
                ;;
            348)
                #ü
                analyse_result_default $taskid "analyse_result_CheckALLNodeSpecialConfPatch"
                ;;
            350)
                #洢汾
                analyse_result_common $taskid 0
                ;;
            351)
                #洢Ӳ汾
                analyse_result_common $taskid 0
                ;;
            352)
                #ǰü
                analyse_result_common $taskid 0
                ;;
            354)
                #IPַ滮
                analyse_result_common $taskid 0
                ;;
            358)
                #ü
                analyse_result_common $taskid 0
                ;;
            359)
                #Ⱥļ
                analyse_result_common $taskid 0
                ;;
            407)
                analyse_result_common $taskid 0
                ;;
            408)
                analyse_result_common $taskid 0
                ;;
            501)
                analyse_result_common $taskid 0
                ;;
            502)
                analyse_result_common $taskid 0
                ;;
            503)
                analyse_result_common $taskid 0
                ;;
            504)
                analyse_result_common $taskid 0
                ;;
            505)
                analyse_result_common $taskid 0
                ;;
            *)
                noInspectItem "0"
                ;;
        esac
    }
    done
}
# **************************************************************************** #
# Function Name: writeErrxml
# Description: Ѳidһxmlظ
#
# Parameter: $1(ѲID) $2(Ϣ)
# Return:
# **************************************************************************** #
function writeErrxml()
{
    local taskid="$1"
    local desc="$2"
    WRITE_XML_HEADER >/dev/null
    WRITE_XML_CMD_HEADER $checkid >/dev/null
    WRITE_XML_SUBCMD_HEADER 0
    WRITE_XML_ERROR 0 "${desc}" >/dev/null
    WRITE_XML_JUDGE 1 >/dev/null
    WRITE_XML_SUBCMD_TAIL >/dev/null
    WRITE_XML_CMD_TAIL >/dev/null
    WRITE_XML_TAIL ${taskid} >/dev/null
}

# **************************************************************************** #
# Function Name: StandbyNodeCheck
# Description: Ϊ˼CMڵѹѲм㸴䵽ӽڵִУ
#
# Parameter: $1 ѲID
# Return:
# **************************************************************************** #
function StandbyNodeCheck()
{
    local id="$1"
    local StandbyIpList=($(cat ${STANDBY_IP_FILE}))
    local tmpIp=""
    local exec_taskid="StandbyCheck"
    local command=""
    local localfile="${G_SCRIPT_PATH}/check_id_file"
    local remotefile="${G_SCRIPT_PATH}/check_id_file"
    local validTaskID=()
    local ipNum=${#StandbyIpList[@]}

    ##ȡipʧ
    if [ $ipNum -eq 0 ];then
        LOG "[$FUNCNAME][$LINENO]Download file(${remotefile}$id) failed return!"
        writeErrxml "${id}" "Get node information failed"
        return
    fi

   #ѡȡһڵip
   tmpIp=${StandbyIpList[$[$RANDOM%$ipNum]]}
    case $id in
    1*)
        command="$G_SCRIPT_PATH/inspect_hardware_nomal.sh $id > /dev/null"
        ;;
    2*|3*)
        command="$G_SCRIPT_PATH/inspect_software_nomal.sh $id > /dev/null"
        ;;
    esac
   remote_exec_async $tmpIp $exec_taskid 1000 "$command"
   #3ηӽڵʧܣôش
   if [ $? -eq 101 ];then
       writeErrxml "$id" "Exec cmd failed."
       LOG "[$FUNCNAME][$LINENO]exec cmd($id) failed. ip(${tmpIp})"
       return
   fi

   sleep 5

    LOG "[$FUNCNAME][$LINENO]exec cmd(taskid=$id) at node(${tmpIp})"
    download_standby_result "${tmpIp}" "StandbyCheck" "${localfile}$id" "${remotefile}$id"
    if [ $? -ne 0 ];then
        LOG "[$FUNCNAME][$LINENO]Download file(${remotefile}${id}) failed return!"
        writeErrxml "$id" "Get node information failed"
    fi
    return
}

# **************************************************************************** #
# Function Name: checkwareStatusExBatch
# Description: ware мչ.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkwareStatusExBatch()
{
    touch /tmp/check_thread_count$$
    #ȡеĺIPִ
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #Զ̽ڵȡϢѲ
    local alltask="$@"
    local Num=0
    #齨checkitemsִвʽ壨InspectFun1-param1-param2-param3 inspectFun2-param1-param2-param3 ...)

    local Params=$(echo ${alltask}|awk '{printf $1}'|tr '[0-9]' '[A-J]')
    local startTime=0
    local endTime=0
    local diffTime=0
    local iRet=0
    startTime=$(date +%s)
    G_CHECK_IDLIST="${alltask}"
    LOG "[${FUNCNAME}][$LINENO]Enter inspect item ${alltask}"
    for REMOTE_IP in $REMOTE_IP_S
    do
        exec_cmd "${REMOTE_IP}" "${alltask}" "$Params"

    done

    for REMOTE_IP in $REMOTE_IP_S
    do
        download_result "${REMOTE_IP}" "$Params"
        iRet=$?

        #ʧ
        if [ ${iRet} -eq 126 ]; then
            download_result "${REMOTE_IP}" "$Params"
        fi
    done
    endTime=$(date +%s)
    diffTime=$((endTime - startTime))
    LOG "[${FUNCNAME}][$LINENO]Exit inspect item ${alltask}, elapsed time:${diffTime}s"
    analyse_result "${alltask}"
    rm -f /tmp/check_thread_count$$
}
