#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

function usage()
{
    echo "$ScriptHardwareFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#ʱΪʱմСȡ־
function Hardware_collectBySize()
{
    local size=$1
    local need_size="${size}"
    local is_T3000=0
    local is_RHNode=0
    local HWtarFile=""
    local HWpath=""
    log "start collect Hardware,size=${size}"
    local sub_path="${MessageDir}/Hardware/"
    rm -rf ${sub_path}
    mkdir -p ${sub_path}

    #жǷΪT3000
    IsT3000Node
    is_T3000=$?
    #жǷΪRH,RH2288 5288
    IsRHNode
    is_RHNode=$?

    #Ǹܿڵִcollect_t3000_log.sh
    if [ ${is_T3000} -eq 0 ]; then
        dmidecode -t 4 | grep -q "Family: Atom"
        if [ $? -ne 0 ]; then
            cd /opt/huawei/snas/bin/
            HWtarFile=`ls t3000infor_* | grep "tar.gz$"`
            tar -zxf  ${HWtarFile}
            HWpath=`ls -d t3000infor_* | grep -v "tar.gz"`
            cd  ${HWpath}
            log "start collect BMC log for T3000"
            ./CollectBmcLog.sh ${sub_path} > /dev/null 2>&1
            sh T3000GetLog.sh ${sub_path}  > /dev/null 2>&1
            cd /opt/huawei/snas/bin/
            rm -rf ${HWpath}
            log "end collect BMC log for T3000"
        fi
    fi

    #T3000RHִ־ռ
    if [ ${is_T3000} -eq 0 ] || [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_eth.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ib.sh ${sub_path}
        cp /var/log/sel.log ${sub_path}
        cp /var/log/sel.log.bak ${sub_path}
    fi

    #RHִ־ռ
    if [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_sas.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ses.sh ${sub_path}
    fi

    #жǷIB
    IsIBNode
    is_IBNode=$?
    if [ ${is_IBNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_ib.sh ${sub_path}
    fi

    #
    cd ${sub_path}
    tar zcf ${output_file} ./*
    if [ -d ${sub_path} ];then
        rm -rf ${sub_path}/*
    fi
    log "end collect Hardware by size"
}

function Hardware_collectByTime()
{
    log "collect Hardware by time,from [${begin_time}] to [${end_time}]"
    local sub_path="${MessageDir}/Hardware/"
    local HWtarFile=""
    local HWpath=""
    rm -rf ${sub_path}
    mkdir -p ${sub_path}

    #жǷΪT3000
    IsT3000Node
    is_T3000=$?
    #жǷΪRH,RH2288 5288
    IsRHNode
    is_RHNode=$?

    #Ǹܿڵִcollect_t3000_log.sh
    if [ ${is_T3000} -eq 0 ]; then
        dmidecode -t 4 | grep -q "Family: Atom"
        if [ $? -ne 0 ]; then
            cd /opt/huawei/snas/bin/
            HWtarFile=`ls t3000infor_* | grep "tar.gz$"`
            tar -zxf  ${HWtarFile}
            HWpath=`ls -d t3000infor_* | grep -v "tar.gz"`
            cd  ${HWpath}
            ./CollectBmcLog.sh ${sub_path} > /dev/null 2>&1
            sh T3000GetLog.sh ${sub_path}  > /dev/null 2>&1
            cd /opt/huawei/snas/bin/
            rm -rf ${HWpath}
        fi
    fi

    #T3000RHִ־ռ
    if [ ${is_T3000} -eq 0 ] || [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_eth.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ib.sh ${sub_path}
        cp /var/log/sel.log ${sub_path}
        cp /var/log/sel.log.bak ${sub_path}
    fi

    #RHִ־ռ
    if [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_sas.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ses.sh ${sub_path}
    fi

    #
    cd ${sub_path}
    tar zcf ${output_file} ./*
    if [ -d ${sub_path} ];then
        rm -rf ${sub_path}/*
    fi
    log "end collect Hardware by time"
}

#ռӲϢ
function collectSSDInfo()
{
    local DevSsd=""
    local max_loginfonum=6;
    local log_head_info=""
    local get_log_cmd=""
    local cnt=0;
    local CmdPort=4016;
    local tmp_time=""
    local tmp_result=""
    local line_list=""
    log "start collect ssd log"

    head_info=("Useful information of disk"
    "smart value"
    "smart threshold"
    "The NV log of HSSD SAS"
    "The Flash Log of HSSD SATA "
    "The Flash of HSSD SAS "
    "The current log of HSSD SAS")
    cmd_info=("disktool -f a"
    "disktool -A o -z smartval"
    "disktool -A o -z smartthr"
    "disktool -A o -z log"
    "disktool -A o -z log2"
    "disktool -A o -z log3"
    "disktool -A o -z log4")

    DevSsd=`lsscsi | grep "/dev/sd" | grep HSSD | awk {'print $NF'}`
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm showdiskname" >/tmp/collectSSDInfo 2>&1
    dos2unix /tmp/collectSSDInfo
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' /tmp/collectSSDInfo 2>&1
    DevSsd=`cat /tmp/collectSSDInfo |grep -wE "Disk_Type:3|Disk_Type:17" |awk '{print $3}'`
    for cnt in `seq 0 $max_loginfonum`; do
        log_head_info="${head_info[$cnt]}"
        get_log_cmd="${cmd_info[$cnt]}"
        echo "***********************$log_head_info**********************" >>$SSD_LOG_FILE
        echo "$get_log_cmd" >>$SSD_LOG_FILE
        for line in $DevSsd
        do
            echo "**********$line info**********" >>$SSD_LOG_FILE

            $get_log_cmd $line >>$SSD_LOG_FILE
            if [ $? -ne 0 ];then
                $get_log_cmd $line >>$SSD_LOG_FILE
            fi
        done
    done

    #Ϣ
    cat /proc/mpt2sas/mpt2sas0-drives > "$CMLogDir"Other/disk_info
    disktool -f A >> "$CMLogDir"Other/disk_info
    log "$Item: Get mpt2sas0-drives info.ret($?)"

    cp -f /proc/interrupts "$CMLogDir"/Other/interrupts
    log "$Item: Get interrupts file,ret($?)"
    #ռdisktool־
    cp -rf /tmp/disktool_log* "$CMLogDir"/Other/ >/dev/null 2>&1
    log "$Item: Get disktool_log* file,ret($?)"

    #ռʷϢ
    for time in ${RepeatTimes[*]}; do
        line_list=$(sqlite3 /opt/huawei/snas/etc/cm_diskkick.db "select SN,KICKTIME,NID,DSID,SLOTID,POOLNAME from disk_kicklist")
        if [ "X${line_list}" == "X" ];then
            log "[collectSSDInfo]Failed to get info from DB"
            sleep 2
        else
            break
        fi
    done
    echo "********************broken disk info********************" > "$CMLogDir"Other/broken_disk_info
    for line in ${line_list}
    do
        tmp_result=$(echo "${line}" | awk -F'|' '{print $1}')
        echo "DiskSN : ${tmp_result}" >> "$CMLogDir"Other/broken_disk_info
        tmp_result=$(echo "${line}" | awk -F'|' '{print $2}')
        tmp_time=$(date -d @"${tmp_result}" "+%Y-%m-%d %H:%M:%S")
        echo "KickTime : ${tmp_time}" >> "$CMLogDir"Other/broken_disk_info
        tmp_result=$(echo "${line}" | awk -F'|' '{print $3}')
        echo "NodeID : ${tmp_result}" >> "$CMLogDir"Other/broken_disk_info
        tmp_result=$(echo "${line}" | awk -F'|' '{print $4}')
        echo "DiskID : ${tmp_result}" >> "$CMLogDir"Other/broken_disk_info
        tmp_result=$(echo "${line}" | awk -F'|' '{print $5}')
        echo "DiskSlot : ${tmp_result}" >> "$CMLogDir"Other/broken_disk_info
        tmp_result=$(echo "${line}" | awk -F'|' '{print $6}')
        echo "PollName : ${tmp_result}" >> "$CMLogDir"Other/broken_disk_info
        echo "" >> "$CMLogDir"Other/broken_disk_info
        echo "===============================" >> "$CMLogDir"Other/broken_disk_info
    done

    #ռHDDӲϢ
    DevSsd=`cat /tmp/collectSSDInfo | grep -wE "Disk_Type:1|Disk_Type:2|Disk_Type:4" |awk '{print $3}'`
    log_head_info="${head_info[0]}"
    get_log_cmd="${cmd_info[0]}"
    echo "***********************$log_head_info**********************" >$HDD_LOG_FILE
    echo "$get_log_cmd" >>$HDD_LOG_FILE
    for line in $DevSsd
    do
        echo "**********$line info**********" >>$HDD_LOG_FILE
        $get_log_cmd $line >>$HDD_LOG_FILE
    done

    #ռǰ̵smartϢ
    cp /var/log/snas_DiskFaultStatus.log "$CMLogDir"Other/snas_DiskFaultStatus.log >/dev/null 2>&1
    adjustSize
    log "end collect ssd log"

    return 0
}

#ӡϢ
function collectPrintFirmWare()
{
    local NodeID=$1
    local FirmWareType=$2
    local FirmWareVer=$3
    local collectConfigFile="${CMLogDir}Config/HD_Config.txt"
    echo "" >> ${collectConfigFile} 2>&1
    echo "        NodeId      :${NodeID}" >> ${collectConfigFile} 2>&1
    echo "        FirmwireName:${FirmWareType}" >> ${collectConfigFile} 2>&1
    echo "        FirmwireVer :${FirmWareVer}" >> ${collectConfigFile} 2>&1
}
#ȡ̼汾Ϣ
function collectFirmWareInfo()
{
    local collectConfigFile="${CMLogDir}Config/HD_Config.txt"
    local NodeID=$(cat /opt/huawei/snas/etc/cm.ini | grep "^NID=" | awk -F'=' '{print $2}')
    local BmcVer=""
    local NvdimmVer=""
    local IbNum=0
    local IbVer=""
    local RoceNum=0
    local RoceVer=""
    local SesVer=""
    local BiosVer=""
    local CpldVer=""
    local FirmWareNum=0
    local TmpMMLCMDFile="/tmp/Mml_Cmd_file.$$"
    local TmpMMLResultFile="/tmp/Mml_Result_file.$$"
    local result=""
    #FlagΪ1ʾǸ͹̼
    RHFlag=1
    T3000Flag=1
    C72Flag=1

    IsRHNode
    RHFlag=$?

    IsT3000Node
    T3000Flag=$?

    IsC72Node
    C72Flag=$?

    echo "Firmware--------------------------------"         >> ${collectConfigFile} 2>&1
    echo "Number of Firmware:${FirmWareNum}"                >> ${collectConfigFile} 2>&1
    echo "Firmware Info--------------------------------"    >> ${collectConfigFile} 2>&1

    if [ ${RHFlag} -eq 0 ];then
        #ȡNvdimm version
        source /opt/huawei/snas/upd/upd_util/upd_func.sh
        #ȡBMC SES Bios version
        source /opt/huawei/snas/upd/upd_fw/rhfw/snas_rhbmc_fw_upd_utility.sh
        source /opt/huawei/snas/upd/upd_fw/rhfw/ses_utility.sh
        source /opt/huawei/snas/upd/upd_fw/rhfw/snas_rhbmc_fw_upd_utility.sh

        BmcVer=$(GetRHBmcFwVer)
        if [ ! -z "${BmcVer}" ];then
            collectPrintFirmWare "${NodeID}" "BMC" "${BmcVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi

        NvdimmVer=$(GetRHNvdimmFwVer)
        if [ ! -z "${NvdimmVer}" ];then
            collectPrintFirmWare "${NodeID}" "NVDIMM" "${NvdimmVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡIB version
        IbNum=$(GetIbNum)
        if [ ${IbNum} -ne 0 ];then
            for((index=0; index<${IbNum};index++))
            do
                IbVerTmp=$(GetIbFwVer ${index})
                IbVer="${IbVer} ${IbVerTmp}"
            done
        fi
        if [ ! -z "${IbVer}" ];then
            collectPrintFirmWare "${NodeID}" "IB" "${IbVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡRoCE version
        RoceNum=$(GetRoceNum)
        if [ ${RoceNum} -ne 0 ];then
            for((index=0; index<${RoceNum};index++))
            do
                RoceVerTmp=$(GetRoceVer ${index})
                RoceVer="${RoceVer} ${RoceVerTmp}"
            done
        fi
        if [ ! -z "${RoceVer}" ];then
            collectPrintFirmWare "${NodeID}" "ROCE" "${RoceVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi

        SesVer=$(GetsesFwVer)
        if [ ! -z "${SesVer}" ];then
            collectPrintFirmWare "${NodeID}" "SES" "${SesVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi

        BiosVer=$(GetBiosFwVer)
        if [ ! -z "${BiosVer}" ];then
            collectPrintFirmWare "${NodeID}" "BIOS" "${BiosVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡCLDP version
        CpldVer=$(GetCpldFwVer)

        #ڷ V5ӲҪȥ
        echo "${CpldVer}" | grep ')' >/dev/null
        if [ $? -eq 0 ];then
            CpldVer=$(echo "${CpldVer}" | awk -F ")" '{print $2}')
        fi

        if [ ! -z "${CpldVer}" ];then
            collectPrintFirmWare "${NodeID}" "CPLD" "${CpldVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
    elif [ ${T3000Flag} -eq 0 ];then
        #ȡBMC version
        source /opt/huawei/snas/upd/upd_fw/t3000fw/snas_bmc_fw_upd_utility.sh
        BmcVer=$(GetBmcFwVer)
        if [ ! -z "${BmcVer}" ];then
            collectPrintFirmWare "${NodeID}" "BMC" "${BmcVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡNvdimm version
        source /opt/huawei/snas/upd/upd_util/upd_func.sh
        NvdimmVer=$(GetNvdimmFwVer)
        if [ ! -z "${NvdimmVer}" ];then
            collectPrintFirmWare "${NodeID}" "NVDIMM" "${NvdimmVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡIB version
        IbNum=$(GetIbNum)
        if [ ${IbNum} -ne 0 ];then
            for((index=0; index<${IbNum};index++))
            do
                IbVerTmp=$(GetIbFwVer ${index})
                IbVer="${IbVer} ${IbVerTmp}"
            done
        fi
        if [ ! -z "${IbVer}" ];then
            collectPrintFirmWare "${NodeID}" "IB" "${IbVer}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
    elif [ ${C72Flag} -eq 0 ];then
        echo "mpa scsi 6 0" >${TmpMMLCMDFile}
        echo "bsp getbiosversion" >>${TmpMMLCMDFile}
        echo "mpa sas getmgmtversion 800 0" >>${TmpMMLCMDFile}
        echo "mpa sas getcpldversion 800 0" >>${TmpMMLCMDFile}
        echo "sascbb allinfo" >>${TmpMMLCMDFile}
        echo "exit" >>${TmpMMLCMDFile}

        /OSM/script/mml <${TmpMMLCMDFile} >${TmpMMLResultFile}
        dos2unix ${TmpMMLResultFile}
        #ȡBIOS汾
        result=$(cat ${TmpMMLResultFile} | grep "Bios Version is" | awk -F":" '{print $NF}')
        if [ ! -z "${result}" ];then
            collectPrintFirmWare "${NodeID}" "BIOS" "${result}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡSES汾
        result=$(cat ${TmpMMLResultFile} |grep "Mgmt Version" | awk -F":" '{print $NF}')
        if [ ! -z "${result}" ];then
            collectPrintFirmWare "${NodeID}" "SES" "${result}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡCPLD汾
        result=$(cat ${TmpMMLResultFile} |grep "Cpld Version" | awk -F":" '{print $NF}')
        if [ ! -z "${result}" ];then
            collectPrintFirmWare "${NodeID}" "CPLD" "${result}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
        #ȡSAS汾
        result=$(cat ${TmpMMLResultFile} |grep "Current Sal Version" | awk -F":" '{print $NF}')
        if [ ! -z "${result}" ];then
            collectPrintFirmWare "${NodeID}" "SAS" "${result}"
            let "FirmWareNum=${FirmWareNum}+1"
        fi
    else
        log "The firmware type is not in C72 or RH or T3000."
    fi
    #ù̼ע벻Ҫ޸Ľֵ
    sed -i "s/Number of Firmware:0/Number of Firmware:${FirmWareNum}/g" ${collectConfigFile}
    rm -f ${TmpMMLResultFile}
    rm -f ${TmpMMLCMDFile}
}

function redirectContent()
{
    local realConfig="${CMLogDir}Config/Config.txt"
    local collectConfigFile="${CMLogDir}Config/HD_Config.txt"
    echo "" >> ${realConfig}
    log "[$FUNCNAME][$LINENO]start get lock"
    flock -e ${realConfig} -c "cat ${collectConfigFile} >> ${realConfig}"
    log "[$FUNCNAME][$LINENO]end get lock"
    rm -f ${collectConfigFile}
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        log "[$FUNCNAME][$LINENO]start collect Hardware config info"
        collectSSDInfo
        collectFirmWareInfo
        redirectContent
        log "[$FUNCNAME][$LINENO]end collect Hardware config info"
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" == "Xnull" -a "X$end_time" == "Xnull"  -a "X${log_size}" != "X" ];then
            Hardware_collectBySize ${log_size}
        elif [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            Hardware_collectByTime
        fi
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
prepare

main
exit $?