#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

TMP_ISM_BASE_PATH="${CMLogDir}../tmp_DeviceManager_ToolKit"
TMP_ISM_MSG_PATH="${TMP_ISM_BASE_PATH}/Messages"
g_ism_collect_bysize=1
SUBNAME="DeviceManager_ToolKit"
function usage()
{
    echo "$ScriptISMFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_ism_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

function getUtcSecondsFromISMFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    #ǰֻibase
    echo ${sname} | grep ibase.log | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #ibase.log.2019-01-15_01 or ibase.log.2019-01-15_01.tar.gz
        tmp=${sname##*ibase.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #ibase.logûʱ,ǰʱ
            cur_sec=$(get_cfglog_seconds)
            sec=${cur_sec}
        elif [ "${tmp}" == "${cuttail}" ];then
            #ibase.log.2019-01-15_01 
            #tmp: 2019-01-15_01
            sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        else
            #ibase.log.2019-01-15_01.tar.gz
            #cuttail: 2019-01-15_01
            sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep ibase.log | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #ibase.log.2019-01-15_07_1.tar.gz
        tmp=${sname##*ibase.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}

function ismGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/ISM /var/log/backup/DeviceManager_ToolKit /var/log/backup/ISM"
    local lower_version_path="/var/log/snas"
    local in_rec_file=""
    local des_ism_path="${MessageDir}DeviceManager_ToolKit"
    local loc_ism_logs="ibase.log"
    local loc_low_logs="snas.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem ,ǲҪݵͰ汾C01,snas?
        grep "ibase.log.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_ism_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ibase.log from ${rec_file} and redirect to ${out_file} fail"
        return 0
    else
        #δѹļҲʱibase.log.2019-01-15_01,ʱ01¼01-02һСʱ־ (δѹļҪѹĻ,С¼бҪ?)
        ls -l /var/log/ISM/ibase.log* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_ism_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/ISM/ibase.log* >> ${out_file} fail"
        #ѹļ
        for path in ${sub_paths}
        do
            for file in ${loc_ism_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_ism_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        #ݵͰ汾־(ѭʵȥ)
        if [ -d /var/log/backup/ISM ];then
            ls -l /var/log/backup/ISM/ibase.log* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_ism_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/backup/ISM/ibase.log* >> ${out_file} fail"
        fi
        return 0
    fi

}
function ISM_collect()
{
    log [$SUBNAME]"collect DeviceManager_ToolKit , size:${log_size} ,begin_time:${begin_time} ,end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path=${MessageDir}DeviceManager_ToolKit
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
   
    collect_compressed_logs "${collect_sub}" ${size} "${begin_time}" "${end_time}" ismGetLoglist getUtcSecondsFromISMFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} ismGetLoglist getUtcSecondsFromISMFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_ISM_BASE_PATH} ] ;then
        rm -rf ${TMP_ISM_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_ISM_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    
    #
    cd ${sub_path}

    tar cf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ DeviceManager_ToolKit >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
    return 0
}

#ռISMϢ
function collectISMInfo()
{
    return
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        collectISMInfo
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_ism_collect_bysize=0
            log_size="0" 
        fi
        ISM_collect "DeviceManager_ToolKit" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
product_type
prepare

main
exit $?