#!/bin/sh

#ű·
ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

#0ʾֻռϢռ־1ʾռϢռ־
COLLECT_LOG=1
COLLECT_BY_TIME=1
COLLECT_DAYS=14

FIFO_THREAD_NUM_MAX=8
FIFO_OPERATE_ID=760

#ʹfifoܵ, ʵֶ̲
function fifo_start
{
    local tmp_fifofile="/tmp/collect_local_$$.fifo"
    trap "exec ${FIFO_OPERATE_ID}>&-;exec ${FIFO_OPERATE_ID}<&-;exit 0" 2

    mkfifo "${tmp_fifofile}"
    eval "exec ${FIFO_OPERATE_ID}<>${tmp_fifofile}"
    rm -rf "${tmp_fifofile}"

    for ((i=0;i<$FIFO_THREAD_NUM_MAX;i++))
    do
        eval "echo >&${FIFO_OPERATE_ID}"
    done
}

#ɾļ
function fifo_finish
{
    eval "exec ${FIFO_OPERATE_ID}>&-"
    eval "exec ${FIFO_OPERATE_ID}<&-"
}

#жļϵͳǷ
JudgeCAFS()
{
    local CAFSDir="/mnt/fs/system"
    local iNode=""

    if [ -d "${CAFSDir}" ]; then
        iNode=$(stat -c %i ${CAFSDir})
        if [ "${iNode}" = "7168" ]; then
            log "Current CAFS is OK."
            return 0
        else
            log "Current CAFS is damaged."
            return 1
        fi
    else
        log "Current CAFS is damaged."
        return 1
    fi
}

JudgeS3FS()
{
    local S3FSDir="/mnt/s3fs"
    local Mount=""

    if [ -d "${S3FSDir}" ]; then
        cd "${S3FSDir}"
        if [ $? -ne 0 ]; then
            log "[$(date "+%Y-%m-%d %H:%M:%S")] S3FS Mount Check failed: Change directory failed"
            return 1
        fi
        Mount=$(df ${S3FSDir} | tr -d '\n' | awk '{print $NF}')
        if [ $? -ne 0 ]; then
            log "[$(date "+%Y-%m-%d %H:%M:%S")] S3FS Mount Check failed: ${Mount}"
            return 1
        elif [ "${Mount}" == "/" ]; then
            log "[$(date "+%Y-%m-%d %H:%M:%S")] S3FS Mount Check failed: Mount on root"
            rm -rf "log/"
            return 1
        elif [ "${Mount}" != "/mnt/s3fs" ]; then
            log "[$(date "+%Y-%m-%d %H:%M:%S")] S3FS Mount Check failed: ${Mount}"
            return 1
        else
            log "S3FSDir is OK"
            return 0
        fi
    else
        log "[$(date "+%Y-%m-%d %H:%M:%S")] S3FS Mount Check failed: /mnt/s3fs not exists"
        return 1
    fi
}
#ݴ
function DataTar()
{
    #ѹΪҪİ
    local all_file_list=""
    log "start zip..."
    if [ ! -d /var/log/cm/LocalDataCollect/ ];then
        log "/var/log/cm/LocalDataCollect is not exists"
        return
    fi
    cd /var/log/cm/LocalDataCollect/
    #configĿ¼:
    if [ -d /var/log/cm/LocalDataCollect/Config ];then
        log "tar /var/log/cm/LocalDataCollect/Config"
        tar -czf Config.tar.gz Config/*
        rm -rf /var/log/cm/LocalDataCollect/Config
    fi
    #otherĿ¼:
    if [ -d /var/log/cm/LocalDataCollect/Other ];then
        log "tar /var/log/cm/LocalDataCollect/Other"
        tar -czf Other.tar.gz Other/*
        rm -rf /var/log/cm/LocalDataCollect/Other
    fi

    all_file_list=`ls ./`
    mkdir $(hostname)
    for file in ${all_file_list}
    do
        mv -f ${file} $(hostname)/ >/dev/null 2>&1
    done
    DelSensitiveInfo
    #zip -qr $DATA_REMOTE_FileName ./*
    tar -cf $DATA_REMOTE_FileName ./*
    cd /var/
    log "rm $CMLogDir"
    rm -rf $CMLogDir
    log "zip done"
}

###############################################
# main
###############################################

function getBackupPath()
{
    sub=$1
    local type=$(get_node_service_type)
    for i in $(seq 0 $(expr "${#SUB_SYSTEM[@]}" - 1))
    do
        if [ "${SUB_SYSTEM[$i]}" == "${sub}" ];then
            if [ -n "${type}" -a "${type}" != "1"  ];then
                echo "/mnt/s3fs/log/$(hostname)"
            else
                echo "/mnt/fs/system/log/$(hostname)"
            fi
        fi
    done
}

#1.Ѽѹ־ļ
#2.Ѽѹ־ļ
#3.Ѽļϵͳѹ־ļ
function collectSubFileBySize()
{
    sub=$1
    size=$2
    need_size="${size}"
    log "start collect ${sub},size=${size}"
    if [ "${need_size}" -eq 0 ];then
        return 0
    fi

    sub_path=${MessageDir}$(tr 'A-Z' 'a-z' <<< ${sub})
    rm -rf "${sub_path}"
    mkdir -p "${sub_path}"
    backup_path=$(getBackupPath "${sub}")
    log_file=$(getLogFile "${sub}")
    log_path=$(dirname "${log_file}")
    file_name=$(basename "${log_file}")
    split_file_pattern="${file_name}(.\w{1,2}){0,1}$"
    merge_file_pattern="${file_name}\.${TIME_STAMP_PATTERN}$"
    tar_file_pattern="${merge_file_pattern//$/}\.tar\.gz$"

    [ -d "${log_path}" ] && cp -fpr "${log_path}"/*  "${sub_path}"
    cd "${sub_path}"
    need_list=""

    for file in $(ls | egrep "${merge_file_pattern}" | sort -k 3r -t.)
    do
        rm -rf ${file}.tar.gz
        file_size=$(caculateSizeOfFile ${file})

        if [ "${file_size}" -ge "${need_size}" ];then
            ddFile ${file} ${need_size}
            file_size=$(caculateSizeOfFile ${file})
        fi
        need_list="${need_list}|${file}\$"
        let "need_size=need_size-file_size"

        if [ "${need_size}" -le "${MIN_VALUE}" ];then
            break
        fi
    done

    for file in $(ls | egrep "${split_file_pattern}" | sort -n -k 3 -t.)
    do
        if [ "${need_size}" -le "${MIN_VALUE}" ];then
            break
        fi
        file_size=$(caculateSizeOfFile ${file})
        if [ "${file_size}" -ge "${need_size}" ];then
            ddFile ${file} ${need_size}
            file_size=$(caculateSizeOfFile ${file})
        fi
        need_list="${need_list}|${file}\$"
        let "need_size=need_size-file_size"
    done

    for tarFile in $(ls | egrep "${tar_file_pattern}" | egrep -vw "${need_list}" | sort -k 3r -t.)
    do
        if [ "${need_size}" -le "${MIN_VALUE}" ];then
            break
        fi

        tar xzf ${tarFile}
        if [ $? -ne 0 ];then
            rm -rf ${tarFile}
            need_list="${need_list}|${file}\$"
            continue
        fi
        rm -rf ${tarFile}
        file=${tarFile//.tar.gz/}
        file_size=$(caculateSizeOfFile ${file})
        if [ "${file_size}" -ge "${need_size}" ];then
            ddFile ${file} ${need_size}
            file_size=$(caculateSizeOfFile ${file})
        fi
        need_list="${need_list}|${file}\$"
        let "need_size=need_size-file_size"
    done

    if [ -d "${backup_path}"/ -a "${fileSystemFlag}" -eq 0 ];then
        for tarFile in $(ls ${backup_path}/ | egrep "${tar_file_pattern}" | egrep -vw "${need_list}" | sort -k 3r -t.)
        do
            if [ "${need_size}" -le "${MIN_VALUE}" ];then
                break
            fi

            file=${tarFile//.tar.gz/}
            cp -fp "${backup_path}/${tarFile}" "${sub_path}/" && tar xzf ${tarFile}
            if [ $? -ne 0 ];then
                rm -rf ${tarFile}
                need_list="${need_list}|${file}\$"
                continue
            fi
            rm -rf ${tarFile}
            file_size=$(caculateSizeOfFile ${file})
            if [ "${file_size}" -ge "${need_size}" ];then
                ddFile ${file} ${need_size}
                file_size=$(caculateSizeOfFile ${file})
            fi
            need_list="${need_list}|${file}\$"
            let "need_size=need_size-file_size"
        done
    fi

    ls | egrep -vw "${need_list}" | xargs -I{} rm -rf {}
    adjustSize
    let "real_size=size-need_size"
    log "end collect ${sub},real size is ${real_size}"
    return 0
}

function logCheck()
{
    mkdir -p $(dirname ${LOG_FILE})
    touch ${LOG_FILE}
    tail -n5000 ${LOG_FILE} > ${LOG_FILE}.tmp
    mv ${LOG_FILE}.tmp ${LOG_FILE}
}

function argsCheck()
{
    : ${1?"args error"}
    if [ "$1" == "clean" ];then
        clean
        exit 0
    fi

    if [ "$1" == "kill" ];then
        killProc
        exit 0
    fi

    : ${4?"args error"}

    killOldChildproc

    LOCAL_IP=$1
    TIME_START=$2
    TIME_END=$3
    SUB_TYPE=$4

    if [ "$LOCAL_IP"  == "null" ]; then
        log "LOCAL_IP is null"
        exit 1
    fi

    #תΪʱַ
    if [ "${TIME_START}" != "null" ];then
        TIME_START=$(date -d @"${TIME_START}" "+%Y-%m-%d %H:%M:%S")
    fi

    if [ "${TIME_END}" != "null" ];then
        TIME_END=$(date -d @"${TIME_END}" "+%Y-%m-%d %H:%M:%S")
    fi

    log "LOCAL_IP:${LOCAL_IP}"
    log "TIME_START:${TIME_START}"
    log "TIME_END:${TIME_END}"
    log "SUB_TYPE:${SUB_TYPE}"

    #¼ļУűʹ
    addRecToIni 1 "LOCAL_IP=$LOCAL_IP"
    rc=$?
    if [ $rc -ne 0 ];then
        log "ERROR, in $FUNCNAME, addRecToIni 1 LOCAL_IP=$LOCAL_IP fail with $rc"
        return $rc
    fi

    addRecToIni 0 "TIME_START=$TIME_START"
    rc=$?
    if [ $rc -ne 0 ];then
        log "ERROR, in $FUNCNAME, addRecToIni  0 TIME_START=$TIME_START fail with $rc"
        return $rc
    fi
    addRecToIni 0 "TIME_END=$TIME_END"
    rc=$?
    if [ $rc -ne 0 ];then
        log "ERROR, in $FUNCNAME, addRecToIni  0 TIME_END=$TIME_END fail with $rc"
        return $rc
    fi
    addRecToIni 0 "SUB_TYPE=$SUB_TYPE"
    rc=$?
    if [ $rc -ne 0 ];then
        log "ERROR, in $FUNCNAME, addRecToIni  0 SUB_TYPE=$SUB_TYPE fail with $rc"
        return $rc
    fi
    updRecToIni "TOTAL_SIZE=" "TOTAL_SIZE=$TOTAL_SIZE"
    rc=$?
    if [ $rc -ne 0 ];then
        log "ERROR, in $FUNCNAME, updRecToIni   TOTAL_SIZE= TOTAL_SIZE=$TOTAL_SIZE fail with $rc"
        return $rc
    fi

    #ֹʱ䶼Ϊ򰴴Сռ
    if [ "${TIME_START}" == "null" -a "${TIME_END}" == "null" ]; then
        TIME_END=$(getCurrentTime)
        #Ĭȡ7б
        TIME_START=$(getTimeBeforeDays "${TIME_END}" 7)
        COLLECT_BY_TIME=0
    else
        #ʱ䲻ΪգʼʱΪգ򽫿ʼʱΪʱ-14
        if [ "${TIME_START}" == "null" ];then
            TIME_START=$(getTimeBeforeDays "${TIME_END}" ${COLLECT_DAYS})
        fi
        #ʼʱ䲻ΪգʱΪգ򽫽ʱΪʼʱ+14
        if [ "${TIME_END}" == "null" ];then
            TIME_END=$(getTimeAfterDays "${TIME_START}" ${COLLECT_DAYS})
        fi

        if [ "${TIME_START}" != "null" -a "${TIME_END}" != "null" ];then
            #ʱǷռ־
            if [ "$(getSeconds "${TIME_START}")" -gt "$(getSeconds "${TIME_END}")" ];then
                COLLECT_LOG=0
            fi
        fi

        #ռ14־
        if [ "$(diffTime "${TIME_START}" "${TIME_END}")" -gt "${COLLECT_DAYS}" ];then
            TIME_END=$(getTimeAfterDays "${TIME_START}" ${COLLECT_DAYS})
        fi
    fi
}

#===================================================
# ƣȡļ
# ܣȥһ'/'Ĵʡ
# 
#===================================================
get_file_name_dir()
{
    local dirname=$1
    if [ -z "$dirname" ]; then
        echo ""
        return $ERR_PARA_ERROR
    fi

    echo $dirname | awk -F/ '{print $NF}'
}

function collectBySize()
{
    log "collect by size"
    local OM_sub_path="${MessageDir}OM"
    local ISM_sub_path="${MessageDir}DeviceManager_ToolKit"
    local OceanStorOS_sub_path="${MessageDir}OceanStorOS"
    local MON_BJM_sub_path="${MessageDir}MON_BJM"
    local DFS_OBS_sub_path="${MessageDir}DFS_OBS"
    local RPCUser_sub_path="${MessageDir}RPCUser"
    local Hardware_sub_path="${MessageDir}Hardware"
    local OS_sub_path="${MessageDir}OS"
    local OSS_sub_path="${MessageDir}OSS"
    local WorkLoad_sub_path="${MessageDir}WorkLoad"
    local Access_sub_path="${MessageDir}Accesslog"
    local Gaussdb_sub_path="${MessageDir}Gaussdblog"
    local DiskLog_sub_path="${MessageDir}DiskLog"
    local CA_sub_path="${MessageDir}snas_CA"
    local DiskFaultInfo_sub_path="${MessageDir}DiskFaultInfo"
    local Procc_Num=0
    local DataCollectFile="datacollect_$$"
    adjustSize
    mkdir -p /var/log/tmp_collect
    #ִ̨ӲϢռ
	{
    echo "${SUB_TYPE}" | grep "Hardware"
    if [ $? -eq 0 ];then
        rm -rf "${Hardware_sub_path}"
        mkdir -p "${Hardware_sub_path}"
        sub_size=$(getSize "Hardware" ${TOTAL_SIZE})
        local Command="${ScriptDir}/${ScriptHardwareFname} \"log\" \"9000\" \"V300R006C00\" \"/var/log/tmp_collect/Hardware.tar.gz\" \"null\" \"null\" ${sub_size}"
        execWithTimeout "${Command}" 1800 5 2>/dev/null
        if [ $? -eq 125 ];then
            echo "collect Hardware log time out" >${Hardware_sub_path}/CollectHardware.log
        else
            mv /var/log/tmp_collect/Hardware.tar.gz ${Hardware_sub_path}
        fi
    fi
    echo "Hardware sucess" >/tmp/${DataCollectFile}
	}&

    ##ռģ־
    fifo_start
    for sub in ${SUB_SYSTEM[@]}
    do
        echo ${SUB_TYPE} | grep -w ${sub}
        if [ $? -ne 0 ];then
            continue
        fi

        if [ "${sub}" == "Hardware" ]; then
            #Ӳռִ̨
            echo "collect Hardware"
            continue
        fi

        read -u ${FIFO_OPERATE_ID}
        {
            sub_size=$(getSize ${sub} ${TOTAL_SIZE})
            if [ "${sub}" == "OM" ]; then
                ${ScriptDir}/${ScriptOMFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OM.tar.gz" "null" "null" ${sub_size}
                rm -rf "${OM_sub_path}"
                mkdir -p "${OM_sub_path}"
                mv /var/log/tmp_collect/OM.tar.gz ${OM_sub_path}
            elif [ "${sub}" == "DeviceManager_ToolKit" ]; then
                ${ScriptDir}/${ScriptISMFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/ISM.tar.gz" "null" "null" ${sub_size}
                rm -rf "${ISM_sub_path}"
                mkdir -p "${ISM_sub_path}"
                mv /var/log/tmp_collect/ISM.tar.gz ${ISM_sub_path}
            elif [ "${sub}" == "OceanStorOS" ]; then
                ${ScriptDir}/${ScriptOceanStorOSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OceanStorOS.tar.gz" "null" "null" ${sub_size}
                rm -rf "${OceanStorOS_sub_path}"
                mkdir -p "${OceanStorOS_sub_path}"
                mv /var/log/tmp_collect/OceanStorOS.tar.gz ${OceanStorOS_sub_path}
            elif [ "${sub}" == "MON_BJM" ]; then
                ${ScriptDir}/${ScriptMONandBJMFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/MON_BJM.tar.gz" "null" "null" ${sub_size}
                rm -rf "${MON_BJM_sub_path}"
                mkdir -p "${MON_BJM_sub_path}"
                mv /var/log/tmp_collect/MON_BJM.tar.gz ${MON_BJM_sub_path}
            elif [ "${sub}" == "DFS_OBS" ]; then
                ${ScriptDir}/${ScriptDFSandOBSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/DFS_OBS.tar.gz" "null" "null" ${sub_size}
                rm -rf "${DFS_OBS_sub_path}"
                mkdir -p "${DFS_OBS_sub_path}"
                mv /var/log/tmp_collect/DFS_OBS.tar.gz ${DFS_OBS_sub_path}
            elif [ "${sub}" == "RPCUser" ]; then
                ${ScriptDir}/${ScriptRPCUserFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/RPCUser.tar.gz" "null" "null" ${sub_size}
                rm -rf "${RPCUser_sub_path}"
                mkdir -p "${RPCUser_sub_path}"
                mv /var/log/tmp_collect/RPCUser.tar.gz ${RPCUser_sub_path}
            elif [ "${sub}" == "OS" ]; then
                ${ScriptDir}/${ScriptOSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OS.tar.gz" "null" "null" ${sub_size}
                rm -rf "${OS_sub_path}"
                mkdir -p "${OS_sub_path}"
                mv /var/log/tmp_collect/OS.tar.gz ${OS_sub_path}
            elif [ "${sub}" == "OSS" ]; then
                ${ScriptDir}/${ScriptOSSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OSS.tar.gz" "null" "null" ${sub_size}
                rm -rf "${OSS_sub_path}"
                mkdir -p "${OSS_sub_path}"
                mv /var/log/tmp_collect/OSS.tar.gz ${OSS_sub_path}
            elif [ "${sub}" == "WorkLoad" ]; then
                ${ScriptDir}/${ScriptWorkLoadFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/WorkLoad.tar.gz" "null" "null" ${sub_size}
                rm -rf "${WorkLoad_sub_path}"
                mkdir -p "${WorkLoad_sub_path}"
                mv /var/log/tmp_collect/WorkLoad.tar.gz ${WorkLoad_sub_path}
            elif [ "${sub}" == "Accesslog" ];then
                ${ScriptDir}/${ScriptAccessFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/Accesslog.tar.gz" "null" "null" ${sub_size}
                rm -rf "${Access_sub_path}"
                mkdir -p "${Access_sub_path}"
                mv /var/log/tmp_collect/Accesslog.tar.gz ${Access_sub_path}
            elif [ "${sub}" == "Gaussdblog" ];then
                ${ScriptDir}/${ScriptGaussdbFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/Gaussdblog.tar.gz" "null" "null" ${sub_size}
                rm -rf "${Gaussdb_sub_path}"
                mkdir -p "${Gaussdb_sub_path}"
                mv /var/log/tmp_collect/Gaussdblog.tar.gz ${Gaussdb_sub_path}
            elif [ "${sub}" == "DiskInfo" ];then
                ${ScriptDir}/${ScriptDiskFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/Diskinfo.tar.gz"
                mv /var/log/tmp_collect/Diskinfo.tar.gz /var/log/cm/
            elif [ "${sub}" == "DiskLog" ];then
                ${ScriptDir}/${ScriptDiskLogFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/DiskLog.tar.gz"
                rm -rf ${DiskLog_sub_path}
                mkdir -p ${DiskLog_sub_path}
                mv /var/log/tmp_collect/DiskLog.tar.gz ${DiskLog_sub_path}
            elif [ "${sub}" == "snas_CA" ]; then
                ${ScriptDir}/${ScriptCAFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/snas_CA.tar.gz" "null" "null" ${sub_size}
                rm -rf "${CA_sub_path}"
                mkdir -p "${CA_sub_path}"
                mv /var/log/tmp_collect/snas_CA.tar.gz ${CA_sub_path}
            elif [ "${sub}" == "DiskFaultInfo" ];then
                ${ScriptDir}/${ScriptDiskFaultInfoFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/DiskFaultInfo.tar.gz" "null" "null"
                rm -rf ${DiskFaultInfo_sub_path}
                mkdir -p ${DiskFaultInfo_sub_path}
                mv /var/log/tmp_collect/DiskFaultInfo.tar.gz ${DiskFaultInfo_sub_path}
            else
                collectSubFileBySize ${sub} ${sub_size}
            fi
            echo >& ${FIFO_OPERATE_ID}
        } &
    done

    wait
    fifo_finish

    #жϺӲռǷ,5һ
    while [ 1 ]
    do
        Procc_Num=`cat /tmp/${DataCollectFile} 2>/dev/null | grep "Hardware" | wc -l`
        if [ ${Procc_Num} -ne 0 ]; then
            break
	    fi
        sleep 5
	done
    log "end collect by size"
    rm -rf /var/log/tmp_collect
    rm -rf /tmp/${DataCollectFile}
    return 0
}

function collectByTime()
{
    log "collect by time"
    local OM_sub_path="${MessageDir}OM"
    local ISM_sub_path="${MessageDir}DeviceManager_ToolKit"
    local OceanStorOS_sub_path="${MessageDir}OceanStorOS"
    local MON_BJM_sub_path="${MessageDir}MON_BJM"
    local DFS_OBS_sub_path="${MessageDir}DFS_OBS"
    local RPCUser_sub_path="${MessageDir}RPCUser"
    local Hardware_sub_path="${MessageDir}Hardware"
    local OS_sub_path="${MessageDir}OS"
    local OSS_sub_path="${MessageDir}OSS"
    local WorkLoad_sub_path="${MessageDir}WorkLoad"
    local Access_sub_path="${MessageDir}Accesslog"
    local Gaussdb_sub_path="${MessageDir}Gaussdblog"
    local DiskLog_sub_path="${MessageDir}DiskLog"
    local CA_sub_path="${MessageDir}snas_CA"
    local DiskFaultInfo_sub_path="${MessageDir}DiskFaultInfo"
    local Procc_Num=0
    local DataCollectFile="datacollect_$$"
    adjustSize
    mkdir -p /var/log/tmp_collect
    #ִ̨ӲϢռ
	{
    echo "${SUB_TYPE}" | grep "Hardware"
    if [ $? -eq 0 ];then
        rm -rf "${Hardware_sub_path}"
        mkdir -p "${Hardware_sub_path}"
        local Command="${ScriptDir}/${ScriptHardwareFname} \"log\" \"9000\" \"V300R006C00\" \"/var/log/tmp_collect/Hardware.tar.gz\" \"${TIME_START}\" \"${TIME_END}\""
        execWithTimeout "${Command}" 1800 5 2>/dev/null
        if [ $? -eq 125 ];then
            echo "collect Hardware log time out" >${Hardware_sub_path}/CollectHardware.log
        else
            mv /var/log/tmp_collect/Hardware.tar.gz ${Hardware_sub_path}
        fi
    fi
    echo "Hardware sucess" >/tmp/${DataCollectFile}
	}&
	
    ##ռģ־
    fifo_start
    for sub in ${SUB_SYSTEM[@]}
    do
        echo ${SUB_TYPE} | grep -w ${sub}
        if [ $? -ne 0 ];then
            continue
        fi
        if [ "${sub}" == "Hardware" ]; then
            #Ӳռִ̨
            echo "collect Hardware"
            continue
        fi

        read -u ${FIFO_OPERATE_ID}
        {
            if [ "${sub}" == "OM" ]; then
                rm -rf "${OM_sub_path}"
                mkdir -p "${OM_sub_path}"
                ${ScriptDir}/${ScriptOMFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OM.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/OM.tar.gz ${OM_sub_path}
            elif [ "${sub}" == "DeviceManager_ToolKit" ]; then
                ${ScriptDir}/${ScriptISMFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/ISM.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/ISM.tar.gz ${ISM_sub_path}
            elif [ "${sub}" == "OceanStorOS" ]; then
                ${ScriptDir}/${ScriptOceanStorOSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OceanStorOS.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/OceanStorOS.tar.gz ${OceanStorOS_sub_path}
            elif [ "${sub}" == "MON_BJM" ]; then
                ${ScriptDir}/${ScriptMONandBJMFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/MON_BJM.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/MON_BJM.tar.gz ${MON_BJM_sub_path}
            elif [ "${sub}" == "DFS_OBS" ]; then
                ${ScriptDir}/${ScriptDFSandOBSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/DFS_OBS.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/DFS_OBS.tar.gz ${DFS_OBS_sub_path}
            elif [ "${sub}" == "RPCUser" ]; then
                ${ScriptDir}/${ScriptRPCUserFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/RPCUser.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/RPCUser.tar.gz ${RPCUser_sub_path}
            elif [ "${sub}" == "Hardware" ]; then
                #Ӳռִ̨
                echo "collect Hardware"
            elif [ "${sub}" == "OS" ]; then
                ${ScriptDir}/${ScriptOSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OS.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/OS.tar.gz ${OS_sub_path}
            elif [ "${sub}" == "OSS" ]; then
                ${ScriptDir}/${ScriptOSSFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/OSS.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/OSS.tar.gz ${OSS_sub_path}
            elif [ "${sub}" == "WorkLoad" ]; then
                ${ScriptDir}/${ScriptWorkLoadFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/WorkLoad.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/WorkLoad.tar.gz ${WorkLoad_sub_path}
            elif [ "${sub}" == "Accesslog" ];then
                ${ScriptDir}/${ScriptAccessFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/Accesslog.tar.gz" "${TIME_START}" "${TIME_END}"
                rm -rf "${Access_sub_path}"
                mkdir -p "${Access_sub_path}"
                mv /var/log/tmp_collect/Accesslog.tar.gz ${Access_sub_path}
            elif [ "${sub}" == "Gaussdblog" ];then
                ${ScriptDir}/${ScriptGaussdbFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/Gaussdblog.tar.gz" "${TIME_START}" "${TIME_END}"
                rm -rf "${Gaussdb_sub_path}"
                mkdir -p "${Gaussdb_sub_path}"
                mv /var/log/tmp_collect/Gaussdblog.tar.gz ${Gaussdb_sub_path}
            elif [ "${sub}" == "DiskInfo" ];then
                ${ScriptDir}/${ScriptDiskFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/Diskinfo.tar.gz"
                mv /var/log/tmp_collect/Diskinfo.tar.gz /var/log/cm/
            elif [ "${sub}" == "DiskLog" ];then
                ${ScriptDir}/${ScriptDiskLogFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/DiskLog.tar.gz"
                rm -rf ${DiskLog_sub_path}
                mkdir -p ${DiskLog_sub_path}
                mv /var/log/tmp_collect/DiskLog.tar.gz ${DiskLog_sub_path}
            elif [ "${sub}" == "snas_CA" ]; then
                ${ScriptDir}/${ScriptCAFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/snas_CA.tar.gz" "${TIME_START}" "${TIME_END}"
                mv /var/log/tmp_collect/snas_CA.tar.gz ${CA_sub_path}
            elif [ "${sub}" == "DiskFaultInfo" ];then
                ${ScriptDir}/${ScriptDiskFaultInfoFname} "log" "9000" "V300R006C00" "/var/log/tmp_collect/DiskFaultInfo.tar.gz" "${TIME_START}" "${TIME_END}" 
                rm -rf ${DiskFaultInfo_sub_path}
                mkdir -p ${DiskFaultInfo_sub_path}
                mv /var/log/tmp_collect/DiskFaultInfo.tar.gz ${DiskFaultInfo_sub_path}
            else
                collectSubFileBySize ${sub} ${sub_size}
            fi
	    echo >& ${FIFO_OPERATE_ID}
        } &
    done
    
    wait
    fifo_finish
    
    #жϺӲռǷ,5һ
    while [ 1 ]
    do
        Procc_Num=`cat /tmp/${DataCollectFile} 2>/dev/null | grep "Hardware" | wc -l`
        if [ ${Procc_Num} -ne 0 ]; then
            break
	    fi
        sleep 5
	done
    log "end collect by time"
    rm -rf /var/log/tmp_collect
    rm -rf /tmp/${DataCollectFile}
    return 0
}

#ռģĻϢ
function collectConfig()
{
    local tmpModule=""
    local scriptName=""
    local ConfigList=(
    'OM|${ScriptDir}/${ScriptOMFname} "config"'
    'OS|${ScriptDir}/${ScriptOSFname} "config"'
    'Hardware|${ScriptDir}/${ScriptHardwareFname} "config"'
    'RPCUser|${ScriptDir}/${ScriptRPCUserFname} "config"'
    'DFS_OBS|${ScriptDir}/${ScriptDFSandOBSFname} "config"'
    'MON_BJM|${ScriptDir}/${ScriptMONandBJMFname} "config"'
    'OceanStorOS|${ScriptDir}/${ScriptOceanStorOSFname} "config"'
    'DeviceManager_ToolKit|${ScriptDir}/${ScriptISMFname} "config"'
    'OSS|${ScriptDir}/${ScriptOSSFname} "config"'
    'WorkLoad|${ScriptDir}/${ScriptWorkLoadFname} "config"'
    'snas_CA|${ScriptDir}/${ScriptCAFname} "config"'
    )

    log "[$FUNCNAME][$LINENO]start collect subsystem config"
    set_ifs
    for item in ${ConfigList[@]};do
        tmpModule=$(echo "${item}" | awk -F'|' '{print $1}')
        scriptName=$(echo "${item}" | awk -F'|' '{print $2}')
        echo ${SUB_TYPE} | grep -w ${tmpModule}
        if [ $? -ne 0 ];then
            log "[$FUNCNAME][$LINENO]start collect subsystem config:skip module ${tmpModule}"
            continue
        fi

       {
            eval "${scriptName}"
       } &
    done
    log "[$FUNCNAME][$LINENO]wait process subsystem config"
    wait
    restore_ifs
    log "[$FUNCNAME][$LINENO]end collect subsystem config"
}

function collect()
{
    local rc=0
    local cfgPid=""
    rm -rf "$CMLogDir"
    rm -rf $DATA_REMOTE_FileName
    rm -rf "/tmp/collect_local_*.fifo"
    #жϲƷ
    judge_product_type
    CreateCollectDir

    #жļϵͳǷ
    local node_type=$(get_node_service_type)
    log "node_type is : ${node_type}"
    if [ -n "${node_type}" -a "${node_type}" != "1"  ];then
        JudgeS3FS
        fileSystemFlag=$?
        log "After call JudgeS3FS fileSystemFlag: ${fileSystemFlag}"
    else
        JudgeCAFS
        fileSystemFlag=$?
        log "After call JudgeCAFS fileSystemFlag: ${fileSystemFlag}"
    fi
    updRecToIni "FS_FLAG=" "FS_FLAG=$fileSystemFlag"
    if [ 0 -eq ${fileSystemFlag} ];then
        if [ ! -d ${TMP_PATH_NEWWAY} ];then
            mkdir -p ${TMP_PATH_NEWWAY} 2>>/dev/null
        fi
        #ls -l ${BACKUP_DIR}/ > ${LOG_INFO} 2>>/dev/null
        #ȡļϵͳļб
        starttime=$(getTimeStamp "${TIME_START}")
        endtime=$(getTimeStamp "${TIME_END}")
        ${S3LogDealFile} --option=batchlistdetail --nodeName="$(hostname)" --startTime=${starttime} --endTime=${endtime} | sort -k2 > ${LOG_INFO} 2>>/dev/null
        rc=$?
        if [ ${rc} -ne 0 ];then
            log [$FUNCNAME][$LINENO]"ERROR: ${S3LogDealFile} --option=batchlistdetail --nodeName=$(hostname) --startTime=${starttime} --endTime=${endtime} | sort -k2 > ${LOG_INFO} fail with ${rc}"
            rm ${LOG_INFO}
        fi
        log [$FUNCNAME][$LINENO]"INFO: ${S3LogDealFile} --option=batchlistdetail --nodeName=$(hostname) --startTime=${starttime} --endTime=${endtime} | sort -k2 > ${LOG_INFO} fail with ${rc}"
    elif [ -f ${LOG_INFO} ];then
        rm ${LOG_INFO}
    fi
    
    #ռϵͳϢ
    collectConfig &
    cfgPid=$!
    if [ "${COLLECT_LOG}" -eq 1 ];then
        if [ "${COLLECT_BY_TIME}" -eq 0 ];then
            collectBySize
        else
            collectByTime
        fi
    else
        log "donnot collect log"
    fi

    #ȴк̨ļռ
    wait ${cfgPid}
    
    if [ -f ${LOG_INFO} ];then
        rm ${LOG_INFO}
    fi
    
    #ɾмļ¼
    rm -rf ${TMP_PATH_NEWWAY} >/dev/null 2>&1 
    DataTar    
    return 0
}

##############################MAIN#######################

logCheck
argsCheck "${@:1}"
collect