#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect.sh
# Description: Ѳ칤.
# Input:
# Output:
# Author:
# Created:
# Function:
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #
IP_ROLE_FILE="/tmp/tmp_ip_role"
NID_ROLE_FILE="/tmp/tmp_nid_role"
RepeatTimes=(1 2 3)
LOG_FILE="/var/log/inspect.log"
Valid_IP_FILE="/tmp/tmp_value_ip$!"
TMP_G_SCRIPT_PATH=$1 
CHECK_ID=$3
G_SCRIPT_PATH=$(dirname "$0")
version=$(cat /opt/huawei/deploy/package/version |grep "ProductVersion"|awk -F= '{print $2}')
function LOG
{
    echo [`date`][$$][$!]$@ >> $LOG_FILE
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#нڵĺIP
function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    local count=1

    > $IP_ROLE_FILE
    > $NID_ROLE_FILE
    #ݿȡнڵĺIP
    LOG "[$FUNCNAME]start get all nid from cm_conf.db"
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    while [[ "${JavaId}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get all nid from db ,count=$count"
        JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
        count=$((count + 1))
        if [ $count -gt 5 ];then
            break
        fi
    done
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`

        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        if [ "$localNID" == "$lastNID" ];then 
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))
            continue
        fi

        #pingһ¼Ƿͨ
        for time in ${RepeatTimes[*]};do
            tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done

        #
        numCnt=$((numCnt+1))
        lastNID=$localNID

        if [ "$tempStr_ping" -le 0 ];then

            LOG "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"

            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`

            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                for time in ${RepeatTimes[*]};do
                    tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                    local iRet=$?
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done

                LOG "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"

                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    LOG "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi

        #жϽڵǷúͶ
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then
            Status_values=`echo $Status_info | awk -F= '{print $2}'`
            Status_value=`echo $Status_values | awk '{print $1}'`
            if [ "$Status_value" == "0" ];then
                echo -n "$ItemIp " >> $IP_ROLE_FILE
                echo -n "$localNID " >> $NID_ROLE_FILE
                LOG "[$FUNCNAME]add $ItemIp,$localNID"
            fi
        fi

    done
    >${TMP_G_SCRIPT_PATH}/test
}

#/opt/inspect/
function UpdInspect()
{
    ValidIP=`cat ${IP_ROLE_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${Valid_IP_FILE}

        LOG "[$FUNCNAME][$LINENO]:begin to upload file. "
        for Item in $ValidIP
        do  
            /opt/huawei/deploy/script/localexec.py upload $Item /tmp/tmpfileupd/snas-inspect_$version.tar.gz /var/log/snas-inspect_$version.tar.gz
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]$Item :update inspect failed!"
                echo "failed "
            fi
            /opt/huawei/deploy/script/localexec.py async $Item 0 120 true "tar -zvxf /var/log/snas-inspect_$version.tar.gz -C /opt/inspect;chmod 550 /opt/inspect/inspect*;chown root:root /opt/inspect/inspect*"
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]$Item :tar inspect failed!"
            fi
        done
        ValidIP=`cat ${Valid_IP_FILE}`
    done 
}

#/opt/huawei/snas/script/inspect_mml/
function UpdInspect_mml()
{
    ValidIP=`cat ${IP_ROLE_FILE}`

    while [ "${ValidIP}" != "" ]; do
        >${Valid_IP_FILE}

        for Item in $ValidIP
        do
            /opt/huawei/deploy/script/localexec.py upload $Item /tmp/tmpfileupd/snas-inspect_mml_$version.tar.gz /var/log/snas-inspect_mml_$version.tar.gz
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]$Item :update inspect failed!"
            fi
            /opt/huawei/deploy/script/localexec.py async $Item 0 120 true "tar -vzxf /var/log/snas-inspect_mml_$version.tar.gz -C /opt/huawei/snas/script/inspect_mml;chmod 550 /opt/huawei/snas/script/inspect_mml/*"
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]$Item :tar inspect_mml failed!"
            fi
        done
        ValidIP=`cat ${Valid_IP_FILE}`
    done
    
}

#Ѳ
function Inspect_Update()
{
    local version=$(cat /opt/huawei/deploy/package/version |grep "ProductVersion"|awk -F= '{print $2}')
    if [ ! -f ${TMP_G_SCRIPT_PATH}/test ];then
        GetIPAndRoleFromDB
        if [ -f ${TMP_G_SCRIPT_PATH}/snas-inspect_$version.tar.gz ];then 
            if [ ! -d /tmp/tmpfileupd ];then
                mkdir /tmp/tmpfileupd
            fi
            cp ${TMP_G_SCRIPT_PATH}/snas-inspect_$version.tar.gz /tmp/tmpfileupd/snas-inspect_$version.tar.gz
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]upload inspect failed" 
            fi 
        
            UpdInspect
        fi


        if [ -f ${TMP_G_SCRIPT_PATH}/snas-inspect_mml_$version.tar.gz ];then
            if [ ! -d /tmp/tmpfileupd ];then
                mkdir /tmp/tmpfileupd 
            fi
            cp ${TMP_G_SCRIPT_PATH}/snas-inspect_mml_$version.tar.gz /tmp/tmpfileupd/snas-inspect_mml_$version.tar.gz
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]upload inspect_mml failed"
            fi
            UpdInspect_mml 
        
        fi
        rm -rf /tmp/tmpfileupd
    fi
}
function main()
{
    if [ -f ${TMP_G_SCRIPT_PATH}/svn_${version}.txt ];then
        toolsvn=`cat ${TMP_G_SCRIPT_PATH}/svn_${version}.txt |grep "svn="|awk -F= '{print int($2)}'`
    else
        toolsvn=0
    fi
    if [ -f ${G_SCRIPT_PATH}/svn_${version}.txt ];then
        prodsvn=`cat ${G_SCRIPT_PATH}/svn_${version}.txt |grep "svn="|awk -F= '{print int($2)}'`
    else
        prodsvn=0
    fi
    if [ $toolsvn -ge $prodsvn ];then
        Inspect_Update  
    fi
}
#preinspect.pyãÿѲ쿪ʼǰһΣɺIPбļ
if [ "$TMP_G_SCRIPT_PATH" == "ipcfg" ];then
    #ϴѲļ
    rm -f /opt/inspect/check_id_file*
    rm -f /tmp/check_result_file*
    rm -f /tmp/check_thread_file*
    rm -f /tmp/check_thread_count*
    GetIPAndRoleFromDB
    exit 0
fi
main
/opt/inspect/inspect_entrystart_${version}.sh $TMP_G_SCRIPT_PATH -c $CHECK_ID 



