#!/bin/bash
set +x

# 环境信息
CA_MAP=$(cat /proc/monc_camap | grep -a -E '^CA')
NODE_MAP=$(cat /proc/monc_nodemap | grep -a 'Node: NodeID')
LOCAL_IP=$(cat /proc/monc_nodemap | grep -a NodeId | sed 's/,/ /g' | awk '{print $11}')

# ip数组
REMOTE_IP=$(echo "${CA_MAP}" | cut -d ' ' -f 4 | grep -a -v ${LOCAL_IP} | tr '\n' ' ')
ALL_IP=$(echo "${CA_MAP}" | cut -d ' ' -f 4 | tr '\n' ' ')

# 文件
BASE_PATH="/var/log/update_SN/"
LOG_FILE="${BASE_PATH}UpdateSN.log"
SCRIPT_USER_ACT="${BASE_PATH}ChangeCmd"
SCRIPT_TO_INVOKE="${BASE_PATH}CheckItems"
REMOTE_MASTER_DB="${BASE_PATH}RemoteMasterDb"
REMOTE_SLAVE_DB="${BASE_PATH}RemoteSlaveDb"

upd_master_ip=""
upd_slave_ip=""
iRet=0

# 日志打印
function LOG
{
   local time=$(date)
   echo [${time}][$$]$@ >> ${LOG_FILE}
}
# result值
# 0 success
# -1 get_upd_identity
# -2 upd_database_check
# -3 uploadFile
# -4 remoteChmod
# -5 update_date_db

#*********************获取信息*********************#
# 获取upd master和upd slave的ip
function get_upd_identity()
{
    local mml_output=$(/usr/local/bin/MmlBatch 4040 "upd master" | tr '\r' '\n')
    iRet=$?
    if [[ ${iRet} -ne 0 ]]; then
        LOG "[$FUNCNAME][$LINENO] failed when executing mml command (MmlBatch 4040 'upd master')"
        return 1
    fi
    upd_master_ip=$(echo "$mml_output" | grep "master:" | awk '{print $2}')
    if [[ ! ${upd_master_ip} =~ ^[1-9][0-9]*\.[0-9]+\.[0-9]+\.[1-9][0-9]*$ ]]; then
        LOG "[$FUNCNAME][$LINENO] got wrong upd master ip(${upd_master_ip})"
        return 1
    fi
    upd_slave_ip=$(echo "$mml_output" | grep "Slave:" | awk '{print $2}')
    if [[ ! ${upd_slave_ip} =~ ^[1-9][0-9]*\.[0-9]+\.[0-9]+\.[1-9][0-9]*$ ]]; then
        LOG "[$FUNCNAME][$LINENO] got wrong upd slave ip(${upd_master_ip})"
        return 1
    fi
    LOG "[$FUNCNAME][$LINENO] ${upd_master_ip} is upd master."
    LOG "[$FUNCNAME][$LINENO] ${upd_slave_ip} is upd slave."
    return 0
}

# 获取master和slave节点数据库信息到本节点
function upd_database_check()
{
    /opt/huawei/deploy/script/localexec.py cmd ${upd_master_ip} 10 false "sqlite3 /opt/huawei/snas/upd/cm_upd.db 'select strSerial FROM UPD_STATUS_T'" > ${REMOTE_MASTER_DB} 2>&1
    iRet=$?
    if [[ ${iRet} -ne 0 ]]; then
        LOG "[$FUNCNAME][$LINENO] get cm_upd.db from upd master node failed."
        return 2
    else
        LOG "[$FUNCNAME][$LINENO] get cm_upd.db from upd master node succeed."
    fi
    /opt/huawei/deploy/script/localexec.py cmd ${upd_slave_ip} 10 false "sqlite3 /opt/huawei/snas/upd/cm_upd.db 'select strSerial FROM UPD_STATUS_T'" > ${REMOTE_SLAVE_DB} 2>&1
    iRet=$?
    if [[ ${iRet} -ne 0 ]]; then
        LOG "[$FUNCNAME][$LINENO] get cm_upd.db from upd slave node failed."
        return 2
    else
        LOG "[$FUNCNAME][$LINENO] get cm_upd.db from upd slave node succeed."
    fi
    return 0;
}

#*********************更新方法*********************#
#上传文件到指定路径
function uploadFile()
{
    local upload_file=$1
    local dst_file=$2
    local remote_ip=$3
    /opt/huawei/deploy/script/localexec.py upload ${remote_ip} "${upload_file}" "${dst_file}"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME][$LINENO] Upload file ${upload_file} to ${remote_ip} failed, result:${iRet}."
        return 3
    else
        LOG "[$FUNCNAME][$LINENO] Upload file ${upload_file} to ${remote_ip} succeed."
    fi
    return 0
}

#远端对脚本文件赋予执行权限
function remoteChmod()
{
    local chmod_file=$1
    local remote_ip=$2
    local rmtCmd="chmod 770 ${chmod_file}"
    /opt/huawei/deploy/script/localexec.py cmd ${remote_ip} 60 false "${rmtCmd}"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME][$LINENO] chmod file ${chmod_file} on ${remote_ip} failed, result:${iRet}."
        return 4
    else
        LOG "[$FUNCNAME][$LINENO] chmod file ${chmod_file} on ${remote_ip} succeed."
    fi  
    return 0
}

#上传脚本文件并赋予执行权限
function uploadScript()
{
    local remote_ip=$1
    uploadFile "${SCRIPT_USER_ACT}" "${SCRIPT_TO_INVOKE}" "${remote_ip}"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        return 3
    fi
    remoteChmod "${SCRIPT_TO_INVOKE}" "${remote_ip}"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        return 4
    fi
    return 0
}

#*********************判断修正*********************#
# 修正upd数据库
function update_date_db()
{
    local rip=$1
    local cip=$2
    local tmp_loacl_NID=$(/opt/huawei/deploy/script/localexec.py cmd ${rip} 10 false "grep NID /opt/huawei/snas/etc/cm.ini" | awk -F = '{print $2}')
    echo "sqlite3 /opt/huawei/snas/upd/cm_upd.db \"update UPD_STATUS_T set strSerial='"${tmp_local_SN}"' where NodeNID=${tmp_loacl_NID}\"" > ${SCRIPT_USER_ACT} 2>&1
    echo 'sleep 2s' >> ${SCRIPT_USER_ACT} 2>&1
    echo '/opt/huawei/deploy/bin/daemon -s /opt/huawei/snas/upd/updservice; /opt/huawei/deploy/bin/daemon /opt/huawei/snas/upd/updservice' >> ${SCRIPT_USER_ACT} 2>&1
    uploadScript "${cip}"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        return ${iRet}
    fi
    /opt/huawei/deploy/script/localexec.py cmd ${cip} 10 false "${SCRIPT_TO_INVOKE}"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME][$LINENO] update cm_upd.db on ${remote_ip} failed, result:${iRet}."
        return 5
    fi
    LOG "[$FUNCNAME][$LINENO] update finish on ${cip}."
    return 0
}

# 逐个节点判断是否需要更新并修正
function if_need_update()
{
    local sum=0
    for ip in ${ALL_IP}
    do
        tmp_local_SN=$(/opt/huawei/deploy/script/localexec.py cmd $ip 10 false "/bin/ipmitool fru | grep 'Product Serial'" | awk '{print $4}')
        if ! grep -q "${tmp_local_SN}" "${REMOTE_MASTER_DB}"; then
            LOG "[$FUNCNAME][$LINENO] ${ip} need update on master."
            LOG "[$FUNCNAME][$LINENO] update start on ${upd_master_ip}."
            update_date_db ${ip} ${upd_master_ip}
            iRet=$?
            if [ $iRet -ne 0 ]; then
                return ${iRet}
            fi
        fi
        if ! grep -q "${tmp_local_SN}" "${REMOTE_SLAVE_DB}"; then
            LOG "[$FUNCNAME][$LINENO] ${ip} need update on slave."
            LOG "[$FUNCNAME][$LINENO] update start on ${upd_slave_ip}."
            update_date_db ${ip} ${upd_slave_ip}
            if [ $iRet -ne 0 ]; then
                return ${iRet}
            fi
        fi
    done
    return 0
}

#*********************main*********************#
function main()
{
    LOG "[$FUNCNAME][$LINENO] UpdateSN.sh starts."
    get_upd_identity
    iRet=$?
    if [ $iRet -ne 0 ]; then
        echo "error: -${iRet}"
        LOG "[$FUNCNAME][$LINENO] UpdateSN.sh end in abnormal."
        return
    fi
    upd_database_check
    iRet=$?
    if [ $iRet -ne 0 ]; then
        echo "error: -${iRet}"
        LOG "[$FUNCNAME][$LINENO] UpdateSN.sh end in abnormal."
        return
    fi
    if_need_update
    iRet=$?
    if [ $iRet -ne 0 ]; then
        echo "error: -${iRet}"
        LOG "[$FUNCNAME][$LINENO] UpdateSN.sh end in abnormal."
        return
    fi
    echo "finished."
    LOG "[$FUNCNAME][$LINENO] UpdateSN.sh end in normal."
}

main

exit 0
