#!/bin/bash
set +x
source $(dirname "$0")/inspect_map.sh 2>/dev/null
CONFIG_SYS_FILE="/var/log/Config_system.txt"
DEVICE_SYS_FILE="/var/log/Device_system.txt"
JSON_FILE="/var/log/config_collection.json"
G_MML_PATH="/opt/huawei/snas/script/inspect_mml"
source $G_MML_PATH/CommonFunc.sh
G_TMP_FILE="/tmp/sys_info"
LOG_FILE="/var/log/inspect.log"
collllect_tmp="/tmp/Config_"
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
RepeatTimes=(1 2 3)
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
IP_ROLE_FILE="/tmp/tmp_ip_role"
NID_ROLE_FILE="/tmp/tmp_nid_role"
T="    "
TT="        "
TTT="            "
TTTT="                "
TASK_ID_FILE="/opt/inspect/check_id_file"

function log
{
    echo [`date`][$$]$@ >> $LOG_FILE
}
#分割符，MML命令返回的是以回车符为分隔符
function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}
#map 信息
MapHealthStatus()
{
    case $1 in
    0)
        echo "UNKNOWN"
        ;;
    1)
        echo "NORMAL"
        ;;
    2)
        echo "FAULT"
        ;;
    3)
        echo "PRE_FAIL"
        ;;
    4)
        echo "PART_BROKEN"
        ;;
    5)
        echo "DEGRADE"
        ;;
    6)
        echo "HAS_BAD_BLOCK"
        ;;
    7)
        echo "HAS_ERROR_CODE"
        ;;
    8)
        echo "CONSISTENT"
        ;;
    9)
        echo "INCONSISTENT"
        ;;
    10)
        echo "BUSY"
        ;;
    11)
        echo "POWER_NO_INPUT"
        ;;
    12)
        echo "POWER_NOT_ENOUGH"
        ;;
    13)
        echo "SINGLE_LINK_FAULT"
        ;;
         *)
        echo "No this type"
        ;;
    esac
}

MapRunningStatus()
{
    case $1 in
    0)
        echo "UNKNOWN"
        ;;
    1)
        echo "NORMAL"
        ;;
    2)
        echo "RUNNING"
        ;;
    3)
        echo "NOT_RUNNING"
        ;;
    4)
        echo "NOT_EXIST"
        ;;
    5)
        echo "HIGH_TEMPERATURE_SLEEP"
        ;;
    6)
        echo "STARTING"
        ;;
    7)
        echo "POWER_FAILURE_PROTECTING"
        ;;
    8)
        echo "SLEEPING"
        ;;
    9)
        echo "SPINGUP"
        ;;
    10)
        echo "LINK_UP"
        ;;
    11)
        echo "LINK_DOWN"
        ;;
    12)
        echo "POWER_ON"
        ;;
    13)
        echo "POWER_OFF"
        ;;
    14)
        echo "PRE_COPY"
        ;;
    15)
        echo "COPYBACK"
        ;;
    16)
        echo "RECONSTRUCTION"
        ;;
    17)
        echo "EXPANSION"
        ;;
    18)
        echo "NOT_FORMAT"
        ;;
    19)
        echo "FORMATTING"
        ;;
    20)
        echo "UNMAPPING"
        ;;
    21)
        echo "INITIAL_SYNCHRONIZING"
        ;;
    22)
        echo "CONSISTENT"
        ;;
    23)
        echo "SYNCHRONIZING"
        ;;
    24)
        echo "SYNCHRONIZED"
        ;;
    25)
        echo "NOT_SYNCHRONIZED"
        ;;
    26)
        echo "SPLIT"
        ;;
    27)
        echo "ONLINE"
        ;;
    28)
        echo "OFFLINE"
        ;;
    29)
        echo "LOCKED"
        ;;
    30)
        echo "ENABLE"
        ;;
    31)
        echo "DISABLED"
        ;;
    32)
        echo "LEVELING"
        ;;
    33)
        echo "TO_BE_RECOVERD"
        ;;
    34)
        echo "INTERRUPTED"
        ;;
    35)
        echo "INVALID"
        ;;
    36)
        echo "NOSTART"
        ;;
    37)
        echo "QUEUING"
        ;;
    38)
        echo "STOP"
        ;;
    39)
        echo "COPYING"
        ;;
    40)
        echo "COMPLETED"
        ;;
    41)
        echo "PAUSE"
        ;;
    42)
        echo "REVSYNCHRONIZING"
        ;;
    43)
        echo "ACTIVATED"
        ;;
    44)
        echo "ROLLBACK"
        ;;
    45)
        echo "INACTIVATED"
        ;;
    46)
        echo "IDLE"
        ;;
    47)
        echo "POWERING_OFF"
        ;;
    48)
        echo "CHARGING"
        ;;
    49)
        echo "CHARGED"
        ;;
    50)
        echo "DISCHARGING"
        ;;
    51)
        echo "UPGRADING"
        ;;
    *)
        echo "No this type"
        ;;
    esac
}

#远程异步执行，输入ip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        log "[$FUNCNAME]:IP:$remote_ip,thread:$!,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#检查远程命令执行是否结束
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$2"
    local err_info=$3
    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ] || [ $iRet -eq 107 ] || [ "X${proresult}" == "X" ]; then
            log "[$FUNCNAME]:IP:${remote_ip}, return:${iRet}, time:${time}, le_pid:${le_pid}, proresult:${proresult}."
            sleep 10
        else
            break
        fi
    done

    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #查询命令执行成功，但远程命令还没有完成
    elif [ $iRet -ne 0 ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!,exec(get progress) failed.iRet($iRet)"
        return 1    #查询命令执行失败
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        log "[$FUNCNAME] IP:$remote_ip,thread:$!, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #命令成功完成，此处要求命令以0作为成功返回
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.iRet($iRet) errno($errno)"
        return 3    #命令在远端执行失败
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.process(null), ip not accessed"
        return 5    #解决重启超时问题
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.process(null)"
        return 0    #容错
    else
        log "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed. Undefined error info"
        return 4    #未定义错误
    fi
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        log "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done

    remote_exec $remote_ip 30 "${G_MML_FILE_PATH}/ClearTmpFile ${remote_file}"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        log "[$FUNCNAME][$LINENO] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
}

#获取本节点第一个后端网络IP
function get_backnet_ip
{
    local subnet_id=`grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'|sort -k1|head -n1`
    if [ "$subnet_id" = "" ]; then
        log "[$FUNCNAME]Failed to get back subnet"
    fi

    local IPAddress=`grep ipaddr_${subnet_id} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}'`
    if [ "$IPAddress" = "" ]; then
        log "[$FUNCNAME]Failed to get back subnet IP"
    fi

    echo $IPAddress
    return 0
}



function GetDiskInfo_MML()
{
    local DiskNodeID=""
    echo "Disk--------------------------------" >> $CONFIG_SYS_FILE
    BackIP=$MasterCM_BACK_IP
    local tmp=""
    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm diskinfo" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=$(cat ${G_TMP_FILE} | sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g')
        Result="${Info}"
        echo "$Result" >> $CONFIG_SYS_FILE
    else
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $G_TMP_FILE >/dev/null 2>&1
        tmp=$(cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep -Po "/tmp/snas_debug[0-9]*")
        if [ "X${tmp}" != "X" ];then
            cat $tmp > $G_TMP_FILE
        fi
        DiskNumber=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" |grep Disk_ID|grep -v "Running_Status: 4"| wc -l`
        echo "    Number of disks:$DiskNumber" >> $CONFIG_SYS_FILE
        echo "    DISK Physical Info--------------------------------" >> $CONFIG_SYS_FILE
        cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" |grep Disk_ID|grep -v "Running_Status: 4" |sed 's/^/        /g'>> $CONFIG_SYS_FILE
    fi
}


function GetLicenseInfo_MML()
{
    echo "License information--------------------------------" >> $CONFIG_SYS_FILE
    LicenseSerialNo=`cat /opt/huawei/snas/license/license_active.dat | grep "LicenseSerialNo"`
    echo "    $LicenseSerialNo" >> $CONFIG_SYS_FILE
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm licensecfg" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result" >> $CONFIG_SYS_FILE
    else
        set_ifs
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $G_TMP_FILE >/dev/null 2>&1
        javaID=`cat $G_TMP_FILE |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            FeatureID=`echo $line |awk '{print $3}'`
            echo "    FeatureID:$FeatureID" >> $CONFIG_SYS_FILE
            TrialDays=60
            echo "    Trial Days:$TrialDays" >> $CONFIG_SYS_FILE
            Deadline=`echo $line |awk '{print $7}'`
            date1=`expr $Deadline \/ 1000`
            Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            echo "    Running Deadline:$Deadline" >> $CONFIG_SYS_FILE
            Number=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            echo "    Maximal Resource Number:$Number" >> $CONFIG_SYS_FILE
        done
        restore_ifs
    fi
}

function GetSystemGeneral_MML()
{
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm system" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=$(cat ${G_TMP_FILE} | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g')
        Result="${Info}"
        echo "$Result" >> $CONFIG_SYS_FILE 2>&1
    else
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' ${G_TMP_FILE} >/dev/null 2>&1
        Version=`cat $G_TMP_FILE|grep "Cluster_Version"|awk -F: '{print $2}'`
        echo "    Cluster_Version:$Version" >> $CONFIG_SYS_FILE
        Health=`cat $G_TMP_FILE|grep "Cluster_Health_Status"|awk -F: '{print $2}'`
        Health=`MapHealthStatus $Health`
        echo "    Cluster_Health_Status:$Health" >> $CONFIG_SYS_FILE
        Running=`cat $G_TMP_FILE|grep "Cluster_Running_Status"|awk -F: '{print $2}'`
        Running=`MapRunningStatus $Running`
        echo "    Cluster_Running_Status:$Running" >> $CONFIG_SYS_FILE
        Capacity=`cat $G_TMP_FILE|grep "Cluster_Capacity"|awk -F: '{print $2}' | egrep -o "^[0-9]+"`
        echo "    Cluster_Capacity(MB):$Capacity" >> $CONFIG_SYS_FILE
        Used=`cat $G_TMP_FILE|grep "Cluster_Used_Capacity"|awk -F: '{print $2}' | egrep -o "^[0-9]+"`
        echo "    Cluster_Used_Capacity(MB):$Used" >> $CONFIG_SYS_FILE
    fi
}

function GetNodeInfo_MML()
{
    local ID=""
    echo "Node--------------------------------" >> $CONFIG_SYS_FILE
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm node" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g'`
        Result="${Info}"
        echo "$Result"
    else
        set_ifs
        dos2unix $G_TMP_FILE >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $G_TMP_FILE >/dev/null 2>&1

        Node=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep Node_ID|wc -l`
        echo "    Number of Node:$Node" >> $CONFIG_SYS_FILE
        echo "    Node info--------------------------------" >> $CONFIG_SYS_FILE

        javaID=`cat $G_TMP_FILE |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            Name=`echo $line |awk '{print $5}'`
            echo "        Name:$Name" >> $CONFIG_SYS_FILE
            ID=`echo $line |awk '{print $2}'`
            echo "        ID:${ID}" >> $CONFIG_SYS_FILE
            Fram=`echo $line |awk '{print $14}'`
            echo "        Fram Number:$Fram" >> $CONFIG_SYS_FILE
            Slot=`echo $line |awk '{print $17}'`
            echo "        Slot Number:$Slot" >> $CONFIG_SYS_FILE
            SN=`echo $line |awk '{print $20}'`
            echo "        Device SN :$SN" >> $CONFIG_SYS_FILE
            echo "" >> $CONFIG_SYS_FILE
        done
        restore_ifs
    fi
}

function GetSummaryInfo()
{
    local node_name=""
    echo "SUMMARY--------------------------------" >> $CONFIG_SYS_FILE
    #Name:
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_name"`
    echo "    $result" >> $CONFIG_SYS_FILE
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_id"`
    echo "    $result" >> $CONFIG_SYS_FILE

    #系统信息
    GetSystemGeneral_MML

    #获取默认冗余配比
    result=`cat /opt/huawei/snas/etc/mons.ini | grep "^DefaultProtection"`
    result=$(echo $result | sed 's/=/:/g')
    echo "    $result" >> $CONFIG_SYS_FILE
    #获取最大冗余配比
    result=`cat /opt/huawei/snas/etc/mons.ini | grep "^MaxProtection"`
    result=$(echo $result | sed 's/=/:/g')
    echo "    $result" >> $CONFIG_SYS_FILE
    result=`cat /opt/huawei/snas/etc/snas.ini| grep -w "^serviceType"`
    echo "    $result" >> $CONFIG_SYS_FILE

}

function GetDeviceInfo()
{
    local tmpmmlfile="/tmp/tmpmmlfile$$" 
    /usr/local/bin/MmlBatch 4016 "cm system" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' >$tmpmmlfile 2>/dev/null
    
    echo "NEInformation--------------------------------" >> $DEVICE_SYS_FILE
    NE_ID=$(cat $tmpmmlfile |grep Cluster_ID | cut -d":" -f2)
    echo "    NE_ID=$NE_ID" >> $DEVICE_SYS_FILE
    Name=$(cat $tmpmmlfile |grep Cluster_Name | cut -d":" -f2)
    echo "    Name=$Name" >> $DEVICE_SYS_FILE
    version=$(cat $tmpmmlfile | grep Cluster_Version | cut -d":" -f2)
    if [[ "X$version" == "XV300"* ]];then
        type="OceanStor 9000"
    else
        if [[ "X$version" == "XV100"* ]];then
            type="FusionStorage"
        else
            type="OceanStor 9000 V5"
        fi
    fi
    echo "    Type=$type" >> $DEVICE_SYS_FILE
    echo "    Version=$version" >> $DEVICE_SYS_FILE

    # 获取补丁版本号
    sphversion=$( ls /var/huawei/patch/cur/sph 2>/dev/null| grep -e "OceanStor*" -e "FusionStorage*" | awk -F'_' '{print $NF}' )
    if [ "X${sphversion}" == "X" ]
    then
        echo "    SphVersion=$version" >> $DEVICE_SYS_FILE
    else
        echo "    SphVersion=$sphversion" >> $DEVICE_SYS_FILE
    fi

    LicenseSerialNo=$( grep LicenseSerialNo /opt/huawei/snas/license/license_active.dat | awk -F= '{print $2}' )
    if [ "X${LicenseSerialNo}" == "X" ]
    then
        LicenseSerialNo="null"
    fi

     echo "    LicenseSerialNo=${LicenseSerialNo}" >> $DEVICE_SYS_FILE

    log "[$FUNCNAME] collect Device_System info.NE_ID=$NE_ID,Name=$Name,Version=$version,Type=$Type"

    rm -rf $tmpmmlfile
}

#===================================================
# 函数名称：获取cm_conf.db中节点对应的节点名
# 函数功能：通过节点的后端IP，从数据库中取出节点名称
# 描述：
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do

        log "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 3 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do

        log "[$FUNCNAME]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 3 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}

#===================================================
# 函数名称：collect_node_infomation
# 函数功能：搜集集群中各个节点的设备档案信息
# 描述：
#===================================================
function collect_node_infomation()
{
    #集群信息搜集完以后，下发给各个节点开始搜集,tmp_ip_role中含有集群节点的后端IP（在执行巡检开始的时候inspect_entry就会去检验集群中的IP，这里没必要再去获取和检验一次）
    local TASK_ID="inspectcollect"
    VALID_IP_FILE="/tmp/tmp_valid_ip_collect"
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    log "start get node information IP_ROLE_FILE=$REMOTE_IP_S "
    >${VALID_IP_FILE}

    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 120 "/opt/inspect/inspect_collect_nodeinfo.sh"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            log "node information collect fail iRet=$iRet"
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    sleep 1
    ValidIP=`cat ${VALID_IP_FILE}`
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        local hava_sata=""
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get config information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                log "checkini failed"
                continue
            fi

            #主节点下载至本地
            remote_download $Item $collllect_tmp$Item /var/log/Config.txt
            iRet=$?
            if [ $iRet -ne 0 ];then
                log "download collect fail Item=$Item"
                continue
            fi

            nodeName=$(get_node_hostname_from_db "${Item}")
            mv $collllect_tmp$Item ${tmpcollectdir}"Config_""$nodeName".txt > /dev/null 2>&1
            dos2unix ${tmpcollectdir}"Config_""$nodeName".txt

            #主节点下载至本地
            remote_download $Item $collllect_tmp$Item /var/log/Device.txt
            iRet=$?
            if [ $iRet -ne 0 ];then
                log "download /var/log/Device collect fail Item=$Item"
                continue
            fi

            mv $collllect_tmp$Item ${tmpcollectdir}"Device_""$nodeName".txt > /dev/null 2>&1
            dos2unix ${tmpcollectdir}"Device_""$nodeName".txt
        done
        ValidIP=$(cat $VALID_IP_FILE)
    done
    [ -f "${VALID_IP_FILE}" ] && rm -f "${VALID_IP_FILE}"
}


# 数据形式为一个字典，并且不是有规律重复的数据，key和wavlue之间分隔符是=或者：
#    cluster_name=cluster_49
#    cluster_id=cluster_491632462436342
#    Cluster_Version:7.1.1.SPC1
#    Cluster_Health_Status:NORMAL
#    Cluster_Running_Status:RUNNING
#    Cluster_Capacity(MB):1792424704
function output_line_to_dict()
{
    local content="${1}"
    local indent="${2}"  #输出缩进
    local loop=0
    local key_value_f=/tmp/inspect_key_value_f
    local linecnt=0
    local line=""
    local key=""
    local value=""
    >${key_value_f}
    
    echo "${content}" | awk -F "[|][|]" '{for (i=1;i<=NF;i++){print $i}}' >${key_value_f}
    linecnt=$( wc -l ${key_value_f} 2>/dev/null | awk '{print $1}' )
    
    while read line
    do
        loop=$((loop+1))
        if [ X"${line}" == X"" ]; then
            continue
        fi
        
        key=$( echo "${line}" | awk -F "[=:]" '{print $1}' | sed -e "s/^ *//g" -e "s/ *$//g" )
        value=$( echo "${line}" | sed "s/^ *${key}[:=]//g" | sed -e "s/^ *//g" -e "s/ *$//g" )
        if [ ${loop} -lt ${linecnt} ]; then
            echo "${indent}\"${key}\": \"${value}\"," >>${JSON_FILE}
        else
            echo "${indent}\"${key}\": \"${value}\"" >>${JSON_FILE}
        fi
    done <${key_value_f}
    
    rm -f ${key_value_f}
    return
}

function output_list()
{
    local check_id_file="${1}"
    local indent="${2}"
    local tmpfile=/tmp/tmp_check_id_file
    local line=""
    local loop=1
    local lincnt=0
    
    if [ ! -f "${check_id_file}" -o ! -s "${check_id_file}" ]; then
        return
    else
        grep "commonvalue type" ${check_id_file} | awk -F "[<>]" '{print $3}' | sed -e "s/ *//g" -e "s/ *$//g" | grep -v "^$" | sort | uniq > ${tmpfile}
        linecnt=$( wc -l ${tmpfile} | awk '{print $1}' )
        while read line
        do
            if [ X"{line}" == X"" ]; then
                continue
            fi
            echo "${indent}{" >>${JSON_FILE}
            output_line_to_dict "${line}" "${indent}${T}"
            if [ ${loop} -eq ${linecnt} ]; then
                echo "${indent}}" >>${JSON_FILE}
            else
                echo "${indent}}," >>${JSON_FILE}
            fi
        
            loop=$((loop+1))
        done <${tmpfile}
    fi  
    
    rm -f "${tmpfile}"
    return
}

# 目前包括巡检项151(网卡固件版本检查)和144(网卡PCIE速率协商)
function output_network_information()
{
    local tmpfile=/tmp/tmp_json_file
    >${tmpfile}
    
    
    # 输出网卡固件版本NIC firmware
    echo "${TT}\"NIC firmware\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}151" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出网卡PCIE速率协商 
    echo "${TT}\"NIC Rate negotiation\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}144" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    rm -f ${tmpfile}
    return
}

# 目前包括巡检项108(节点状态 )和107(CPU 状态)133(物理内存)103(业务硬盘状态)148(SMR磁盘运行状态检查)
function output_hardware_information()
{      
    # 输出节点状态
    echo "${TT}\"Node Information\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}108" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出CPU状态 
    echo "${TT}\"CPU Information\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}107" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出物理内存 
    echo "${TT}\"Physical Memory\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}133" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出业务硬盘状态 
    echo "${TT}\"Disk Information\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}103" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出SMR磁盘运行状态
    echo "${TT}\"SMR Disk Information\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}148" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    return      
}

# 目前只有一个巡检项涉及210(客户端个数)
function output_clients_information()
{
    local tmpfile=/tmp/tmp_json_file
    >${tmpfile}
    
    # 输出客户端个数
    echo "${TT}\"Clients Count\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}210" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    rm -f ${tmpfile} 
    return      

}
function output_file_to_dict()
{
    local tmpfile="${1}"
    local indent="${2}"  #输出缩进
    local loop=0
    local linecnt=0
    local line=""
    local key=""
    local value=""
    
    linecnt=$( wc -l ${tmpfile} 2>/dev/null | awk '{print $1}' )
    
    while read line
    do
        loop=$((loop+1))
        if [ X"${line}" == X"" ]; then
            continue
        fi
        
        key=$( echo "${line}" | awk -F "[=:]" '{print $1}' | sed -e "s/^ *//g" -e "s/ *$//g" )
        value=$( echo "${line}" | awk -F "[=:]" '{print $2}' | sed -e "s/^ *//g" -e "s/ *$//g" )
        if [ ${loop} -lt ${linecnt} ]; then
            echo "${indent}\"${key}\": \"${value}\"," >>${JSON_FILE}
        else
            echo "${indent}\"${key}\": \"${value}\"" >>${JSON_FILE}
        fi
    done <${tmpfile}
    
    rm -f ${tmpfile}
    return
}

# 单独从CONFIG_SYS_FILE从获取集群信息，还包括巡检项108(节点状态 )和229(集群只读水位)113(SSD配置)
function output_cluster_information()
{
    local tmpfile=/tmp/tmp_json_file
    >${tmpfile}
    
    # 输出SUMMARY
    echo "${TT}\"SUMMARY\": [" >>${JSON_FILE}
    sed -n "/^SUMMARY/,/^Node/ p" $CONFIG_SYS_FILE | grep "^  " | grep -v "^$" | sed -e 's/^ *//g' -e 's/ *$//g'| grep -v "^$" >${tmpfile}
    echo "${TTT}{" >>${JSON_FILE}
    output_file_to_dict "${tmpfile}" "${TTTT}"
    echo "${TTT}}" >>${JSON_FILE}
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出节点状态
    echo "${TT}\"Node Information\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}108" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 集群只读水位
    echo "${TT}\"NodePool ReadOnly Watermark \": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}229" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # SSD配置
    echo "${TT}\"SSD配置\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}113" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}    
    
    
    rm -f ${tmpfile} 
    return
}

# 目前包括巡检项：239(集群状态)、284(协议删除操作日志目录开关)、210(客户端个数)、220(外部DNS连通性)、331部署场景条带大小配置、309(WAL开关一致性)、329(审计日志开关)
function output_basic_configuration()
{
    # 部署场景
    echo "${TT}\"Deployment Scenario\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}239" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出协议开关 
    echo "${TT}\"Protocol switch\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}284" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出协议类型 
    echo "${TT}\"Protocol Type\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}210" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 输出DNS连通性 
    echo "${TT}\"DNS\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}220" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 目录条带大小设置
    echo "${TT}\"Directory Stripe Size Settings\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}331" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # WAL开关状态 
    echo "${TT}\"WAL switch status\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}309" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 审计日志开关状态
    echo "${TT}\"Audit log switch status\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}329" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    return
}

# 目前包括巡检项：319(配额/分级/快照/InfoRevive/Worm)、248(复制任务运行状态)
function output_value_added_features()
{
    # WAL开关状态 
    echo "${TT}\"Quota_Tier_Snapshot_InfoRevive_Worm\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}319" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 复制任务运行状态
    echo "${TT}\"Replication task status\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}248" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    return
}

# 目前包括巡检项：139(rmbg任务并发数)
function output_backgroud_tasks()
{
    # RMBG任务数 
    echo "${TT}\"RMBG Tasks Count\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}139" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    return
}

# 目前包括巡检项：244(删除任务检查)、214(内存资源池使用情况)、101(CPU利用率)、102(内存利用率)、100(系统硬盘利用率)
function output_important_resource_information()
{
    # 删除任务检查
    echo "${TT}\"Delete Task Check\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}244" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 内存资源池使用情况 
    echo "${TT}\"Memory resource pool usage\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}214" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # CPU利用率
    echo "${TT}\"CPU usage\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}101" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 内存使用率 
    echo "${TT}\"Memory usage\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}102" "${TTT}"
    echo "${TT}]," >>${JSON_FILE}
    
    # 系统硬盘利用率
    echo "${TT}\"System Disk Usage\": [" >>${JSON_FILE}
    output_list "${TASK_ID_FILE}100" "${TTT}"
    echo "${TT}]" >>${JSON_FILE}
    
    return
}


function generate_baykal_json()
{
    >${JSON_FILE}
    echo "{" >>${JSON_FILE}
    
    # 网络组网
    echo "${T}\"NetWork\": {" >>${JSON_FILE}
    output_network_information
    echo "${T}}," >>${JSON_FILE}    
    
    # 硬件信息
    echo "${T}\"Hardware\": {" >>${JSON_FILE}
    output_hardware_information
    echo "${T}}," >>${JSON_FILE}
    
    # 客户端信息
    echo "${T}\"Clients\": {" >>${JSON_FILE}
    output_clients_information
    echo "${T}}," >>${JSON_FILE}
    
    # 集群信息
    echo "${T}\"Cluster Information\": {" >>${JSON_FILE}
    output_cluster_information
    echo "${T}}," >>${JSON_FILE}    
    
    # 基础配置
    echo "${T}\"Basic Configuration\": {" >>${JSON_FILE}
    output_basic_configuration
    echo "${T}}," >>${JSON_FILE}
    
    # 增值特性
    echo "${T}\"Value added features\": {" >>${JSON_FILE}
    output_value_added_features
    echo "${T}}," >>${JSON_FILE}
    
    # 后台任务
    echo "${T}\"Background Tasks\": {" >>${JSON_FILE}
    output_backgroud_tasks
    echo "${T}}," >>${JSON_FILE}
    
    # 关键资源信息
    echo "${T}\"Important Resource Information\": {" >>${JSON_FILE}
    output_important_resource_information
    echo "${T}}" >>${JSON_FILE}
    

    echo "}" >>${JSON_FILE}
    
    return
}

function collect_monc_maps()
{
    local mapinfodir="${tmpcollectdir}/mapinfo"

    if [ -d "${mapinfodir}" -a X"$( dirname $mapinfodir )" == X"/var/log/inspect_collect" ]; then
        rm -rf $mapinfodir
    fi

    mkdir -p ${mapinfodir}

    if [ -f "/proc/monc_dsmap" ]; then
        cp /proc/monc_dsmap ${mapinfodir}
    fi

    if [ -f "/proc/monc_handoffmap" ]; then
        cp /proc/monc_handoffmap ${mapinfodir}
    fi

    if [ -f "/proc/monc_recoverymap" ]; then
        cp /proc/monc_recoverymap ${mapinfodir}
    fi

    if [ -f "/proc/monc_balancemap" ]; then
        cp /proc/monc_balancemap ${mapinfodir}
    fi

    if [ -f "/proc/monc_nlunmap" ]; then
        cp /proc/monc_nlunmap ${mapinfodir}
    fi

    nluninfo_file=$( /usr/local/bin/MmlBatch 988 "monc nluninfo 0" | grep "Get nlun info ok" | awk '{print $NF}' | dos2unix | sed "s/ *//g" | sed "s/ $*//g" )
    if [ -f "${nluninfo_file}" ]; then
        cp ${nluninfo_file} ${mapinfodir}
    fi

    # 增加拷贝cm告警数据库
    cp /opt/huawei/snas/etc/cm_alarm_record.db ${mapinfodir}

    return
}

function collect_main()
{
    log "start get config info###############"
    touch $CONFIG_SYS_FILE #创建一个Config_system.txt文件,存放集群信息
    touch $DEVICE_SYS_FILE #创建一个Device_system.txt文件,存放设备档案收集的集群信息

    #配置文件说明
    nowtime=`date "+%Y-%m-%d %H:%M:%S"`
    echo "PROFILE FOR MASSIVE STORAGE($nowtime)" > $CONFIG_SYS_FILE

    #集群总体信息
    GetSummaryInfo

    #集群节点信息
    GetNodeInfo_MML

    #License信息
    GetLicenseInfo_MML

    #硬盘信息
    GetDiskInfo_MML
    
    #设备档案收集集群整体信息
    GetDeviceInfo

    dos2unix ${CONFIG_SYS_FILE}
    dos2unix ${DEVICE_SYS_FILE}

    # 备份IP_ROLE_FILE,因为会在collect_node_infomation中被干掉
    cp ${G_TMP_INSPECT_PATH}tmp_ip_role ${tmpcollectdir}
    #远程收集各个节点的信息
    collect_node_infomation
    cp ${tmpcollectdir}tmp_ip_role ${G_TMP_INSPECT_PATH}tmp_ip_role
    
    # 生成对接Baykal需要展示集群节点信息的json文件
    generate_baykal_json
    sed -i "s/配置/ Config/g" ${JSON_FILE}
    mv ${JSON_FILE} $tmpcollectdir >/dev/null 2>&1
    mv $CONFIG_SYS_FILE  $tmpcollectdir > /dev/null 2>&1
    mv $DEVICE_SYS_FILE  $tmpcollectdir > /dev/null 2>&1
    [ -f "/var/log/CCDB_DB_version.log" ] && cp /var/log/CCDB_DB_version.log $tmpcollectdir > /dev/null 2>&1

    # 收集mon各种map
    collect_monc_maps
}

log "start collect config infomation"
#创建目录
tmpcollectdir="/var/log/inspect_collect/"
rm -rf $tmpcollectdir > /dev/null 2>&1
mkdir -p "$tmpcollectdir"

#搜集入口脚本,先拿一个本地后端IP（CM主），后面MML命令会使用到
MasterCM_BACK_IP=`GetLocalIp`
if [ "${MasterCM_BACK_IP}X" == "X" ];then
    log "MasterCM_BACK_IP is null ,get it again"
    MasterCM_BACK_IP=`GetLocalIp`
fi
collect_main

#压缩
cd $tmpcollectdir
zip -qr "Config.zip" ./* >/dev/null 2>&1
chown omuser:group9000 -R $tmpcollectdir >/dev/null 2>&1

#删除临时文件
rm *.txt >/dev/null 2>&1
rm -f $G_TMP_FILE >/dev/null 2>&1
[ -f "${IP_ROLE_FILE}" ] && rm -f "${IP_ROLE_FILE}"
[ -f "${NID_ROLE_FILE}" ] && rm -f "${NID_ROLE_FILE}"

log "end get config info"
exit 0



