#!/bin/bash
set +x
export G_SCRIPT_PATH=.
export G_CHECK_RESULT_FILE=t.xml
PROGRAM=`basename $0`

. $G_SCRIPT_PATH/inspect_software.sh
. $G_SCRIPT_PATH/inspect_hardware.sh

function usage()
{
cat << INPUT

    usage:            ${PROGRAM} <software|hardware> [taskid]
    exsample1:        ${PROGRAM} software
    exsample2:        ${PROGRAM} hardware 100
INPUT
}

#main
function inspect_main()
{
    time=`date "+%Y%m%d%H%M%S"`
    case $1 in
        software)
            taskids=`cat inspect_software.sh |grep "2[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
            checkStatus=checkSoftwareStatus
            checklog=checkSoftware.log
            break
            ;;
        hardware)
            taskids=`cat inspect_hardware.sh |grep "1[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
            checkStatus=checkHardwareStatus
            checklog=checkHardware$time.log
            break
            ;;
        *)
            usage
            exit 0
            ;;
    esac
    if [ "$2" == "" ];then
        for taskid in $taskids
        do
        {
            $checkStatus $taskid >$checklog
        }&
        done
        wait
    else
        echo #########################################
        $checkStatus $2 >$checklog
    fi
}

checkfile="${G_TMP_INSPECT_PATH}check_result_file$2"
needcheck=1

if [ -f "$checkfile" ];then
    curttime="`date +%Y%m%d%H%M%S`"
    filetime="`stat $checkfile | grep -i Modify | awk -F. '{print $1}' | awk '{print $2$3}'| awk -F- '{print $1$2$3}' | awk -F: '{print $1$2$3}'`"
    passtime=`expr $curttime - $filetime`
    if [ $passtime -le 500 ];then
        needcheck=0
    fi
fi

if [ $needcheck -eq 1 ];then
    GetBackIPAndRoleFromDB
    inspect_main "software"
    GetIPAndRoleFromDB
    inspect_main "hardware"
fi

mv $checkfile "${G_TMP_INSPECT_PATH}check_result_file"
exit 0
