/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.CertCheckUtil;
import com.huawei.ism.tool.devicemanager.service.DebugCheck;
import com.huawei.ism.tool.devicemanager.service.DeveloperModeCheck;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.PeerIPGainer;
import com.huawei.ism.tool.devicemanager.service.VerSpcGainer;
import com.huawei.ism.tool.devicemanager.service.VerSphGainer;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.HostServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.devicemanager.ui.former.GetTooolSupportList;
import com.huawei.ism.tool.devicemanager.utils.CertCheckCfmUtils;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.devicemanager.utils.ModeTypeParse;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityResMgr;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DevServicePkg;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.SVPModuleInfo;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import utils.Products;

public class DefaultNodeTypeQuery
implements INodeTypeQuery {
    private static final String OEM_VENDOR = "OEM Vendor";
    private static final String OEM_BRAND = "OEM Brand";
    private static final String SHOWSYS = "showsys";
    private static final String OEM_PRODUCT_MODEL = "OEM Product Model";
    protected static final String TOOLS = "tools";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DefaultNodeTypeQuery.class);
    protected List<String> queryInfoCmds = new ArrayList<String>();
    protected List<DeviceType> supportDevTypes = new ArrayList<DeviceType>();
    protected List<DeviceType> excludeDevTypes = new ArrayList<DeviceType>();
    protected Map<DeviceType, String> checkMap = new HashMap<DeviceType, String>();
    protected INodeSupport nodeSupport = null;
    protected static final int SUPERADMIN = 1;
    protected static final int SYSTEMADMIN = 2;
    protected static final int MONITOR = 13;
    private static final int GUEST = 10;
    protected static final String ISM_OEM_PRODUCT = "ism.OEM.product";
    protected static final String ISM_OEM_BRAND = "ism.OEM.brand";
    protected static final String ISM_OEM_VENDOR = "ism.OEM.vendor";
    protected static final String OEMCMDUNIFIEDSTORAGE = "show system manufactory";
    protected static final String OEMCMDMASSIVESTORAGE = "cat /opt/huawei/deploy/package/oem/products/description/oem.js";
    protected static final String OEMCMDUNIFIEDSTORAGENEW = "show system general|filterColumn exclude columnList=Product\\sModel";
    protected static final String INTERNAL_PRODUCT_MODEL = "Internal Product Model";
    private static final String HUAWEI = "huawei";
    protected static final String MINISYSTEM = "Storage: minisystem>";
    protected static final String UPGRADE = "upgrade:/>";
    private static final String CHANGETODEVELOPER = "change user_mode current_mode user_mode=developer";
    private static final String EXIT = "exit";
    private static final String DEVELOPER = "developer:/>";
    private static final String LDAP_SUPPORT_DEV_TYPE = "6.1.0";

    public DefaultNodeTypeQuery(List<DeviceType> supportDevTypes, String ... queryInfoCmdArr) {
        if (null != supportDevTypes) {
            this.supportDevTypes.addAll(supportDevTypes);
        }
        if (null != queryInfoCmdArr) {
            for (String cmd : queryInfoCmdArr) {
                this.queryInfoCmds.add(cmd);
            }
        }
    }

    public DefaultNodeTypeQuery(List<DeviceType> supportDevTypes, INodeSupport nodeSupport, String ... queryInfoCmds) {
        this(supportDevTypes, queryInfoCmds);
        if (null != nodeSupport) {
            this.nodeSupport = nodeSupport;
        }
    }

    public DefaultNodeTypeQuery() {
    }

    public void setExcludeDevTypes(List<DeviceType> excludeDevTypes) {
        this.excludeDevTypes = excludeDevTypes;
    }

    public void setCheckMap(Map<DeviceType, String> checkMap) {
        this.checkMap = checkMap;
    }

    /*
     * Exception decompiling
     */
    @Override
    public TaskResult queryNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    private static TaskResult initQueryTaskResult(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        TaskResult ret = new TaskResult();
        ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", (Object[])new Object[]{devNode.getIp()}));
        ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
        ret.setResult(TaskResult.Result.FAILED);
        return ret;
    }

    private boolean checkOutSvpCanAdd(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ICliConnection con) {
        boolean isSVPOptionalSupport;
        LOGGER.info("current device :{}, is replace {}", (Object)devNode.getItDeviceType(), (Object)DeviceAddUtil.isReplaceCertScene());
        if (ItDeviceType.Host.equals((Object)devNode.getItDeviceType()) && DeviceAddUtil.isReplaceCertScene()) {
            return true;
        }
        DeviceTypeUtil.SvpOptional svpOptional = DeviceTypeUtil.isSupportSVPCmd((ICliConnection)con);
        if (svpOptional == DeviceTypeUtil.SvpOptional.SUPPORT_NO) {
            devNode.setHighDevSVPModuleInfo(SVPModuleInfo.NEW_TOOLBOX_NOSVP.getName());
        } else if (DeviceTypeUtil.isDeviceHasSVPModule((String)devNode.getProductVersion(), (String)devNode.getDeviceType().toString())) {
            devNode.setHighDevSVPModuleInfo(SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName());
            this.checkCliCanEnterDiagnose(devNode, con);
        } else {
            devNode.setHighDevSVPModuleInfo(SVPModuleInfo.NEW_TOOLBOX_NOSVP.getName());
        }
        boolean isSVPSupportEnabled = SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo());
        boolean bl = isSVPOptionalSupport = !LocalHostUtil.isRunInSvp() && !isSVPSupportEnabled;
        if (!(this.isDevSupportOutSvpAdd(devNode) || devNode.canEnterDiagnose() || ArrayUtils.isHighEndDevSupportSvpAdd((String)GetTooolSupportList.getNeededSceneID()) || isSVPOptionalSupport)) {
            String messageKey = SceneUtils.supportAddDeviceViaSvp() ? "devicemanager.device.add.filter.support_svp" : "devicemanager.device.add.filter.dev";
            ret.setErrorLocaleDescription(ResourceUtil.getString((String)messageKey));
            ret.setErrorId(messageKey);
            ret.setResult(TaskResult.Result.FAILED);
            return false;
        }
        return true;
    }

    private void fetchHostInitiatorInfo(ICliConnection con, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        HostService hostService = HostServiceFactory.createHostService(devNode);
        if (null != hostService) {
            Object wwnErrMsg;
            Launcher launcher = hostService.queryWwn(con, devNode);
            if (null == launcher) {
                LOGGER.info("Launcher is null");
                return;
            }
            List<String> fcWwns = launcher.getFcWwns();
            List<String> iscsiWwns = launcher.getiSCSIWwns();
            List<String> ibWwns = launcher.getIBWwns();
            List<String> nVmeWwns = launcher.getNVMEWwns();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("current host {} 's wwns:{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.getDevKey()), (Object)launcher.getJsonString());
            }
            if (null == (wwnErrMsg = launcher.getOtherDataMap().get("queryWwnSuccess"))) {
                LOGGER.error("wwnErrMsg is null");
                return;
            }
            if (wwnErrMsg.toString().equals("unknown")) {
                devNode.setHostFCLauncherWwns(Collections.emptyList());
                devNode.setHostISCSILauncherWwns(Collections.emptyList());
                devNode.setHostIbLauncherWwns(Collections.emptyList());
                devNode.setHostNvmeLauncherWwns(Collections.emptyList());
            } else {
                devNode.setHostFCLauncherWwns(fcWwns);
                devNode.setHostISCSILauncherWwns(iscsiWwns);
                devNode.setHostIbLauncherWwns(ibWwns);
                devNode.setHostNvmeLauncherWwns(nVmeWwns);
            }
        }
    }

    private boolean isNeedQueryHBACardInfo(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return ItDeviceType.Host.equals((Object)devNode.getItDeviceType());
    }

    protected void chkSpcVersion(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ICliConnection con) {
        this.querySpcVersion(devNode, ret, con);
    }

    protected void queryStorageRemoteSNInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) {
        if (DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
            return;
        }
        String errRemoteSN = "UnknownDeviceSN";
        ArrayList<String> remoteSNList = new ArrayList<String>();
        try {
            String queryCmd = "show hyper_metro_domain general |filterColumn include columnList=Remote\\sDevice\\sID";
            List hyperMetroDevList = CliResolverUtils.queryStorageRemoteSNInfo((ICliConnection)con, (String)queryCmd);
            String queryNasCmd = "show fs_hyper_metro_domain general |filterColumn include columnList=Remote\\sDevice\\sID";
            List nasHyperDevList = CliResolverUtils.queryStorageRemoteSNInfo((ICliConnection)con, (String)queryNasCmd);
            hyperMetroDevList.removeAll(nasHyperDevList);
            hyperMetroDevList.addAll(nasHyperDevList);
            if (hyperMetroDevList.isEmpty()) {
                devNode.setRemoteSNs(remoteSNList);
                return;
            }
            String queryRemoteCmd = "show remote_device general |filterColumn include columnList=ID,SN";
            String cliResult1 = con.execCmdWithTimout(queryRemoteCmd, 15);
            if (CliResolverUtils.isCLIResultInValid((String)cliResult1) || cliResult1.contains("executed successfully")) {
                return;
            }
            List remoteDevList = CliResolverUtils.resloveCliRetToList((String)cliResult1);
            if (remoteDevList.isEmpty()) {
                return;
            }
            for (Map hyperMetroDev : hyperMetroDevList) {
                boolean getSnFlag = false;
                String hyperRemoteDevId = (String)hyperMetroDev.get("Remote Device ID");
                for (Map remoteDev : remoteDevList) {
                    if (!hyperRemoteDevId.equals(remoteDev.get("ID"))) continue;
                    getSnFlag = true;
                    CollectionUtil.addIfAbsent(remoteSNList, remoteDev.get("SN"));
                    break;
                }
                if (getSnFlag) continue;
                remoteSNList.add(errRemoteSN + hyperRemoteDevId);
            }
        }
        catch (Exception e) {
            LOGGER.error("query remote device info error!", (Throwable)e);
            return;
        }
        devNode.setRemoteSNs(remoteSNList);
        LOGGER.info("query remote device info success: ", (Object)((Object)remoteSNList).toString());
    }

    protected void queryRealtedDoradoNasSNInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) {
        if (devNode.getDeviceType().toString().contains("Dorado") && devNode.getProductVersion().compareTo("V300R002C10") >= 0) {
            HashMap<String, String> relatedSNIPmap = new HashMap<String, String>();
            try {
                String queryRelatedDevCmd = "";
                String relatedIP = "";
                boolean enterDeveloperMode = DeviceTypeUtil.changeDeveloperMode((ICliConnection)con);
                if (enterDeveloperMode) {
                    if (devNode.getDeviceType().toString().equals("Dorado NAS")) {
                        queryRelatedDevCmd = "show back_device general|filterColumn include columnList=Device\\sSN,Master\\sIP";
                        relatedIP = "Master IP";
                    } else {
                        queryRelatedDevCmd = "show nas_head general|filterColumn include columnList=Device\\sSN,Connect\\sIP";
                        relatedIP = "Connect IP";
                    }
                    String cliResult = con.execCmdWithTimout(queryRelatedDevCmd, 15);
                    cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
                    if (CliResolverUtils.isCLIResultInValid((String)cliResult) || cliResult.contains("executed successfully")) {
                        devNode.setRelatedSNIPs(relatedSNIPmap);
                        return;
                    }
                    List relatedDevList = CliResolverUtils.resloveVerticalCliRetToList((String)cliResult);
                    if (relatedDevList.isEmpty()) {
                        return;
                    }
                    for (Map relatedDev : relatedDevList) {
                        String relatedDevSN = (String)relatedDev.get("Device SN");
                        String relatedDevIP = (String)relatedDev.get(relatedIP);
                        if (relatedSNIPmap.containsKey(relatedDevSN)) continue;
                        relatedSNIPmap.put(relatedDevSN, relatedDevIP);
                        break;
                    }
                    con.execCmd(EXIT);
                } else {
                    LOGGER.info("change user mode to developer failed...");
                }
            }
            catch (Exception e) {
                LOGGER.error("query related device info error!", (Throwable)e);
                return;
            }
            devNode.setRelatedSNIPs(relatedSNIPmap);
            LOGGER.info("query related device info success: ", (Object)((Object)relatedSNIPmap).toString());
            return;
        }
    }

    protected boolean isDevSupportOutSvpAdd(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        String workingPath = ApplicationContext.getInstance().getWorkPath();
        File file = new File(workingPath);
        try {
            if (!file.getCanonicalFile().getParent().endsWith(TOOLS)) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error("check app path error!");
        }
        return ArrayUtils.isDevSupportOutSvpAdd((com.huawei.ism.tool.obase.entity.DevNode)devNode);
    }

    public static TaskResult checkProductUserRole(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con, TaskResult ret) {
        LOGGER.info("Start check user role...");
        if (DefaultNodeTypeQuery.isRestrictDomainUser(devNode)) {
            LOGGER.info("Device is domain user. ");
            String des = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.V3R6domainuser");
            ret.setErrorLocaleDescription(des);
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.V3R6domainuser");
            ret.setResult(TaskResult.Result.FAILED);
            return ret;
        }
        boolean isBuiltInRole = CliResolverUtils.checkUserRole((com.huawei.ism.tool.obase.entity.DevNode)devNode, (ICliConnection)con, (int[])new int[]{1, 2, 13, 10});
        if (!isBuiltInRole) {
            String des = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.V3R6nonsupportroleid");
            ret.setErrorLocaleDescription(des);
            ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.V3R6nonsupportroleid");
            ret.setResult(TaskResult.Result.FAILED);
            return ret;
        }
        return ret;
    }

    private static boolean isRestrictDomainUser(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return devNode.getLoginUser().isDomain() && (devNode.isDsStorage() || !Products.isSpecifiedDomainDev((String)devNode.getDeviceType().toString(), (String)devNode.getProductVersion()) || !ArrayUtils.isSupportDomainUserAdd((String)SceneUtils.getCurrentSubScene()));
    }

    protected static boolean checkProductVersion(String devVersion, Map<String, String> customRoleSuportProducts, String name) {
        if (customRoleSuportProducts.get(name).contains(",")) {
            for (String productVersion : customRoleSuportProducts.get(name).split(",")) {
                if (!DefaultNodeTypeQuery.isVersionMatch(productVersion, devVersion)) continue;
                return true;
            }
        } else {
            return DefaultNodeTypeQuery.isVersionMatch(customRoleSuportProducts.get(name), devVersion);
        }
        return false;
    }

    protected static boolean isVersionMatch(String productVersion, String devVersion) {
        if (productVersion.contains("+")) {
            String pointVersion = productVersion.substring(0, productVersion.indexOf("+"));
            return devVersion.compareTo(pointVersion) >= 0;
        }
        return Products.contains((String)devVersion, (String)productVersion);
    }

    protected void showCertCheckStep(com.huawei.ism.tool.obase.entity.DevNode devNode, ProgressDialog progressDialog, int totalSteps, int curStep) {
        if (!DefaultNodeTypeQuery.isHostDevice(devNode) && !DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
            this.updateProgressDialogMsg(progressDialog, "devicemanager.device.add.authing.server.cert", totalSteps, ++curStep);
        }
    }

    protected void checkHostReachAble(com.huawei.ism.tool.obase.entity.DevNode devNode) throws ToolException {
        if (!this.isUseForward(devNode) && !NetUtil.isHostCanConnect((String)devNode.getIp(), (int)devNode.getPort(), (int)5)) {
            throw new ToolException("ssh.connect.timed.out.ip.cannot.reatch", (Object[])new String[]{devNode.getIp()});
        }
    }

    protected boolean isUseForward(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return !devNode.isNotSshForward() || !devNode.isNotSocks5Proxy();
    }

    protected void checkPsdIfNeeded(com.huawei.ism.tool.obase.entity.DevNode devNode, Future<TaskResult> pwdFuture) throws InterruptedException, ExecutionException, ToolException {
        if (!DefaultNodeTypeQuery.isHostDevice(devNode) && !DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
            try {
                TaskResult tr;
                TaskResult taskResult = tr = pwdFuture == null ? null : pwdFuture.get(5L, TimeUnit.MINUTES);
                if (tr != null && TaskResult.Result.FAILED.equals((Object)tr.getResult())) {
                    throw new ToolException(tr.getErrorId(), (Object[])new String[]{devNode.getIp()});
                }
            }
            catch (TimeoutException ex) {
                throw new ToolException("check pass need timeout", (Object[])new String[]{devNode.getIp()});
            }
        }
    }

    protected void certCheck(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ProgressDialog progressDialog, int totalSteps, int curStep) throws InterruptedException, ExecutionException, ToolException {
        devNode.setVerifyCertificate(devNode.isCertCheckSelectFlag());
        if (!devNode.isVerifyCertificate()) {
            return;
        }
        this.showCertCheckStep(devNode, progressDialog, totalSteps, curStep);
        try {
            ret.setNeedCertWarn((Boolean)AsyncExcutor.submit((Callable)new CertCheckTask(devNode)).get(5L, TimeUnit.MINUTES) == false);
            if (!ret.isNeedCertWarn()) {
                CertCheckCfmUtils.setCertConfirmProp(devNode.getDeviceSerialNumber(), String.valueOf(true));
            }
        }
        catch (TimeoutException e) {
            throw new ToolException("check cert result timeout", (Object[])new String[]{devNode.getIp()});
        }
    }

    protected void updateProgressDialogMsg(ProgressDialog progressDialog, String custMizeMsg, int totalSteps, int curSteps) {
        if (progressDialog != null) {
            progressDialog.setCustMizeMsg(ResourceUtil.getStringWithParams((String)custMizeMsg, (Object[])new Object[]{curSteps, totalSteps}));
        }
    }

    @Override
    public TaskResult queryNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    protected void setFingerPrint(TaskResult ret, ICliConnection con) {
        if (con instanceof SshConnection && ret.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            ret.setFingerPrint(((SshConnection)con).getFingerPrint());
            ClientSession session = ((SshConnection)con).getSession();
            ret.setPublicKeyInfo(SshUtils.getKnownHostsInfo((ClientSession)session, (String)((SshConnection)con).getHost()));
        }
    }

    protected String getActalErrorMsg(PwdException e, DeviceOpr opr) {
        ToolLoggerFactory.getLogger(this.getClass()).warn("get actal errorMsg,Device opr is " + opr.toString());
        if (DeviceOpr.UPDATE.equals((Object)opr)) {
            return PwdSecurityResMgr.getInstance().queryUpdateDesc(e.getErrorMsg());
        }
        if (DeviceOpr.IMPORT.equals((Object)opr)) {
            return PwdSecurityResMgr.getInstance().queryImportDesc(e.getErrorMsg());
        }
        return e.getErrorMsg();
    }

    public void querySpcVersion(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ICliConnection con) {
        String sphVer;
        if (DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        new PeerIPGainer().getPeerIP(con, devNode);
        String spcVer = new VerSpcGainer().query(con);
        if (!StringUtils.isNULLStr((String)spcVer)) {
            String regex = "V\\d{3}R\\d{3}C\\d{2}";
            if (devNode.getProductVersion().contains(" Kunpeng") && StringUtils.hasMatchStr((String)devNode.getProductVersion(), (String)regex)) {
                spcVer = spcVer + " Kunpeng";
            }
            devNode.setProductVersion(spcVer);
        }
        if (!StringUtils.isNULLStr((String)(sphVer = new VerSphGainer().query(con)))) {
            String regex = "V\\d{3}R\\d{3}C\\d{2}";
            if (devNode.getProductVersion().contains(" Kunpeng") && StringUtils.hasMatchStr((String)devNode.getProductVersion(), (String)regex)) {
                sphVer = sphVer + " Kunpeng";
            }
            devNode.setHotPatchVersion(sphVer);
        }
        if (!this.supportDevTypes.contains(DeviceType.ALL)) {
            DeviceType tmpType = DeviceType.valueOf((String)(devNode.getDeviceType() + " " + devNode.getProductVersion()));
            if (null != this.nodeSupport) {
                if (!this.nodeSupport.isNodeSupport(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devNode))) {
                    if (this.nodeSupport instanceof SceneAddDeviceAction) {
                        this.setTaskFailedResultWithSceneNotSupportErrMsg((SceneAddDeviceAction)this.nodeSupport, ret, devNode, tmpType);
                    } else {
                        this.setTaskFailedResult(ret, devNode, tmpType);
                    }
                }
            } else if (!this.isDeviceTypeSupport(devNode)) {
                this.setTaskFailedResult(ret, devNode, tmpType);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(" query device SPC info takes :" + (System.currentTimeMillis() - startTime) + " millseconds and SPC version is:" + spcVer + " and task result is:" + ret);
        }
    }

    protected void setTaskFailedResultWithSceneNotSupportErrMsg(SceneAddDeviceAction sceneAddDeviceAction, TaskResult ret, com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
        } else {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)sceneAddDeviceAction.getAddDevErrMsgPropKey(), (Object[])new Object[]{devNode.getIp(), tmpType}));
        }
    }

    protected void setTaskFailedResult(TaskResult ret, com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
            return;
        }
        if (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isOEM()) {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtype.oem", (Object[])new Object[]{devNode.getIp()}));
        } else if ("patch".equals(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolTypeName()) && this.isHotPatchSpecialVersion(tmpType.toString())) {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtypeforhotpatch", (Object[])new Object[]{devNode.getIp(), tmpType}));
        } else if (StringUtils.isNULLStr((String)devNode.getProductVersion())) {
            LOGGER.info("production version is empty.");
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.queryversion.error"));
        } else {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtype", (Object[])new Object[]{devNode.getIp(), devNode.getDeviceType() + "(" + devNode.getProductVersion() + ")"}));
        }
    }

    private boolean isHotPatchSpecialVersion(String modelVersion) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The device is\uff1a" + modelVersion);
        }
        List<String> specialModel = Arrays.asList("S2600T", "S5500T", "S5600T", "S5800T", "S6800T");
        String specialVersion = "V200R002C00";
        for (String string : specialModel) {
            if (!modelVersion.contains(string) || !modelVersion.contains(specialVersion)) continue;
            return true;
        }
        return false;
    }

    protected TaskResult queryDeviceShowInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ICliConnection con) throws ToolException {
        if (DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
            return this.dealNewNodeInfo(devNode, con);
        }
        String cliResult = "";
        TaskResult result = ret;
        for (String cmd : this.queryInfoCmds) {
            cliResult = con.execCmdWithTimout(cmd, 30);
            cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
            if (cmd.equals("show system general") && cliResult.contains("Permission denied")) {
                result = result == null ? new TaskResult() : result;
                String des = ResourceUtil.getString((String)"devicemanager.layout.device.add.device.miss.root.DPA");
                result.setErrorLocaleDescription(des);
                result.setErrorId(des);
                result.setResult(TaskResult.Result.FAILED);
                return result;
            }
            if (this.isOtherPorductCLIResultInValid(cliResult) || CliResolverUtils.isCLIResultInValid((String)cliResult) || !this.isContainXVEModel(cliResult)) continue;
            String subCmdResult = "";
            if (cmd.equals("show system general")) {
                subCmdResult = con.execCmdWithTimout(OEMCMDUNIFIEDSTORAGENEW, 30);
                if (!(subCmdResult = Normalizer.normalize(subCmdResult, Normalizer.Form.NFKC)).contains(INTERNAL_PRODUCT_MODEL)) {
                    subCmdResult = "";
                }
            }
            TaskResult deviceRet = this.dealNodeInfo(devNode, cliResult, subCmdResult);
            if (!StringUtils.isNULLStr((String)devNode.getProductVersion())) {
                result = deviceRet;
                break;
            }
            if (TaskResult.Result.SUCCESS == deviceRet.getResult()) {
                result = deviceRet;
                break;
            }
            result = deviceRet;
        }
        this.getSysUnnormalStatus(devNode, con);
        this.chkUnNormalStatus(devNode, con, result);
        DefaultNodeTypeQuery.checkProductUserRole(devNode, con, result);
        if (TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
            return result;
        }
        if (StringUtils.isNULLStr((String)devNode.getProductVersion())) {
            return this.dealNewNodeInfo(devNode, con);
        }
        return result;
    }

    protected void getSysUnnormalStatus(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) {
        if (con instanceof SshConnection) {
            Matcher matcher1;
            String loginMessage = ((SshConnection)con).getLoginMessage();
            Matcher matcher = Pattern.compile(MINISYSTEM).matcher(loginMessage);
            if (matcher.find()) {
                LOGGER.info("The device is in minisystem mode.");
                devNode.setMiniSystem(true);
            }
            if ((matcher1 = Pattern.compile(UPGRADE).matcher(loginMessage)).find()) {
                LOGGER.info("The device is in upgrade mode.");
                devNode.setUpgrade(true);
            }
        }
    }

    protected boolean chkOEMStep(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ICliConnection con) throws ToolException {
        if (DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
            return true;
        }
        if (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isOEM()) {
            if (devNode.isMiniSystem() || devNode.isUpgrade()) {
                ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.devicestatuserror");
                ret.setErrorLocaleDescription(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicestatuserror"));
                ret.setResult(TaskResult.Result.FAILED);
                return false;
            }
            if (!this.chkOEMInfo(devNode, con)) {
                ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtype.oem", (Object[])new Object[]{devNode.getIp()}));
                ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.nosupportdevtype.oem");
                ret.setResult(TaskResult.Result.FAILED);
                LOGGER.error("the device {} is not oem device.", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.getIp()));
                return false;
            }
        }
        return true;
    }

    protected boolean chkOEMInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) throws ToolException {
        return this.chkOEMUnifiedStorage(devNode, con) || this.chkOEMMassiveStorage(devNode, con);
    }

    protected boolean chkOEMMassiveStorage(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) throws ToolException {
        String cliShowSysResult = con.execCmdWithTimout(SHOWSYS, 30);
        String newVerModel = CliResolverUtils.getDeviceInfo((String)cliShowSysResult, (String)OEM_PRODUCT_MODEL);
        if (!CliResolverUtils.isCLIResultInValid((String)cliShowSysResult) && !StringUtils.isNULLStr((String)newVerModel)) {
            String brand = CliResolverUtils.getDeviceInfo((String)cliShowSysResult, (String)OEM_BRAND);
            String vendor = CliResolverUtils.getDeviceInfo((String)cliShowSysResult, (String)OEM_VENDOR);
            LOGGER.error("CLI valid." + cliShowSysResult);
            return this.setOEMInfo(devNode, newVerModel, brand, vendor);
        }
        String cliResult = con.execCmdWithTimout(OEMCMDMASSIVESTORAGE, 30);
        if (CliResolverUtils.isCLIResultInValid((String)cliResult)) {
            LOGGER.error("CLI invalid.");
            return false;
        }
        String oemModel = this.handleMassiveStorageRet(cliResult, ISM_OEM_PRODUCT);
        String brand = this.handleMassiveStorageRet(cliResult, ISM_OEM_BRAND);
        String vendor = this.handleMassiveStorageRet(cliResult, ISM_OEM_VENDOR);
        return this.setOEMInfo(devNode, oemModel, brand, vendor);
    }

    private boolean setOEMInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, String oemModel, String brand, String vendor) {
        devNode.setOemModel(null == oemModel ? "" : oemModel);
        devNode.setBrand(null == brand ? "" : brand);
        devNode.setVendor(null == vendor ? "" : vendor);
        LOGGER.info(String.format(Locale.ROOT, "oemModel:%s, brand:%s, vendor:%s", oemModel, brand, vendor));
        if (devNode.getOemModel().equals("") && devNode.getBrand().equals("") && devNode.getVendor().equals("")) {
            return false;
        }
        return !devNode.getVendor().contains(HUAWEI);
    }

    private String handleMassiveStorageRet(String cliResult, String field) {
        String oemModel = CliResolverUtils.vertical((String)"=", (String)Normalizer.normalize(cliResult, Normalizer.Form.NFKC), (String)field);
        int start = oemModel.indexOf("'");
        int end = oemModel.lastIndexOf("'");
        if (-1 == end || -1 == start || 0 != start || start == end) {
            return null;
        }
        int semicolon = 0;
        if (oemModel.endsWith(";") && end != (semicolon = oemModel.lastIndexOf(";")) - 1) {
            return null;
        }
        oemModel = oemModel.substring(start + 1, end).replaceAll("'", "");
        return oemModel;
    }

    protected boolean chkOEMUnifiedStorage(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) throws ToolException {
        String cliResult = con.execCmdWithTimout(OEMCMDUNIFIEDSTORAGE, 30);
        if (CliResolverUtils.isCLIResultInValid((String)cliResult)) {
            LOGGER.error("CLI invalid.");
            return false;
        }
        String oemModel = CliResolverUtils.vertical((String)":", (String)cliResult, (String)"Model");
        String brand = CliResolverUtils.vertical((String)":", (String)cliResult, (String)"Brand");
        String vendor = CliResolverUtils.vertical((String)":", (String)cliResult, (String)"Vendor");
        return this.setOEMInfo(devNode, oemModel, brand, vendor);
    }

    protected Set<String> getNotSupportCmds() {
        HashSet<String> notSupportComds = new HashSet<String>();
        List<DevServicePkg> desServicePkgs = DeviceContext.getDevServicePkgs();
        for (DevServicePkg desServicePkg : desServicePkgs) {
            List notSupportComd = desServicePkg.getNotSupportComd();
            for (String string : notSupportComd) {
                if (StringUtils.isNULLStr((String)string)) continue;
                notSupportComds.add(string);
            }
        }
        return notSupportComds;
    }

    protected boolean getendingJudges(String type) {
        List<DevServicePkg> desServicePkgs = DeviceContext.getDevServicePkgs();
        for (DevServicePkg desServicePkg : desServicePkgs) {
            String devType = desServicePkg.getDevType();
            if (!type.equals(devType)) continue;
            return desServicePkg.isMutilCtr();
        }
        return false;
    }

    protected String findProperPathByNode(com.huawei.ism.tool.obase.entity.DevNode devNode, String path) {
        return path + File.separator + (DefaultNodeTypeQuery.isHostDevice(devNode) ? "host" : "switch");
    }

    protected String generateProperFilelName(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode) ? devNode.getDevTypeLevel2().toString().toLowerCase(Locale.ENGLISH) + ".py" : "query.py";
    }

    protected synchronized TaskResult dealNewNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con) {
        long saTime = System.currentTimeMillis();
        String path = FilePathUtils.filterPath((String)FileUtils.getAddDevProductSuprotPkgPath());
        TaskResult ret = new TaskResult();
        LOGGER.info("Prepare script executor takes time {} .", (Object)(System.currentTimeMillis() - saTime));
        path = this.findProperPathByNode(devNode, path);
        File[] files = new File(path).listFiles();
        if (files == null) {
            LOGGER.error("files is null!");
            return ret;
        }
        long startQueryTime = System.currentTimeMillis();
        List<Object> ipLists = null;
        Map<String, String> nodeInfoRet = new HashMap<String, String>();
        List scripts = Arrays.stream(files).filter(File::isDirectory).map(dir -> new File(new File((File)dir, "discovery"), this.generateProperFilelName(devNode))).filter(File::exists).collect(Collectors.toList());
        JythonExecuter executor = new JythonExecuter();
        for (File script : scripts) {
            try {
                executor.compileScript(script);
                if (DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("SSH", con);
                    context.put("dev", devNode);
                    context.put("Logger", LOGGER);
                    nodeInfoRet = (Map)executor.simpleInvokeFunction("execute", context);
                } else {
                    nodeInfoRet = (Map)executor.simpleInvokeFunction("execute", con);
                }
                if (!this.checkResult(nodeInfoRet)) continue;
                String type = nodeInfoRet.get("type");
                if (!(script = new File(script.getParent(), "queryctrips.py")).exists() || !this.getendingJudges(type)) break;
                executor.compileScript(script);
                ipLists = executor.invokeFunction("execute", con);
                break;
            }
            catch (SignException e) {
                LOGGER.error("py file SHAAndRSAVerifyUtils filed!", (Throwable)e);
                this.makeErrorTaskResult(devNode, ret);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("py file {} not found!", (Object)"queryctrips.py");
                this.makeErrorTaskResult(devNode, ret);
            }
            catch (ToolException e) {
                LOGGER.error("py file not found!", (Throwable)e);
                this.makeErrorTaskResult(devNode, ret);
            }
        }
        LOGGER.info("Query dev info by script takes time {} .", (Object)(System.currentTimeMillis() - startQueryTime));
        if (null == nodeInfoRet) {
            throw new NullPointerException("NodeInfos is null");
        }
        this.addDevNodeInfo(devNode, nodeInfoRet, ipLists, ret);
        this.nodeSupportCheck(devNode, ret);
        return ret;
    }

    protected void nodeSupportCheck(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret) {
        if (DeviceAddUtil.isReplaceCertScene() && DefaultNodeTypeQuery.isHostDevice(devNode)) {
            return;
        }
        if ((DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) && null != this.nodeSupport && !TaskResult.Result.FAILED.equals((Object)ret.getResult())) {
            DevNode newDevNode = EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devNode);
            if (!this.nodeSupport.isNodeSupport(newDevNode)) {
                if (!StringUtils.isNULLStr((String)newDevNode.getErrorDecs())) {
                    devNode.setErrorDecs(newDevNode.getErrorDecs());
                }
                this.setTaskFailedResult(ret, devNode, devNode.getDeviceType());
            }
            ret.setAddConfirmInfo(newDevNode.getAddConfirmInfo());
        }
    }

    protected boolean checkResult(Map<String, String> nodeInfos) {
        if (null == nodeInfos || nodeInfos.isEmpty()) {
            return false;
        }
        String name = nodeInfos.get("name");
        String type = nodeInfos.get("type");
        String sn = nodeInfos.get("sn");
        String version = nodeInfos.get("version");
        return !this.checkDefaultstr(name) && !this.checkDefaultstr(type) && !this.checkDefaultstr(sn) && !this.checkDefaultstr(version);
    }

    protected void addDevNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, Map<String, String> nodeInfos, List<Object> ipLists, TaskResult ret) {
        String name = nodeInfos.get("name");
        String type = nodeInfos.get("type");
        String sn = nodeInfos.get("sn");
        String version = nodeInfos.get("version");
        if (StringUtils.hasNULLStr((String[])new String[]{sn}) || this.checkDefaultstr(sn)) {
            String errorDesKey = "devicemanager.layout.device.add.deviceadddialog.queryinfoerror";
            if (DeviceContext.isChooseDevType()) {
                errorDesKey = "devicemanager.layout.device.add.deviceadddialog.queryinfoerror1";
            }
            if (DefaultNodeTypeQuery.isHostDevice(devNode) || DefaultNodeTypeQuery.isSwitchDevice(devNode)) {
                errorDesKey = "devicemanager.layout.device.add.host.deviceadddialog.queryinfoerror";
            }
            if (!devNode.getDevTypeLevel2().toString().equalsIgnoreCase(name)) {
                errorDesKey = "devicemanager.layout.device.add.deviceadddialog.queryinfoerror1";
            }
            String errorDes = ResourceUtil.getString((String)errorDesKey);
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
            ToolLoggerFactory.getLogger(this.getClass()).warn("Query host sn failed, sn is blank.");
            return;
        }
        if (this.checkDefaultstr(name) || this.checkDefaultstr(type) || this.checkDefaultstr(sn) || this.checkDefaultstr(version)) {
            this.makeErrorTaskResult(devNode, ret);
            return;
        }
        if (null != type && "unknown".equalsIgnoreCase(type) && !DeviceAddUtil.isReplaceCertScene()) {
            String errorDes = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.queryinfoerror1");
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
            return;
        }
        devNode.setDeviceName(name);
        devNode.setDeviceSerialNumber(sn);
        DeviceType devType = DeviceType.valueOf((String)type);
        devNode.setDeviceType(devType);
        devNode.setProductVersion(version);
        ret.setResult(TaskResult.Result.SUCCESS);
        ret.setResultObject((Object)devNode);
        ret.setErrorLocaleDescription("");
        if (null != ipLists && !ipLists.isEmpty()) {
            for (Object ipObj : ipLists) {
                String ip = String.valueOf(ipObj);
                PeerIPGainer.addIPlist(ip, devNode);
                PeerIPGainer.addPeerIP(ip, devNode);
            }
        }
    }

    protected boolean checkDefaultstr(String str) {
        return "--".equals(str);
    }

    protected void makeErrorTaskResult(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setErrorId("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror");
        ret.setResult(TaskResult.Result.FAILED);
    }

    public boolean isDeviceTypeSupport(com.huawei.ism.tool.obase.entity.DevNode dev) {
        boolean isSupport = true;
        String tmpType = dev.getDeviceType() + " " + dev.getProductVersion();
        Set<Map.Entry<DeviceType, String>> entrys = this.checkMap.entrySet();
        for (Map.Entry<DeviceType, String> entry : entrys) {
            if (!Products.contains((String)tmpType, (String)entry.getKey().toString())) continue;
            isSupport = this.checkVersionByScript(dev, entry.getValue());
            break;
        }
        if (!isSupport) {
            return isSupport;
        }
        for (DeviceType devTpye : this.excludeDevTypes) {
            if (!Products.contains((String)tmpType, (String)devTpye.toString())) continue;
            return false;
        }
        for (DeviceType devTpye : this.supportDevTypes) {
            if (!Products.contains((String)tmpType, (String)devTpye.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean checkVersionByScript(com.huawei.ism.tool.obase.entity.DevNode dev, String scriptPath) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dev", dev);
        try {
            JythonExecuter jythonExecuter = new JythonExecuter();
            File pyFile = new File(scriptPath);
            jythonExecuter.compileScript(pyFile);
            Object ret = jythonExecuter.simpleInvokeFunction("execute", paramMap);
            return (Boolean)ret;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.", (Throwable)e);
            return true;
        }
    }

    protected boolean isContainXVEModel(String cliResult) {
        String normalizedCliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
        return normalizedCliResult.contains("Device Model") || normalizedCliResult.contains("Device Type") || normalizedCliResult.contains("Product Model") || normalizedCliResult.contains("Product Version") || normalizedCliResult.contains("Model");
    }

    protected boolean isOtherPorductCLIResultInValid(String cliResult) {
        String normalizedCliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
        Set<String> notSupportComds = this.getNotSupportCmds();
        if (notSupportComds.isEmpty()) {
            return false;
        }
        for (String string : notSupportComds) {
            if (!normalizedCliResult.contains(string)) continue;
            return true;
        }
        return false;
    }

    protected TaskResult dealNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, String cliResult, String subCliResult) {
        TaskResult ret = new TaskResult();
        String normalizedCliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
        boolean isFusionStorage = CliResolverUtils.getInfoByNames((String)normalizedCliResult, (String[])new String[]{"Product Name"}).toLowerCase(Locale.ENGLISH).contains("fusionstorage");
        if (isFusionStorage) {
            String version = CliResolverUtils.getDeviceInfo((String)normalizedCliResult, (String)"Product Version");
            ToolLoggerFactory.getLogger(this.getClass()).info("the version is :" + version);
            try {
                version = version.split("[.]", 3)[0] + "." + version.split("[.]", 3)[1];
                if (Float.parseFloat(version) >= Float.parseFloat("7.0")) {
                    ret.setResult(TaskResult.Result.FAILED);
                    ret.setResultObject((Object)devNode);
                    return ret;
                }
            }
            catch (NumberFormatException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("check version error:" + e);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("check version error:" + e);
            }
        }
        String deviceSerialNumber = CliResolverUtils.getSerialNumber((String)normalizedCliResult);
        String deviceName = CliResolverUtils.getInfoByNames((String)normalizedCliResult, (String[])new String[]{"System Name", "Name"});
        String productVersion = CliResolverUtils.getDeviceInfo((String)normalizedCliResult, (String)"Product Version");
        String deviceMode = "";
        if (!subCliResult.isEmpty() && subCliResult.contains(INTERNAL_PRODUCT_MODEL)) {
            String cliDeviceMode = CliResolverUtils.getInfoByNames((String)subCliResult, (String[])new String[]{INTERNAL_PRODUCT_MODEL});
            String string = deviceMode = DeviceAddUtil.needGetDeviceModeByRest(subCliResult) ? DeviceAddUtil.getDeviceModeByRest(devNode).orElse(cliDeviceMode) : cliDeviceMode;
        }
        if (deviceMode.isEmpty()) {
            deviceMode = CliResolverUtils.getInfoByNames((String)normalizedCliResult, (String[])new String[]{"Device Model", "Device Type", "Product Model", "Product Mode", "Model"});
        }
        deviceMode = ModeTypeParse.getModelType(deviceMode);
        devNode.setDeviceName(deviceName);
        devNode.setDeviceSerialNumber(deviceSerialNumber);
        if (deviceMode.contains("VIS") && productVersion.equals("")) {
            productVersion = "V100R001C02";
        }
        devNode.setProductVersion(productVersion);
        DeviceType type = DeviceType.valueOf((String)deviceMode);
        devNode.setDeviceType(type);
        ret.setResult(TaskResult.Result.SUCCESS);
        ret.setResultObject((Object)devNode);
        return ret;
    }

    protected static boolean isHostDevice(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return ArrayUtils.isHostDevice((com.huawei.ism.tool.obase.entity.DevNode)devNode);
    }

    protected static boolean isSwitchDevice(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return ArrayUtils.isSwitchDevice((com.huawei.ism.tool.obase.entity.DevNode)devNode);
    }

    public void chkUnNormalStatus(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection con, TaskResult ret) {
    }

    protected TaskResult checkParam(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret, ICliConnection con, String debugPwd) {
        TaskResult result = ret;
        if (!StringUtils.isNULLStr((String)debugPwd)) {
            result = DeveloperModeCheck.checkDeveloperPwd(con, devNode);
            this.setFingerPrint(result, con);
        }
        if (!StringUtils.isNULLStr((String)debugPwd) && !TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
            result = DebugCheck.checkDebugPwd(con, devNode);
            this.setFingerPrint(result, con);
        }
        return result;
    }

    private void checkCliCanEnterDiagnose(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection connection) {
        if (devNode.getItDeviceType() != ItDeviceType.Storage) {
            return;
        }
        if (DeviceTypeUtil.changeDeveloperMode((ICliConnection)connection)) {
            try {
                String res = connection.execCmd("debug");
                if (res.trim().endsWith("/diagnose>")) {
                    devNode.setCanEnterDiagnose(true);
                    connection.execCmd(EXIT);
                }
                connection.execCmd(EXIT);
            }
            catch (ToolException e) {
                LOGGER.error("try to check whether cli can enter diagnose error", (Throwable)e);
            }
        }
    }

    public INodeSupport getNodeSupport() {
        return this.nodeSupport;
    }

    protected static class CertCheckTask
    implements Callable<Boolean> {
        protected com.huawei.ism.tool.obase.entity.DevNode devNode;

        public CertCheckTask(com.huawei.ism.tool.obase.entity.DevNode devNode) {
            this.devNode = devNode;
        }

        @Override
        public Boolean call() throws Exception {
            if (DefaultNodeTypeQuery.isHostDevice(this.devNode)) {
                LOGGER.warn("start check cert isHostDevice.......... end");
                return true;
            }
            if (!this.devNode.isVerifyCertificate() || CertCheckCfmUtils.isTCfmrusteDev(this.devNode.getDeviceSerialNumber())) {
                LOGGER.info("start check cert isTCfmrusteDev.......... end");
                return true;
            }
            int result = CertCheckUtil.checkDevCert(this.devNode);
            if (0 != result && -1 != result) {
                LOGGER.error("cert check failed.");
                return false;
            }
            LOGGER.info("cert check success.");
            return true;
        }
    }
}

