/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.IDevInfoQueryService;
import com.huawei.ism.tool.devicemanager.service.host.HostService;
import com.huawei.ism.tool.devicemanager.service.host.HostServiceFactory;
import com.huawei.ism.tool.devicemanager.utils.WwnUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsInfoQryServiceImpl
implements IDevInfoQueryService {
    private static final String MAC_MATCH_REGEX = "([0-9a-fA-F]{2}(:|-)){5}[0-9a-fA-F]{2}";
    private static volatile IDevInfoQueryService instance = null;
    public static final String DEVICE_CANNOT_CONNECT_WIN = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror.win";
    public static final String DEVICE_CANNOT_CONNECT = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsInfoQryServiceImpl.class);
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED";
    private static final String RPC_SERVICE_NOTOK = "ERROR";
    private static final String PATH_NOT_FIND = "The system cannot find the path specified.";

    private WindowsInfoQryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDevInfoQueryService getInstance() {
        if (instance != null) return instance;
        Class<WindowsInfoQryServiceImpl> clazz = WindowsInfoQryServiceImpl.class;
        synchronized (WindowsInfoQryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new WindowsInfoQryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult ret = new TaskResult();
        try {
            ICliConnection conn = WmicConnectionManager.getWmicConnection((DevNode)devNode);
            String cmdMac = "wmic NICCONFIG get ipaddress,macaddress,description";
            String cmdVer = "wmic OS get name";
            String versionCmd = "wmic OS get version";
            String resultMac = Normalizer.normalize(conn.execCmd(cmdMac), Normalizer.Form.NFKC);
            String resultVer = Normalizer.normalize(conn.execCmd(cmdVer), Normalizer.Form.NFKC);
            String version = Normalizer.normalize(conn.execCmd(versionCmd), Normalizer.Form.NFKC);
            LOGGER.info("resultMac = {}{}", (Object)System.lineSeparator(), (Object)resultMac);
            LOGGER.info("resultVer = {}{}", (Object)System.lineSeparator(), (Object)resultVer);
            if (conn instanceof WmicConnection && !((WmicConnection)conn).isLocalSupportWmic()) {
                String errorDes = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.wmic.not.found");
                ret.setErrorLocaleDescription(errorDes);
                ret.setResult(TaskResult.Result.FAILED);
                LOGGER.info("Local Not Support.");
                return ret;
            }
            if (resultMac.contains(EXE_FAILED) || resultVer.contains(EXE_FAILED) || resultVer.contains(RPC_SERVICE_NOTOK) || resultVer.contains(PATH_NOT_FIND) || resultVer.contains(RPC_SERVICE_NOTOK.toLowerCase(Locale.ENGLISH))) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Failed to excute wmic cmd!");
                this.makeWindowsErrorTaskResult(devNode, ret);
                return ret;
            }
            String[] resultMacArray = resultMac.split("\r\n");
            String[] resultVerArray = resultVer.split("\r\n");
            resultMac = this.handleMacToSerialNum(devNode, resultMac, resultMacArray);
            resultVer = this.getString(resultVer, resultVerArray);
            String[] verInfo = version.split(System.lineSeparator());
            this.matchVInfo(devNode, verInfo);
            devNode.setDeviceType(DeviceType.valueOf((String)resultVer));
            devNode.setDeviceName(devNode.getDevTypeLevel2().toString());
            devNode.setDeviceSerialNumber(resultMac.replace("-", "").toUpperCase(Locale.US));
            this.fetchHostInitiatorInfo(conn, devNode);
            ret.setResult(TaskResult.Result.SUCCESS);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)devNode);
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("execute cmd error.", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            return ret;
        }
        return ret;
    }

    private void matchVInfo(DevNode devNode, String[] verInfo) {
        for (String vInfo : verInfo) {
            if (!vInfo.matches(".*\\d{2}.*")) continue;
            devNode.setProductVersion(vInfo.trim());
            break;
        }
    }

    private String getString(String resultVer, String[] resultVerArray) {
        for (int i = 0; i < resultVerArray.length; ++i) {
            if (!resultVerArray[i].contains("Microsoft")) continue;
            return ("Windows" + resultVerArray[i].split("\\|")[0].trim().replace("?", "").split("Windows")[1]).replace("Serverr", "Server");
        }
        return resultVer;
    }

    public String handleMacToSerialNum(DevNode devNode, String resultMac, String[] resultMacArray) {
        boolean isDealMac = false;
        String actualResultMac = resultMac;
        for (int i = 1; i < resultMacArray.length; ++i) {
            if (!resultMacArray[i].contains(devNode.getIp())) continue;
            actualResultMac = resultMacArray[i].split(" ")[resultMacArray[i].split(" ").length - 1];
            actualResultMac = actualResultMac.trim().replace(":", "");
            isDealMac = true;
            break;
        }
        if (!isDealMac && actualResultMac.length() > 20) {
            String ptn = MAC_MATCH_REGEX;
            Pattern pattern = Pattern.compile(ptn);
            Matcher m = pattern.matcher(actualResultMac);
            boolean isFinded = false;
            if (m.find()) {
                actualResultMac = m.group();
                isFinded = true;
            }
            if (!isFinded) {
                actualResultMac = Base64EncodeUtils.encode((String)devNode.getIp());
            }
        }
        return actualResultMac;
    }

    private void fetchHostInitiatorInfo(ICliConnection conn, DevNode devNode) {
        HostService hostService = HostServiceFactory.createHostService(devNode);
        if (null != hostService) {
            Launcher launcher = hostService.queryWwn(conn, devNode);
            if (null == launcher) {
                LOGGER.error("launcher is null");
                return;
            }
            Future taskFuture = (Future)launcher.getOtherDataMap().get("taskFuture");
            if (null == taskFuture) {
                LOGGER.error("taskFuture is null");
                return;
            }
            try {
                taskFuture.get();
            }
            catch (InterruptedException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("failed to get windows host's HBA card info.", (Throwable)e);
                WwnUtil.setFailedInLauncher(launcher);
            }
            catch (ExecutionException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("failed to get windows host's HBA card info.", (Throwable)e);
                WwnUtil.setFailedInLauncher(launcher);
            }
            List<String> fcWwns = launcher.getFcWwns();
            List<String> iscsiWwns = launcher.getiSCSIWwns();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("current host " + devNode.getDevKey() + " 's wwns:" + launcher.getJsonString());
            }
            if (launcher.getOtherDataMap().get("queryWwnSuccess").toString().equals("unknown")) {
                devNode.setHostFCLauncherWwns(null);
                devNode.setHostISCSILauncherWwns(null);
            } else {
                devNode.setHostFCLauncherWwns(fcWwns);
                devNode.setHostISCSILauncherWwns(iscsiWwns);
            }
        }
    }

    private void makeErrorTaskResult(DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)DEVICE_CANNOT_CONNECT, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeWindowsErrorTaskResult(DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)DEVICE_CANNOT_CONNECT_WIN, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }
}

