/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action.support;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.devicemanager.ui.action.support.MultiInfoDialogParams;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MultiInfoDialog
extends IsmDialog {
    private static final long serialVersionUID = -2587908427263722274L;
    static final String[] DEFAULT_TITLES = new String[]{ResourceUtil.getString((String)"device.importdialog.ip"), ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.reason")};
    static final Dimension DEFAULT_DEMENSION = new Dimension(350, 250);
    private DefaultTableModel errorTableModel = null;
    private IsmTable errTable = null;
    private JButton confirmButton;
    private JButton oKButton;
    private JButton cancelButton;
    private boolean okPerformed = false;
    private boolean isNewWiondw = false;
    private boolean confirmAgain = false;
    private String confirmAgainInfo;

    public MultiInfoDialog(Window parent, String errMsg, String[] titles) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setInfoMsg(errMsg).setTitles(titles).build());
    }

    public MultiInfoDialog(Window parent, boolean newWindow) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setNewWindow(newWindow).build());
    }

    public MultiInfoDialog(Window parent, boolean newWindow, String infoMsg) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setNewWindow(newWindow).setInfoMsg(infoMsg).build());
    }

    public MultiInfoDialog(Window parent, boolean newWindow, String infoMsg, String[] titles) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setNewWindow(newWindow).setInfoMsg(infoMsg).setTitles(titles).build());
    }

    public MultiInfoDialog(Window parent, boolean newWindow, String infoMsg, String[] titles, Dimension preferredDimension) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setNewWindow(newWindow).setInfoMsg(infoMsg).setTitles(titles).setPreferredDimension(preferredDimension).build());
    }

    public MultiInfoDialog(Window parent, String dlgTitle, String infoMsg, String[] titles, String img) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setDlgTitle(dlgTitle).setImg(img).setInfoMsg(infoMsg).setTitles(titles).build());
    }

    public MultiInfoDialog(Window parent, String dlgTitle, String img, boolean newWindow) {
        this(MultiInfoDialogParams.getNewBuilder().setParent(parent).setDlgTitle(dlgTitle).setImg(img).setNewWindow(newWindow).build());
    }

    public MultiInfoDialog(MultiInfoDialogParams multiInfoDialogParams) {
        super(multiInfoDialogParams.getParent());
        int[] tableLinesWidth = multiInfoDialogParams.getTableLinesWidth();
        this.isNewWiondw = multiInfoDialogParams.isNewWindow();
        this.doLayoutPane(multiInfoDialogParams.getInfoMsg(), multiInfoDialogParams.getTitles(), multiInfoDialogParams.getImg(), multiInfoDialogParams.getPreferredDimension(), tableLinesWidth);
        if (multiInfoDialogParams.isConfirmAgain()) {
            this.confirmAgain = multiInfoDialogParams.isConfirmAgain();
            this.confirmAgainInfo = multiInfoDialogParams.getConfirmAgainInfo();
        }
        this.initButtonsBehavior();
        this.setModal(true);
        this.setTitle(multiInfoDialogParams.getDlgTitle());
        this.toFront();
        this.setMinimumSize(DEFAULT_DEMENSION);
        this.setResizable(true);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.pack();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)multiInfoDialogParams.getParent());
    }

    private void initButtonsBehavior() {
        if (this.isNewWiondw) {
            this.addListener();
            this.getRootPane().setDefaultButton(this.oKButton);
            this.oKButton.requestFocus();
        } else {
            this.addEventHandler();
            this.getRootPane().setDefaultButton(this.confirmButton);
            this.confirmButton.requestFocus();
        }
    }

    private void addEventHandler() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiInfoDialog.this.dispose();
            }
        });
    }

    private void addListener() {
        this.oKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiInfoDialog.this.okPerformed = true;
                MultiInfoDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MultiInfoDialog.this.confirmAgain) {
                    String okInfo = ResourceUtil.getString((String)"ssh.adddevice.button.register");
                    String cancelInfo = ResourceUtil.getString((String)"ssh.adddevice.button.unregister");
                    WarningDialog wd = DialogUtils.showYesNoWarningDialog((Window)((Object)MultiInfoDialog.this), (String)MultiInfoDialog.this.confirmAgainInfo, (String)okInfo, (String)cancelInfo, (int)100, (int)100, (boolean)true);
                    if (wd.getValue() == 0) {
                        MultiInfoDialog.this.okPerformed = true;
                        MultiInfoDialog.this.dispose();
                        return;
                    }
                }
                MultiInfoDialog.this.okPerformed = false;
                MultiInfoDialog.this.dispose();
            }
        });
    }

    private void doLayoutPane(String errMsg, String[] titles, String img, Dimension preferredDimension, int[] tableLinesWidth) {
        IsmTextArea displayPrompt = new IsmTextArea();
        displayPrompt.setText(errMsg);
        JLabel imgLabel = new JLabel();
        imgLabel.setIcon(ResourceManager.getImage((String)img));
        this.errorTableModel = new DefaultTableModel(titles, new int[0]);
        this.errTable = new IsmTable((TableModel)this.errorTableModel);
        this.errTable.setSelectionMode(2);
        TableScrollPane scrollPane = new TableScrollPane(this.errTable);
        scrollPane.setPreferredSize(preferredDimension);
        JComponent imgBox = UCD.buildVerticalBox(null, (Component[])new Component[]{imgLabel, Box.createVerticalGlue()});
        JComponent descBox = UCD.buildVerticalBox(null, (Component[])new Component[]{displayPrompt, Box.createVerticalGlue()});
        JComponent topBox = UCD.buildHorizotalBox(null, (Component[])new Component[]{imgBox, descBox});
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.add((Component)topBox, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.setBorder(new EmptyBorder(8, 8, 0, 8));
        this.getContentPane().add(contentPane);
        this.setSeparateLineWidth(tableLinesWidth);
        Dimension size = new Dimension(80, 21);
        if (!this.isNewWiondw) {
            this.confirmButton = new JButton(ResourceUtil.getString((String)"device.importdialog.close"));
            this.confirmButton.setMnemonic('C');
            this.confirmButton.setPreferredSize(size);
            this.getSouthBox().add(this.confirmButton);
        } else {
            this.oKButton = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbutton"));
            this.oKButton.setMnemonic('O');
            this.oKButton.setPreferredSize(new Dimension(90, 25));
            this.cancelButton = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"));
            this.cancelButton.setMnemonic('C');
            this.cancelButton.setPreferredSize(new Dimension(90, 25));
            JPanel bottomJpanel = new JPanel();
            bottomJpanel.setPreferredSize(new Dimension(400, 32));
            Component cancelComp = Box.createHorizontalStrut(200);
            bottomJpanel.add(cancelComp);
            bottomJpanel.add(this.oKButton);
            bottomJpanel.add(this.cancelButton);
            this.getSouthBox().add(bottomJpanel);
        }
    }

    private void setSeparateLineWidth(int[] tableLinesWidth) {
        if (null != tableLinesWidth) {
            TableColumnModel columnModel = this.errTable.getColumnModel();
            Enumeration<TableColumn> columns = columnModel.getColumns();
            for (int index = 0; columns.hasMoreElements() && tableLinesWidth.length > index; ++index) {
                int lineWidthRatioOnIndex = tableLinesWidth[index];
                TableColumn tableColumn = columns.nextElement();
                tableColumn.setPreferredWidth(lineWidthRatioOnIndex);
                tableColumn.setWidth(lineWidthRatioOnIndex);
            }
        }
    }

    public IsmTable getErrTable() {
        return this.errTable;
    }

    public void setErrTable(IsmTable errTable) {
        this.errTable = errTable;
    }

    public DefaultTableModel getTableModel() {
        return this.errorTableModel;
    }

    public boolean isOkPerformed() {
        return this.okPerformed;
    }
}

