/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusioncube;

import cn.hutool.core.bean.BeanUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddFusionCubeLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractAddDeviceLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusioncube.enmus.VersionEnum;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.fusionstorage.AddFusionStorageLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.listener.FusionCubeAddConfirmListener;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.entity.enums.ClusterMode;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FusionCubeAddLayout
extends AbstractAddDeviceLayout {
    private final JLabel versionLabel = new JLabel(ResourceUtil.getString((String)"device.version"));
    private final JLabel deployModeLabel = new JLabel(ResourceUtil.getString((String)"fusionstorage.eval.conn.deploy.desc") + ":");
    private final TitledBorder configBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.titleborder.desc"));
    private final String standbyNodePortName = ResourceUtil.getString((String)"fusionstorage.eval.conn.configinfo.standby.port.desc");
    private final JComponent standbyNodePortLabel = UiMethod.createRequiredLabel((String)(this.standbyNodePortName + ":"), (boolean)true);
    private final String standbyUserNameDesc = ResourceUtil.getString((String)"fusionstorage.eval.conn.username.desc");
    private final JComponent standbyUserNameLabel = UiMethod.createRequiredLabel((String)(this.standbyUserNameDesc + ":"), (boolean)true);
    private final String standbyPwdDesc = ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc");
    private final JComponent standbyPwdLabel = UiMethod.createRequiredLabel((String)(this.standbyPwdDesc + ":"), (boolean)true);
    private final String standbyRootPwdDesc = ResourceUtil.getString((String)"fusionstorage.eval.conn.root.pwd.desc");
    private final JComponent standbyRootPwdLabel = UiMethod.createRequiredLabel((String)(this.standbyRootPwdDesc + ":"), (boolean)true);
    private final JComboBox<ClusterMode> mode = new JComboBox();
    private final IsmTextField standbyPortField = UiMethod.getSshPortFiled();
    protected final IsmTextField standbyUserNameField = UiMethod.getUsernameFiled();
    private final IsmPasswordField standbyPwdField = UiMethod.getPasswordFiled();
    private final IsmPasswordField standbyRootPwdField = UiMethod.getPasswordFiled();
    private final JButton okBtn = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
    private final JButton cancel = new JButton(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"));
    private final JComboBox<VersionEnum> verBox = new JComboBox();
    private AbstractAddDeviceLayout fusionStoragePanel;
    private JComponent fusionInputPanel;
    private DeviceAddFusionCubeLayout cubePanel;
    private JComponent cube6Layout;
    private JComponent standbyConfig;

    public FusionCubeAddLayout(SceneDeviceAddDialog sceneDeviceAddDialog) {
        this.parentDialog = sceneDeviceAddDialog;
        this.initData();
        this.initComponent();
    }

    private void initData() {
        this.mode.addItem(ClusterMode.DOUBLE);
        this.mode.addItem(ClusterMode.SINGLE);
        this.verBox.addItem(VersionEnum.FUSION_CUBE_3);
        this.verBox.addItem(VersionEnum.FUSION_CUBE_6);
        this.verBox.setSelectedIndex(0);
        NotEmptyInputValidator notEmptyInputValidator = new NotEmptyInputValidator();
        this.standbyPortField.addInputValidator((InputValidator)notEmptyInputValidator);
        this.standbyPortField.setInputValueName(this.standbyNodePortName);
        this.standbyUserNameField.addInputValidator((InputValidator)notEmptyInputValidator);
        this.standbyUserNameField.setInputValueName(this.standbyUserNameDesc);
        this.standbyPwdField.addInputValidator((InputValidator)notEmptyInputValidator);
        this.standbyPwdField.setInputValueName(this.standbyPwdDesc);
        this.standbyRootPwdField.addInputValidator((InputValidator)notEmptyInputValidator);
        this.standbyRootPwdField.setInputValueName(this.standbyRootPwdDesc);
    }

    private void initComponent() {
        this.buildPriStandbyPanel();
        UCD.setSameWidth((JComponent[])new JComponent[]{this.mode, this.verBox});
        UCD.setSameWidth((JComponent[])new JComponent[]{this.versionLabel, this.deployModeLabel});
        Box versionBox = UCD.buildHBoxLeft((Component[])new Component[]{this.versionLabel, this.verBox});
        Box deployScene = UCD.buildHBoxLeft((Component[])new Component[]{this.deployModeLabel, this.mode});
        JPanel cubeInputPanel = this.buildCubePanel();
        this.standbyConfig = this.initStandbyConfig();
        if (LanguageManager.isEnglish()) {
            UCD.setSameWidth((int)450, (JComponent[])new JComponent[]{this.fusionInputPanel, deployScene, cubeInputPanel, this.standbyConfig});
        } else {
            UCD.setSameWidth((int)415, (JComponent[])new JComponent[]{this.fusionInputPanel, deployScene, cubeInputPanel, this.standbyConfig});
        }
        JComponent bottomPanel = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancel, Box.createHorizontalStrut(0)}), Box.createHorizontalStrut(0)});
        this.cube6Layout = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{deployScene, cubeInputPanel, this.standbyConfig, bottomPanel});
        this.cube6Layout.setVisible(false);
        this.fusionInputPanel.setVisible(true);
        JComponent view = UCD.buildVerticalBox(null, (int)2, (Component[])new Component[]{versionBox, this.cube6Layout, this.fusionInputPanel});
        this.add(view);
    }

    private JPanel buildCubePanel() {
        this.cubePanel = new DeviceAddFusionCubeLayout(this.parentDialog);
        this.cubePanel.getSshUsername().setText("fc2omm");
        this.cubePanel.getPasswordCheckInputs().addAll(Arrays.asList(this.standbyPwdField, this.standbyRootPwdField));
        return this.cubePanel.getConfigPanel();
    }

    private void buildPriStandbyPanel() {
        AddFusionStorageLayout addFusionStorageLayout = new AddFusionStorageLayout(this.parentDialog);
        addFusionStorageLayout.setItDeviceType(ItDeviceType.FUSIONCUBE);
        this.fusionStoragePanel = addFusionStorageLayout;
        this.fusionInputPanel = addFusionStorageLayout.getInputPanel();
    }

    private JComponent initStandbyConfig() {
        this.standbyPortField.setText("22");
        this.standbyUserNameField.setText("fc2omm");
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.standbyNodePortLabel, this.standbyPortField, this.standbyUserNameLabel, this.standbyUserNameField, this.standbyRootPwdLabel, this.standbyRootPwdField, this.standbyPwdLabel});
        if (LanguageManager.isEnglish()) {
            UiMethod.setComponentSize((Dimension)new Dimension(220, 21), (Component[])new Component[]{this.standbyNodePortLabel, this.standbyPortField, this.standbyUserNameLabel, this.standbyUserNameField, this.standbyRootPwdLabel, this.standbyRootPwdField, this.standbyPwdLabel, this.standbyPwdField});
        } else {
            UiMethod.setComponentSize((Dimension)new Dimension(160, 21), (Component[])new Component[]{this.standbyNodePortLabel, this.standbyPortField, this.standbyUserNameLabel, this.standbyUserNameField, this.standbyRootPwdLabel, this.standbyRootPwdField, this.standbyPwdLabel, this.standbyPwdField});
        }
        return UCD.buildVerticalBox((Border)this.configBorder, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.standbyNodePortLabel, this.standbyPortField})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.standbyUserNameLabel, this.standbyUserNameField})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.standbyPwdLabel, this.standbyPwdField})})}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHorizotalBox(null, (Component[])new Component[]{this.standbyRootPwdLabel, this.standbyRootPwdField})})})});
    }

    @Override
    public void bindListener() {
        this.verBox.addItemListener(e -> {
            if (VersionEnum.FUSION_CUBE_6.equals(this.verBox.getSelectedItem())) {
                this.fusionInputPanel.setVisible(false);
                this.cube6Layout.setVisible(true);
            }
            if (VersionEnum.FUSION_CUBE_3.equals(this.verBox.getSelectedItem())) {
                this.fusionInputPanel.setVisible(true);
                this.cube6Layout.setVisible(false);
            }
        });
        this.fusionStoragePanel.bindListener();
        this.okBtn.addActionListener(new FusionCubeAddConfirmListener(this.parentDialog, this));
        this.cancel.addActionListener(e -> this.parentDialog.dispose());
        this.mode.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                boolean showStandbyInfo = !ClusterMode.SINGLE.equals(event.getItem());
                this.standbyConfig.setVisible(showStandbyInfo);
                this.standbyPortField.setVisible(showStandbyInfo);
                this.standbyUserNameField.setVisible(showStandbyInfo);
                this.standbyPwdField.setVisible(showStandbyInfo);
                this.standbyRootPwdField.setVisible(showStandbyInfo);
            }
        });
    }

    @Override
    public JButton getDefaultButton() {
        if (this.fusionInputPanel.isVisible()) {
            return this.fusionStoragePanel.getDefaultButton();
        }
        return this.okBtn;
    }

    public FsDevNode createFusionCubeDev() {
        DevNode fusionCubeDev = this.cubePanel.createFusionCubeDev();
        FsDevNode fsDevNode = new FsDevNode();
        BeanUtil.copyProperties((Object)fusionCubeDev, (Object)fsDevNode, (String[])new String[0]);
        fsDevNode.setHaModel((ClusterMode)this.mode.getSelectedItem());
        if (ClusterMode.DOUBLE.equals(this.mode.getSelectedItem())) {
            FsDevNode standBy = new FsDevNode();
            standBy.setLoginUser(new User(this.standbyUserNameField.getText(), String.valueOf(this.standbyPwdField.getPassword())));
            standBy.setRootUser(new User("root", Base64EncodeUtils.encode((String)String.valueOf(this.standbyRootPwdField.getPassword()))));
            fsDevNode.setStandbyDevNode(standBy);
        }
        return fsDevNode;
    }

    public List<IsmTextField> getStandbyTextInputs() {
        return Arrays.asList(this.standbyPortField, this.standbyUserNameField);
    }

    public DeviceAddFusionCubeLayout getCubePanel() {
        return this.cubePanel;
    }
}

