/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetTooolSupportList {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GetTooolSupportList.class);
    private static final String MAIM_SCENE_ID_NODE = "mainScene";
    private static final String SCENE_ID_NODE = "scene";
    private static final String RELATIVE_PATH_NODE = "cfgPath";
    private static final String PRODUCTE_NODE = "product";
    private static final String PRODUCT_NAME_NODE = "productname";
    private static final String SUPPORT_TYPE_NODE = "supporttypes";
    private static final String ID = "id";
    private static String configScenePath;
    private static String neededMainSceneID;
    private static String relativePath;
    private static String neededSceneID;
    private static String scenePath;
    private Element root = null;
    private boolean isFailed = false;

    public static String getConfigScenePath() {
        return configScenePath;
    }

    public static void setConfigScenePath(String configScenePath) {
        GetTooolSupportList.configScenePath = configScenePath;
    }

    public static String getNeededMainSceneID() {
        return neededMainSceneID;
    }

    public static void setNeededMainSceneID(String neededMainSceneID) {
        GetTooolSupportList.neededMainSceneID = neededMainSceneID;
    }

    public static String getNeededSceneID() {
        return neededSceneID;
    }

    public static void setNeededSceneID(String neededSceneID) {
        GetTooolSupportList.neededSceneID = neededSceneID;
    }

    public GetTooolSupportList(String scenePath, String mainSceneID, String sceneID) {
        GetTooolSupportList.setConfigScenePath(scenePath);
        GetTooolSupportList.setNeededMainSceneID(mainSceneID);
        GetTooolSupportList.setNeededSceneID(sceneID);
        this.initDocument(configScenePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDocument(String path) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(FilePathUtils.filterPath((String)path));
            Document document = XmlUtils.parseDocument((InputStream)in);
            this.root = document.getDocumentElement();
        }
        catch (Exception e) {
            try {
                this.isFailed = true;
                LOGGER.error("There is error path : " + path, (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, in);
                throw throwable;
            }
            StreamUtils.closeStream(null, (InputStream)in);
        }
        StreamUtils.closeStream(null, (InputStream)in);
    }

    public Map<String, ArrayList<String>> parse() {
        KeyOrderedHashMap infos = new KeyOrderedHashMap();
        if (null == this.root) {
            return infos;
        }
        Collection mainScenes = XmlUtils.getChildren((Element)this.root, (String)MAIM_SCENE_ID_NODE);
        for (Element mainScene : mainScenes) {
            String mainSceneID = mainScene.getAttribute(ID);
            if (!mainSceneID.equals(neededMainSceneID)) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The same mainSceneID : " + neededSceneID);
            }
            this.matchScenes(mainScene, (Map<String, ArrayList<String>>)infos);
        }
        return infos;
    }

    private Map<String, ArrayList<String>> matchScenes(Element mainScene, Map<String, ArrayList<String>> infos) {
        Collection scenes = XmlUtils.getChildren((Element)mainScene, (String)SCENE_ID_NODE);
        for (Element scene : scenes) {
            String sceneID = scene.getAttribute(ID);
            if (!sceneID.equals(neededSceneID)) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The same sceneID : " + neededSceneID);
            }
            this.getProductInfo(scene, infos);
        }
        return infos;
    }

    private Map<String, ArrayList<String>> getProductInfo(Element scene, Map<String, ArrayList<String>> infos) {
        Element path = XmlUtils.getChild((Element)scene, (String)RELATIVE_PATH_NODE);
        relativePath = path.getFirstChild().getTextContent();
        scenePath = this.getScenePath(relativePath);
        this.initDocument(scenePath);
        if (this.isFailed) {
            return infos;
        }
        Collection products = XmlUtils.getChildren((Element)this.root, (String)PRODUCTE_NODE);
        for (Element product : products) {
            this.parseProduct(product, infos);
        }
        return infos;
    }

    private String getScenePath(String scenePathStr) {
        File file = new File(configScenePath);
        String resultPath = file.getParent();
        resultPath = resultPath + File.separator + scenePathStr;
        return resultPath;
    }

    private void parseProduct(Element product, Map<String, ArrayList<String>> infos) {
        String[] supportTypes;
        Element modelNode = XmlUtils.getChild((Element)product, (String)PRODUCT_NAME_NODE);
        String model = modelNode.getFirstChild().getTextContent();
        Element supportNode = XmlUtils.getChild((Element)product, (String)SUPPORT_TYPE_NODE);
        String supports = supportNode.getFirstChild().getTextContent();
        ArrayList<String> support = new ArrayList<String>();
        for (String type : supportTypes = supports.split(",")) {
            support.add(type.trim());
        }
        infos.put(model, support);
    }
}

