/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.listener.verify;

import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialog;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.A800SelectVerifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.CertSceneMultiChooseVerifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.CubeSelectVerifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.NodeNotConfiguredVerifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.OmAuthVerifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.Verifier;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.ZoneAuthVerifier;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneDeviceSelectVerifyUtil {
    private static final Logger log = LoggerFactory.getLogger(SceneDeviceSelectVerifyUtil.class);
    private static final List<Verifier> VERIFIERS = new ArrayList<Verifier>();

    public static VerifyResult verify(List<DevNode> selectNodes, ScenePreparedMainJDialog dialog) {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        log.info("start scene verify, current scene :{}", (Object)sceneJson);
        return VERIFIERS.stream().map(verifier -> verifier.verify((JDialog)dialog, sceneJson, selectNodes)).filter(result -> !result.isVerifySuccess()).findFirst().orElseGet(VerifyResult::new);
    }

    static {
        VERIFIERS.add(new CertSceneMultiChooseVerifier());
        VERIFIERS.add(new NodeNotConfiguredVerifier());
        VERIFIERS.add(new CubeSelectVerifier());
        VERIFIERS.add(new ZoneAuthVerifier());
        VERIFIERS.add(new OmAuthVerifier());
        VERIFIERS.add(new A800SelectVerifier());
    }
}

