/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.cert.auth;

import com.huawei.ism.tool.cert.auth.CertUtil;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;

public class MyTrustManager
implements X509TrustManager {
    private static final int BASE64 = 64;
    private static final Logger logger = ToolLoggerFactory.getLogger(MyTrustManager.class);
    private X509Certificate certificateFromFile;
    private String ip;
    private String crlPath;
    private boolean checkCrl;

    public MyTrustManager(X509Certificate certificateFromFile) {
        this.certificateFromFile = certificateFromFile;
    }

    public MyTrustManager(X509Certificate certificateFromFile, String ip, boolean checkCrl, String crlPath) {
        this(certificateFromFile);
        this.ip = ip;
        this.checkCrl = checkCrl;
        this.crlPath = crlPath;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkServerTrusted(X509Certificate[] deviceCerts, String authType) throws CertificateException {
        boolean findone = false;
        for (int i = 0; i < deviceCerts.length; ++i) {
            X509Certificate cert = deviceCerts[i];
            try {
                findone = this.recheckUsingTheOldPemCert(cert);
                if (this.checkCrl) {
                    boolean bl = findone = findone && !this.isInCrl(cert);
                }
                if (!findone) {
                    findone = CertUtil.isValid(cert, this.certificateFromFile);
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                logger.error("Error when check.", e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Error when check.", e);
            }
            catch (NoSuchProviderException e) {
                logger.error("Error when check.", e);
            }
            if (!findone) continue;
            return;
        }
        throw new CertificateException("Not find matched certificate.");
    }

    private boolean recheckUsingTheOldPemCert(X509Certificate deviceCertFromSocket) throws CertificateEncodingException {
        Base64 encoder = new Base64(64);
        String pemCertPre = new String(encoder.encode(deviceCertFromSocket.getEncoded()), Charset.defaultCharset());
        String pemCertFromDevice = "-----BEGIN CERTIFICATE-----\n" + pemCertPre + "-----END CERTIFICATE-----";
        return CertUtil.isValidCert(pemCertFromDevice);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] ax509certificate, String authType) throws CertificateException {
    }

    public boolean isInCrl(X509Certificate cert) {
        if (this.ip == null || cert == null) {
            return false;
        }
        File file = new File(this.crlPath);
        if (!file.exists()) {
            logger.info("Not get the crl file. {} on {}", (Object)this.ip, (Object)this.crlPath);
            return false;
        }
        X509CRL crl = CertUtil.getCrl(this.crlPath);
        return CertUtil.isInCrl(cert, crl);
    }
}

