/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.mail.auth;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.mail.auth.CertUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;

public class MyTrustManager
implements X509TrustManager {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MyTrustManager.class);
    private X509Certificate certificateFromFile;

    public MyTrustManager(X509Certificate certificateFromFile) {
        this.certificateFromFile = certificateFromFile;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkServerTrusted(X509Certificate[] deviceCerts, String authType) throws CertificateException {
        boolean findone = false;
        for (int i = 0; i < deviceCerts.length; ++i) {
            X509Certificate cert = deviceCerts[i];
            try {
                findone = CertUtil.isValid(cert, this.certificateFromFile);
                LOGGER.info("findone result:{}", (Object)findone);
            }
            catch (InvalidAlgorithmParameterException e) {
                LOGGER.error("Error when check.");
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("Error when check.");
            }
            catch (NoSuchProviderException e) {
                LOGGER.error("Error when check.");
            }
            if (!findone) continue;
            return;
        }
        throw new CertificateException("Not find matched certificate.");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] ax509certificate, String authType) throws CertificateException {
    }
}

