/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.pubservice.entity.DevNodeCommon;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.SwitchNode;
import com.huawei.ism.tool.obase.entity.SwitchPort;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.entity.VersionAndModelInfo;
import com.huawei.ism.tool.obase.entity.json.DeviceTypeSerializer;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import utils.Products;

public class DevNode
extends DevNodeCommon
implements Cloneable,
Serializable {
    public static final String META_VISION = "MetaVision";
    private static final long serialVersionUID = -1935711444152552935L;
    private static final int NUM_171 = 171;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DevNode.class);
    private static final int DEFAULT_PORT = 22;
    private static final String DEFAULT_REDFISH_PORT = "443";
    private static final int DEFAULT_TLV_PORT = 8080;
    private Socks5Proxy socks5Proxy;
    private String productVersion = "";
    private String productModel = "";
    private String hotPatchVersion = "";
    private String distributedHotPatchVersion = "";
    private String deviceName = "";
    private String deviceSerialNumber = "";
    private String deviceNodeIds = null;
    private boolean miniSystem = false;
    private boolean isSandboxOpen = false;
    private boolean upgrade = false;
    private List<ClusterNode> clusterNodes;
    private List<String> selectedNodeIps = new ArrayList<String>();
    private User rootUser = null;
    private User kAdminUser;
    private User metaVisionUser;
    private String preCheckModel = "";
    private List<String> zoneIds;
    private String executeZoneIp;
    private ComputeStorageDevNode computeStorageDevNode = null;
    private String deviceModel = null;
    private String migrType = null;
    private boolean isSudoGrab = false;
    private String productSubModel = "";
    private String productSubVersion = "";
    private User fusionCubeLoginUser = null;
    private User clientUser;
    private User fusionCubeUser = null;
    private int fusionCubeSSHPort = 22;
    private User a3000LoginUser = null;
    private boolean isSnFail = true;
    private boolean isVerifyCertificate = false;
    private String containerVersion = "";
    private boolean isSupportedContainer = false;
    private boolean isSshqueue = false;
    private VersionAndModelInfo storageVersionInfo;
    private Map<String, Object> miniSystemProperties = new HashMap<String, Object>();
    private boolean ipListAreInnerIp = false;
    private String ip = "";
    private ItDeviceType itDeviceType = ItDeviceType.Storage;
    private String unSupportSign = "^";
    private DeviceType devTypeLevel2 = null;
    private String peerIp = "";
    private String uuid = StringUtils.getNoStripUUID();
    private int port = 22;
    private String redFishPort = "443";
    private int tlvPort = 8080;
    @JSONField(serializeUsing=DeviceTypeSerializer.class, deserializeUsing=DeviceTypeSerializer.class)
    private DeviceType deviceType = null;
    private String oemModel = null;
    private String brand = null;
    private String vendor = null;
    private User loginUser = null;
    private List<MultiRouteNode> sshForwardList;
    private String developerPwd = "";
    private long createTime = System.currentTimeMillis();
    private long devCurrentTime = System.currentTimeMillis();
    private List<String> ipList = new ArrayList<String>();
    private String matchType = "";
    private String sshName = "";
    private PriKeyInfo priKey;
    private String uid = "";
    private String errorDecs = "";
    private String devKey;
    private String ultraPathVersion = "";
    private String ultraPathVRVersion = "";
    private String dbName = "";
    private boolean useJdbc;
    private List<String> remoteSNs = null;
    private boolean hyperMetroHost = false;
    private Map<String, String> relatedSNIPs = null;
    private List<Object> hostInfo = new ArrayList<Object>();
    private List<String> hostFCLauncherWwns = new ArrayList<String>();
    private List<String> hostISCSILauncherWwns = new ArrayList<String>();
    private List<String> hostIbLauncherWwns = new ArrayList<String>();
    private List<String> hostNvmeLauncherWwns = new ArrayList<String>();
    private ConcurrentHashMap<String, HashMap<String, Object>> allStrgHyprMtrLns = new ConcurrentHashMap();
    private List<FusionStorStoragePool> storagePools = new ArrayList<FusionStorStoragePool>();
    private List<FusionStorDiskInfo> allDiskInfo = new ArrayList<FusionStorDiskInfo>();
    private ClusterNode.BaseBoardType baseBoardType;
    private boolean isOnlySecurityAlgorithm = false;
    private String taskId = "";
    private String scenarioInfo;
    private Set<SwitchNode> switchNodes = new HashSet<SwitchNode>();

    public User getRootUser() {
        return this.rootUser;
    }

    public String getProductModel() {
        return this.productModel;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public void setRootUser(User rootUser) {
        this.rootUser = rootUser;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    public long getDevCurrentTime() {
        return this.devCurrentTime;
    }

    public void setDevCurrentTime(long devCurrentTime) {
        this.devCurrentTime = devCurrentTime;
    }

    public void setDevKey(String devKey) {
        this.devKey = devKey;
    }

    public String getErrorDecs() {
        return this.errorDecs;
    }

    public void setErrorDecs(String errorDecs) {
        this.errorDecs = errorDecs;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public String getOemModel() {
        return this.oemModel;
    }

    public void setOemModel(String oemModel) {
        this.oemModel = oemModel;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public User getLoginUser() {
        return this.loginUser;
    }

    public ItDeviceType getItDeviceType() {
        return this.itDeviceType;
    }

    public void setItDeviceType(ItDeviceType itDeviceType) {
        this.itDeviceType = itDeviceType;
    }

    public void setLoginUser(User loginUser) {
        this.loginUser = loginUser;
    }

    public String getIp() {
        return this.ip;
    }

    @Deprecated
    public boolean isDsStorage() {
        return "DStorage".equalsIgnoreCase(this.getItDeviceType().getName()) || this.isFusionCube() || this.isA3000() || this.isA800DpcOm();
    }

    public boolean isRealDsStorage() {
        return ItDeviceType.DStorage.getName().equalsIgnoreCase(this.getItDeviceType().getName()) || this.isFusionCube();
    }

    public boolean isLikeDsStorage() {
        return this.isRealDsStorage() || this.isA3000() || this.isA800DpcOm() || this.is2910V7();
    }

    public boolean isMetaVision() {
        return META_VISION.equals(this.productModel);
    }

    public DeviceType getDevTypeLevel2() {
        return this.devTypeLevel2;
    }

    public void setDevTypeLevel2(DeviceType devTypeLevel2) {
        this.devTypeLevel2 = devTypeLevel2;
    }

    public void setIp(String ip1) {
        if (null != ip1) {
            ip1 = ip1.trim();
        }
        this.ip = ip1;
    }

    public List<ClusterNode> getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterNodes(List<ClusterNode> clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public void setDeviceSerialNumber(String deviceSerialNumber) {
        this.deviceSerialNumber = deviceSerialNumber;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getHotPatchVersion() {
        return this.hotPatchVersion;
    }

    public void setHotPatchVersion(String hotPatchVersion) {
        this.hotPatchVersion = hotPatchVersion;
    }

    public List<MultiRouteNode> getSshForwardList() {
        return this.sshForwardList;
    }

    public void setSshForwardList(List<MultiRouteNode> sshForwardList) {
        this.sshForwardList = sshForwardList;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public PriKeyInfo getPriKey() {
        return this.priKey;
    }

    public void setPriKey(PriKeyInfo priKey) {
        this.priKey = priKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DevNode) {
            DevNode devNode = (DevNode)obj;
            String snNumber = this.getDeviceSerialNumber() == null ? "" : this.getDeviceSerialNumber();
            DeviceType type = this.getDeviceType() == null ? DeviceType.ALL : this.getDeviceType();
            boolean snSame = snNumber.equals(devNode.getDeviceSerialNumber());
            boolean typeSame = type.equals(devNode.getDeviceType());
            if (!typeSame) {
                boolean bl = typeSame = DeviceTypeUtil.isHVS(devNode.getDeviceType()) && DeviceTypeUtil.isHVS(this.getDeviceType());
            }
            if (this.isDsStorage() && devNode.getIp().equalsIgnoreCase(this.ip) && devNode.getDeviceSerialNumber().equalsIgnoreCase(this.deviceSerialNumber) && devNode.getTaskId().equals(this.taskId)) {
                return true;
            }
            return snSame && typeSame;
        }
        return false;
    }

    public String getUnSupportSign() {
        return this.unSupportSign;
    }

    public void setUnSupportSign(String unSupportSign) {
        this.unSupportSign = unSupportSign;
    }

    public int hashCode() {
        String snNumber = this.getDeviceSerialNumber() == null ? "" : this.getDeviceSerialNumber();
        DeviceType type = this.getDeviceType() == null ? DeviceType.ALL : this.getDeviceType();
        return 171 + 3 * snNumber.hashCode() + 7 * type.hashCode() + 5 * this.taskId.hashCode();
    }

    public String toString() {
        return "DevNode [deviceName=" + this.deviceName + ", storageDeviceType =" + this.getStorageDeviceType() + ", deviceSerialNumber=" + this.deviceSerialNumber + ", deviceType=" + this.deviceType + ", ip=" + this.ip + ", loginUser=" + this.loginUser + ", port=" + this.port + ", productVersion=" + this.productVersion + ", socks5Proxy=" + this.socks5Proxy + ", sshForwardList=" + this.sshForwardList + ",uuid=" + this.uuid + ",peerIP=" + this.peerIp + "] compute storage dev node:" + this.computeStorageDevNode;
    }

    public boolean isNotSshForward() {
        return null == this.sshForwardList || this.sshForwardList.isEmpty();
    }

    public boolean isNotSocks5Proxy() {
        return null == this.socks5Proxy || StringUtils.isNULLStr(this.socks5Proxy.getServerIp());
    }

    public Socks5Proxy getSocks5Proxy() {
        return this.socks5Proxy;
    }

    public void setSocks5Proxy(Socks5Proxy socks5Proxy) {
        this.socks5Proxy = socks5Proxy;
    }

    public void setPeerIp(String peerIp) {
        this.peerIp = peerIp;
    }

    public String getPeerIp() {
        return this.peerIp;
    }

    public String getDeveloperPwd() {
        return AESEncrypt.decrypt((String)this.developerPwd);
    }

    public void setDeveloperPwd(String developerPwd) {
        this.developerPwd = AESEncrypt.encrypt((String)developerPwd);
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    public void addIp(String ipAddr) {
        this.ipList.add(ipAddr);
    }

    public List<String> getIpList() {
        ArrayList<String> ips = new ArrayList<String>(this.ipList);
        if (ips.isEmpty()) {
            ips.add(this.ip);
        }
        return ips;
    }

    public void setActiveIp(String ipAddr) {
        if (this.ipList.contains(ipAddr)) {
            this.ipList.remove(ipAddr);
            this.ipList.add(0, ipAddr);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DevNode newNode = (DevNode)super.clone();
        if (null != this.loginUser) {
            newNode.loginUser = (User)this.loginUser.clone();
        }
        if (null != this.socks5Proxy) {
            newNode.socks5Proxy = (Socks5Proxy)this.socks5Proxy.clone();
        }
        newNode.ipList = new ArrayList<String>();
        newNode.ipList.addAll(this.ipList);
        newNode.sshForwardList = null;
        if (null != this.sshForwardList) {
            newNode.sshForwardList = new ArrayList<MultiRouteNode>();
            for (MultiRouteNode sshNode : this.sshForwardList) {
                newNode.sshForwardList.add((MultiRouteNode)sshNode.clone());
            }
        }
        return newNode;
    }

    public String getMatchType() {
        return this.matchType;
    }

    public void setMatchType(String matchType) {
        this.matchType = matchType;
    }

    public String getSshName() {
        return this.sshName;
    }

    public void setSshName(String sshName) {
        this.sshName = sshName;
    }

    public int getTlvPort() {
        return this.tlvPort;
    }

    public void setTlvPort(int tlvPort) {
        this.tlvPort = tlvPort;
    }

    public boolean isIpListAreInnerIp() {
        return this.ipListAreInnerIp;
    }

    public void setIpListAreInnerIp(boolean ipListAreInnerIp) {
        this.ipListAreInnerIp = ipListAreInnerIp;
    }

    public boolean isMiniSystem() {
        return this.miniSystem;
    }

    public void setMiniSystem(boolean miniSystem) {
        this.miniSystem = miniSystem;
    }

    public String getDeviceNodeIds() {
        return this.deviceNodeIds;
    }

    public void setDeviceNodeIds(String deviceNodeIds) {
        this.deviceNodeIds = deviceNodeIds;
    }

    public Map<String, Object> getMiniSystemProperties() {
        return this.miniSystemProperties;
    }

    public void setMiniSystemProperties(Map<String, Object> miniSystemProperties) {
        this.miniSystemProperties = miniSystemProperties;
    }

    public String getUid() {
        return StringUtils.isNULLStr(this.uid) ? this.ip : this.uid;
    }

    public void setUid() {
        if (null != this.socks5Proxy) {
            this.uid = this.ip + "(" + this.socks5Proxy.getName() + ")";
            return;
        }
        if (!StringUtils.isNULLStr(this.sshName)) {
            this.uid = this.ip + "(" + this.sshName + ")";
            return;
        }
    }

    public String getDevKey() {
        if (StringUtils.isNULLStr(this.devKey)) {
            this.devKey = this.getAddressKey();
        }
        return this.devKey;
    }

    public String getCurLoginUser() {
        User user = SshConnectionManager.getDevRUser(this.getDevKey());
        if (user != null) {
            return user.getUserName();
        }
        return this.loginUser == null ? "" : this.loginUser.getUserName();
    }

    private String getAddressKey() {
        StringBuilder snSb = new StringBuilder(this.ip);
        if (this.sshForwardList != null) {
            for (MultiRouteNode node : this.sshForwardList) {
                snSb.append(node.getHost());
            }
        }
        if (null != this.socks5Proxy) {
            snSb.append(this.socks5Proxy.getServerIp());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(" use value:" + com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)snSb.toString()));
        }
        return snSb.toString();
    }

    public String getRealPeerIp() {
        String pIp = this.peerIp;
        if (null == this.peerIp || "".equals(this.peerIp)) {
            String secondaryIP = "";
            for (String ips : this.getIpList()) {
                if (!ips.endsWith("101")) continue;
                secondaryIP = ips;
            }
            pIp = secondaryIP;
        }
        return pIp;
    }

    public List<String> getSelectClusterNodeIds() {
        if (this.clusterNodes != null) {
            return this.clusterNodes.stream().filter(ClusterNode::isSelected).map(nodeSelected -> nodeSelected.getId() + "").collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<Integer> getSelectClusterNodeIntIds() {
        return CollectionUtils.emptyIfNull(this.clusterNodes).stream().filter(ClusterNode::isSelected).map(ClusterNode::getId).collect(Collectors.toList());
    }

    public List<Integer> getAllClusterNodeIds() {
        if (this.clusterNodes != null) {
            return this.clusterNodes.stream().map(ClusterNode::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getUltraPathVersion() {
        return this.ultraPathVersion;
    }

    public void setUltraPathVersion(String ultraPathVersion) {
        this.ultraPathVersion = ultraPathVersion;
    }

    public String getUltraPathVRVersion() {
        return this.ultraPathVRVersion;
    }

    public void setUltraPathVRVersion(String ultraPathVRVersion) {
        this.ultraPathVRVersion = ultraPathVRVersion;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public boolean isUseJdbc() {
        return this.useJdbc;
    }

    public void setUseJdbc(boolean useJdbc) {
        this.useJdbc = useJdbc;
    }

    public List<String> getRemoteSNs() {
        return this.remoteSNs;
    }

    public void setRemoteSNs(List<String> remoteSNs) {
        this.remoteSNs = remoteSNs;
    }

    public Map<String, String> getRelatedSNIPs() {
        return this.relatedSNIPs;
    }

    public void setRelatedSNIPs(Map<String, String> relatedSNIPs) {
        this.relatedSNIPs = relatedSNIPs;
    }

    public boolean isHyperMetro() {
        return null != this.remoteSNs && !this.remoteSNs.isEmpty();
    }

    public List<Object> getHostInfo() {
        return this.hostInfo;
    }

    public void setHostInfo(List<Object> hostInfo) {
        this.hostInfo = hostInfo;
    }

    public ConcurrentHashMap<String, HashMap<String, Object>> getAllStrgHyprMtrLns() {
        return this.allStrgHyprMtrLns;
    }

    public void setAllStrgHyprMtrLns(ConcurrentHashMap<String, HashMap<String, Object>> allStrgHyprMtrLns) {
        this.allStrgHyprMtrLns = allStrgHyprMtrLns;
    }

    public List<String> getHostISCSILauncherWwns() {
        return this.hostISCSILauncherWwns;
    }

    public void setHostISCSILauncherWwns(List<String> hostISCSILauncherWwns) {
        this.hostISCSILauncherWwns = hostISCSILauncherWwns;
    }

    public List<String> getHostFCLauncherWwns() {
        return this.hostFCLauncherWwns;
    }

    public void setHostFCLauncherWwns(List<String> hostFCLauncherWwns) {
        this.hostFCLauncherWwns = hostFCLauncherWwns;
    }

    public List<String> getHostIbLauncherWwns() {
        return this.hostIbLauncherWwns;
    }

    public void setHostIbLauncherWwns(List<String> hostIbLauncherWwns) {
        this.hostIbLauncherWwns = hostIbLauncherWwns;
    }

    public List<String> getHostNvmeLauncherWwns() {
        return this.hostNvmeLauncherWwns;
    }

    public void setHostNvmeLauncherWwns(List<String> hostNvmeLauncherWwns) {
        this.hostNvmeLauncherWwns = hostNvmeLauncherWwns;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getMigrType() {
        return this.migrType;
    }

    public void setMigrType(String migrType) {
        this.migrType = migrType;
    }

    public boolean isHyperMetroHost() {
        return this.hyperMetroHost;
    }

    public void setHyperMetroHost(boolean hyperMetroHost) {
        this.hyperMetroHost = hyperMetroHost;
    }

    public boolean isSudoGrab() {
        return this.isSudoGrab;
    }

    public void setSudoGrab(boolean sudoGrab) {
        this.isSudoGrab = sudoGrab;
    }

    public String getRedFishPort() {
        return this.redFishPort;
    }

    public void setRedFishPort(String redFishPort) {
        this.redFishPort = redFishPort;
    }

    public List<FusionStorStoragePool> getStoragePools() {
        return this.storagePools;
    }

    public List<FusionStorDiskInfo> getAllDiskInfo() {
        return this.allDiskInfo;
    }

    public boolean isPacificNode() {
        return this.baseBoardType == ClusterNode.BaseBoardType.PACIFIC;
    }

    public boolean isEastSeaNode() {
        return this.baseBoardType == ClusterNode.BaseBoardType.DH_SERVER;
    }

    public boolean isEastSeaSingleNode() {
        return this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_SINGLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isEastSeaDoubleNode() {
        return this.baseBoardType == ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_SINGLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isEastSeaSingleProcessor() {
        return this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_SINGLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_SINGLE_PROCESSOR;
    }

    public boolean isEastSeaDoubleProcessor() {
        return this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054 || this.baseBoardType == ClusterNode.BaseBoardType.DH_DOUBLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public boolean isEastSeaSingleNodeDualProcessor() {
        return this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR || this.baseBoardType == ClusterNode.BaseBoardType.DH_SINGLE_SERVER_DOUBLE_PROCESSOR_8054;
    }

    public void setBaseBoardType(String baseBoardType) {
        ClusterNode.BaseBoardType.mappingEnum(baseBoardType).ifPresent(type -> {
            this.baseBoardType = type;
        });
    }

    public void setBaseBoardTypeByDevType(String devType) {
        ClusterNode.BaseBoardType.mappingEnumByType(devType).ifPresent(type -> {
            this.baseBoardType = type;
        });
    }

    public void setProductSubModel(String productSubModel) {
        this.productSubModel = productSubModel;
    }

    public String getProductSubModel() {
        return this.productSubModel;
    }

    public void setProductSubVersion(String productSubVersion) {
        this.productSubVersion = productSubVersion;
    }

    public String getProductSubVersion() {
        return this.productSubVersion;
    }

    public String getDisplayProductVersion() {
        if (!StringUtils.isNULLStr(this.productSubVersion)) {
            return this.productSubVersion;
        }
        return this.productVersion;
    }

    public boolean isFusionCube() {
        return ItDeviceType.FUSIONCUBE.equals((Object)this.itDeviceType) || ItDeviceType.FUSIONCUBE.getName().equals(this.productSubModel);
    }

    public boolean isA3000() {
        return ItDeviceType.A3000.equals((Object)this.itDeviceType) || ItDeviceType.A3000.getName().equals(this.productSubModel);
    }

    public boolean is2910V7() {
        return this.is2910() && Products.compareVersion(this.productVersion, "V700R001C00") >= 0 && EntityUtils.isComputeStorageDevLoginThroughFcv(this);
    }

    private boolean is2910() {
        return ItDeviceType.OCEANSTOR_2910.getName().equals(this.productModel) || META_VISION.equals(this.productModel) || ItDeviceType.OCEANSTOR_2910.getName().equals(StringUtils.toString(this.deviceType));
    }

    public boolean isA800DpcOm() {
        return ItDeviceType.A800_OM.equals((Object)this.itDeviceType) || ItDeviceType.A800_OM.getName().equals(StringUtils.toString(this.deviceType));
    }

    public boolean isOceanCyber() {
        return ItDeviceType.OCEAN_CYBER.equals((Object)this.itDeviceType) || ItDeviceType.OCEAN_CYBER.getName().equals(this.productSubModel);
    }

    public boolean isDataTurbo() {
        return ItDeviceType.DATATURBO.getName().equals(this.productModel);
    }

    public boolean isOceanStorA310() {
        return ItDeviceType.OCEAN_STOR_A310.getName().equals(StringUtils.toString(this.deviceType)) || ItDeviceType.OCEAN_STOR_A310.getName().equals(this.productModel);
    }

    public void setFusionCubeLoginUser(User fusionCubeLoginUser) {
        this.fusionCubeLoginUser = fusionCubeLoginUser;
    }

    public User getFusionCubeLoginUser() {
        return this.fusionCubeLoginUser;
    }

    public void setFusionCubeSSHPort(int port) {
        this.fusionCubeSSHPort = port;
    }

    public int getFusionCubeSSHPort() {
        return this.fusionCubeSSHPort;
    }

    public String getProductVersionToShow() {
        if (StringUtils.isNULLStr(this.distributedHotPatchVersion)) {
            if (StringUtils.isNULLStr(this.hotPatchVersion)) {
                return this.productVersion;
            }
            if (this.productVersion.toUpperCase(Locale.ROOT).contains(".SPH") || this.productVersion.toUpperCase(Locale.ROOT).contains(".SPC")) {
                return this.productVersion;
            }
            if (this.hotPatchVersion.contains(this.productVersion)) {
                return this.hotPatchVersion;
            }
            return this.productVersion + "." + this.hotPatchVersion;
        }
        if (this.isFusionCube()) {
            return this.productVersion;
        }
        if (this.productVersion.toUpperCase(Locale.ROOT).contains(".SPH")) {
            return this.productVersion;
        }
        if (this.distributedHotPatchVersion.contains(".")) {
            return this.distributedHotPatchVersion;
        }
        String mainVersion = this.productVersion.toUpperCase(Locale.ROOT);
        if (mainVersion.contains(".SPC")) {
            mainVersion = mainVersion.substring(0, mainVersion.indexOf(".SPC"));
        }
        return mainVersion + "." + this.distributedHotPatchVersion;
    }

    public void addSwitchNodes(List<SwitchNode> loginSwitchNodes) {
        loginSwitchNodes.stream().peek(switchNode -> switchNode.setFloatIp(this.getIp())).filter(switchNode -> !this.switchNodes.add((SwitchNode)switchNode)).forEach(this::handleEqualNode);
    }

    private void handleEqualNode(SwitchNode switchNode) {
        this.switchNodes.remove(switchNode);
        this.switchNodes.add(switchNode);
    }

    public List<SwitchNode> getSwitchNodes() {
        return new ArrayList<SwitchNode>(this.switchNodes);
    }

    public void updateSwitchConfig(SwitchNode switchNode) {
        this.switchNodes.stream().filter(node -> node.getIp().equals(switchNode.getIp())).forEach(node -> this.updateSwitchPort((SwitchNode)node, switchNode.getSwitchPort()));
    }

    private void updateSwitchPort(SwitchNode node, List<SwitchPort> switchPort) {
        node.setConfigdPorts(true);
        Map portMap = node.getSwitchPort().stream().collect(Collectors.toMap(SwitchPort::getPortName, Function.identity(), (port1, port2) -> port1));
        switchPort.stream().filter(newPort -> portMap.containsKey(newPort.getPortName())).forEach(newPort -> ((SwitchPort)portMap.get(newPort.getPortName())).setSelected(newPort.isSelected()));
    }

    public void removeSwitchNodes(List<SwitchNode> loginSwitchNodes) {
        loginSwitchNodes.forEach(this.switchNodes::remove);
    }

    public boolean isAllClusterNodeSelect() {
        return CollectionUtils.isNotEmpty(this.clusterNodes) && this.clusterNodes.stream().allMatch(ClusterNode::isSelected);
    }

    public boolean isNeedAuthClusterNodes() {
        return false;
    }

    public boolean isNeedRestQuery() {
        return this.getItDeviceType().equals((Object)ItDeviceType.Storage) || this.isFusionCube() || this.isA3000();
    }

    public boolean isNeedFcvQuery() {
        return this.getItDeviceType().equals((Object)ItDeviceType.Storage) || !this.isFusionCube() && !this.isA3000();
    }

    public void setDistributedHotPatchVersion(String distributedHotPatchVersion) {
        this.distributedHotPatchVersion = distributedHotPatchVersion;
    }

    public String getDistributedHotPatchVersion() {
        return this.distributedHotPatchVersion;
    }

    public void setSandboxOpen(boolean isSandboxOpen) {
        this.isSandboxOpen = isSandboxOpen;
    }

    public boolean isSandboxOpen() {
        return this.isSandboxOpen;
    }

    public void setSelectedNodeIps(List<String> selectedNodeIps) {
        this.selectedNodeIps = selectedNodeIps;
    }

    public List<String> getSelectedNodeIps() {
        return this.selectedNodeIps;
    }

    public User getKAdminUser() {
        return this.kAdminUser;
    }

    public void setKAdminUser(User kAdminUser) {
        this.kAdminUser = kAdminUser;
    }

    public User getMetaVisionUser() {
        return this.metaVisionUser;
    }

    public void setMetaVisionUser(User metaVisionUser) {
        this.metaVisionUser = metaVisionUser;
    }

    public String getPreCheckModel() {
        return this.preCheckModel;
    }

    public void setPreCheckModel(String preCheckModel) {
        this.preCheckModel = preCheckModel;
    }

    public List<String> getZoneIds() {
        return this.zoneIds;
    }

    public void setZoneIds(List<String> zoneIds) {
        this.zoneIds = zoneIds;
    }

    public String getExecuteZoneIp() {
        return this.executeZoneIp;
    }

    public void setExecuteZoneIp(String executeZoneIp) {
        this.executeZoneIp = executeZoneIp;
    }

    public void setComputeStorageDevNode(ComputeStorageDevNode computeStorageDevNode) {
        this.computeStorageDevNode = computeStorageDevNode;
    }

    public ComputeStorageDevNode getComputeStorageDevNode() {
        return this.computeStorageDevNode;
    }

    public void setClientUser(User clientUser) {
        this.clientUser = clientUser;
    }

    public User getClientUser() {
        return this.clientUser;
    }

    public User getFusionCubeUser() {
        return this.fusionCubeUser;
    }

    public void setFusionCubeUser(User fusionCubeUser) {
        this.fusionCubeUser = fusionCubeUser;
    }

    public User getA3000LoginUser() {
        return this.a3000LoginUser;
    }

    public void setA3000LoginUser(User a3000LoginUser) {
        this.a3000LoginUser = a3000LoginUser;
    }

    public void setSnFail(boolean isSnFail) {
        this.isSnFail = isSnFail;
    }

    public boolean isSnFail() {
        return this.isSnFail;
    }

    public void setVerifyCertificate(boolean isVerifyCertificate) {
        this.isVerifyCertificate = isVerifyCertificate;
    }

    public boolean isVerifyCertificate() {
        return this.isVerifyCertificate;
    }

    public void setContainerVersion(String containerVersion) {
        this.containerVersion = containerVersion;
    }

    public String getContainerVersion() {
        return this.containerVersion;
    }

    public boolean isSupportedContainer() {
        return this.isSupportedContainer;
    }

    public void setSupportedContainer(boolean isSupportedContainer) {
        this.isSupportedContainer = isSupportedContainer;
    }

    public void setSshqueue(boolean isSshqueue) {
        this.isSshqueue = isSshqueue;
    }

    public boolean isSshqueue() {
        return this.isSshqueue;
    }

    public VersionAndModelInfo getStorageVersionInfo() {
        return this.storageVersionInfo;
    }

    public void setStorageVersionInfo(VersionAndModelInfo storageVersionInfo) {
        this.storageVersionInfo = storageVersionInfo;
    }

    public ClusterNode.BaseBoardType getBaseBoardType() {
        return this.baseBoardType;
    }

    public boolean isOnlySecurityAlgorithm() {
        return this.isOnlySecurityAlgorithm;
    }

    public void setOnlySecurityAlgorithm(boolean isOnlySecurityAlgorithm) {
        this.isOnlySecurityAlgorithm = isOnlySecurityAlgorithm;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getScenarioInfo() {
        return this.scenarioInfo;
    }

    public void setScenarioInfo(String scenarioInfo) {
        this.scenarioInfo = scenarioInfo;
    }

    public void setSwitchNodes(Set<SwitchNode> switchNodes) {
        this.switchNodes = switchNodes;
    }
}

