/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolNetUtil {
    private static final Logger log = LoggerFactory.getLogger(ToolNetUtil.class);

    private ToolNetUtil() {
    }

    public static InetAddress int2InetAddress(int val) {
        byte[] value = new byte[]{(byte)((val & 0xFF000000) >>> 24), (byte)((val & 0xFF0000) >>> 16), (byte)((val & 0xFF00) >>> 8), (byte)(val & 0xFF)};
        try {
            return InetAddress.getByAddress(value);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static InetAddress long2InetAddress(long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            return null;
        }
        return ToolNetUtil.int2InetAddress((int)val);
    }

    public static int inetAddress2Int(InetAddress addr) {
        byte[] addrBytes = addr.getAddress();
        int part1 = (addrBytes[0] & 0xFF) << 24;
        int part2 = (addrBytes[1] & 0xFF) << 16;
        int part3 = (addrBytes[2] & 0xFF) << 8;
        int part4 = addrBytes[3] & 0xFF;
        return part1 | part2 | part3 | part4;
    }

    public static long inetAddress2Long(InetAddress addr) {
        return (long)ToolNetUtil.inetAddress2Int(addr) & 0xFFFFFFFFL;
    }

    public static List<Map<String, String>> calcIpAddressSubnet(NetworkInterface netCard) {
        ToolLoggerFactory.getLogger(ToolNetUtil.class).info("DHCP ToolNetUtil calcIpAddressSubnet exec. ");
        ArrayList<Map<String, String>> ipList = new ArrayList<Map<String, String>>();
        NetUtil.initLocalIPSubMaskMap();
        List<InterfaceAddress> ncAddrList = netCard.getInterfaceAddresses();
        Iterator<InterfaceAddress> ncAddrIterator = ncAddrList.iterator();
        while (ncAddrIterator.hasNext()) {
            String hostAddress;
            HashMap<String, String> map = new HashMap<String, String>();
            InterfaceAddress networkCardAddress = ncAddrIterator.next();
            InetAddress address = networkCardAddress.getAddress();
            if (address.isLoopbackAddress() || -1 != (hostAddress = address.getHostAddress()).indexOf(":")) continue;
            short maskLength = networkCardAddress.getNetworkPrefixLength();
            ToolLoggerFactory.getLogger(ToolNetUtil.class).info("DHCP ToolNetUtil InetAddress = " + address + " maskLength = " + maskLength);
            String maskAddress = NetUtil.getSubNetMaskByIP(hostAddress);
            if (!ApplicationContext.getInstance().isWindowsOS()) {
                maskAddress = ToolNetUtil.calcMaskByPrefixLength(networkCardAddress.getNetworkPrefixLength());
            }
            map.put(hostAddress, maskAddress);
            ipList.add(map);
        }
        return ipList;
    }

    public static String calcMaskByPrefixLength(int length) {
        int mask = -1 << 32 - length;
        int partsNum = 4;
        int bitsOfPart = 8;
        int[] maskParts = new int[partsNum];
        int selector = 255;
        for (int i = 0; i < maskParts.length; ++i) {
            int pos = maskParts.length - 1 - i;
            maskParts[pos] = mask >> i * bitsOfPart & selector;
        }
        StringBuffer result = new StringBuffer().append(maskParts[0]);
        for (int i = 1; i < maskParts.length; ++i) {
            result.append(".").append(maskParts[i]);
        }
        return result.toString();
    }

    public static int transMaskToPrefixLength(String mask) {
        int len = 0;
        for (String netNum : mask.split("\\.")) {
            len = (int)((double)len + (8.0 - Math.log(256 - Integer.parseInt(netNum)) / Math.log(2.0)));
        }
        return len;
    }

    public static String calcSubnetAddress(String ip, String mask) {
        StringBuffer result = new StringBuffer();
        try {
            int i;
            InetAddress ipAddress = InetAddress.getByName(ip);
            InetAddress maskAddress = InetAddress.getByName(mask);
            byte[] ipRaw = ipAddress.getAddress();
            byte[] maskRaw = maskAddress.getAddress();
            int unsignedByteFilter = 255;
            int[] resultRaw = new int[ipRaw.length];
            for (i = 0; i < resultRaw.length; ++i) {
                resultRaw[i] = ipRaw[i] & maskRaw[i] & unsignedByteFilter;
            }
            result.append(resultRaw[0]);
            for (i = 1; i < resultRaw.length; ++i) {
                result.append(".").append(resultRaw[i]);
            }
        }
        catch (UnknownHostException e) {
            ToolLoggerFactory.getLogger(ToolNetUtil.class).error("Uncorrect ip or mask.", e);
        }
        return result.toString();
    }

    public static byte[] getMaskByte(String mask) {
        byte[] bs = new byte[]{};
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(mask);
            bs = addr.getAddress();
        }
        catch (UnknownHostException e) {
            ToolLoggerFactory.getLogger(ToolNetUtil.class).error("Uncorrect  mask.", e);
        }
        return bs;
    }

    public static String calcIpv6SubnetAddress(String ipv6) throws ToolException {
        if (!ipv6.contains("/")) {
            throw new ToolException("invalid ip format", false);
        }
        int prefix = Integer.parseInt(ipv6.split("/")[1]);
        if (prefix < 1 || prefix > 128) {
            throw new ToolException("prefix out of range", false);
        }
        String ip = ipv6.split("/")[0];
        String fullIp = ToolNetUtil.deCompressIpv6(ip);
        int group = prefix / 16;
        if (group == 8) {
            return String.format(Locale.ENGLISH, "%s/%s", ip, prefix);
        }
        String[] ipSplit = fullIp.split(":");
        ArrayList<String> newIp = new ArrayList<String>();
        if (group < 1) {
            newIp.add(ToolNetUtil.calculateSegment(ipSplit[0], prefix % 16));
        } else {
            newIp.addAll(Arrays.asList(Arrays.copyOfRange(ipSplit, 0, group)));
            newIp.add(ToolNetUtil.calculateSegment(ipSplit[group], prefix % 16));
        }
        for (int i = 0; i < 8 - newIp.size(); ++i) {
            newIp.add("0000");
        }
        return String.format(Locale.ENGLISH, "%s/%s", ToolNetUtil.compressIp(String.join((CharSequence)":", newIp)), prefix);
    }

    private static String compressIp(String ipV6) {
        return ipV6.replaceAll("^0{1,3}", "").replaceAll("((?:(?:^|:)0+\\b){2,}):?(?!\\S*\\b\\1:0+\\b)", "::").replaceAll(":0{1,3}", ":");
    }

    private static String calculateSegment(String ipSegment, int prefixLeft) {
        int i;
        int group = prefixLeft / 4;
        if (group < 1) {
            return ToolNetUtil.calculateOneNumber(String.valueOf(ipSegment.charAt(0)), prefixLeft % 4) + "000";
        }
        StringBuilder newIpSegment = new StringBuilder();
        for (i = 0; i < group; ++i) {
            newIpSegment.append(ipSegment.charAt(i));
        }
        newIpSegment.append(ToolNetUtil.calculateOneNumber(String.valueOf(ipSegment.charAt(group)), prefixLeft % 4));
        for (i = 0; i < ipSegment.length() - group - 1; ++i) {
            newIpSegment.append("0");
        }
        return newIpSegment.toString();
    }

    private static String calculateOneNumber(String hex, int prefixLet) {
        if (hex.equals("0") || prefixLet == 0) {
            return "0";
        }
        String hexToByte = ToolNetUtil.getNumberByte(hex);
        String substring = hexToByte.substring(0, prefixLet);
        StringBuilder byteNum = new StringBuilder();
        byteNum.append(substring);
        for (int i = 0; i < 4 - substring.length(); ++i) {
            byteNum.append("0");
        }
        return Integer.toHexString(Integer.parseInt(byteNum.toString(), 2));
    }

    private static String getNumberByte(String hex) {
        String hexToByte = Integer.toBinaryString(Integer.valueOf(hex, 16));
        StringBuilder byteString = new StringBuilder();
        for (int i = 0; i < 4 - hexToByte.length(); ++i) {
            byteString.append(0);
        }
        return byteString.append(hexToByte).toString();
    }

    private static String deCompressIpv6(String ip) {
        if (!ip.contains("::")) {
            return ToolNetUtil.fullDeCompressIpv6(ip);
        }
        String[] ipSplit = ip.split("::");
        if (ipSplit.length < 2) {
            ipSplit = new String[]{ipSplit[0], ""};
        }
        int positionCount = ipSplit[0].split(":").length + ipSplit[1].split(":").length;
        int zeroPositionCount = 8 - positionCount;
        StringBuilder deCompressIp = new StringBuilder(ipSplit[0]);
        if ("".equals(deCompressIp.toString())) {
            deCompressIp = new StringBuilder("0");
        }
        for (int i = 0; i < zeroPositionCount; ++i) {
            deCompressIp.append(":0");
        }
        deCompressIp.append(":");
        deCompressIp.append(ipSplit[1]);
        if ("".equals(ipSplit[1])) {
            deCompressIp.append("0");
        }
        return ToolNetUtil.fullDeCompressIpv6(deCompressIp.toString());
    }

    private static String fullDeCompressIpv6(String deCompressIp) {
        ArrayList<String> fullIp = new ArrayList<String>();
        for (String ipSegment : deCompressIp.split(":")) {
            fullIp.add(ToolNetUtil.fillWithZero(ipSegment));
        }
        return String.join((CharSequence)":", fullIp);
    }

    private static String fillWithZero(String ipSegment) {
        if (ipSegment.length() >= 4) {
            return ipSegment;
        }
        StringBuilder fullSegment = new StringBuilder();
        for (int i = 0; i < 4 - ipSegment.length(); ++i) {
            fullSegment.append("0");
        }
        fullSegment.append(ipSegment);
        return fullSegment.toString();
    }
}

