/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.processor.parser;

import com.huawei.ism.tool.obase.entity.TSonData;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.processor.parser.ICmdReturnParser;
import com.huawei.ism.tool.obase.utils.BooleanUtils;
import com.huawei.ism.tool.obase.xml.cli.CaseNode;
import com.huawei.ism.tool.obase.xml.cli.CheckNode;
import com.huawei.ism.tool.obase.xml.cli.QueryNode;
import com.huawei.ism.tool.obase.xml.cli.ResultNode;
import java.util.List;

public abstract class AbstractReturnParser
implements ICmdReturnParser {
    private ResultNode resultNode = null;

    @Override
    public List<TSonData> parser(String cmdResult) throws ToolException {
        List<TSonData> resultDatas = this.parseReturnData(cmdResult);
        if (this.resultNode instanceof CheckNode) {
            CheckNode check = (CheckNode)this.resultNode;
            this.matchCheckNode(resultDatas, check);
        } else if (this.resultNode instanceof QueryNode) {
            QueryNode query = (QueryNode)this.resultNode;
            this.parseQueryNode(resultDatas, query);
        }
        return resultDatas;
    }

    public void setXmlCheckNode(ResultNode node) {
        this.resultNode = node;
    }

    protected abstract List<TSonData> parseReturnData(String var1) throws ToolException;

    protected void matchCheckNode(List<TSonData> datas, CheckNode node) throws ToolException {
        List<CaseNode> caseNodes = node.getCaseNodes();
        if (null == datas || datas.isEmpty()) {
            return;
        }
        block0: for (TSonData jSonData : datas) {
            String value = jSonData.getValue(node.getCheckKey());
            jSonData.setXmlCmdKey(node.getCheckKey());
            for (int i = 0; i < caseNodes.size(); ++i) {
                CaseNode caseNode = caseNodes.get(i);
                boolean matchCaseNode = this.matchCaseNode(value, caseNode);
                if (!matchCaseNode) continue;
                this.parseCaseNode(jSonData, caseNode);
                continue block0;
            }
        }
    }

    protected void parseQueryNode(List<TSonData> datas, QueryNode node) {
        for (TSonData tsonData : datas) {
            tsonData.setXmlCmdKey(node.getCmdKey());
        }
    }

    private void parseCaseNode(TSonData jSonData, CaseNode node) {
        jSonData.setSuggestion(node.getSuggest());
        jSonData.setXmlCmdKey(node.getComment());
        jSonData.setXmlValue(node.getValue());
        jSonData.setPassCofnig(node.isPassedNode());
    }

    protected boolean matchCaseNode(String value, CaseNode caseNode) throws ToolException {
        if (!caseNode.isDefaultNode()) {
            String expression = caseNode.getValue();
            if (expression.contains("$")) {
                return BooleanUtils.eval(expression, value);
            }
            return expression.equals(value);
        }
        return true;
    }
}

