/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.upgrade;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.config.resource.ReleaseFeatureConfig;
import com.huawei.ism.tool.obase.entity.UpgradeFeature;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import utils.Products;

public class UpgradeModePanel
extends JPanel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UpgradeModePanel.class);
    private JLabel upgradeModeLbl = new JLabel(ResourceUtil.getString("upgrademode.radioButton.label"));
    private JRadioButton onlineRtn = new JRadioButton(ResourceUtil.getString("upgrademode.radioButton.online"));
    private JTextPane onlinesuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.radioButton.online.desc"));
    private JRadioButton offlineRtn = new JRadioButton(ResourceUtil.getString("upgrademode.radioButton.offline"));
    private JTextPane offlinesuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.radioButton.offline.desc"));
    private JRadioButton fastRtn = new JRadioButton(ResourceUtil.getString("upgrademode.radioButton.fast") + ResourceUtil.getString("upgrademode.recommended"));
    private JTextPane fastSuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.radioButton.fast.desc"));
    private JRadioButton rollRtn = new JRadioButton(ResourceUtil.getString("upgrademode.radioButton.roll"));
    private JTextPane rollsuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.radioButton.roll.desc"));
    private JRadioButton apolloRtn = new JRadioButton(ResourceUtil.getString("upgrademode.radioButton.apollo"));
    private JTextPane apolloSuggestion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.radioButton.apollo.desc"));
    private JCheckBox stopHostBusinessCbx = new JCheckBox(ResourceUtil.getString("upgrademode.checkbox.stopbusiness"));
    private JTextPane stopHostBusinessDesc = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.checkbox.stopbusiness.desc"));
    private JTextPane stopHostBusinessWarning = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.stopbusiness.upgrade.warning"));
    private JTextPane stopHostBusinessWarningApollo = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.stopbusiness.upgrade.warning"));
    private JRadioButton parallelRtn = new JRadioButton(ResourceUtil.getString("upgrademode.radioButton.parallel"));
    private JTextPane parallelsuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("upgrademode.radioButton.parallel.desc"));
    private JRadioButton offlineContainerButton = new JRadioButton(ResourceUtil.getString("secondaryupgrade.upgradeinfo.upgrade.type.offline"));
    private JTextPane offlineContainerSuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("secondaryupgrade.upgradeinfo.upgrade.type.offline.desc"));
    private JRadioButton patchContainerButton = new JRadioButton(ResourceUtil.getString("secondaryupgrade.upgradeinfo.upgrade.type.patch"));
    private JTextPane patchContainerSuggesstion = UiMethod.createTextPaneWithDefaultLeftIdent(ResourceUtil.getString("secondaryupgrade.upgradeinfo.upgrade.type.patch.desc"));
    private ToolHyperLinkLabel expandLink = new ToolHyperLinkLabel(ResourceUtil.getString("upgrademode.hyperlink.expand"));
    private ToolHyperLinkLabel collapseLink = new ToolHyperLinkLabel(ResourceUtil.getString("upgrademode.hyperlink.collapse"));
    private ToolHyperLinkLabel featureLink = new ToolHyperLinkLabel(ResourceUtil.getString("upgrade.featurelist.dialog.link"));
    private UpgradeModeItem defaultItem = null;
    private List<UpgradeModeItem> initItems = new ArrayList<UpgradeModeItem>();
    private List<UpgradeModeItem> moreItems = new ArrayList<UpgradeModeItem>();
    private final Pattern v6VersionPattern = Pattern.compile("(\\d\\.\\d+\\.[^\\.]+)(.+)?");
    private transient Map<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>> featureMap = new HashMap<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>>();
    private int maxWidth = 550;
    private boolean needOfflineWarning = false;
    private boolean showStopHosBusiness = false;
    private boolean showParallel = true;
    private boolean showApollo = false;
    private JDialog parent = null;
    private ICallBack callBack = null;
    private String scene = "";
    private String currentVersion;
    private String targetVersion;

    public UpgradeModePanel(String scene) {
        this.scene = scene;
        this.initComponents();
        this.initListner();
    }

    private void initComponents() {
        ButtonGroup upgradeModelGrp = new ButtonGroup();
        upgradeModelGrp.add(this.onlineRtn);
        upgradeModelGrp.add(this.offlineRtn);
        upgradeModelGrp.add(this.fastRtn);
        upgradeModelGrp.add(this.rollRtn);
        upgradeModelGrp.add(this.parallelRtn);
        upgradeModelGrp.add(this.apolloRtn);
        upgradeModelGrp.add(this.offlineContainerButton);
        upgradeModelGrp.add(this.patchContainerButton);
        this.stopHostBusinessWarning.setForeground(Color.RED);
        this.stopHostBusinessWarningApollo.setForeground(Color.RED);
    }

    private void initListner() {
        this.expandLinkAddListener();
        this.collapseLinkAddListener();
        this.stopHostBusinessCbxAddListener();
        this.offlineRtnAddListener();
        ActionListener actionListener = event -> {
            this.switchSubItems(this.rollRtn, this.rollRtn.isSelected());
            this.switchSubItems(this.apolloRtn, this.apolloRtn.isSelected());
            this.updateStopBusinessNotice();
            if (null != this.callBack) {
                this.callBack.itemChanged();
            }
        };
        this.featureLink.addClickListener(event -> new FeatureDetailDialog(this.parent, this.featureMap));
        this.onlineRtn.addActionListener(actionListener);
        this.offlineRtn.addActionListener(actionListener);
        this.fastRtn.addActionListener(actionListener);
        this.rollRtn.addActionListener(actionListener);
        this.parallelRtn.addActionListener(actionListener);
        this.apolloRtn.addActionListener(actionListener);
        this.offlineContainerButton.addActionListener(actionListener);
        this.patchContainerButton.addActionListener(actionListener);
    }

    private void offlineRtnAddListener() {
        this.offlineRtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WarningDialog dialog;
                if (UpgradeModePanel.this.needOfflineWarning && UpgradeModePanel.this.offlineRtn.isSelected() && 1 == (dialog = DialogUtils.showYesNoDialog((Window)UpgradeModePanel.this.parent, (String)ResourceUtil.getString("upgrademode.tv2.offline"))).getValue()) {
                    UpgradeModePanel.this.onlineRtn.setSelected(true);
                }
            }
        });
    }

    private void stopHostBusinessCbxAddListener() {
        this.stopHostBusinessCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarningDialog dialog;
                if (UpgradeModePanel.this.stopHostBusinessCbx.isSelected() && 0 != (dialog = DialogUtils.showYesNoDialog((Window)UpgradeModePanel.this.parent, (String)ResourceUtil.getString("upgrademode.checkbox.stopbusiness.notice"))).getValue()) {
                    UpgradeModePanel.this.stopHostBusinessCbx.setSelected(false);
                }
            }
        });
    }

    private void collapseLinkAddListener() {
        this.collapseLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent me) {
                UpgradeModePanel.this.collapseLink.setVisible(false);
                for (UpgradeModeItem item : UpgradeModePanel.this.moreItems) {
                    item.name.setVisible(false);
                    item.desc.setVisible(false);
                    if (null == item.getExtraComps()) continue;
                    for (Component jc : item.getExtraComps()) {
                        jc.setVisible(false);
                    }
                }
                UpgradeModePanel.this.expandLink.setVisible(true);
            }
        });
    }

    private void expandLinkAddListener() {
        this.expandLink.addClickListener(new ToolHyperLinkLabel.ClickListener(){

            @Override
            public void clickLink(MouseEvent me) {
                UpgradeModePanel.this.expandLink.setVisible(false);
                for (UpgradeModeItem item : UpgradeModePanel.this.moreItems) {
                    item.name.setVisible(true);
                    item.desc.setVisible(true);
                    if (!item.name.isSelected()) continue;
                    UpgradeModePanel.this.switchSubItems(item.name, true);
                }
                UpgradeModePanel.this.collapseLink.setVisible(true);
            }
        });
    }

    private void autoAdjustCompSize() {
        this.adjustSize(this.onlinesuggesstion);
        this.adjustSize(this.offlinesuggesstion);
        this.adjustSize(this.fastSuggesstion);
        this.adjustSize(this.rollsuggesstion);
        this.adjustSize(this.parallelsuggesstion);
        this.adjustSize(this.apolloSuggestion);
        this.adjustSize(this.offlineContainerSuggesstion);
        this.adjustSize(this.patchContainerSuggesstion);
        this.adjustSize(this.stopHostBusinessDesc);
        this.adjustSize(this.stopHostBusinessWarning);
        this.adjustSize(this.stopHostBusinessWarningApollo);
    }

    private void adjustSize(JTextPane comp) {
        int width = this.getMaxWidth();
        Font font = new Font("Serif", 1, 12);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        Rectangle rec = font.getStringBounds(comp.getText(), frc).getBounds();
        int height = (int)(rec.getWidth() / (double)(width - 20) + 1.0) * 20;
        comp.setPreferredSize(new Dimension(width, height));
    }

    public JPanel getPanel() {
        this.autoAdjustCompSize();
        List<Component> compList = this.generatePanel();
        JPanel upgradePanel = new JPanel();
        upgradePanel.setLayout(new FlowLayout(0, 0, 0));
        JPanel upgradeJc = new JPanel();
        upgradeJc.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.left = 0;
        gbc.anchor = 18;
        upgradeJc.setOpaque(false);
        for (Component cp : compList) {
            upgradeJc.add(cp, gbc);
            ++gbc.gridy;
        }
        upgradePanel.add(upgradeJc);
        return upgradePanel;
    }

    public void disableAll() {
        this.onlineRtn.setEnabled(false);
        this.offlineRtn.setEnabled(false);
        this.fastRtn.setEnabled(false);
        this.rollRtn.setEnabled(false);
        this.parallelRtn.setEnabled(false);
        this.apolloRtn.setEnabled(false);
        this.stopHostBusinessCbx.setEnabled(false);
        this.offlineContainerButton.setEnabled(false);
        this.patchContainerButton.setEnabled(false);
    }

    public UpgradeMode getSelectedMode() {
        if (this.fastRtn.isSelected()) {
            return UpgradeMode.FAST;
        }
        if (this.apolloRtn.isSelected()) {
            return UpgradeMode.APOLLO;
        }
        if (this.onlineRtn.isSelected() || this.rollRtn.isSelected()) {
            return UpgradeMode.ONLINE;
        }
        if (this.patchContainerButton.isSelected()) {
            return UpgradeMode.PATCH_CONTAINER;
        }
        if (this.offlineContainerButton.isSelected()) {
            return UpgradeMode.OFFLINE_CONTAINER;
        }
        return UpgradeMode.OFFLINE;
    }

    public UpgradeMode getSelectedModeUI() {
        if (this.onlineRtn.isSelected()) {
            return UpgradeMode.ONLINE;
        }
        if (this.offlineRtn.isSelected()) {
            return UpgradeMode.OFFLINE;
        }
        if (this.offlineContainerButton.isSelected()) {
            return UpgradeMode.OFFLINE_CONTAINER;
        }
        if (this.patchContainerButton.isSelected()) {
            return UpgradeMode.PATCH_CONTAINER;
        }
        if (this.fastRtn.isSelected()) {
            return UpgradeMode.FAST;
        }
        if (this.rollRtn.isSelected()) {
            return UpgradeMode.ROLL;
        }
        if (this.parallelRtn.isSelected()) {
            return UpgradeMode.PARALLEL;
        }
        if (this.apolloRtn.isSelected()) {
            return UpgradeMode.APOLLO;
        }
        return UpgradeMode.ONLINE;
    }

    public void setSelectedModeUI(UpgradeMode mode) {
        switch (mode) {
            case ONLINE: {
                this.onlineRtn.setSelected(true);
                break;
            }
            case OFFLINE: {
                this.offlineRtn.setSelected(true);
                break;
            }
            case FAST: {
                this.fastRtn.setSelected(true);
                this.stopHostBusinessCbx.setEnabled(false);
                this.stopHostBusinessWarning.setVisible(false);
                this.stopHostBusinessWarningApollo.setVisible(false);
                break;
            }
            case ROLL: {
                this.rollRtn.setSelected(true);
                this.stopHostBusinessWarning.setVisible(true);
                this.stopHostBusinessWarningApollo.setVisible(false);
                this.switchSubItems(this.rollRtn, true);
                break;
            }
            case PARALLEL: {
                this.parallelRtn.setSelected(true);
                this.stopHostBusinessCbx.setEnabled(false);
                this.stopHostBusinessWarning.setVisible(false);
                this.stopHostBusinessWarningApollo.setVisible(false);
                break;
            }
            case APOLLO: {
                this.setApolloRtn();
                break;
            }
            case PATCH_CONTAINER: {
                this.patchContainerButton.setEnabled(true);
                break;
            }
            case OFFLINE_CONTAINER: {
                this.offlineContainerButton.setEnabled(true);
                break;
            }
        }
        this.setDefaultItem();
    }

    private void setApolloRtn() {
        this.apolloRtn.setSelected(true);
        this.stopHostBusinessWarning.setVisible(false);
        this.stopHostBusinessWarningApollo.setVisible(true);
        this.switchSubItems(this.apolloRtn, true);
    }

    private void updateStopBusinessNotice() {
        if (SceneUtils.isA800SceneInTool()) {
            this.stopHostBusinessCbx.setVisible(false);
            this.stopHostBusinessDesc.setVisible(false);
            this.stopHostBusinessWarning.setVisible(false);
            this.stopHostBusinessWarningApollo.setVisible(false);
        }
    }

    private void setDefaultItem() {
        if (!this.defaultItem.name.isSelected()) {
            this.expandLink.setVisible(false);
            for (UpgradeModeItem item : this.moreItems) {
                item.name.setVisible(true);
                item.desc.setVisible(true);
            }
            this.collapseLink.setVisible(true);
        }
    }

    private void switchSubItems(JRadioButton checkedButton, boolean turnOn) {
        ArrayList<UpgradeModeItem> allItems = new ArrayList<UpgradeModeItem>(this.initItems);
        allItems.addAll(this.moreItems);
        allItems.forEach(entry -> {
            if (((UpgradeModeItem)entry).name != checkedButton) {
                return;
            }
            if (entry.getExtraComps() != null) {
                entry.getExtraComps().forEach(val -> {
                    val.setVisible(turnOn);
                    val.setEnabled(turnOn);
                    if (val instanceof JCheckBox) {
                        ((JCheckBox)val).setSelected(false);
                    }
                });
            }
        });
    }

    private List<Component> generatePanel() {
        this.buildComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        this.featureLink.setVisible(!this.featureMap.isEmpty());
        JComponent component = UiMethod.buildCompsLeft(this.upgradeModeLbl, this.featureLink);
        compList.add(component);
        compList.add(Box.createHorizontalStrut(0));
        this.defaultItem.name.setSelected(true);
        for (UpgradeModeItem item : this.initItems) {
            compList.add(UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalGlue(), item.name}));
            compList.add(UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(10), item.desc}));
            if (null == item.getExtraComps()) continue;
            for (Component jc : item.getExtraComps()) {
                compList.add(UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(10), jc}));
            }
        }
        if (!this.moreItems.isEmpty()) {
            compList.add(this.expandLink);
        }
        for (UpgradeModeItem item : this.moreItems) {
            compList.add(UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalGlue(), item.name}));
            compList.add(UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(10), item.desc}));
            item.name.setVisible(false);
            item.desc.setVisible(false);
            if (null == item.getExtraComps()) continue;
            for (Component jc : item.getExtraComps()) {
                compList.add(UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(10), jc}));
                jc.setVisible(false);
            }
        }
        if (!this.moreItems.isEmpty()) {
            compList.add(this.collapseLink);
        }
        this.collapseLink.setVisible(false);
        return compList;
    }

    private void buildComponents() {
        UpgradeModeItem onlineItem = new UpgradeModeItem(this.onlineRtn, this.onlinesuggesstion);
        UpgradeModeItem offlineItem = new UpgradeModeItem(this.offlineRtn, this.offlinesuggesstion);
        UpgradeModeItem fastItem = new UpgradeModeItem(this.fastRtn, this.fastSuggesstion);
        UpgradeModeItem rollItem = new UpgradeModeItem(this.rollRtn, this.rollsuggesstion);
        UpgradeModeItem parallelItem = new UpgradeModeItem(this.parallelRtn, this.parallelsuggesstion);
        UpgradeModeItem apolloItem = new UpgradeModeItem(this.apolloRtn, this.apolloSuggestion);
        UpgradeModeItem offlineContainerItem = new UpgradeModeItem(this.offlineContainerButton, this.offlineContainerSuggesstion);
        UpgradeModeItem patchContainerItem = new UpgradeModeItem(this.patchContainerButton, this.patchContainerSuggesstion);
        this.initItemByHosBusiness(rollItem, apolloItem);
        switch (this.scene) {
            case "FAST": {
                this.defaultItem = fastItem;
                this.initItems.add(fastItem);
                if (this.showApollo) {
                    this.moreItems.add(apolloItem);
                }
                this.moreItems.add(rollItem);
                this.stopHostBusinessCbx.setEnabled(false);
                this.stopHostBusinessWarning.setVisible(false);
                if (!this.showParallel) break;
                this.moreItems.add(parallelItem);
                break;
            }
            case "ROLL": {
                this.defaultItem = rollItem;
                this.initItems.add(rollItem);
                this.stopHostBusinessWarning.setVisible(true);
                if (!this.showParallel) break;
                this.moreItems.add(parallelItem);
                break;
            }
            case "ONLINE": {
                this.defaultItem = onlineItem;
                this.initItems.add(onlineItem);
                this.moreItems.add(offlineItem);
                break;
            }
            case "EBACKUP": {
                this.defaultItem = offlineItem;
                this.initItems.add(offlineItem);
                break;
            }
            case "OFFLINE_CONTAINER": {
                this.setItem(offlineContainerItem, patchContainerItem);
                break;
            }
            case "PATCH_CONTAINER": {
                this.setItem(patchContainerItem, offlineContainerItem);
                break;
            }
        }
    }

    private void setItem(UpgradeModeItem initItem, UpgradeModeItem moreItem) {
        this.defaultItem = initItem;
        this.initItems.add(initItem);
        this.moreItems.add(moreItem);
    }

    private void initItemByHosBusiness(UpgradeModeItem rollItem, UpgradeModeItem apolloItem) {
        if (this.showStopHosBusiness) {
            ArrayList<Component> extraCpts = new ArrayList<Component>();
            extraCpts.add(Box.createVerticalStrut(12));
            extraCpts.add(this.stopHostBusinessCbx);
            extraCpts.add(this.stopHostBusinessDesc);
            rollItem.setExtraComps(extraCpts);
        } else if (!ApplicationContext.getInstance().isOEM()) {
            ArrayList<Component> extraCpts = new ArrayList<Component>();
            extraCpts.add(this.stopHostBusinessWarning);
            rollItem.setExtraComps(extraCpts);
            ArrayList<Component> extraCptsForApollo = new ArrayList<Component>();
            extraCptsForApollo.add(this.stopHostBusinessWarningApollo);
            apolloItem.setExtraComps(extraCptsForApollo);
        } else {
            LOGGER.info("this is oem env.");
        }
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public JRadioButton getOnlineRtn() {
        return this.onlineRtn;
    }

    public JRadioButton getOfflineRtn() {
        return this.offlineRtn;
    }

    public JCheckBox getStopHostBusinessCbx() {
        return this.stopHostBusinessCbx;
    }

    public ICallBack getCallBack() {
        return this.callBack;
    }

    public void setCallBack(ICallBack callBack) {
        this.callBack = callBack;
    }

    public JRadioButton getFastRtn() {
        return this.fastRtn;
    }

    public JRadioButton getParallelRtn() {
        return this.parallelRtn;
    }

    public void setShowParallel(boolean showParallel) {
        this.showParallel = showParallel;
    }

    public void setNeedOfflineWarning(boolean needOfflineWarning) {
        this.needOfflineWarning = needOfflineWarning;
    }

    public void setShowStopHosBusiness(boolean showStopHosBusiness) {
        this.showStopHosBusiness = showStopHosBusiness;
    }

    public void setShowApollo(boolean showApollo) {
        this.showApollo = showApollo;
    }

    public void setFeatureMap(Map<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>> featureMap) {
        this.featureMap = featureMap;
        if (!featureMap.isEmpty()) {
            this.featureLink.setVisible(true);
        }
    }

    public void setCurrentVersion(String currentVersion) {
        Matcher matcher = this.v6VersionPattern.matcher(currentVersion);
        if (matcher.find()) {
            currentVersion = matcher.group(1);
        }
        this.currentVersion = currentVersion;
        this.setApolloFeatures();
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
        this.setNormalFeatures();
    }

    private void setApolloFeatures() {
        if (!this.showApollo) {
            return;
        }
        List<UpgradeFeature> featureList = ReleaseFeatureConfig.getInstance().getApolloFeatureList(this.currentVersion);
        HashMap<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>> tmpFeatureMap = new HashMap<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>>();
        featureList.forEach(feature -> {
            EnumMap<UpgradeMode, UpgradeFeature.FeatureSupport> supportMap = new EnumMap<UpgradeMode, UpgradeFeature.FeatureSupport>(UpgradeMode.class);
            supportMap.put(UpgradeMode.FAST, UpgradeFeature.FeatureSupport.NOT_RELATED);
            supportMap.put(UpgradeMode.ROLL, UpgradeFeature.FeatureSupport.NOT_RELATED);
            supportMap.put(UpgradeMode.PARALLEL, UpgradeFeature.FeatureSupport.NOT_RELATED);
            supportMap.put(UpgradeMode.APOLLO, UpgradeFeature.FeatureSupport.SUPPORT);
            tmpFeatureMap.put((UpgradeFeature)feature, (Map<UpgradeMode, UpgradeFeature.FeatureSupport>)supportMap);
        });
        this.setFeatureMap(tmpFeatureMap);
    }

    private void setNormalFeatures() {
        if (!this.scene.equals(UpgradeMode.FAST.toString())) {
            return;
        }
        LinkedHashMap<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>> tmpFeatureMap = new LinkedHashMap<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>>();
        if (Products.compareVersion(this.currentVersion, this.targetVersion) < 0) {
            List<UpgradeFeature> featureList = ReleaseFeatureConfig.getInstance().getFeatureListWithinVersion(this.currentVersion, this.targetVersion);
            featureList.forEach(upgradeFeature -> {
                EnumMap<UpgradeMode, UpgradeFeature.FeatureSupport> supportMap = new EnumMap<UpgradeMode, UpgradeFeature.FeatureSupport>(UpgradeMode.class);
                supportMap.put(UpgradeMode.FAST, ReleaseFeatureConfig.supportType(upgradeFeature, UpgradeMode.FAST));
                supportMap.put(UpgradeMode.ROLL, ReleaseFeatureConfig.supportType(upgradeFeature, UpgradeMode.ROLL));
                supportMap.put(UpgradeMode.PARALLEL, ReleaseFeatureConfig.supportType(upgradeFeature, UpgradeMode.PARALLEL));
                supportMap.put(UpgradeMode.APOLLO, UpgradeFeature.FeatureSupport.NOT_SUPPORT);
                tmpFeatureMap.put((UpgradeFeature)upgradeFeature, (Map<UpgradeMode, UpgradeFeature.FeatureSupport>)supportMap);
            });
        }
        if (this.showApollo) {
            List<UpgradeFeature> apolloFeatures = ReleaseFeatureConfig.getInstance().getApolloFeatureList(this.currentVersion);
            apolloFeatures.forEach(feature -> {
                Map currentSupport = (Map)tmpFeatureMap.get(feature);
                if (currentSupport == null) {
                    EnumMap<UpgradeMode, UpgradeFeature.FeatureSupport> supportMap = new EnumMap<UpgradeMode, UpgradeFeature.FeatureSupport>(UpgradeMode.class);
                    supportMap.put(UpgradeMode.FAST, UpgradeFeature.FeatureSupport.NOT_RELATED);
                    supportMap.put(UpgradeMode.ROLL, UpgradeFeature.FeatureSupport.NOT_RELATED);
                    supportMap.put(UpgradeMode.PARALLEL, UpgradeFeature.FeatureSupport.NOT_RELATED);
                    supportMap.put(UpgradeMode.APOLLO, UpgradeFeature.FeatureSupport.SUPPORT);
                    tmpFeatureMap.put((UpgradeFeature)feature, (Map<UpgradeMode, UpgradeFeature.FeatureSupport>)supportMap);
                } else {
                    currentSupport.put(UpgradeMode.APOLLO, UpgradeFeature.FeatureSupport.SUPPORT);
                }
            });
        }
        this.setFeatureMap(tmpFeatureMap);
    }

    private class FeatureDetailDialog
    extends PublicDialog {
        private static final int INT500 = 500;
        private static final int INT850 = 850;
        private transient Map<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>> featureMap;
        private IsmTable deviceTable;
        private final String support;
        private final String notSupport;

        public FeatureDetailDialog(JDialog parent, Map<UpgradeFeature, Map<UpgradeMode, UpgradeFeature.FeatureSupport>> featureMap) {
            super(parent);
            this.support = ResourceUtil.getString("upgrade.featurelist.table.value.support", this.getParent().getLocale());
            this.notSupport = ResourceUtil.getString("upgrade.featurelist.table.value.notsupport", this.getParent().getLocale());
            this.setModal(true);
            this.setTitle(ResourceUtil.getString("upgrade.featurelist.dialog.title", this.getParent().getLocale()));
            this.featureMap = featureMap;
            this.getOkBtn().setVisible(false);
            this.setAppButtonVisible(false);
            this.setHelpButtonVisiable(false);
            this.getCancelBtn().setText(ResourceUtil.getString("toolbase.public.dialog.txt.close", this.getParent().getLocale()));
            this.initTableData();
            this.getContentPanel().setLayout(new BorderLayout());
            this.getContentPanel().add(this.createUI(), "Center");
            UiMethod.setComponentSize(new Dimension(850, 500), this);
            this.pack();
            this.setResizable(false);
            SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
            SwingUtil.putScreenCenter((Window)this);
            this.setVisible(true);
        }

        private void initTableData() {
            int[] showColumns = this.getShownColumns();
            DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{ResourceUtil.getString("upgrade.featurelist.table.title.name", this.getParent().getLocale()), ResourceUtil.getString("upgrade.featurelist.table.title.desc", this.getParent().getLocale()), ResourceUtil.getString("upgrademode.radioButton.fast", this.getParent().getLocale()), ResourceUtil.getString("upgrademode.radioButton.roll", this.getParent().getLocale()), ResourceUtil.getString("upgrade.featurelist.table.title.parallel", this.getParent().getLocale()), ResourceUtil.getString("upgrademode.radioButton.apollo", this.getParent().getLocale())}, showColumns);
            this.deviceTable = new IsmTable((TableModel)defaultTableModel);
            int columnCount = 6;
            this.featureMap.forEach((key, value) -> {
                DefaultTableRow row = new DefaultTableRow(columnCount, key);
                UpgradeFeature.FeatureDetail detail = key.getDetail(this.getParent().getLocale());
                row.setValueAt(0, (Object)detail.getName());
                row.setValueAt(1, (Object)detail.getContent());
                row.setValueAt(2, (Object)this.getSupportValue((UpgradeFeature.FeatureSupport)((Object)((Object)value.get((Object)UpgradeMode.FAST)))));
                row.setValueAt(3, (Object)this.getSupportValue((UpgradeFeature.FeatureSupport)((Object)((Object)value.get((Object)UpgradeMode.ROLL)))));
                row.setValueAt(4, (Object)this.getSupportValue((UpgradeFeature.FeatureSupport)((Object)((Object)value.get((Object)UpgradeMode.PARALLEL)))));
                row.setValueAt(5, (Object)this.getSupportValue((UpgradeFeature.FeatureSupport)((Object)((Object)value.get((Object)UpgradeMode.APOLLO)))));
                defaultTableModel.addRow(new TableRow[]{row});
            });
        }

        private int[] getShownColumns() {
            List<String> noParallelVersion = Collections.singletonList("6.0.RC1");
            int[] showColumns = UpgradeModePanel.this.showApollo ? new int[]{0, 1, 2, 3, 4, 5} : (noParallelVersion.contains(UpgradeModePanel.this.currentVersion) ? new int[]{0, 1, 2, 3} : new int[]{0, 1, 2, 3, 4});
            return showColumns;
        }

        private String getSupportValue(UpgradeFeature.FeatureSupport supportType) {
            switch (supportType) {
                case SUPPORT: {
                    return this.support;
                }
                case NOT_SUPPORT: {
                    return this.notSupport;
                }
            }
            return "--";
        }

        private Component createUI() {
            JScrollPane tableJScroll = new JScrollPane((Component)this.deviceTable);
            return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), tableJScroll, Box.createHorizontalStrut(0)}), Box.createVerticalStrut(0)});
        }
    }

    private class UpgradeModeItem {
        private JRadioButton name;
        private JTextPane desc;
        private List<Component> extraComps = null;

        public UpgradeModeItem(JRadioButton name, JTextPane desc) {
            this.name = name;
            this.desc = desc;
        }

        public void setExtraComps(List<Component> extraComps) {
            this.extraComps = extraComps;
        }

        public List<Component> getExtraComps() {
            return this.extraComps;
        }
    }

    public static enum UpgradeMode {
        ONLINE,
        OFFLINE,
        FAST,
        ROLL,
        PARALLEL,
        APOLLO,
        PATCH_CONTAINER,
        OFFLINE_CONTAINER;

    }

    public static interface ICallBack {
        public void itemChanged();
    }
}

