/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Base64EncodeUtils {
    private static final Logger log = LoggerFactory.getLogger(Base64EncodeUtils.class);
    private static final int INT_2 = 2;

    private Base64EncodeUtils() {
    }

    public static String encode(String pliant) {
        if (StringUtils.isNULLStr(pliant)) {
            return "";
        }
        byte[] pliantByte = null;
        if (Base64EncodeUtils.isSingleByteEnvironment() && Base64EncodeUtils.isStrIncludeChinese(pliant)) {
            try {
                pliantByte = pliant.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("pliant.getBytes('UTF-8')", e);
                pliantByte = pliant.getBytes(Charset.defaultCharset());
            }
        } else {
            pliantByte = pliant.getBytes(Charset.defaultCharset());
        }
        return new String(Base64.encodeBase64((byte[])pliantByte));
    }

    public static String decode(String code) {
        if (StringUtils.isNULLStr(code)) {
            return "";
        }
        byte[] ret = null;
        try {
            ret = Base64.decodeBase64((String)code);
        }
        catch (Exception e) {
            log.error("decode base64 error.", e);
            return "";
        }
        if (Base64EncodeUtils.isSingleByteEnvironment() && Base64EncodeUtils.isStrIncludeChinese(code)) {
            try {
                return new String(ret, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("new String(ret, 'UTF-8')", e);
            }
        }
        return new String(ret, Charset.defaultCharset());
    }

    private static boolean isSingleByteEnvironment() {
        return "\u6d4b\u8bd5".getBytes(Charset.defaultCharset()).length == 2;
    }

    private static boolean isStrIncludeChinese(String str) {
        return Pattern.compile("[\u4e00-\u9fa5]").matcher(str).find();
    }

    public static String decodeNew(String code) {
        if (StringUtils.isNULLStr(code)) {
            return "";
        }
        byte[] ret = null;
        try {
            return new String(Base64.decodeBase64((String)code), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("new String(ret, 'UTF-8')", e);
        }
        catch (Exception e) {
            log.error("decode base64 error.", e);
            return "";
        }
        return new String(ret, Charset.defaultCharset());
    }

    public static String encodeNew(String pliant) {
        if (StringUtils.isNULLStr(pliant)) {
            return "";
        }
        byte[] pliantByte = null;
        try {
            pliantByte = pliant.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("pliant.getBytes('UTF-8')", e);
            pliantByte = pliant.getBytes(Charset.defaultCharset());
        }
        return new String(Base64.encodeBase64((byte[])pliantByte));
    }
}

