/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import sun.swing.FilePane;

public final class FileChooserWrapper
implements Serializable {
    private static final long serialVersionUID = -2439488771343897125L;
    private JTextField filenametext;
    private JFileChooser chooser;

    private FileChooserWrapper() {
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void setChooser(JFileChooser chooser) {
        this.chooser = chooser;
    }

    public static void wrapper(JFileChooser fileChooser) {
        FileChooserWrapper chooserWrapper = new FileChooserWrapper();
        chooserWrapper.setChooser(fileChooser);
        chooserWrapper.getTextField(fileChooser.getComponents());
    }

    public static void setDefaultFileName(String name, JFileChooser fileChooser, boolean fileNameEditable) {
        FileChooserWrapper chooserWrapper = new FileChooserWrapper();
        chooserWrapper.getTextField(fileChooser.getComponents());
        chooserWrapper.changeDoclistener();
        chooserWrapper.filenametext.setText(name);
        chooserWrapper.filenametext.setEditable(fileNameEditable);
    }

    private void changeDoclistener() {
        AbstractDocument abstracDoc = (AbstractDocument)this.filenametext.getDocument();
        DocumentListener docListener = ((DocumentListener[])abstracDoc.getListeners(DocumentListener.class))[0];
        this.filenametext.setDocument(new FileNameDocument());
        this.filenametext.getDocument().addDocumentListener(docListener);
    }

    public void handleTableHeader(JFileChooser chooserName) {
        Component[] allComponents;
        if (chooserName == null) {
            return;
        }
        for (Component component : allComponents = chooserName.getComponents()) {
            JTableHeader tableHeader;
            if (!(component instanceof FilePane) || (tableHeader = FileChooserWrapper.findTableheader(((FilePane)component).getComponents())) == null) continue;
            TableColumnModel tcm = tableHeader.getColumnModel();
            tcm.getColumn(0).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.name"));
            tcm.getColumn(1).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.size"));
            tcm.getColumn(2).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.type"));
            tcm.getColumn(3).setHeaderValue(ResourceUtil.getString("filechooser.prompt.file.date.modified"));
        }
    }

    private static JTableHeader findTableheader(Component[] comps) {
        for (Component cp : comps) {
            JTableHeader result;
            if (cp instanceof JTableHeader) {
                return (JTableHeader)cp;
            }
            if (cp instanceof JPanel) {
                return FileChooserWrapper.findTableheader(((JPanel)cp).getComponents());
            }
            if (cp instanceof JScrollPane) {
                Component[] compss = ((JScrollPane)cp).getComponents();
                return FileChooserWrapper.findTableheader(compss);
            }
            if (!(cp instanceof JViewport) || (result = FileChooserWrapper.findTableheader(((JViewport)cp).getComponents())) == null) continue;
            return result;
        }
        return null;
    }

    private void getTextField(Component[] allComponents) {
        block0: for (Component component : allComponents) {
            Component[] subComps;
            if (!(component instanceof JPanel)) continue;
            for (Component comp : subComps = ((JComponent)component).getComponents()) {
                AbstractButton btn;
                if (comp instanceof JTextField) {
                    this.filenametext = (JTextField)comp;
                    this.filenametext.setName("IsmFileChooser_FileName_Txt");
                    continue block0;
                }
                if (comp instanceof JButton) {
                    btn = (JButton)comp;
                    this.setBtnSize((JButton)btn);
                } else {
                    this.getTextField(subComps);
                }
                if (!(comp instanceof JToggleButton) || this.chooser == null) continue;
                btn = (JToggleButton)comp;
                this.updateListnerViewListner((JToggleButton)btn);
            }
        }
    }

    public void updateListnerViewListner(JToggleButton btn) {
        if (ResourceUtil.getString("filechooser.prompt.file.listview.tip").equalsIgnoreCase(btn.getToolTipText())) {
            final ActionListener[] listners = btn.getActionListeners();
            btn.removeActionListener(listners[0]);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    listners[0].actionPerformed(event);
                    FileChooserWrapper.this.handleTableHeader(FileChooserWrapper.this.chooser);
                }
            });
        }
    }

    private void setBtnSize(JButton bttton) {
        if (StringUtils.isNULLStr(bttton.getText())) {
            bttton.setPreferredSize(new Dimension(24, 16));
        }
    }

    private class FileNameDocument
    extends PlainDocument {
        private static final long serialVersionUID = -6025453852238999699L;
        private String fileNameRegex = ApplicationContext.getInstance().isWindowsOS() ? "[^|/*?<>]+" : "[^|*?<>]+";

        @Override
        public void insertString(int offs, String str, AttributeSet attributeSet) throws BadLocationException {
            if (!this.checkStr(str)) {
                return;
            }
            String text = FileChooserWrapper.this.filenametext.getText();
            String temp = null;
            temp = 0 == offs ? str + text : (text.length() == offs ? text + str : text.substring(0, offs) + str + text.substring(offs));
            if (temp.startsWith(".") || temp.contains("..")) {
                return;
            }
            super.insertString(offs, str, attributeSet);
        }

        private boolean checkStr(String str) {
            return str.matches(this.fileNameRegex);
        }
    }
}

