/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OemUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ResourceUtil {
    private static final String DEFAULTICONPATH = "/config/images/none.png";
    private static final String PICPATH = "config/images/";
    private static final String OEM_PROPERTIES_ZH = "logo/res/common_zh.properties";
    private static final String OEM_PROPERTIES_EN = "logo/res/common_en.properties";
    private static final String OEM_RES_KEYS = "logo/res/reslist.xml";
    private static final String OEM_PICPATH = "logo/img/";
    private static List<String> oemKeys = new ArrayList<String>();
    private static List<String> expansionEvalKeys = new ArrayList<String>();
    private static List<String> customizedSceneKeys = new ArrayList<String>();
    private static boolean oemSupported = false;
    private static Properties oemPropertiesZh = new Properties();
    private static Properties oemPropertiesEn = new Properties();
    private static boolean isExpansionEvalScene = false;
    private static final String EXPANSION_EVAL_RES_KEYS = "expansionEvaluate/expansion_eval_reslist.xml";
    private static final String EXPANSION_EVAL_PROPERTIES_ZH = "expansionEvaluate/expansion_eval_zh.properties";
    private static final String EXPANSION_EVAL_PROPERTIES_EN = "expansionEvaluate/expansion_eval_en.properties";
    public static final String INSPECT_OBJECT = "jsonSceneArgsList";
    private static Properties expansionEvalPropertiesZh = new Properties();
    private static Properties expansionEvalPropertiesEn = new Properties();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ResourceUtil.class);
    private static Properties customizedPropertiesZh = new Properties();
    private static Properties customizedPropertiesEn = new Properties();
    private static boolean isCustomizedScene = false;

    private ResourceUtil() {
    }

    public static String getArgsParamFormSceneConfig(String key) {
        block5: {
            String currentScenceToolBoxString = System.getenv(INSPECT_OBJECT);
            if (!StringUtils.isNULLStr((String)currentScenceToolBoxString)) {
                try {
                    JSONObject jsonObject = new JSONObject(currentScenceToolBoxString);
                    currentScenceToolBoxString = jsonObject.getString(key);
                    return currentScenceToolBoxString;
                }
                catch (JSONException e) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("get " + key + "  failed.");
                    }
                }
                catch (RuntimeException e) {
                    if (!LOGGER.isInfoEnabled()) break block5;
                    LOGGER.info("get " + key + "  failed.");
                }
            }
        }
        return "";
    }

    public static boolean isOemSupported() {
        return oemSupported;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = ResourceUtil.class.getClassLoader();
        StackTraceElement[] stackList = Thread.currentThread().getStackTrace();
        if (null != stackList) {
            for (StackTraceElement stackTraceElement : stackList) {
                String className = stackTraceElement.getClassName();
                if (ResourceUtil.class.getName().equals(className) || Thread.class.getName().equals(className) || ToolException.class.getName().equals(className)) continue;
                try {
                    Class<?> cl = Class.forName(className);
                    classLoader = cl.getClassLoader();
                    break;
                }
                catch (ClassNotFoundException e) {
                    ToolLoggerFactory.getLogger(ResourceUtil.class).error("load class error.", e);
                }
            }
        }
        return classLoader;
    }

    public static String getUndefindStringReturnKey(String key) {
        if (ApplicationContext.getInstance().isJunit()) {
            return "NEXT(N)";
        }
        return ResourceUtil.getStringByKey(key, ApplicationContext.getInstance().getCurrentLanguage());
    }

    private static String getStringByKey(String key, Locale locale) {
        if (ApplicationContext.getInstance().isJunit()) {
            return "Next";
        }
        if (oemSupported && ResourceUtil.isOemKey(key)) {
            return ResourceUtil.getCustomedString(key, locale);
        }
        ClassLoader classLoader = ContextUtil.getContextClassLoader(ResourceUtil.class);
        String returnValue = key;
        try {
            String pluginId = ContextUtil.getContextPackageName(ResourceUtil.class);
            String resPath = ContextUtil.getObaseResPath((String)pluginId);
            ResourceBundle resources = ResourceBundle.getBundle(resPath, locale, classLoader);
            returnValue = resources.getString(key);
        }
        catch (Exception ex) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key + ";contextClassLoader:" + classLoader, ex);
        }
        return returnValue;
    }

    private static String getCustomedString(String key, Locale loc) {
        if (ApplicationContext.getInstance().isJunit()) {
            return "Next";
        }
        Properties properties = null;
        if (oemSupported) {
            properties = "en".equalsIgnoreCase(loc.getLanguage()) ? oemPropertiesEn : oemPropertiesZh;
        } else if (isCustomizedScene) {
            properties = "en".equalsIgnoreCase(loc.getLanguage()) ? customizedPropertiesEn : customizedPropertiesZh;
        } else {
            Properties properties2 = properties = "en".equalsIgnoreCase(loc.getLanguage()) ? expansionEvalPropertiesEn : expansionEvalPropertiesZh;
        }
        if (null == properties || properties.isEmpty()) {
            return "--";
        }
        String value = (String)properties.get(key);
        if (StringUtils.isNULLStr((String)value)) {
            return "--";
        }
        return value;
    }

    public static String getString(String key) {
        if (ApplicationContext.getInstance().isJunit()) {
            return "NEXT(N)";
        }
        return ResourceUtil.getString(key, ApplicationContext.getInstance().getCurrentLanguage());
    }

    public static String getStringWithParams(String key, Object ... params) {
        return ResourceUtil.getStringWithParams(key, ApplicationContext.getInstance().getCurrentLanguage(), params);
    }

    public static String getString(String key, Locale locale) {
        if (ApplicationContext.getInstance().isJunit()) {
            return "Next";
        }
        if (oemSupported && ResourceUtil.isOemKey(key)) {
            return ResourceUtil.getCustomedString(key, locale);
        }
        if (isExpansionEvalScene && ResourceUtil.isExpansionEvalKey(key)) {
            return ResourceUtil.getCustomedString(key, locale);
        }
        if (isCustomizedScene && customizedSceneKeys.contains(key)) {
            return ResourceUtil.getCustomedString(key, locale);
        }
        ClassLoader classLoader = ContextUtil.getContextClassLoader(ResourceUtil.class);
        String value = null;
        try {
            String pluginId = ContextUtil.getContextPackageName(ResourceUtil.class);
            String resPath = ContextUtil.getObaseResPath((String)pluginId);
            ResourceBundle resources = ResourceBundle.getBundle(resPath, locale, classLoader);
            value = resources.getString(key);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key + ";contextClassLoader:" + classLoader);
        }
        return null == value ? "--" : value;
    }

    public static String getString(ResourceBundle bundle, String key) {
        String value = "--";
        try {
            value = bundle.getString(key);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key);
        }
        return value;
    }

    public static String getString(ResourceBundle bundle, ResourceBundle defaultBundle, String key) {
        String value = "--";
        String readValue = ResourceUtil.getString(bundle, key);
        if (value.equalsIgnoreCase(readValue)) {
            return ResourceUtil.getString(defaultBundle, key);
        }
        return readValue;
    }

    public static String getString(String key, ResourceBundle ... bundles) {
        for (ResourceBundle bundle : bundles) {
            String value;
            if (bundle == null || "--".equals(value = ResourceUtil.getString(bundle, key))) continue;
            return value;
        }
        return "--";
    }

    public static String getStringHandledNewline(ResourceBundle bundle, ResourceBundle defaultBundle, String key) {
        return ResourceUtil.getString(bundle, defaultBundle, key).replaceAll("\n", "<br/>");
    }

    public static String replaceWrapLineToBr(String content) {
        return content.replaceAll("\n", "<br/>");
    }

    public static String getStringHandledNewline(String key, ResourceBundle ... bundles) {
        return ResourceUtil.getString(key, bundles).replaceAll("\n", "<br/>");
    }

    public static String getStringWithParams(String key, Locale locale, Object ... params) {
        String value = ResourceUtil.getString(key, locale);
        value = StringUtils.fillValues((String)value, (Object[])params);
        return value;
    }

    public static ImageIcon getImage(String key) {
        if (ApplicationContext.getInstance().isJunit()) {
            return new ImageIcon(new BufferedImage(1, 1, 1));
        }
        if (oemSupported && ResourceUtil.isOemKey(key)) {
            return ResourceUtil.getOemImageIcon(key);
        }
        return ResourceUtil.getImageByClassLoader(PICPATH, key);
    }

    public static ImageIcon getOEMImage(String oemImgKey) {
        if (oemSupported && ResourceUtil.isOemKey(oemImgKey)) {
            return ResourceUtil.getOemImageIcon(oemImgKey);
        }
        return ResourceUtil.getImageByClassLoader(PICPATH + OemUtils.getVender().toLowerCase(Locale.ENGLISH) + "/", oemImgKey);
    }

    public static ImageIcon getImageByClassLoader(String picturePath, String key) {
        URL imgURL;
        if (ApplicationContext.getInstance().isJunit()) {
            return new ImageIcon(new byte[]{0, 1});
        }
        ClassLoader classLoader = ContextUtil.getContextClassLoader(ResourceUtil.class);
        ImageIcon icon = null;
        if (null != classLoader && null != (imgURL = classLoader.getResource(picturePath + key))) {
            icon = new ImageIcon(imgURL);
            return icon;
        }
        ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find image: " + picturePath + key);
        try {
            URL url;
            ClassLoader cl = ResourceUtil.class.getClassLoader();
            if (null != cl && null != (url = cl.getResource(DEFAULTICONPATH))) {
                icon = new ImageIcon(url);
                return icon;
            }
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find default icon.");
            icon = new ImageIcon(new BufferedImage(1, 1, 1));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find default icon.", e);
            icon = new ImageIcon(new BufferedImage(1, 1, 1));
        }
        return icon;
    }

    public static ImageIcon getOemImageIcon(String key) {
        if (ApplicationContext.getInstance().isJunit()) {
            return new ImageIcon(new byte[]{0, 1});
        }
        File sysFile = new File(ApplicationContext.getInstance().getConfigurationPath(), OEM_PICPATH);
        return new ImageIcon(FilePathUtils.getCanonicalPath((File)sysFile) + File.separator + key);
    }

    public static InputStream getStreamFromJar(String res) {
        ClassLoader classLoader = ResourceUtil.getContextClassLoader();
        if (null == classLoader) {
            return null;
        }
        return classLoader.getResourceAsStream(res);
    }

    public static boolean isOemKey(String key) {
        return oemKeys.contains(key);
    }

    public static boolean isExpansionEvalKey(String key) {
        return expansionEvalKeys.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadOemResKeys() {
        File sysResListFile = new File(ApplicationContext.getInstance().getConfigurationPath(), OEM_RES_KEYS);
        Document doc = null;
        FileInputStream filedInput = null;
        try {
            filedInput = new FileInputStream(sysResListFile.getCanonicalFile());
            doc = XmlUtils.parseDocument(filedInput);
            Collection<Element> keys = XmlUtils.searchByExp2Ele(doc.getDocumentElement(), "/reslist/reskey");
            for (Element key : keys) {
                oemKeys.add(key.getTextContent());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)sysResListFile.getName());
            StreamUtils.closeStream(null, filedInput);
        }
        catch (Throwable e1) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("read reslist error.");
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, filedInput);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, filedInput);
        }
        StreamUtils.closeStream(null, filedInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadExpasionEvalResKeys() {
        File sysResListFile = new File(ApplicationContext.getInstance().getConfigurationPath(), EXPANSION_EVAL_RES_KEYS);
        Document doc = null;
        FileInputStream filedInput = null;
        try {
            filedInput = new FileInputStream(sysResListFile.getCanonicalFile());
            doc = XmlUtils.parseDocument(filedInput);
            Collection<Element> keys = XmlUtils.searchByExp2Ele(doc.getDocumentElement(), "/reslist/reskey");
            for (Element key : keys) {
                expansionEvalKeys.add(key.getTextContent());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)sysResListFile.getName());
            StreamUtils.closeStream(null, filedInput);
        }
        catch (Throwable e1) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("read reslist error.");
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, filedInput);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, filedInput);
        }
        StreamUtils.closeStream(null, filedInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties loadProperties(String fileName) {
        File file = FilePathUtils.checkFile((File)new File(ApplicationContext.getInstance().getConfigurationPath(), fileName));
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        try {
            fileInputStream = new FileInputStream(file.getCanonicalFile());
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)file.getName());
            StreamUtils.closeStream(null, fileInputStream);
        }
        catch (Exception ex) {
            LOGGER.error("load properties error", ex);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, fileInputStream);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, fileInputStream);
        }
        StreamUtils.closeStream(null, fileInputStream);
        return properties;
    }

    public static void initCustomizedResource(String keysPath, String propertiesZhPath, String propertiesEnPath) {
        isCustomizedScene = true;
        customizedPropertiesZh = ResourceUtil.loadProperties(propertiesZhPath);
        customizedPropertiesEn = ResourceUtil.loadProperties(propertiesEnPath);
        ResourceUtil.loadCustomizedKeys(customizedSceneKeys, keysPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadCustomizedKeys(List<String> customizedKeys, String keyPath) {
        File sysResListFile = FilePathUtils.checkFile((File)new File(ApplicationContext.getInstance().getConfigurationPath(), keyPath));
        Document doc = null;
        FileInputStream filedInput = null;
        try {
            filedInput = new FileInputStream(sysResListFile.getCanonicalFile());
            doc = XmlUtils.parseDocument(filedInput);
            Collection<Element> keys = XmlUtils.searchByExp2Ele(doc.getDocumentElement(), "/reslist/reskey");
            for (Element key : keys) {
                customizedKeys.add(key.getTextContent());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found:{}", (Object)sysResListFile.getName());
            StreamUtils.closeStream(null, filedInput);
        }
        catch (Throwable e1) {
            LOGGER.error("read reslist error.");
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, filedInput);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, filedInput);
        }
        StreamUtils.closeStream(null, filedInput);
    }

    static {
        oemSupported = "true".equalsIgnoreCase(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getAppConfig("app.oem.mode.enabled"));
        isExpansionEvalScene = "exInspect".equalsIgnoreCase(ResourceUtil.getArgsParamFormSceneConfig("effectiveScene"));
        ResourceUtil.loadOemResKeys();
        oemPropertiesZh = ResourceUtil.loadProperties(OEM_PROPERTIES_ZH);
        oemPropertiesEn = ResourceUtil.loadProperties(OEM_PROPERTIES_EN);
        ResourceUtil.loadExpasionEvalResKeys();
        expansionEvalPropertiesZh = ResourceUtil.loadProperties(EXPANSION_EVAL_PROPERTIES_ZH);
        expansionEvalPropertiesEn = ResourceUtil.loadProperties(EXPANSION_EVAL_PROPERTIES_EN);
    }
}

