/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpUtils {
    public static final String FULL_PERM = "111";
    private static final String MKDIR_CMDS = "mkdir -p ";
    private static final Logger LOGGER = LoggerFactory.getLogger(SftpUtils.class);
    public static final int INVALID_PERM = -1;

    public static int convertRightToInt(String rightInfo) {
        try {
            int result = 0;
            for (int i = 0; i < 3; ++i) {
                int valu = rightInfo.charAt(i) - 48;
                result = (int)((double)result + Math.pow(2 * valu, 2 - i));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("convert error" + rightInfo, e);
            return -1;
        }
    }

    public static int convertRightToInt(String[] rightInfos) {
        if (rightInfos == null) {
            return -1;
        }
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < rightInfos.length; ++i) {
            int result = SftpUtils.convertRightToInt(rightInfos[i]);
            if (result == -1) {
                return result;
            }
            resultSb.append(result);
        }
        if (resultSb.length() > 0) {
            return Integer.parseInt(resultSb.toString());
        }
        return -1;
    }

    public static String[] getUploadAuthPath(SshConnection originalConnection, String serverFilePath) {
        if (originalConnection != null && originalConnection.getdNode() != null && SshConnectionManager.getRuserMap().containsKey(originalConnection.getdNode().getDevKey())) {
            try {
                String right;
                String chmodFile = serverFilePath;
                if (chmodFile.contains(".")) {
                    chmodFile = new File(serverFilePath).getParent().replace("\\", "/");
                }
                if ((right = originalConnection.getCurpathRight(chmodFile)).contains("No such file or directory")) {
                    originalConnection.execCmd(MKDIR_CMDS + chmodFile);
                    right = originalConnection.getCurpathRight(chmodFile);
                }
                return new String[]{chmodFile.replace("\\", "/"), right};
            }
            catch (Exception e) {
                LOGGER.error("auth file permError", e);
            }
        }
        return new String[0];
    }

    public static String[] getFilePermDetail(String cmdRtn) {
        if (StringUtils.isNULLStr(cmdRtn)) {
            return new String[0];
        }
        String[] lines = cmdRtn.split("\n");
        String[] rightInfo = lines[1].split(" ");
        String rInfo = rightInfo[0].replaceAll("[.+]", "");
        return SftpUtils.getCurpathRightDetail(rInfo);
    }

    public static String[] getCurpathRightDetail(String rInfo) {
        ToolLoggerFactory.getLogger(SshConnection.class).info("fileRight info:" + rInfo);
        if (StringUtils.isNULLStr(rInfo) || rInfo.length() < 9) {
            return new String[0];
        }
        StringBuilder result = new StringBuilder();
        int length = 0;
        for (int i = 1; i < rInfo.length(); ++i) {
            if (rInfo.charAt(i) != '-') {
                result.append('1');
            } else {
                result.append('0');
            }
            if (++length % 3 != 0 || i == rInfo.length() - 1 || length <= 0) continue;
            result.append(',');
        }
        return result.toString().split(",");
    }
}

