/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;

public final class GifAssistant {
    private static GifAssistant assistant = new GifAssistant();
    private static final String ENDSTR = ".png";
    private static final String HEADSTR = "loading";
    private volatile boolean isStarted = false;
    private static final int DURATION_TIME = 200;
    private int startNumber = 1;
    private ImageIcon processingImage = ResourceUtil.getImage("loading1.png");
    private ScheduledExecutorService gifTimmerPool;
    private final Object lock = new Object();
    private IGifUiObserver observer;

    public IGifUiObserver getObserver() {
        return this.observer;
    }

    public void setObserver(IGifUiObserver observer) {
        this.observer = observer;
    }

    public ImageIcon getProcessingImage() {
        return this.processingImage;
    }

    public void setProcessingImage(ImageIcon processingImage) {
        this.processingImage = processingImage;
    }

    private GifAssistant(IGifUiObserver observer) {
        this.observer = observer;
    }

    private GifAssistant() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStarted) {
                return;
            }
            this.gifTimmerPool = Executors.newSingleThreadScheduledExecutor();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StringBuffer hearBuffer = new StringBuffer(GifAssistant.HEADSTR);
                    String finalName = hearBuffer.append(GifAssistant.this.getNextCircleNumber()).append(GifAssistant.ENDSTR).toString();
                    GifAssistant.this.setProcessingImage(ResourceUtil.getImage(finalName));
                    if (GifAssistant.this.observer != null) {
                        GifAssistant.this.observer.refreshLoadingPic();
                    }
                }
            });
            thread.setPriority(10);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable throwable) {
                    LoggerFactory.getLogger(GifAssistant.class).error("gif run error {}", throwable);
                }
            });
            this.gifTimmerPool.scheduleAtFixedRate(thread, 200L, 200L, TimeUnit.MILLISECONDS);
            this.isStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGifLoading() {
        Object object = this.lock;
        synchronized (object) {
            this.isStarted = false;
            if (null != this.gifTimmerPool) {
                this.gifTimmerPool.shutdown();
            }
        }
    }

    public boolean isStart() {
        return this.isStarted;
    }

    private int getNextCircleNumber() {
        return this.startNumber++ & 7;
    }

    public static GifAssistant getInstance() {
        return assistant;
    }

    public static interface IGifUiObserver {
        public void refreshLoadingPic();
    }
}

