/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.IMOKey;
import com.huawei.ism.tlv.docoder.ParamType;

public class TLVTag
implements IMOKey {
    private ParamType dataType = null;
    private String paramName;
    private final int index;

    public TLVTag(String paramName, int paramIndex, ParamType type) {
        this.paramName = paramName;
        this.index = paramIndex;
        this.dataType = type;
    }

    public String getTagName() {
        return this.paramName;
    }

    @Deprecated
    public String getTagDescription() {
        return ResourceManager.getString(this.paramName);
    }

    public void setTagName(String tagName) {
        this.paramName = tagName;
    }

    public int getParamIndex() {
        return this.index;
    }

    public ParamType getParamType() {
        return this.dataType;
    }

    @Override
    public int compareTo(IMOKey other) {
        if (!(other instanceof TLVTag)) {
            return 0;
        }
        int otherIndex = ((TLVTag)other).getParamIndex();
        return this.index > otherIndex ? 1 : (this.index == otherIndex ? 0 : -1);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TLVTag other = (TLVTag)obj;
        return this.index == other.index;
    }

    public String toString() {
        return this.paramName + '(' + (Object)((Object)this.dataType) + ", " + this.index + ')';
    }

    @Override
    public String toJSONStr() {
        return this.paramName;
    }

    @Override
    public IMOKey.MOValueDataType getMOValueDataType() {
        if (this.dataType == null) {
            return null;
        }
        switch (this.dataType) {
            case STRING: {
                return IMOKey.MOValueDataType.STRING;
            }
            case UNSIGN_INT: {
                return IMOKey.MOValueDataType.UNSIGN_INT;
            }
            case SIGN_INT: {
                return IMOKey.MOValueDataType.SIGN_INT;
            }
            case BOOL: {
                return IMOKey.MOValueDataType.BOOL;
            }
            case ENUM: {
                return IMOKey.MOValueDataType.INT32;
            }
            case ARRAY: {
                return IMOKey.MOValueDataType.ARRAY;
            }
            case JSON: {
                return IMOKey.MOValueDataType.JSON;
            }
            case TIME: {
                return IMOKey.MOValueDataType.TIME;
            }
        }
        return IMOKey.MOValueDataType.OBJECT;
    }
}

