/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.bean;

import com.huawei.ism.tlv.lang.SignedInt16;
import com.huawei.ism.tlv.lang.SignedInt32;
import com.huawei.ism.tlv.lang.SignedInt64;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import java.io.IOException;
import java.io.Serializable;

public class MessageHead
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2559367505723503876L;
    private int magicWord = 0x55555555;
    private int version = 3;
    private long status = 0L;
    private long sessionKey = 0x660001L;
    private long operationCode;
    private int dataLength = 0;
    private short nodeId = (short)-1;
    private short reserved = (short)-1;
    private short messageBoardId = (short)-1;
    private short serial = (short)-1;

    public MessageHead() {
    }

    public MessageHead(int magicWord, int version, long status, int sessionKey, long operationCode, int dataLength) {
        this.magicWord = magicWord;
        this.version = version;
        this.status = status;
        this.sessionKey = sessionKey;
        this.operationCode = operationCode;
        this.dataLength = dataLength;
    }

    public MessageHead(byte[] head) {
        if (null == head || head.length < 28) {
            String msg = "Head data cannot be null or head data length less than ";
            throw new IllegalArgumentException(msg + 28);
        }
        byte[] bytes = new byte[4];
        System.arraycopy(head, 0, bytes, 0, 4);
        this.setMagicWord(new SignedInt32(bytes).intValue());
        System.arraycopy(head, 4, bytes, 0, 4);
        this.setVersion(new SignedInt32(bytes).intValue());
        System.arraycopy(head, 8, bytes, 0, 4);
        this.setStatus(new UnsignedInt32(bytes).longValue());
        System.arraycopy(head, 12, bytes, 0, 4);
        this.setSessionKey(new UnsignedInt32(bytes).longValue());
        if (this.getVersion() == 3) {
            bytes = new byte[2];
            System.arraycopy(head, 16, bytes, 0, 2);
            this.setNodeId(new SignedInt16(bytes).shortValue());
            System.arraycopy(head, 18, bytes, 0, 2);
            this.setReserved(new SignedInt16(bytes).shortValue());
            System.arraycopy(head, 20, bytes, 0, 2);
            this.setMessageBoardId(new SignedInt16(bytes).shortValue());
            System.arraycopy(head, 22, bytes, 0, 2);
            this.setSerial(new SignedInt16(bytes).shortValue());
        } else {
            bytes = new byte[8];
            System.arraycopy(head, 16, bytes, 0, 8);
            this.setOperationCode(new SignedInt64(bytes).longValue());
        }
        bytes = new byte[4];
        System.arraycopy(head, 24, bytes, 0, 4);
        this.setDataLength(new SignedInt32(bytes).intValue());
    }

    public int getMagicWord() {
        return this.magicWord;
    }

    public void setMagicWord(int magicWord) {
        this.magicWord = magicWord;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getStatus() {
        return this.status;
    }

    public void setStatus(long status) {
        this.status = status;
    }

    public long getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(long sessionKey) {
        this.sessionKey = sessionKey;
    }

    public long getOperationCode() {
        return this.operationCode;
    }

    public void setOperationCode(long operationCode) {
        this.operationCode = operationCode;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(short nodeId) {
        this.nodeId = nodeId;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(short reserved) {
        this.reserved = reserved;
    }

    public short getMessageBoardId() {
        return this.messageBoardId;
    }

    public void setMessageBoardId(short messageBoardId) {
        this.messageBoardId = messageBoardId;
    }

    public int getSerial() {
        return this.serial;
    }

    public void setSerial(short serial) {
        this.serial = serial;
    }

    /*
     * Exception decompiling
     */
    public byte[] toByteArray() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object clone() throws CloneNotSupportedException {
        MessageHead head = null;
        head = (MessageHead)super.clone();
        head.magicWord = this.magicWord;
        head.status = this.status;
        head.version = this.version;
        head.sessionKey = this.sessionKey;
        head.operationCode = this.operationCode;
        head.dataLength = this.dataLength;
        return head;
    }

    public String toString() {
        return "MessageHead [operationCode=" + this.operationCode + ", dataLength=" + this.dataLength + ", msn=" + this.serial + ", magicWord=" + this.magicWord + ", status=" + this.status + ", version=" + this.version + ']';
    }
}

