/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.command;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.ui.module.command.CommandExcutorObserver;
import com.huawei.ism.ui.swing.table.IsmVirtualTable;
import com.huawei.ism.ui.swing.table.IsmVirtualTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.table.VirtualIconCellValueBean;
import com.huawei.ism.ui.swing.table.VirtualTableModel;
import com.huawei.ism.ui.swing.table.VirtualTableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CommandExcutorMonitor
extends IsmDialog
implements CommandExcutorObserver {
    private static final long serialVersionUID = 1L;
    private JButton completeButton;
    private Layout layout;

    public CommandExcutorMonitor(Window window) {
        super(window);
        this.setTitle(ResourceManager.getString("HOSTPORT_CONFIG_RESULT"));
        this.completeButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CLOSE"), 'L');
        this.completeButton.setEnabled(false);
        this.layout = new Layout();
        this.getDialogContentPane().add(this.layout);
        this.getSouthBox().add(this.completeButton);
        this.getRootPane().setDefaultButton(this.completeButton);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addEventHandler();
        SwingUtil.setName(this);
        this.setSize(550, 375);
        SwingUtil.cancelEscKeyToClose(this);
        this.getDialogContentPane().setFocusable(true);
        this.pack();
    }

    private void addEventHandler() {
        this.completeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandExcutorMonitor.this.setVisible(false);
                CommandExcutorMonitor.this.dispose();
            }
        });
    }

    @Override
    public void fireAddCommand(Command ... commands) {
        List<VirtualTableRow<?, ?>> tableRows = this.cmdToTableRows(commands);
        this.layout.commandTableModel.setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                CommandExcutorMonitor.this.layout.commandTableModel.readyForDisplay(0, CommandExcutorMonitor.this.layout.commandTable);
                CommandExcutorMonitor.this.layout.commandTable.repaint();
            }
        });
    }

    @Override
    public void fireStateChanged(Command ... commands) {
        for (Command command : commands) {
            VirtualTableRow tableRow = (VirtualTableRow)this.layout.commandTableModel.getTableRowBy(command);
            tableRow.setValueAt(1, this.getIconCellValueBy(command));
            tableRow.setValueAt(2, command.getResult());
        }
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                CommandExcutorMonitor.this.layout.commandTable.repaint();
            }
        });
    }

    @Override
    public void fireExcuteFinished() {
        this.setDefaultCloseOperation(2);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.completeButton.setEnabled(true);
        this.completeButton.requestFocus();
        this.getDialogContentPane().setFocusable(false);
    }

    private List<VirtualTableRow<?, ?>> cmdToTableRows(Command ... commands) {
        ArrayList tableRows = new ArrayList(0);
        VirtualTableRow<Command, Command> tableRow = null;
        for (Command command : commands) {
            tableRow = this.convertCmdToTableRow(command);
            tableRows.add(tableRow);
        }
        return tableRows;
    }

    private VirtualTableRow<Command, Command> convertCmdToTableRow(Command command) {
        VirtualTableRow<Command, Command> tableRow = new VirtualTableRow<Command, Command>(Layout.getCommandTableColNames().length, command, command);
        String desc = command.getDescription();
        if (desc == null) {
            tableRow.setValueAt(0, "--");
        } else {
            tableRow.setValueAt(0, desc);
        }
        tableRow.setValueAt(1, this.getIconCellValueBy(command));
        tableRow.setValueAt(2, command.getResult());
        return tableRow;
    }

    private VirtualIconCellValueBean getIconCellValueBy(Command command) {
        CommandExcutor.CommandState state = command.getCommandState();
        Icon icon = state.getIcon();
        if (state == CommandExcutor.CommandState.EXECUTING) {
            icon = null;
        }
        return new VirtualIconCellValueBean(icon, state.toString());
    }

    private static final class Layout
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int commonColWith = 190;
        private IsmVirtualTable commandTable;
        private VirtualTableModel commandTableModel;

        public Layout() {
            this.doLayoutPane();
        }

        private void doLayoutPane() {
            this.commandTableModel = new MyVirtualModel(Layout.getCommandTableColNames(), new int[0]);
            this.commandTable = new IsmVirtualTable(this.commandTableModel);
            this.commandTable.getColumnModel().getColumn(0).setPreferredWidth(this.commonColWith);
            this.commandTable.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.commandTable.getColumnModel().getColumn(2).setPreferredWidth(this.commonColWith);
            TableScrollPane commandScrollPane = TableScrollPane.createVirtualTablePane(this.commandTable, false);
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)commandScrollPane, "Center");
            this.setBorder(UCD.createEmptyBorder());
        }

        public void updateData(List<TableRow> rows) {
            boolean isAllSuccuss = true;
            Command com = null;
            for (TableRow tableRow : rows) {
                com = (Command)tableRow.getUserObject();
                if (!CommandExcutor.CommandState.FAILED.equals((Object)com.getCommandState())) continue;
                isAllSuccuss = false;
            }
            if (!isAllSuccuss) {
                this.commandTable.getColumnModel().getColumn(0).setPreferredWidth(this.commonColWith - 50);
                this.commandTable.getColumnModel().getColumn(2).setPreferredWidth(this.commonColWith + 50);
            } else {
                this.commandTable.getColumnModel().getColumn(0).setPreferredWidth(this.commonColWith);
                this.commandTable.getColumnModel().getColumn(2).setPreferredWidth(this.commonColWith);
            }
            this.commandTableModel.reset(rows, this.commandTable);
        }

        private static String[] getCommandTableColNames() {
            return new String[]{ResourceManager.getString("OPERATION"), ResourceManager.getString("STATE"), ResourceManager.getString("FALLS_REASON")};
        }

        private static final class MyVirtualModel
        extends VirtualTableModel {
            private static final long serialVersionUID = 0L;

            private MyVirtualModel(String[] columnNames, int ... visibleColumnIds) {
                super(columnNames, visibleColumnIds);
            }

            @Override
            public IsmVirtualTableCell[] getCompoents() {
                IsmVirtualTableCell[] cells = new IsmVirtualTableCell[]{new IsmVirtualTableCell.VirtualTextCell(2), new IsmVirtualTableCell.VirtualIconCell(), new IsmVirtualTableCell.VirtualTextCell(2)};
                return cells;
            }
        }
    }
}

