/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class IsmFileTree
extends JTree {
    public static final FileSystemView FILESYSTEM_VIEW = FileSystemView.getFileSystemView();
    private static final long serialVersionUID = 1L;
    private DefaultTreeModel treeModel;

    public IsmFileTree() {
        this(new DirFilter());
    }

    public IsmFileTree(FileFilter filter) {
        FileNode root = new FileNode(FILESYSTEM_VIEW.getRoots()[0], filter);
        this.treeModel = new DefaultTreeModel(root);
        root.explore();
        this.treeModel.nodeStructureChanged(root);
        this.setModel(this.treeModel);
        this.addTreeExpansionListener(new IsmFileTreeExpandsionListener());
    }

    public FileNode getSelectFileNode() {
        TreePath path = this.getSelectionPath();
        if (path == null || path.getLastPathComponent() == null) {
            return null;
        }
        return (FileNode)path.getLastPathComponent();
    }

    public File getSelectFile() {
        FileNode node = this.getSelectFileNode();
        return node == null ? null : node.getFile();
    }

    public static class DirFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    public static class FileNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private boolean explored = false;
        private transient FileFilter filter = null;

        public FileNode(File file, FileFilter filter) {
            this.filter = filter == null ? new DirFilter() : filter;
            this.setUserObject(file);
        }

        @Override
        public boolean getAllowsChildren() {
            return this.isDirectory();
        }

        public boolean isDirectory() {
            return !this.isLeaf();
        }

        @Override
        public boolean isLeaf() {
            return this.getFile().isFile();
        }

        public File getFile() {
            return (File)this.getUserObject();
        }

        public boolean isExplored() {
            return this.explored;
        }

        public void setExplored(boolean explored) {
            this.explored = explored;
        }

        @Override
        public String toString() {
            return FILESYSTEM_VIEW.getSystemDisplayName(this.getFile());
        }

        public void explore() {
            if (!this.explored) {
                int i;
                this.explored = true;
                File file = this.getFile();
                File[] children = file.listFiles();
                if (children == null || children.length == 0) {
                    return;
                }
                ArrayList<File> listDir = new ArrayList<File>(0);
                ArrayList<File> listFile = new ArrayList<File>(0);
                File f = null;
                for (i = 0; i < children.length; ++i) {
                    f = children[i];
                    if (f.toString().equals("\u7f51\u4e0a\u90bb\u5c45") || f.toString().equals("My Network Places") || !this.filter.accept(f)) continue;
                    if (f.isDirectory()) {
                        listDir.add(f);
                        continue;
                    }
                    listFile.add(f);
                }
                Collections.sort(listDir);
                Collections.sort(listFile);
                for (i = 0; i < listDir.size(); ++i) {
                    this.add(new FileNode((File)listDir.get(i), this.filter));
                }
                for (i = 0; i < listFile.size(); ++i) {
                    this.add(new FileNode((File)listFile.get(i), this.filter));
                }
            }
        }
    }

    static class IsmFileTreeExpandsionListener
    implements TreeExpansionListener {
        IsmFileTreeExpandsionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            if (path == null || path.getLastPathComponent() == null) {
                return;
            }
            FileNode node = (FileNode)path.getLastPathComponent();
            node.explore();
            JTree tree = (JTree)event.getSource();
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            treeModel.nodeStructureChanged(node);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent arg0) {
        }
    }
}

