/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.control;

import com.huawei.ism.ui.swing.text.IsmTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class RequiredHBox
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel signLabel;
    private JComponent jComponent;
    private boolean isEnabled = true;
    private boolean isStar = true;

    public RequiredHBox(JComponent jComponent, boolean isStar) {
        super(new BorderLayout());
        if (null == jComponent) {
            throw new NullPointerException();
        }
        this.jComponent = jComponent;
        if (this.jComponent instanceof JLabel) {
            jComponent.setPreferredSize(new Dimension(0, 12));
        }
        this.isStar = isStar;
        this.createComponents();
        if (this.jComponent instanceof JScrollPane || this.jComponent instanceof IsmTextArea || this.jComponent instanceof JPanel) {
            this.layoutComponents(true);
        } else {
            this.layoutComponents(false);
        }
    }

    private void createComponents() {
        this.signLabel = new JLabel(this.getIcon());
    }

    private void layoutComponents(boolean isTextArea) {
        if (isTextArea) {
            Box boxx = Box.createVerticalBox();
            boxx.add(Box.createVerticalStrut(6));
            boxx.add(this.signLabel);
            this.add((Component)boxx, "West");
        } else {
            this.add((Component)this.signLabel, "West");
        }
        if (null != this.jComponent) {
            this.add((Component)this.jComponent, "Center");
        }
    }

    private Icon getIcon() {
        if (this.isEnabled && this.isStar) {
            return UIManager.getIcon("RequiredHBox.Star");
        }
        return UIManager.getIcon("RequiredHBox.Space");
    }

    public void setStar(boolean isShowStar) {
        this.isStar = isShowStar;
        this.signLabel.setIcon(this.getIcon());
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.jComponent.setEnabled(enabled);
        this.signLabel.setIcon(this.getIcon());
    }
}

