/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.control;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class TabbedPane
extends JPanel {
    private static final long serialVersionUID = 7793339663298714305L;
    private static final Color TOP_GRADIENT = new Color(15198441);
    private static final int GRADIENT_HEIGHT = 15;
    private JPanel southPane = null;

    public TabbedPane(JTabbedPane tabbedPane) {
        this.setLayout(new BorderLayout());
        this.southPane = UCD.createTransparentPane(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        this.add((Component)this.southPane, "South");
        this.setBorder(new TabbedPaneBorder());
        this.setBackground(Color.WHITE);
    }

    public void addSouthComponent(JComponent sourthPane) {
        Assert.notNull(sourthPane);
        this.southPane.removeAll();
        this.southPane.add((Component)sourthPane, "Center");
        this.southPane.revalidate();
        sourthPane.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle bounds = this.getBounds();
        GradientPaint gradientPaint = new GradientPaint((int)bounds.getX(), (int)bounds.getY(), TOP_GRADIENT, (int)bounds.getX(), 15.0f, Color.WHITE, false);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setPaint(gradientPaint);
        g2d.fillRect((int)bounds.getX(), (int)bounds.getY(), bounds.width - 4, 15);
    }

    private static class TabbedPaneBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -6561724735516172063L;
        private static final Insets INSETS = new Insets(3, 2, 2, 2);

        private TabbedPaneBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof TabbedPane)) {
                return;
            }
            Color innerColor = UIManager.getColor("Table.scrollPaneBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, innerColor, innerColor, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
            Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
            IsmPlafUtils.drawBorderStyle(graphics, outterColor, outterColor, new Rectangle(xx, yy, width, height), true);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(xx + 2, yy + 2, width - 4, 2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = insets.bottom = TabbedPaneBorder.INSETS.left;
            insets.left = insets.bottom;
            insets.top = TabbedPaneBorder.INSETS.top;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

