/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.BatchExecutionException;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.swing.dialog.BatchInfoDialog;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.dialog.ErrorDialog;
import com.huawei.ism.ui.swing.dialog.InfoDialog;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui.swing.dialog.LinkDialog;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.dialog.MultiErrorYesOrNoDialog;
import com.huawei.ism.ui.swing.dialog.OldConfirmDialog;
import com.huawei.ism.ui.swing.dialog.SftpInputPassWordDialog;
import com.huawei.ism.ui.swing.dialog.TextInputDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialogWithLink;
import com.huawei.ism.ui.swing.dialog.WarningInfo;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogUtils
implements DialogsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialogUtils.class);
    private static boolean isTextInCenter = true;

    public static ErrorDialog showErrorDialog(Window parent, String message) {
        if (message.equalsIgnoreCase(ResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            DialogUtils.showInfoDialog(parent, message);
            return null;
        }
        ErrorDialog errorDialog = null;
        errorDialog = parent instanceof JDialog ? new ErrorDialog(CommonUtil.convertObject(parent, JDialog.class), message) : (parent instanceof Frame ? new ErrorDialog(CommonUtil.convertObject(parent, Frame.class), message) : new ErrorDialog((JDialog)null, message));
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    public static ErrorDialog showErrorDialog(JDialog parent, String message) {
        if (message.equalsIgnoreCase(ResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            DialogUtils.showInfoDialog(parent, message);
            return null;
        }
        ErrorDialog errorDialog = new ErrorDialog(parent, message);
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    public static ErrorDialog showErrorDialog(Window parent, String message, Throwable throwable) {
        IsmException exc;
        if (throwable instanceof IsmException && (exc = (IsmException)throwable).getErrorId() == 50331670L) {
            DialogUtils.showInfoDialog(parent, exc.getErrorMessage());
            return null;
        }
        String msg = DialogUtils.combineErrMsg(message, throwable);
        List<String> suggestion = DialogUtils.getErrorSuggestion(throwable);
        if (msg.equalsIgnoreCase(ResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            DialogUtils.showInfoDialog(parent, msg);
            return null;
        }
        ErrorDialog errorDialog = null;
        errorDialog = parent instanceof JDialog ? new ErrorDialog(CommonUtil.convertObject(parent, JDialog.class), msg, suggestion) : (parent instanceof Frame ? new ErrorDialog(CommonUtil.convertObject(parent, Frame.class), msg, suggestion) : new ErrorDialog((JDialog)null, msg, suggestion));
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    public static ErrorDialog showErrorDialog(Window parent, Throwable throwable) {
        return DialogUtils.showErrorDialog(parent, "", throwable);
    }

    public static JDialog getErrorDialog(Window parent, Throwable throwable) {
        IsmException exc;
        if (throwable instanceof IsmException && (exc = (IsmException)throwable).getErrorId() == 50331670L) {
            return DialogUtils.getInfoDialog(parent, exc.getErrorMessage());
        }
        String msg = DialogUtils.combineErrMsg("", throwable);
        List<String> suggestion = DialogUtils.getErrorSuggestion(throwable);
        if (msg.equalsIgnoreCase(ResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            return DialogUtils.getInfoDialog(parent, msg);
        }
        return DialogUtils.getErrorDialog(parent, msg, suggestion);
    }

    private static JDialog getErrorDialog(Window parent, String msg, List<String> suggestion) {
        ErrorDialog dialog = null;
        dialog = parent instanceof JDialog ? new ErrorDialog((JDialog)parent, msg, suggestion) : (parent instanceof Frame ? new ErrorDialog((Frame)parent, msg, suggestion) : new ErrorDialog((JDialog)null, msg, suggestion));
        return dialog;
    }

    public static JDialog getInfoDialog(Window parent) {
        return DialogUtils.getInfoDialog(parent, ResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static JDialog getInfoDialog(Window parent, String msg) {
        InformationDialog dialog = null;
        dialog = parent instanceof JDialog ? new InformationDialog(CommonUtil.convertObject(parent, JDialog.class), msg) : (parent instanceof Frame ? new InformationDialog(CommonUtil.convertObject(parent, Frame.class), msg) : new InformationDialog((JDialog)null, msg));
        return dialog;
    }

    public static ErrorDialog showErrorDialog(Frame parent, String message, Throwable throwable) {
        IsmException exc;
        if (throwable instanceof IsmException && (exc = (IsmException)throwable).getErrorId() == 50331670L) {
            DialogUtils.showInfoDialog(parent, exc.getErrorMessage());
            return null;
        }
        String msg = DialogUtils.combineErrMsg(message, throwable);
        List<String> suggestion = DialogUtils.getErrorSuggestion(throwable);
        ErrorDialog errorDialog = new ErrorDialog(parent, msg, suggestion);
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    private static List<String> getErrorSuggestion(Throwable throwable) {
        if (throwable instanceof IsmException) {
            IsmException exc = (IsmException)throwable;
            return exc.getSuggestions();
        }
        return null;
    }

    public static ErrorDialog showErrorDialog(Frame parent, Throwable throwable) {
        return DialogUtils.showErrorDialog(parent, "", throwable);
    }

    public static String combineErrMsg(String message, Throwable throwable) {
        LOGGER.error("", throwable);
        String msg = message;
        if (throwable instanceof IsmException) {
            IsmException ismException = CommonUtil.convertObject(throwable, IsmException.class);
            String cause = ismException.getErrorMessage();
            if (StringUtils.isNotEmpty((CharSequence)cause)) {
                msg = msg + cause;
            }
        } else {
            msg = throwable instanceof TimeoutException ? ResourceManager.getString("SERVER_TIMEOUT_ERROR") : ResourceManager.getString("SERVER_INNER_ERROR");
        }
        return msg;
    }

    public static void showSuccessDialog(JDialog parent, String message) {
        InformationDialog infoDialog = new InformationDialog(parent, message, true);
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog JDialog error.");
            return;
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(JDialog parent, String message) {
        InformationDialog infoDialog = new InformationDialog(parent, message);
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog JDialog error.");
            return;
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialogOnTop(String message) {
        JDialog js = new JDialog();
        js.setAlwaysOnTop(true);
        js.setVisible(true);
        SwingUtil.putScreenCenter(js);
        InformationDialog infoDialog = new InformationDialog(js, message);
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog JDialog error.");
            return;
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(JDialog parent, String message, Dimension areaDimension) {
        InformationDialog infoDialog = new InformationDialog(parent, message, areaDimension);
        if ("--".equals(message)) {
            return;
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(Window parent, String message) {
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog Window error.");
            return;
        }
        if (parent instanceof JDialog) {
            InformationDialog infoDialog = new InformationDialog(CommonUtil.convertObject(parent, JDialog.class), message);
            infoDialog.setVisible(!Utils.isJunitTest());
        } else if (parent instanceof Frame) {
            InformationDialog infoDialog = new InformationDialog(CommonUtil.convertObject(parent, Frame.class), message);
            infoDialog.setVisible(!Utils.isJunitTest());
        }
    }

    public static void showInfoDialog(Frame parent, String message) {
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog Frame error.");
            return;
        }
        InformationDialog infoDialog = new InformationDialog(parent, message);
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialogWithHyperLink(Frame parent, String message, JComponent hyperLink) {
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog Frame error.");
            return;
        }
        InformationDialog infoDialog = new InformationDialog(parent, message, hyperLink);
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static InformationDialog createShowinfoDialog(Frame parent, String message) {
        InformationDialog infoDialog = new InformationDialog(parent, message);
        if ("--".equals(message)) {
            LOGGER.error("showInfoDialog Frame error.");
            return infoDialog;
        }
        boolean isJunitTest = Utils.isJunitTest();
        infoDialog.setVisible(!isJunitTest);
        return infoDialog;
    }

    public static void showInfoDialog(Frame parent) {
        DialogUtils.showInfoDialog(parent, ResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static void showInfoDialog(Window parent) {
        DialogUtils.showInfoDialog(parent, ResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static void showInfoDialog(JDialog parent) {
        DialogUtils.showInfoDialog(parent, ResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static WarningDialog createWarningDialog(JDialog parent, String warnMsg) {
        WarningDialog warningDialog = new WarningDialog(parent, warnMsg);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    private static void showWarningDialog(WarningDialog warningDialog) {
        if (Utils.isJunitTest()) {
            warningDialog.setVisible(false);
            warningDialog.setValue(0);
        } else {
            warningDialog.setVisible(true);
        }
    }

    private static void showInfoDialog(InfoDialog infoDialog) {
        if (Utils.isJunitTest()) {
            infoDialog.setVisible(false);
            infoDialog.setValue(0);
        } else {
            infoDialog.setVisible(true);
        }
    }

    public static synchronized WarningDialog createContinueDialog(Frame parent) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), ResourceManager.getString("CONTINUE_CREATE_MSG"), "Information.png");
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized WarningDialog createContinueDialog(Frame parent, String warnMsg) {
        WarningDialog warningDialog = DialogUtils.createContinueWarningDialog(parent, warnMsg);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized WarningDialog createContinueWarningDialog(Frame parent, String warnMsg) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), warnMsg, "Information.png");
        warningDialog.getCannelButton().setText(ResourceManager.getString("CREATE_LUN_FINISH"));
        warningDialog.getCannelButton().setMnemonic('F');
        UCD.formatMnemonicDisplay(warningDialog.getCannelButton());
        warningDialog.getConfirmButton().setText(ResourceManager.getString("CONTINUE"));
        warningDialog.getConfirmButton().setMnemonic('C');
        UCD.formatMnemonicDisplay(warningDialog.getConfirmButton());
        Dimension dimension = new Dimension(100, 23);
        UCD.setJComponentSize(warningDialog.getCannelButton(), dimension);
        UCD.setJComponentSize(warningDialog.getConfirmButton(), dimension);
        return warningDialog;
    }

    public static WarningDialog showYesNoDialog(Window parent, String waringMsg) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png");
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesDialog(Window parent, String waringMsg) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png");
        warningDialog.getCannelButton().setVisible(false);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesNoDialog(Window parent, String waringMsg, int timeout) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png", timeout);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesNoDialogOnTop(String waringMsg) {
        JDialog js = new JDialog();
        js.setAlwaysOnTop(true);
        js.setVisible(true);
        SwingUtil.putScreenCenter(js);
        WarningDialog warningDialog = new WarningDialog((Window)js, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png");
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesNoDialog(Window parent, String waringMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png", okInfo, cancelInfo, okWidth, cancelWidth);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static InfoDialog showYesNoInfoDialog(Window parent, String message, Dimension dimension, boolean wrapStyleWord) {
        InfoDialog infoDialog = new InfoDialog(parent, message, dimension, wrapStyleWord);
        DialogUtils.showInfoDialog(infoDialog);
        return infoDialog;
    }

    public static WarningDialog showYesNoWarningDialog(Window parent, String waringMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), waringMsg, "comfirmdialog_warn.png", okInfo, cancelInfo, okWidth, cancelWidth);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesNoWarningDialog(Window parent, String waringMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth, boolean focusYes) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), waringMsg, "comfirmdialog_warn.png", okInfo, cancelInfo, okWidth, cancelWidth, focusYes);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showTripleChoiceDialog(DialogConstructorData dialogConstructorData) {
        WarningDialog warningDialog = new WarningDialog(ResourceManager.getString("INFORMATION_DIALOG_TITLE"), "Information.png", dialogConstructorData);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesNoDialog(Window parent, String waringMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth, int textColumn) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png", okInfo, cancelInfo, okWidth, cancelWidth, textColumn);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showYesNoConfirmDialog(Window parent, String waringMsg, String ensureInfo) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, ensureInfo, "Information.png");
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized WarningDialog showYesNoDialog(Window parent, String waringMsg, String okInfo, String cancelInfo) {
        return DialogUtils.showYesNoDialog(parent, waringMsg, okInfo, cancelInfo, 80, 80);
    }

    public static WarningDialog showYesNoDialog(Window parent, String waringMsg, boolean focusYes) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png", focusYes);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showDangerDialog(Window parent, String waringMsg, String okInfo, String cancelInfo) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("DANGER_DIALOG_TITLE"), waringMsg, "danger.gif", okInfo, cancelInfo, 80, 80);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized WarningDialog createContinueDialog(JDialog parent, String warnMsg, boolean isOpen) {
        WarningDialog warningDialog = new WarningDialog((Window)parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), warnMsg, "Information.png");
        warningDialog.getConfirmButton().setText(ResourceManager.getString("CONTINUE"));
        warningDialog.getConfirmButton().setMnemonic('C');
        warningDialog.getCannelButton().setText(ResourceManager.getString("CREATE_LUN_FINISH"));
        warningDialog.getCannelButton().setMnemonic('F');
        UCD.formatMnemonicDisplay(warningDialog.getCannelButton());
        Dimension dimension = new Dimension(100, 23);
        UCD.setJComponentSize(warningDialog.getCannelButton(), dimension);
        UCD.setJComponentSize(warningDialog.getConfirmButton(), dimension);
        UCD.formatMnemonicDisplay(warningDialog.getConfirmButton());
        SwingUtil.putParentCenter(warningDialog, parent);
        if (isOpen) {
            DialogUtils.showWarningDialog(warningDialog);
        }
        return warningDialog;
    }

    public static synchronized WarningDialog createContinueDialog(JDialog parent, String warnMsg) {
        return DialogUtils.createContinueDialog(parent, warnMsg, true);
    }

    public static synchronized WarningDialog createYesAndNoDialog(JDialog parent, String warnMsg) {
        WarningDialog warningDialog = DialogUtils.createContinueDialog(parent, warnMsg, false);
        warningDialog.getConfirmButton().setText(ResourceManager.getString("HYPERMIRROR_PROPERTY_DIALOG_YES"));
        warningDialog.getConfirmButton().setMnemonic('Y');
        UCD.formatMnemonicDisplay(warningDialog.getConfirmButton());
        warningDialog.getCannelButton().setText(ResourceManager.getString("HYPERMIRROR_PROPERTY_DIALOG_NO"));
        warningDialog.getCannelButton().setMnemonic('N');
        UCD.formatMnemonicDisplay(warningDialog.getCannelButton());
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized WarningDialog createContinueDialog(Frame parent, String warnMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        WarningDialog warningDialog = new WarningDialog(parent, ResourceManager.getString("INFORMATION_DIALOG_TITLE"), warnMsg, "Information.png", okInfo, cancelInfo, okWidth, cancelWidth);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog createWarningDialog(Frame parent, String warnMsg) {
        WarningDialog warningDialog = new WarningDialog(parent, warnMsg);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    private static void showRequireInputConfirmationDialog(OldConfirmDialog dlg) {
        if (Utils.isJunitTest()) {
            dlg.setVisible(false);
            dlg.setValue(0);
        } else {
            dlg.setVisible(true);
        }
    }

    private static void showTextInputConfirmationDialog(TextInputDialog dlg) {
        if (Utils.isJunitTest()) {
            dlg.setVisible(false);
            dlg.setCloseEventValue(0);
        } else {
            dlg.setVisible(true);
        }
    }

    public static OldConfirmDialog createInputConfirmDialog(JDialog parent, String msg) {
        OldConfirmDialog inputDialog = new OldConfirmDialog(parent, msg);
        DialogUtils.showRequireInputConfirmationDialog(inputDialog);
        return inputDialog;
    }

    public static OldConfirmDialog createInputConfirmDialog(Frame parent, String msg) {
        OldConfirmDialog inputDialog = new OldConfirmDialog(parent, msg);
        DialogUtils.showRequireInputConfirmationDialog(inputDialog);
        return inputDialog;
    }

    public static TextInputDialog createTextInputDialog(JDialog parent) {
        TextInputDialog inputDialog = new TextInputDialog(parent);
        DialogUtils.showTextInputConfirmationDialog(inputDialog);
        return inputDialog;
    }

    public static void showMultiErrorDialog(Window parent, String msg, String[] headers, List<ArrayList<Object>> datas) {
        isTextInCenter = false;
        DialogUtils.showMultiErrorDialog(parent, msg, headers, datas, (Pair<String, String>)Pair.of((Object)ResourceManager.getString("CLOSE"), (Object)ResourceManager.getString("IGNORE")));
    }

    public static MultiErrorDialog showMultiErrorDialog(Window parent, String msg, String[] headers, List<ArrayList<Object>> datas, Pair<String, String> pair) {
        MultiErrorDialog multiErrorDialog = null;
        multiErrorDialog = parent instanceof Frame ? new MultiErrorDialog(parent, msg, headers, pair) : (parent instanceof JDialog ? new MultiErrorDialog(parent, msg, headers, pair) : new MultiErrorDialog((Window)Framework.getInstance().getMainFrame(), msg, headers, pair));
        ArrayList<DefaultTableRow<String, String>> tableRows = new ArrayList<DefaultTableRow<String, String>>(0);
        DefaultTableRow<String, String> tableRow = null;
        for (ArrayList<Object> row : datas) {
            tableRow = new DefaultTableRow<String, String>(headers.length, "", String.valueOf(DialogUtils.getNoStripUUID()));
            DialogUtils.setRowValues(tableRow, row);
            tableRows.add(tableRow);
        }
        multiErrorDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        multiErrorDialog.setVisible(true);
        return multiErrorDialog;
    }

    public static void showMultiErrorDialogNoIgnoreButton(Window parent, String msg, String[] headers, List<List<String>> datas) {
        MultiErrorDialog multiErrorDialog = new MultiErrorDialog(parent, false, 350);
        multiErrorDialog.commonInitWithBtnInfo(parent, ResourceManager.getString("ERROR_DIALOG_TITLE"), msg, (Pair<String[], String>)Pair.of((Object)headers, (Object)"error.png"), (Pair<String, String>)Pair.of((Object)ResourceManager.getString("CONFIRM"), (Object)ResourceManager.getString("IGNORE")));
        multiErrorDialog.getTableModel().setTableData((TableRow[])datas.stream().map(data -> DialogUtils.addRowInfo(headers, data)).toArray(TableRow[]::new));
        multiErrorDialog.setVisible(true);
    }

    private static TableRow addRowInfo(String[] headers, List<String> rows) {
        DefaultTableRow<String, String> tableRow = new DefaultTableRow<String, String>(headers.length, "", String.valueOf(DialogUtils.getNoStripUUID()));
        AtomicInteger index = new AtomicInteger(0);
        rows.forEach(row -> tableRow.setValueAt(index.getAndIncrement(), new IsmTableCell.TextCell(String.valueOf(row), false, 0)));
        return tableRow;
    }

    private static void setRowValues(DefaultTableRow<String, String> tableRow, ArrayList<Object> row) {
        if (!isTextInCenter) {
            tableRow.setValues(row);
            return;
        }
        for (int i = 0; i < row.size(); ++i) {
            tableRow.setValueAt(i, new IsmTableCell.TextCell(String.valueOf(row.get(i)), false, 0));
        }
    }

    public static void showMultiWarningDialog(Window parent, String msg, String[] headers, List<List<String>> datas) {
        MultiErrorDialog multiErrorDialog = null;
        multiErrorDialog = parent instanceof Frame ? new MultiErrorDialog(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), msg, headers, "comfirmdialog_warn.png") : (parent instanceof JDialog ? new MultiErrorDialog(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), msg, headers, "comfirmdialog_warn.png") : new MultiErrorDialog((Window)Framework.getInstance().getMainFrame(), ResourceManager.getString("WARNING_DIALOG_TITLE"), msg, headers, "comfirmdialog_warn.png"));
        ArrayList<DefaultTableRow<String, String>> tableRows = new ArrayList<DefaultTableRow<String, String>>(0);
        DefaultTableRow<String, String> tableRow = null;
        for (List<String> row : datas) {
            tableRow = new DefaultTableRow<String, String>(headers.length, "", String.valueOf(DialogUtils.getNoStripUUID()));
            tableRow.setValues(row);
            tableRows.add(tableRow);
        }
        multiErrorDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        multiErrorDialog.setVisible(true);
    }

    public static MultiErrorDialog showMultiWarningDialogWithIgnoreButtonAndTable(Window parent, String msg, String[] headers, DefaultTableModel tableModel) {
        MultiErrorDialog multiErrorDialog = parent instanceof Frame ? new MultiErrorDialog(parent, msg, headers, true, tableModel) : (parent instanceof JDialog ? new MultiErrorDialog(parent, msg, headers, true, tableModel) : new MultiErrorDialog((Window)Framework.getInstance().getMainFrame(), msg, headers, true, tableModel));
        multiErrorDialog.setVisible(true);
        return multiErrorDialog;
    }

    public static MultiErrorYesOrNoDialog createMultiWarningYesNoDialog(Window parent, String msg, String[] headers, List<List<String>> datas) {
        MultiErrorYesOrNoDialog multiErrorYesOrNoDialog = null;
        multiErrorYesOrNoDialog = parent instanceof JDialog ? new MultiErrorYesOrNoDialog(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), msg, headers, "comfirmdialog_warn.png") : new MultiErrorYesOrNoDialog((Window)Framework.getInstance().getMainFrame(), ResourceManager.getString("WARNING_DIALOG_TITLE"), msg, headers, "comfirmdialog_warn.png");
        ArrayList<DefaultTableRow<String, String>> dataRows = new ArrayList<DefaultTableRow<String, String>>();
        for (List<String> row : datas) {
            DefaultTableRow<String, String> tableRow = new DefaultTableRow<String, String>(headers.length, "", String.valueOf(DialogUtils.getNoStripUUID()));
            tableRow.setValues(row);
            dataRows.add(tableRow);
        }
        multiErrorYesOrNoDialog.getTableModel().setTableData(dataRows.toArray(new TableRow[dataRows.size()]));
        return multiErrorYesOrNoDialog;
    }

    public static MultiErrorYesOrNoDialog createMultiWarningYesNoDialogWithSize(Window parent, String msg, String[] headers, List<List<String>> datas, List<Integer> size) {
        List<String> params = Arrays.asList(ResourceManager.getString("WARNING_DIALOG_TITLE"), msg, "comfirmdialog_warn.png");
        MultiErrorYesOrNoDialog multiErrorYesOrNoDialog = parent instanceof JDialog ? new MultiErrorYesOrNoDialog(parent, params, headers, size) : new MultiErrorYesOrNoDialog((Window)Framework.getInstance().getMainFrame(), params, headers, size);
        ArrayList<DefaultTableRow<String, String>> dataRows = new ArrayList<DefaultTableRow<String, String>>();
        for (List<String> row : datas) {
            DefaultTableRow<String, String> tableRow = new DefaultTableRow<String, String>(headers.length, "", String.valueOf(DialogUtils.getNoStripUUID()));
            tableRow.setValues(row);
            dataRows.add(tableRow);
        }
        multiErrorYesOrNoDialog.getTableModel().setTableData(dataRows.toArray(new TableRow[dataRows.size()]));
        return multiErrorYesOrNoDialog;
    }

    private static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String str = uuid.toString();
        return str.replaceAll("-", "");
    }

    public static void showDeviceErrorDialog(Window dialog, Throwable e) {
        if (e instanceof BatchExecutionException) {
            DialogUtils.showDeviceMultiErrorDialog((BatchExecutionException)e, dialog);
        } else {
            DialogUtils.showErrorDialog(dialog, e);
        }
    }

    public static void showDeviceMultiErrorDialog(BatchExecutionException e, Window dialog) {
        String[] rowHeaders = new String[]{ResourceManager.getString("TASK_SOURCE"), ResourceManager.getString("FAILREASON")};
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>(0);
        ArrayList<String> row = null;
        String deviceName = "";
        Object obj = null;
        for (int i = 0; i < e.getFailsSize(); ++i) {
            obj = e.getFailOperateObject(i);
            if (obj instanceof String) {
                deviceName = LauncherManager.getInstance().getLauncher((String)obj).getDeviceName();
            }
            row = new ArrayList<String>(0);
            row.add(deviceName);
            row.add(e.getErrorMessage(i));
            rowList.add(row);
        }
        DialogUtils.showMultiErrorDialog(dialog, ResourceManager.getString("EXECUTE_FAILED"), rowHeaders, rowList);
    }

    public static void showMultiErrorDialog(String multiErrorTitle, String[] columnNames, Frame frame, JDialog dialog, BatchExecutionException be, List<List> tableData) {
        MultiErrorDialog multiErrorDialog = null;
        multiErrorDialog = null != frame ? new MultiErrorDialog((Window)frame, multiErrorTitle, columnNames) : new MultiErrorDialog((Window)dialog, multiErrorTitle, columnNames);
        ArrayList<DefaultTableRow<String, String>> tableRows = new ArrayList<DefaultTableRow<String, String>>(0);
        DefaultTableRow<String, String> tableRow = null;
        for (List row : tableData) {
            tableRow = new DefaultTableRow<String, String>(columnNames.length, "", "");
            tableRow.setValues(row);
            tableRows.add(tableRow);
        }
        multiErrorDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        multiErrorDialog.setVisible(true);
    }

    public static SftpInputPassWordDialog showInputPassWordDialog(Window parent, String userName) {
        SftpInputPassWordDialog ipd = SftpInputPassWordDialog.getInstance(parent, userName);
        return ipd;
    }

    public static void showBatchInfoDialog(Window parent, String desc, Map<String, String> messages) {
        BatchInfoDialog infoDialog = new BatchInfoDialog(parent, desc, messages);
        infoDialog.setVisible(true);
    }

    public static void showLinkDialog(Window parent, String desc, String url) {
        LinkDialog linkDialog = new LinkDialog(parent, desc, url);
        linkDialog.setVisible(true);
    }

    public static WarningDialog showWarnConfirmDialog(Window parent, String warningInfo, String ensureInfo) {
        WarningDialog warningDialog = new WarningDialog(parent, warningInfo, ensureInfo);
        DialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static WarningDialog showMultiWarningDialogWithHyperlink(Window main, List<WarningInfo> warningInfo, String confirmInfo) {
        WarningDialogWithLink warningDialogWithLink = new WarningDialogWithLink(main, warningInfo, confirmInfo);
        DialogUtils.showWarningDialog(warningDialogWithLink);
        return warningDialogWithLink;
    }

    public static class DialogConstructorData {
        private Window parent;
        private String newMessage;
        private String okInfo;
        private String cancelInfo;
        private String customInfo;
        private int okWidth;
        private int cancelWidth;
        private int customWidth;

        public DialogConstructorData() {
        }

        public DialogConstructorData(Window parent, String newMessage, String okInfo, String cancelInfo, String customInfo, int okWidth, int cancelWidth, int customWidth) {
            this.parent = parent;
            this.newMessage = newMessage;
            this.okInfo = okInfo;
            this.cancelInfo = cancelInfo;
            this.customInfo = customInfo;
            this.okWidth = okWidth;
            this.cancelWidth = cancelWidth;
            this.customWidth = customWidth;
        }

        public Window getParent() {
            return this.parent;
        }

        public String getNewMessage() {
            return this.newMessage;
        }

        public String getOkInfo() {
            return this.okInfo;
        }

        public String getCancelInfo() {
            return this.cancelInfo;
        }

        public String getCustomInfo() {
            return this.customInfo;
        }

        public int getOkWidth() {
            return this.okWidth;
        }

        public int getCancelWidth() {
            return this.cancelWidth;
        }

        public int getCustomWidth() {
            return this.customWidth;
        }
    }
}

