/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmRolloverButtonUI
extends BasicButtonUI {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmRolloverButtonUI.class);
    private static final IsmRolloverButtonUI INSTANCE = new IsmRolloverButtonUI();
    private Color focusColor;
    private Color selectColor;
    private Color disabledTextColor;

    public static ComponentUI createUI(JComponent x) {
        return INSTANCE;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton button = null;
        if (jComponent instanceof AbstractButton) {
            button = (AbstractButton)jComponent;
        }
        if (null == button) {
            LOGGER.error("The button parameter is null.");
            return;
        }
        if (jComponent.getBackground() instanceof UIResource && button.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!model.isPressed() && model.isRollover()) {
                this.paintButtonRollover(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
            if (!model.isArmed() && !model.isPressed()) {
                this.paintButtonNormal(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
        }
        super.update(graphics, jComponent);
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        return this.focusColor;
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton button, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton button) {
        this.setTextShiftOffset();
        IsmButtonStyle style = (IsmButtonStyle)UIManager.get("RolloverButton.style");
        IsmPlafUtils.drawDualGradient((Component)button, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.PRESSED), style.getGradientDR(IsmButtonStyle.ButtonState.PRESSED), new Rectangle(1, 1, button.getWidth() - 2, button.getHeight() - 2), true);
    }

    protected void paintButtonRollover(Graphics graphics, AbstractButton button) {
        IsmButtonStyle style = (IsmButtonStyle)UIManager.get("RolloverButton.style");
        IsmPlafUtils.drawDualGradient((Component)button, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.ROLLOVER), style.getGradientDR(IsmButtonStyle.ButtonState.ROLLOVER), new Rectangle(1, 1, button.getWidth() - 2, button.getHeight() - 2), true);
    }

    protected void paintButtonNormal(Graphics g, AbstractButton button1) {
    }
}

