/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmMenuItemUI;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ArmorMenuItemUI
extends IsmMenuItemUI {
    private static final int MENU_ITEM_HEIGHT = 30;

    public static ComponentUI createUI(JComponent c) {
        return new ArmorMenuItemUI();
    }

    @Override
    protected void paintBackground(Graphics grap, JMenuItem menuItem, Color bgColor) {
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        ButtonModel model = menuItem.getModel();
        Insets margin1 = menuItem.getMargin();
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            grap.setColor(UIManager.getColor("IsmTopMenu.selectedColor"));
            grap.fillRect(margin1.left, margin1.top, menuWidth - margin1.left - margin1.right, menuHeight - margin1.top - margin1.bottom);
        } else {
            grap.setColor(IsmPlafUtils.mixAlpha(UIManager.getColor("MenuItem.background"), 255));
            grap.fillRect(margin1.left, margin1.top, menuWidth - margin1.left - margin1.right, menuHeight - margin1.top - margin1.bottom);
        }
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem menuItem, Rectangle textRect, String text) {
        if (menuItem instanceof JRadioButtonMenuItem) {
            textRect.setLocation((int)textRect.getX() + 12, (int)textRect.getY());
        }
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = SwingUIUtil.getFontMetrics(menuItem, graphics);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        super.paintText(graphics, menuItem, textRect, text);
        if (menuItem.isEnabled()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                graphics.setColor(this.selectionForeground);
            } else {
                graphics.setColor(UIManager.getColor("MenuItem.foreground"));
            }
            SwingUIUtil.drawStringUnderlineCharAt(menuItem, graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
        }
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jc, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension preferredMenuItemSize = super.getPreferredMenuItemSize(jc, checkIcon, arrowIcon, defaultTextIconGap);
        preferredMenuItemSize.height = 30;
        return preferredMenuItemSize;
    }
}

