/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmTableHeaderCellRenderer;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;

public class ArmorTableHeaderUI
extends BasicTableHeaderUI {
    private static int rolloverColumn = -1;
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new ArmorTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.originalHeaderRenderer = this.header.getDefaultRenderer();
        if (this.originalHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new IsmTableHeaderCellRenderer());
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new BasicTableHeaderUI.MouseInputHandler(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                ArmorTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                ArmorTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                rolloverColumn = -1;
                ArmorTableHeaderUI.this.header.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
                if (ArmorTableHeaderUI.this.header.getReorderingAllowed()) {
                    rolloverColumn = -1;
                    ArmorTableHeaderUI.this.header.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                super.mouseDragged(mouseEvent);
                ArmorTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                ArmorTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }
        };
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof IsmTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    private void updateRolloverColumn(MouseEvent mouseEvent) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(mouseEvent.getPoint()) && (col = this.header.columnAtPoint(mouseEvent.getPoint())) != rolloverColumn) {
            rolloverColumn = col;
            this.header.repaint();
        }
    }
}

