/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.control.IsmComboBoxButton;
import com.huawei.ism.ui.swing.plaf.IsmComboBoxUI;
import com.huawei.ism.ui.swing.plaf.IsmComboPopup;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.ComboPopup;

public class UnifyComboBoxUI
extends IsmComboBoxUI {
    private static final Dimension BUTTON_SIZE = new Dimension(17, 17);

    public static ComponentUI createUI(JComponent c) {
        return new UnifyComboBoxUI();
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new ComboBoxRenderer();
    }

    @Override
    protected ComboPopup createPopup() {
        return new ComboBoxPopup(this.comboBox);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        int gradientHeight = UIManager.getInt("TextField.backgroundGradientHeight");
        String gradientKey = "TextField.backgroundNormalGradient";
        if (!jComponent.isEnabled()) {
            gradientKey = "TextField.backgroundDisabledGradient";
        }
        IsmPlafUtils.drawGradient((Component)jComponent, graphics, gradientKey, new Rectangle(1, 2, jComponent.getWidth() - 2, gradientHeight), true);
        this.paint(graphics, jComponent);
    }

    @Override
    protected JButton createArrowButton() {
        IsmComboBoxButton button = new IsmComboBoxButton(this.comboBox, UIManager.getIcon("ComboBox.arrowIcon"), true, this.currentValuePane, this.listBox);
        button.setFocusPainted(this.comboBox.isEditable());
        button.setMaximumSize(BUTTON_SIZE);
        button.setPreferredSize(BUTTON_SIZE);
        button.setMinimumSize(BUTTON_SIZE);
        return button;
    }

    @Override
    public void installComponents() {
        super.installComponents();
        this.arrowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((BasicComboPopup)UnifyComboBoxUI.this.popup).repaint();
                RepaintManager.currentManager((JComponent)null).paintDirtyRegions();
            }
        });
        this.comboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((BasicComboPopup)UnifyComboBoxUI.this.popup).repaint();
            }
        });
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle bounds, boolean hasFocus) {
        bounds.setLocation((int)bounds.getX() + 1, (int)bounds.getY() + 1);
        bounds.width -= 2;
        bounds.height -= 2;
        Component component = null;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        boolean isSelected = false;
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            isSelected = true;
        }
        component = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, isSelected, false);
        component.setFont(this.comboBox.getFont());
        this.setColor(hasFocus, component);
        boolean shouldValidate = false;
        if (component instanceof JPanel) {
            shouldValidate = true;
        }
        int boundsX = (int)bounds.getX();
        int boundsY = (int)bounds.getY();
        int width = bounds.width;
        int height = bounds.height;
        Insets padding = UIManager.getInsets("ComboBox.padding");
        if (padding != null) {
            boundsX += padding.left;
            boundsY += padding.top;
            width = bounds.width - (padding.left + padding.right);
            height = bounds.height - (padding.top + padding.bottom);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, boundsX, boundsY, width, height, shouldValidate);
    }

    private void setColor(boolean hasFocus, Component component) {
        Color foreground = null;
        Color background = null;
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            foreground = this.listBox.getSelectionForeground();
            background = this.listBox.getSelectionBackground();
        } else {
            background = null;
            foreground = this.comboBox.isEnabled() ? this.comboBox.getForeground() : UIManager.getColor("ComboBox.disabledForeground");
        }
        component.setForeground(foreground);
        component.setBackground(background);
    }

    public static class ComboBoxPopup
    extends IsmComboPopup {
        private static final long serialVersionUID = -9076176265936112033L;

        public ComboBoxPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
            Point point = new Point();
            SwingUtilities.convertPointFromScreen(point, this.comboBox);
            Rectangle screenBounds = new Rectangle(point, toolkit.getScreenSize());
            if (gc != null) {
                Insets screenInsets = toolkit.getScreenInsets(gc);
                screenBounds = gc.getBounds();
                screenBounds.width -= screenInsets.left + screenInsets.right;
                screenBounds.height -= screenInsets.top + screenInsets.bottom;
                screenBounds.setLocation((int)point.getX() + screenInsets.left, (int)point.getY() + screenInsets.top);
            }
            Rectangle rectangle = new Rectangle(px, py, pw, ph);
            if (py + ph > (int)screenBounds.getY() + screenBounds.height && ph < screenBounds.height) {
                rectangle.setLocation((int)rectangle.getX(), -rectangle.height - 8);
            }
            return rectangle;
        }

        @Override
        public void show(Component invoker, int xx, int yy) {
            super.show(invoker, xx, yy + 1);
        }
    }

    private static class RenderUI
    extends BasicLabelUI {
        private static final RenderUI RENDER_UI = new RenderUI();

        private RenderUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            return RENDER_UI;
        }

        @Override
        public void update(Graphics graphics, JComponent jComponent) {
            if (jComponent.isOpaque() && jComponent.isBackgroundSet()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
            this.paint(graphics, jComponent);
        }
    }

    protected class ComboBoxRenderer
    extends BasicComboBoxRenderer.UIResource {
        private static final long serialVersionUID = 1L;
        private final EmptyBorder cellBorder = new EmptyBorder(0, 5, 0, 5);

        public ComboBoxRenderer() {
            this.setBorder(this.cellBorder);
            this.setUI(new RenderUI());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(preferredSize.width, 21);
        }

        @Override
        public void setUI(LabelUI ui) {
            super.setUI(new RenderUI());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rv = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(rv instanceof JComponent)) {
                return rv;
            }
            JComponent component = (JComponent)rv;
            if (index == -1) {
                component.setForeground(list.getForeground());
            }
            if (null != value) {
                FontMetrics fm = IsmPlafUtils.getFontMetrics(component, null, IsmFontFactory.getDialogPlain());
                String valueString = this.getText();
                int width = UnifyComboBoxUI.this.comboBox.getItemCount() > UnifyComboBoxUI.this.comboBox.getMaximumRowCount() ? UnifyComboBoxUI.this.comboBox.getWidth() - 32 : UnifyComboBoxUI.this.comboBox.getWidth() - 19;
                if (fm.stringWidth(valueString) > width) {
                    this.setToolTipText(valueString);
                    String theTitle = SwingUIUtil.clipStringIfNecessary(this, fm, valueString, width);
                    this.setText(theTitle);
                } else {
                    component.setToolTipText(null);
                }
            }
            if (isSelected) {
                Dimension dimension = component.getPreferredSize();
                dimension.height -= 4;
                component.setPreferredSize(dimension);
                component.setMaximumSize(dimension);
            }
            return rv;
        }
    }
}

