/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public final class UnifyIconFactory {
    private static final String NORMAL_STATE = "Normal";
    private static final String ROLLOVER_STATE = "Rollover";
    private static final String DISABLE_STATE = "Disable";
    private static Icon scrollBarUpArrowIcon;
    private static Icon scrollBarLeftArrowIcon;
    private static Icon scrollBarDownArrowIcon;
    private static Icon scrollBarRightArrowIcon;
    private static ScrollBarBlockIcon scrollBarHBlockIcon;
    private static ScrollBarBlockIcon scrollBarVBlockIcon;

    public static Icon getScrollBarUpArrowIcon() {
        if (scrollBarUpArrowIcon == null) {
            scrollBarUpArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.North);
        }
        return scrollBarUpArrowIcon;
    }

    public static Icon getScrollBarLeftArrowIcon() {
        if (scrollBarLeftArrowIcon == null) {
            scrollBarLeftArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.West);
        }
        return scrollBarLeftArrowIcon;
    }

    public static Icon getScrollBarDownArrowIcon() {
        if (scrollBarDownArrowIcon == null) {
            scrollBarDownArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.South);
        }
        return scrollBarDownArrowIcon;
    }

    public static Icon getScrollBarRightArrowIcon() {
        if (scrollBarRightArrowIcon == null) {
            scrollBarRightArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.East);
        }
        return scrollBarRightArrowIcon;
    }

    public static ScrollBarBlockIcon getScrollBarHBlockIcon() {
        if (null == scrollBarHBlockIcon) {
            scrollBarHBlockIcon = new ScrollBarBlockIcon(ScrollBarBlockIcon.Style.Horizonal);
        }
        return scrollBarHBlockIcon;
    }

    public static ScrollBarBlockIcon getScrollBarVBlockIcon() {
        if (null == scrollBarVBlockIcon) {
            scrollBarVBlockIcon = new ScrollBarBlockIcon(ScrollBarBlockIcon.Style.Vertical);
        }
        return scrollBarVBlockIcon;
    }

    public static final class ScrollBarBlockIcon
    implements Icon {
        private static final String PREFIX = "ScrollBar.Thumb";
        private Style style;

        private ScrollBarBlockIcon(Style style) {
            this.style = style;
        }

        @Override
        public int getIconHeight() {
            return this.getImgIcon(IsmButtonStyle.ButtonState.NORMAL).getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.getImgIcon(IsmButtonStyle.ButtonState.NORMAL).getIconWidth();
        }

        public void paintIcon(Component component, Graphics graphics, int xx, int yy, IsmButtonStyle.ButtonState buttonState) {
            Icon imgIcon = this.getImgIcon(buttonState);
            imgIcon.paintIcon(component, graphics, xx, yy);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        private Icon getImgIcon(IsmButtonStyle.ButtonState buttonState) {
            String postFix = UnifyIconFactory.NORMAL_STATE;
            switch (buttonState) {
                case DISABLED: {
                    postFix = UnifyIconFactory.DISABLE_STATE;
                    break;
                }
                case ROLLOVER: 
                case SELECTED: {
                    postFix = UnifyIconFactory.ROLLOVER_STATE;
                    break;
                }
            }
            return UIManager.getIcon(PREFIX + this.style.name() + postFix);
        }

        public static enum Style {
            Horizonal,
            Vertical;

        }
    }

    public static class ScrollBarArrowIcon
    implements Icon,
    UIResource {
        private static final String PREFIX = "ScrollBar.Arrow";
        private Direction direction;

        public ScrollBarArrowIcon(Direction dir) {
            this.direction = dir;
        }

        @Override
        public int getIconHeight() {
            return ScrollBarArrowIcon.getImgIcon(this.direction, UnifyIconFactory.NORMAL_STATE).getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return ScrollBarArrowIcon.getImgIcon(this.direction, UnifyIconFactory.NORMAL_STATE).getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            if (!(component instanceof BasicArrowButton)) {
                return;
            }
            BasicArrowButton arrowButton = (BasicArrowButton)component;
            ButtonModel buttonModel = arrowButton.getModel();
            Icon imgIcon = ScrollBarArrowIcon.getImgIcon(this.direction, buttonModel);
            imgIcon.paintIcon(component, graphics, xx, yy);
        }

        private static Icon getImgIcon(Direction direction, ButtonModel buttonModel) {
            String state = UnifyIconFactory.NORMAL_STATE;
            if (!buttonModel.isEnabled()) {
                state = UnifyIconFactory.DISABLE_STATE;
            } else if (buttonModel.isRollover() || buttonModel.isSelected() || buttonModel.isPressed() || buttonModel.isArmed()) {
                state = UnifyIconFactory.ROLLOVER_STATE;
            }
            return ScrollBarArrowIcon.getImgIcon(direction, state);
        }

        private static Icon getImgIcon(Direction dir, String state) {
            return UIManager.getIcon(PREFIX + (dir == null ? Direction.North : dir).name() + state);
        }

        public static enum Direction {
            North,
            West,
            South,
            East;

        }
    }
}

