/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class MultiFilterIsmTable
extends IsmTable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(MultiFilterIsmTable.class);
    private Set<Integer> totalSelectedRows = new HashSet<Integer>();

    public MultiFilterIsmTable(TableModel model) {
        super(model, false);
    }

    Set<Integer> getTotalSelectedRows() {
        return this.totalSelectedRows;
    }

    int[] getUnSelectedRows() {
        int unSelRowCount = this.getRowCount() - this.getSelectedRowCount();
        int[] rv = new int[unSelRowCount];
        int rvIndex = 0;
        for (int index = 0; index < this.getRowCount(); ++index) {
            if (this.selectionModel.isSelectedIndex(index)) continue;
            rv[rvIndex++] = index;
        }
        return rv;
    }

    @Override
    public List<TableRow> getMarkedRows() {
        ArrayList<TableRow> rows = new ArrayList<TableRow>(this.totalSelectedRows.size());
        TableModel model = this.getModel();
        if (model instanceof IsmAbstractTableModel) {
            IsmAbstractTableModel ismAbstractTableModel = (IsmAbstractTableModel)model;
            for (int modelRowIndex : this.totalSelectedRows) {
                TableRow row = ismAbstractTableModel.getRow(modelRowIndex);
                rows.add(row);
            }
        }
        return rows;
    }
}

