/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyTableHeaderUI;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

final class TableCornerButton
extends JButton {
    private static final long serialVersionUID = 547421446152519918L;
    private boolean isRecovered = false;

    TableCornerButton(IsmTable table) {
        URL url = TableCornerButton.class.getResource("images/columnSelect.png");
        this.setIcon(new ImageIcon(url));
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.addMouseListener(new Handler(table, this));
        this.setToolTipText(ResourceManager.getString("COMMON.TABLECORNERBUTTON_TOOLTIPS_DESC"));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            this.setBackground(UIManager.getColor("TableHeader.background"));
        }
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (!IsmPlafUtils.isBlueStyle()) {
            Dimension size = this.getSize();
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!IsmPlafUtils.isUnifyStyle()) {
            super.paintComponent(graphics);
            return;
        }
        UnifyTableHeaderUI.paintBackGroud(this, graphics, this.isFocusOwner() || this.isRecovered);
        Dimension size = this.getSize();
        Icon ic = this.getIcon();
        if (null != ic) {
            ic.paintIcon(this, graphics, (size.width - ic.getIconWidth()) / 2, (size.height - ic.getIconHeight()) / 2);
        }
    }

    public void setRecovered(boolean bol) {
        if (bol) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.isRecovered = bol;
    }

    private static class CheckBoxItemListener
    implements ItemListener,
    Serializable {
        private static final long serialVersionUID = 2366559968507743906L;
        private IsmTable ismTable;

        public CheckBoxItemListener(IsmTable ismTable) {
            this.ismTable = ismTable;
        }

        @Override
        public void itemStateChanged(ItemEvent source) {
            List<RowSorter.SortKey> sortKeys;
            this.ismTable.adjustStructure(true);
            IsmAbstractTableModel model = (IsmAbstractTableModel)this.ismTable.getModel();
            HashMap<Integer, RowSorter.SortKey> sortKeyMap = new HashMap<Integer, RowSorter.SortKey>(0);
            RowSorter<? extends TableModel> rowSorter = this.ismTable.getRowSorter();
            if (null != rowSorter && !Utils.isNullList(sortKeys = rowSorter.getSortKeys())) {
                RowSorter.SortKey sortKey = sortKeys.get(0);
                int visibleColumnID = model.getVisibleColIds().get(sortKey.getColumn());
                sortKeyMap.put(visibleColumnID, sortKey);
            }
            List<String> columnNames = Arrays.asList(model.getAllColumnNames());
            String selText = ((JCheckBox)source.getSource()).getText();
            int selID = columnNames.indexOf(selText);
            if (source.getStateChange() == 1) {
                model.getVisibleColIds().add(selID);
            } else {
                model.getVisibleColIds().remove((Object)selID);
            }
            List<TableRow> tableRows = this.saveSelectedRow(model);
            model.fireTableStructureChanged();
            this.reSort(model, rowSorter, sortKeyMap);
            this.resetSelectedRow(model, tableRows);
            this.ismTable.adjustStructure(false);
        }

        private void reSort(IsmAbstractTableModel model, RowSorter<? extends TableModel> rowSorter, Map<Integer, RowSorter.SortKey> sortKeyMap) {
            ArrayList<RowSorter.SortKey> newSortKeys = new ArrayList<RowSorter.SortKey>(0);
            int viewColumn = 0;
            for (Map.Entry<Integer, RowSorter.SortKey> entry : sortKeyMap.entrySet()) {
                viewColumn = model.getVisibleColIds().indexOf(entry.getKey());
                if (-1 == viewColumn) continue;
                RowSorter.SortKey sortKey = new RowSorter.SortKey(viewColumn, entry.getValue().getSortOrder());
                newSortKeys.add(sortKey);
            }
            if (!newSortKeys.isEmpty()) {
                rowSorter.setSortKeys(newSortKeys);
                this.ismTable.setRowSorter(rowSorter);
            }
        }

        private void resetSelectedRow(IsmAbstractTableModel model, List<TableRow> tableRows) {
            if (tableRows == null || tableRows.isEmpty()) {
                return;
            }
            int[] viewIndexs = new int[tableRows.size()];
            TableRow tableRow = null;
            int modelIndex = 0;
            int rowIndexToView = 0;
            for (int i = 0; i < viewIndexs.length; ++i) {
                tableRow = tableRows.get(i);
                modelIndex = model.getRowIndex(tableRow);
                viewIndexs[i] = rowIndexToView = this.ismTable.convertRowIndexToView(modelIndex);
            }
            Arrays.sort(viewIndexs);
            int startIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < viewIndexs.length; ++i) {
                rowIndexToView = viewIndexs[i];
                if (startIndex == -1) {
                    startIndex = rowIndexToView;
                    endIndex = rowIndexToView;
                    continue;
                }
                if (rowIndexToView - 1 == endIndex) {
                    endIndex = rowIndexToView;
                    continue;
                }
                this.ismTable.addRowSelectionInterval(startIndex, endIndex);
                startIndex = rowIndexToView;
                endIndex = rowIndexToView;
            }
            if (startIndex != -1 && endIndex != -1) {
                this.ismTable.addRowSelectionInterval(startIndex, endIndex);
            }
        }

        private List<TableRow> saveSelectedRow(IsmAbstractTableModel model) {
            int[] selectedRows = this.ismTable.getSelectedRows();
            ArrayList<TableRow> tableRows = new ArrayList<TableRow>(0);
            int modelRow = 0;
            for (int row : selectedRows) {
                modelRow = this.ismTable.convertRowIndexToModel(row);
                if (null == model.getRow(modelRow)) continue;
                tableRows.add(model.getRow(modelRow));
            }
            return tableRows;
        }
    }

    private static final class Handler
    extends MouseAdapter {
        private IsmTable ismTable;
        private CheckBoxItemListener listener;
        private TableCornerButton tableCornerButton;

        public Handler(IsmTable ismTable, TableCornerButton tableCornerButton) {
            this.ismTable = ismTable;
            this.tableCornerButton = tableCornerButton;
            this.listener = new CheckBoxItemListener(ismTable);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            JButton button = (JButton)me.getSource();
            if (!button.isEnabled()) {
                return;
            }
            JPopupMenu popmenu = new JPopupMenu();
            Map<String, Boolean> columns = this.getColumn();
            ArrayList disableColumn = (ArrayList)this.getFixedVisibleColumn();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setBackground(Color.WHITE);
            String columnName = null;
            boolean isSelected = false;
            JCheckBox checkBox = null;
            for (Map.Entry<String, Boolean> entry : columns.entrySet()) {
                columnName = entry.getKey();
                isSelected = entry.getValue();
                checkBox = new JCheckBox(columnName, isSelected);
                if (disableColumn.contains(columnName)) {
                    checkBox.setEnabled(false);
                    checkBox.setSelected(true);
                }
                checkBox.addItemListener(this.listener);
                panel.add(checkBox);
            }
            panel.setBorder(new EmptyBorder(0, 4, 0, 4));
            popmenu.add(panel);
            popmenu.show(me.getComponent(), me.getX(), me.getY());
            if (this.tableCornerButton.isEnabled() && this.tableCornerButton.contains(me.getPoint())) {
                this.tableCornerButton.setRecovered(true);
                this.tableCornerButton.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.tableCornerButton.isEnabled()) {
                this.tableCornerButton.setRecovered(true);
                this.tableCornerButton.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.tableCornerButton.setRecovered(false);
            this.tableCornerButton.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.tableCornerButton.setRecovered(false);
            this.tableCornerButton.repaint();
        }

        private Map<String, Boolean> getColumn() {
            LinkedHashMap<String, Boolean> columnMap = new LinkedHashMap<String, Boolean>();
            IsmAbstractTableModel model = (IsmAbstractTableModel)this.ismTable.getModel();
            String[] columnNames = model.getAllColumnNames();
            int[] visibleIDs = model.getVisibleColumns();
            String name = null;
            block0: for (int i = 0; i < columnNames.length; ++i) {
                name = columnNames[i];
                columnMap.put(name, false);
                for (int id : visibleIDs) {
                    if (i != id) continue;
                    columnMap.put(name, true);
                    continue block0;
                }
            }
            return columnMap;
        }

        private List<String> getFixedVisibleColumn() {
            ArrayList<String> columns = new ArrayList<String>(0);
            IsmAbstractTableModel model = (IsmAbstractTableModel)this.ismTable.getModel();
            String[] columnNames = model.getAllColumnNames();
            int[] visibleIDsForever = model.getFixedVisiableColumn();
            block0: for (int i = 0; i < columnNames.length; ++i) {
                for (int id : visibleIDsForever) {
                    if (id != i) continue;
                    columns.add(columnNames[i]);
                    continue block0;
                }
            }
            return columns;
        }
    }
}

