/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.ui.swing.text.RegexDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NameRegexDocument2
extends RegexDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(NameRegexDocument2.class);
    private static final long serialVersionUID = 4484807512382654464L;
    private int inputNumberimit;
    private boolean enableQuote = false;

    public NameRegexDocument2(String regex, int inputNumberLimit) {
        super(regex);
        this.inputNumberimit = inputNumberLimit;
    }

    public NameRegexDocument2(String regex, int inputNumberLimit, boolean eableQuote) {
        super(regex);
        this.inputNumberimit = inputNumberLimit;
        this.enableQuote = eableQuote;
    }

    @Override
    public void insertString(int offs, String newContent, AttributeSet attr) {
        try {
            this.doInsertString(offs, newContent, attr);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void doInsertString(int offs, String newContentStr, AttributeSet aSet) throws Exception {
        String actualNewContentStr = newContentStr;
        if (!this.enableQuote) {
            actualNewContentStr = actualNewContentStr.replaceAll("\"", "");
        }
        if (aSet == null || !aSet.isDefined(StyleConstants.ComposedTextAttribute)) {
            String proposedInsert;
            try {
                proposedInsert = this.getText(0, offs) + actualNewContentStr + this.getText(offs, this.getLength() - offs);
            }
            catch (BadLocationException e) {
                LOGGER.error("BadLocationException", (Throwable)e);
                return;
            }
            if (proposedInsert.startsWith("-")) {
                return;
            }
            if (this.inputNumberimit < proposedInsert.getBytes("UTF8").length) {
                return;
            }
        }
        super.insertString(offs, actualNewContentStr, aSet);
    }
}

